/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.services.ServiceConfig;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import ru.bitel.bgbilling.client.common.BGServiceConfig;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.common.Utils;

public class BGDraggableTabbedPane
extends JTabbedPane {
    private boolean dragging = false;
    private Image tabImage = null;
    private Point currentMouseLocation = null;
    private int draggedTabIndex = 0;
    private final JTabbedPane tabbedPane = this;
    private String key;

    public BGDraggableTabbedPane() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!BGDraggableTabbedPane.this.dragging) {
                    int tabNumber = BGDraggableTabbedPane.this.getUI().tabForCoordinate(BGDraggableTabbedPane.this.tabbedPane, e.getX(), e.getY());
                    if (tabNumber >= 0) {
                        BGDraggableTabbedPane.this.draggedTabIndex = tabNumber;
                        Rectangle bounds = BGDraggableTabbedPane.this.getUI().getTabBounds(BGDraggableTabbedPane.this.tabbedPane, tabNumber);
                        BufferedImage totalImage = new BufferedImage(BGDraggableTabbedPane.this.getWidth(), BGDraggableTabbedPane.this.getHeight(), 2);
                        Graphics totalGraphics = ((Image)totalImage).getGraphics();
                        totalGraphics.setClip(bounds);
                        BGDraggableTabbedPane.this.setDoubleBuffered(false);
                        BGDraggableTabbedPane.this.paintComponent(totalGraphics);
                        BGDraggableTabbedPane.this.tabImage = new BufferedImage(bounds.width, bounds.height, 2);
                        Graphics graphics = BGDraggableTabbedPane.this.tabImage.getGraphics();
                        graphics.drawImage(totalImage, 0, 0, bounds.width, bounds.height, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, BGDraggableTabbedPane.this.tabbedPane);
                        BGDraggableTabbedPane.this.dragging = true;
                        BGDraggableTabbedPane.this.repaint();
                    }
                } else {
                    BGDraggableTabbedPane.this.currentMouseLocation = e.getPoint();
                    BGDraggableTabbedPane.this.repaint();
                }
                super.mouseDragged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int tabNumber;
                if (BGDraggableTabbedPane.this.dragging && (tabNumber = BGDraggableTabbedPane.this.getUI().tabForCoordinate(BGDraggableTabbedPane.this.tabbedPane, e.getX(), 10)) >= 0) {
                    Component comp = BGDraggableTabbedPane.this.getComponentAt(BGDraggableTabbedPane.this.draggedTabIndex);
                    String title = BGDraggableTabbedPane.this.getTitleAt(BGDraggableTabbedPane.this.draggedTabIndex);
                    BGDraggableTabbedPane.this.removeTabAt(BGDraggableTabbedPane.this.draggedTabIndex);
                    BGDraggableTabbedPane.this.insertTab(title, null, comp, null, tabNumber);
                    BGDraggableTabbedPane.this.setSelectedComponent(comp);
                    StringBuilder value = new StringBuilder();
                    for (int index = 0; index < BGDraggableTabbedPane.this.tabbedPane.getTabCount(); ++index) {
                        Component component = BGDraggableTabbedPane.this.tabbedPane.getComponentAt(index);
                        if (value.length() > 0) {
                            value.append(" ");
                        }
                        if (component instanceof ServiceConfig.ServiceConfigPane) {
                            value.append(((ServiceConfig.ServiceConfigPane)component).getTabIndex());
                            continue;
                        }
                        if (!(component instanceof BGServiceConfig.ServiceConfigPane)) continue;
                        value.append(((BGServiceConfig.ServiceConfigPane)component).getTabIndex());
                    }
                    ClientSetup.getInstance().getUserConfig().set(BGDraggableTabbedPane.this.key, value.toString());
                    ClientSetup.getInstance().saveUserConfig();
                }
                BGDraggableTabbedPane.this.dragging = false;
                BGDraggableTabbedPane.this.tabImage = null;
                BGDraggableTabbedPane.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int tabNumber = BGDraggableTabbedPane.this.getUI().tabForCoordinate(BGDraggableTabbedPane.this.tabbedPane, e.getX(), e.getY());
                if (tabNumber < 0 && e.getButton() == 3) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem menuItem = new JMenuItem("\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0432\u043a\u043b\u0430\u0434\u043e\u043a");
                    menuItem.addActionListener(__ -> {
                        ClientSetup.getInstance().getUserConfig().set(BGDraggableTabbedPane.this.key, null);
                        ClientSetup.getInstance().saveUserConfig();
                    });
                    menu.add(menuItem);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.dragging && this.currentMouseLocation != null && this.tabImage != null) {
            g.drawImage(this.tabImage, this.currentMouseLocation.x, this.currentMouseLocation.y, this);
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<String> getUserTabOrder() {
        String userTabOrder = ClientSetup.getInstance().getUserConfig().get(this.key);
        if (Utils.isBlankString(userTabOrder)) {
            return null;
        }
        return Utils.toList(userTabOrder, " ");
    }
}

