/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.LocalDateTime;
import java.util.List;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.bgbilling.modules.subscription.common.bean.RegistrationPeriod;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.common.event.SubscriptionModifiedEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.xml.JAXBUtils;

@DirectoryItem(eventClass=SubscriptionModifiedEvent.class)
@XmlRootElement(name="subscription")
public class Subscription
extends Id {
    private int contractId;
    private int typeId;
    private SubscriptionType subscriptionType;
    private PeriodWithTime period;
    private int registrationPeriodId;
    private List<RegistrationPeriod> registrationPeriodList;
    private boolean avtoCommit = false;
    private long jobId;
    private String comment = null;

    @XmlAttribute
    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    @XmlAttribute
    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
        if (subscriptionType != null) {
            this.typeId = subscriptionType.getId();
        }
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.PeriodWithTimeAdapter.class)
    public PeriodWithTime getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodWithTime period) {
        this.period = period;
    }

    @XmlAttribute
    public int getRegistrationPeriodId() {
        return this.registrationPeriodId;
    }

    public void setRegistrationPeriodId(int registrationPeriodId) {
        this.registrationPeriodId = registrationPeriodId;
    }

    @XmlElement
    public List<RegistrationPeriod> getRegistrationPeriodList() {
        return this.registrationPeriodList;
    }

    public void setRegistrationPeriodList(List<RegistrationPeriod> registrationPeriodList) {
        this.registrationPeriodList = registrationPeriodList;
    }

    @XmlAttribute
    public boolean isAvtoCommit() {
        return this.avtoCommit;
    }

    public void setAvtoCommit(boolean avtoCommit) {
        this.avtoCommit = avtoCommit;
    }

    @XmlAttribute
    public long getJobId() {
        return this.jobId;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    @XmlAttribute
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isActive() {
        LocalDateTime now = LocalDateTime.now();
        boolean result = this.period != null && TimeUtils.dateInPeriod((LocalDateTime)now, (PeriodWithTime)this.period);
        boolean bl = result = result && this.registrationPeriodList != null && !this.registrationPeriodList.isEmpty();
        if (result) {
            result = TimeUtils.dateInPeriod((LocalDateTime)now, (PeriodWithTime)this.registrationPeriodList.get(this.registrationPeriodList.size() - 1).getPeriod());
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Subscription subscription = new Subscription();

        private Builder() {
        }

        public Builder setId(int value) {
            this.subscription.setId(value);
            return this;
        }

        public Builder setContractId(int contractId) {
            this.subscription.contractId = contractId;
            return this;
        }

        public Builder setTypeId(int typeId) {
            this.subscription.typeId = typeId;
            return this;
        }

        public Builder setPeriod(PeriodWithTime period) {
            this.subscription.period = period;
            return this;
        }

        public Builder setRegistrationPeriodId(int registrationPeriodId) {
            this.subscription.registrationPeriodId = registrationPeriodId;
            return this;
        }

        public Builder setAvtoCommit(boolean avtoCommit) {
            this.subscription.avtoCommit = avtoCommit;
            return this;
        }

        public Builder setJobId(long jobId) {
            this.subscription.jobId = jobId;
            return this;
        }

        public Builder setComment(String comment) {
            this.subscription.comment = comment;
            return this;
        }

        public Subscription build() {
            try {
                Subscription subscription = this.subscription;
                return subscription;
            }
            finally {
                this.subscription = null;
            }
        }
    }
}

