/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.accounting.worker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.accounting.TvAccounting;
import ru.bitel.bgbilling.apps.tv.accounting.worker.AccountingWorker;
import ru.bitel.bgbilling.apps.tv.accounting.worker.EventTrackingWorker;
import ru.bitel.bgbilling.apps.tv.accounting.worker.TvAccountTrackingWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.worker.ThreadContextFactory;

public class AccountingWorkerSet
implements Lifecycle {
    private static final Logger logger = LogManager.getLogger();
    private final TvAccounting accounting;
    private List<AccountingWorker> workers;

    public AccountingWorkerSet(TvAccounting accounting) {
        this.accounting = accounting;
    }

    public void start() throws BGException {
        ServerContextThreadFactory threadContextFactory = new ServerContextThreadFactory(this.accounting.setup, this.accounting.moduleId, null, null);
        TvDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
        ParameterMap config = rootDeviceRuntime.config;
        if (config.subIndexed("accounting.worker.").size() == 0) {
            Preferences defaults = new Preferences();
            defaults.set("accounting.worker.1.thread.count", "1");
            defaults.set("accounting.worker.1.tracking.account.1.delay", String.valueOf(TimeUnit.MINUTES.toSeconds(1L)));
            defaults.set("accounting.worker.1.tracking.account.1.batchSize", "500");
            defaults.set("accounting.worker.1.tracking.event.1.delay", String.valueOf(TimeUnit.SECONDS.toSeconds(10L)));
            defaults.set("accounting.worker.1.tracking.event.1.batchSize", "100");
            config = defaults.inherit(config);
        }
        this.workers = new ArrayList<AccountingWorker>();
        boolean tracking = false;
        for (Map.Entry workerEntry : config.subKeyed("accounting.worker.").entrySet()) {
            ParameterMap trackingParams;
            String name = (String)workerEntry.getKey();
            ParameterMap workerParams = (ParameterMap)workerEntry.getValue();
            AccountingWorker worker = new AccountingWorker(name, workerParams, (ThreadContextFactory<ServerContext>)threadContextFactory);
            this.workers.add(worker);
            logger.info("Create worker " + name);
            worker.init();
            worker.start();
            for (Map.Entry e : workerParams.subKeyed("tracking.account.").entrySet()) {
                trackingParams = (ParameterMap)e.getValue();
                tracking = true;
                worker.addTask((String)e.getKey(), new TvAccountTrackingWorker(this.accounting, worker.service, trackingParams));
            }
            for (Map.Entry e : workerParams.subKeyed("tracking.event.").entrySet()) {
                trackingParams = (ParameterMap)e.getValue();
                tracking = true;
                worker.addTask((String)e.getKey(), new EventTrackingWorker(this.accounting, worker.service, trackingParams));
            }
        }
        if (!tracking) {
            logger.error("Tracking worker not started. Check config!");
        }
    }

    public void stop() throws InterruptedException {
        for (AccountingWorker worker : this.workers) {
            worker.stop();
        }
        for (AccountingWorker worker : this.workers) {
            worker.destroy();
        }
        this.workers.clear();
        this.workers = null;
    }
}

