/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bean;

import bitel.billing.server.admin.bean.AddressHouse;
import bitel.billing.server.admin.bean.AddressItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class AddressManager {
    private Connection con;

    public AddressManager(Connection con) {
        this.con = con;
    }

    public void searchHouseList(SearchResult<AddressHouse> searchResult, int areaId, int quarterId, int streetId, String houseFrac, boolean loadInfo, boolean loadCityInfo, boolean loadCountryInfo) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            try {
                String frac;
                int house;
                int index = 1;
                ResultSet rs = null;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append("SELECT SQL_CALC_FOUND_ROWS * FROM ");
                query.append("address_house");
                query.append(" AS house ");
                if (loadInfo) {
                    query.append(" LEFT JOIN ");
                    query.append("address_area");
                    query.append(" AS area ON area.id=house.areaid");
                    query.append(" LEFT JOIN ");
                    query.append("address_quarter");
                    query.append(" AS quarter ON quarter.id=house.quarterid");
                    query.append(" LEFT JOIN ");
                    query.append("address_street");
                    query.append(" AS street ON street.id=house.streetid");
                }
                query.append(" WHERE true");
                if (areaId > 0) {
                    query.append(" AND house.areaid=");
                    query.append(areaId);
                }
                if (quarterId > 0) {
                    query.append(" AND house.quarterid=");
                    query.append(quarterId);
                }
                if (streetId > 0) {
                    query.append(" AND house.streetid=");
                    query.append(streetId);
                }
                if ((house = Utils.parseInt((String)AddressUtils.getHouse(houseFrac), (int)-1)) > -1) {
                    query.append(" AND house.house=");
                    query.append(house);
                }
                if (!(frac = AddressUtils.getHouseFrac(houseFrac)).isEmpty()) {
                    query.append(" AND house.frac LIKE ?");
                }
                query.append(" ORDER BY house.house, house.frac").append(Page.toSqlLimit((Page)page));
                ps = this.con.prepareStatement(query.toString());
                if (!frac.isEmpty()) {
                    ps.setString(index++, frac);
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    AddressHouse addressHouse = this.getAddressHouseData(rs, "house.");
                    if (addressHouse == null) continue;
                    if (loadInfo) {
                        addressHouse.setAddressArea(this.getAddressItemData(rs, "area."));
                        addressHouse.setAddressQuarter(this.getAddressItemData(rs, "quarter."));
                        addressHouse.setAddressStreet(this.getAddressItemData(rs, "street."));
                    }
                    list.add(addressHouse);
                }
                rs.close();
                Page.setRecordCount((Page)page, (int)ServerUtils.foundRows(this.con));
                ps.close();
                if (loadCityInfo) {
                    StringBuilder cityIds = new StringBuilder();
                    for (AddressHouse addressHouse : list) {
                        AddressItem addressItem = addressHouse.getAddressStreet();
                        if (addressItem != null) {
                            cityIds.append(", ");
                            cityIds.append(addressItem.getCityId());
                            continue;
                        }
                        addressItem = addressHouse.getAddressQuarter();
                        if (addressItem != null) {
                            cityIds.append(", ");
                            cityIds.append(addressItem.getCityId());
                            continue;
                        }
                        addressItem = addressHouse.getAddressArea();
                        if (addressItem == null) continue;
                        cityIds.append(", ");
                        cityIds.append(addressItem.getCityId());
                    }
                    if (cityIds.length() > 0) {
                        HashMap<Integer, City> addressCityMap = new HashMap<Integer, City>();
                        query = new StringBuilder();
                        query.append("SELECT * FROM ");
                        query.append("address_city");
                        query.append(" AS city ");
                        if (loadCountryInfo) {
                            query.append(" LEFT JOIN ");
                            query.append("address_country");
                            query.append(" AS country ON country.id=city.country_id");
                        }
                        query.append(" WHERE city.id IN ( ");
                        query.append(cityIds.substring(2));
                        query.append(" )");
                        ps = this.con.prepareStatement(query.toString());
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            City addressCity = this.getCityData(rs, "city.");
                            if (loadCountryInfo && addressCity != null) {
                                addressCity.setCountry(this.getCountryData(rs, "country."));
                            }
                            addressCityMap.put(addressCity.getId(), addressCity);
                        }
                        rs.close();
                        ps.close();
                        for (AddressHouse addressHouse : list) {
                            AddressItem addressItem = addressHouse.getAddressStreet();
                            if (addressItem != null) {
                                addressItem.setCity((City)addressCityMap.get(addressItem.getCityId()));
                            }
                            if ((addressItem = addressHouse.getAddressQuarter()) != null) {
                                addressItem.setCity((City)addressCityMap.get(addressItem.getCityId()));
                            }
                            if ((addressItem = addressHouse.getAddressArea()) == null) continue;
                            addressItem.setCity((City)addressCityMap.get(addressItem.getCityId()));
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public AddressStruct getAddress(int contractId, int parameterId) {
        AddressStruct addressStruct = null;
        String query = "SELECT aarea.title, acity.title, params.comment, params.flat,  params.floor, ahouse.frac, ahouse.house, ahouse.box_index, params.pod,  aquarter.title, params.room, astreet.title, params.hid, params.address, acountry.title FROM contract_parameter_type_2 as params LEFT JOIN address_house as ahouse ON params.hid = ahouse.id LEFT JOIN address_area as aarea ON ahouse.areaid = aarea.id LEFT JOIN address_street as astreet ON ahouse.streetid = astreet.id LEFT JOIN address_city as acity ON astreet.cityid = acity.id LEFT JOIN address_quarter as aquarter ON ahouse.quarterid = aquarter.id LEFT JOIN address_country as acountry ON acity.country_id = acountry.id WHERE params.cid = ? AND params.pid = ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, parameterId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    addressStruct = AddressStruct.builder().setArea(rs.getString(1)).setCity(rs.getString(2)).setComment(rs.getString(3)).setFlat(rs.getString(4)).setFloor(rs.getString(5).equals("-1") ? "" : rs.getString(5)).setFrac(rs.getString(6)).setHouse(rs.getString(7)).setIndex(rs.getString(8)).setPod(rs.getString(9).equals("-1") ? "" : rs.getString(9)).setQuarter(rs.getString(10)).setRoom(rs.getString(11)).setStreet(rs.getString(12)).setHouseId(rs.getInt(13)).setFullAddress(rs.getString(14)).setCountry(rs.getString(15)).build();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return addressStruct;
    }

    private Country getCountryData(ResultSet rs, String prefix) {
        Country country = new Country();
        try {
            country.setId(rs.getInt(prefix + "id"));
            country.setTitle(rs.getString(prefix + "title"));
        }
        catch (Exception e) {
            country = null;
        }
        return country;
    }

    private City getCityData(ResultSet rs, String prefix) {
        City city = new City();
        try {
            city.setId(rs.getInt(prefix + "id"));
            city.setCountryId(rs.getInt(prefix + "country_id"));
            city.setTitle(rs.getString(prefix + "title"));
        }
        catch (Exception e) {
            city = null;
        }
        return city;
    }

    private AddressItem getAddressItemData(ResultSet rs, String prefix) {
        AddressItem addressItem = new AddressItem();
        try {
            addressItem.setId(rs.getInt(prefix + "id"));
            addressItem.setCityId(rs.getInt(prefix + "cityid"));
            addressItem.setTitle(rs.getString(prefix + "title"));
        }
        catch (Exception e) {
            addressItem = null;
        }
        return addressItem;
    }

    private AddressHouse getAddressHouseData(ResultSet rs, String prefix) {
        AddressHouse addressHouse = new AddressHouse();
        try {
            addressHouse.setId(rs.getInt(prefix + "id"));
            addressHouse.setAreaId(rs.getInt(prefix + "areaid"));
            addressHouse.setQuarterId(rs.getInt(prefix + "quarterid"));
            addressHouse.setStreetId(rs.getInt(prefix + "streetid"));
            addressHouse.setHouse(rs.getInt(prefix + "house"));
            addressHouse.setFrac(rs.getString(prefix + "frac"));
            addressHouse.setComment(rs.getString(prefix + "comment"));
        }
        catch (Exception e) {
            addressHouse = null;
        }
        return addressHouse;
    }
}

