/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server.action.web;

import bitel.billing.server.ActionResultContentType;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.payonline.common.bean.Rebill;
import ru.bitel.bgbilling.modules.payonline.common.bean.Transaction;
import ru.bitel.bgbilling.modules.payonline.server.bean.Constants;
import ru.bitel.bgbilling.modules.payonline.server.bean.RebillManager;
import ru.bitel.bgbilling.modules.payonline.server.bean.TransactionManager;
import ru.bitel.common.FOUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.util.FileDownload;

@WebAction(title="Payonline")
public class ActionDoTransaction
extends AbstractPaymentAction {
    private static final char POST_DELIM = '&';
    private static final String CURRENCY = "RUB";

    public ActionDoTransaction() {
        super("payonline");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        if (this.moduleSetup.getBoolean("rebill", false)) {
            this.setResultParam("rebill", true);
            RebillManager onlineRebillManager = new RebillManager(this.con, this.moduleId);
            Rebill payOnlineRebill = onlineRebillManager.getTransactionByCid(this.contractId);
            onlineRebillManager.close();
            if (payOnlineRebill != null) {
                if (Utils.notBlankString((String)payOnlineRebill.getRebillAnchor())) {
                    this.setResultParam("anchor", true);
                }
                this.setResultParam("rebillContract", true);
                this.setResultParam("autoPaySumma", Utils.formatBigDecimalSumm((BigDecimal)payOnlineRebill.getSumma()));
                this.setResultParam("day", payOnlineRebill.getDay());
                this.setResultParam("periodicity", payOnlineRebill.getPeriodicity());
                this.setResultParam("date", TimeUtils.formatDate((Date)payOnlineRebill.getActivateDate()));
            }
        }
        this.setMinMaxSum("PAYONLINE", Constants.class);
        this.setResultParam("commissionType", this.moduleSetup.getInt("commission.type", 0));
        this.setResultParam("commissionPercent", this.moduleSetup.getDouble("commission.percent", 0.0));
        this.setResultParam("visaLogoURL", this.moduleSetup.get("payonline.logo.visa.url", "http://www.payonlinesystem.ru/rel/img/logos/mc_brand_038_gif.gif"));
        this.setResultParam("mastercardLogoURL", this.moduleSetup.get("payonline.logo.mastercard.url", "http://www.payonlinesystem.ru/rel/img/logos/visa1_60x38_a.gif"));
        this.requestDispatcher(this.moduleName, "form");
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"transactionDatetime:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, null);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autoPay() throws Exception {
        super.autopayment();
        boolean rebill = this.req.getBoolean("rebill", false);
        BigDecimal summa = this.req.getBigDecimal("sum", BigDecimal.ZERO);
        if (this.moduleSetup.getInt("commission.type", 0) == 2) {
            BigDecimal percent = this.moduleSetup.getBigDecimal("commission.percent", BigDecimal.ZERO).add(new BigDecimal(100)).divide(new BigDecimal(100));
            summa = summa.multiply(percent);
        }
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("payonline.sum.min", this.moduleSetup.getBigDecimal("min.summa", new BigDecimal(100)));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("payonline.sum.max", this.moduleSetup.getBigDecimal("max.summa", new BigDecimal(5000)));
        String uniq = this.moduleSetup.get("rebillUnique", "");
        String order = this.contractId + (String)(uniq.equals("") ? "" : "_" + uniq) + "_" + System.currentTimeMillis() + "_1";
        this.setMinMaxSum("PAYONLINE", Constants.class);
        this.setResultParam("rebill", rebill);
        if (summa.compareTo(BigDecimal.ZERO) <= 0 || summa.compareTo(sumMin) < 0 || summa.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        RebillManager payOnlineRebillManager = new RebillManager(this.con, this.moduleId);
        Rebill payOnlineRebill = payOnlineRebillManager.getTransactionByCid(this.contractId);
        payOnlineRebillManager.close();
        if (rebill) {
            if (payOnlineRebill != null && Utils.notBlankString((String)payOnlineRebill.getRebillAnchor())) {
                throw new BGMessageException("\u0423 \u0412\u0430\u0441 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436!");
            }
            int day = this.req.getInt("day", -1);
            int periodicity = this.req.getInt("periodicity", 2);
            this.setResultParam("summa", Utils.formatBigDecimalSumm((BigDecimal)summa));
            if (day < 0) {
                this.execute();
                throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0434\u0435\u043d\u044c \u043d\u0435\u0434\u0435\u043b\u0438/\u043c\u0435\u0441\u044f\u0446\u0430");
            }
            if (periodicity == 1 && day > 7) {
                this.execute();
                throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0434\u043d\u044f \u043d\u0435\u0434\u0435\u043b\u0438!");
            }
            if (periodicity == 2 && day > Calendar.getInstance().getActualMaximum(5)) {
                this.execute();
                throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0447\u0438\u0441\u043b\u043e \u043c\u0435\u0441\u044f\u0446\u0430 ");
            }
            this.setResultParam("day", day);
            if (payOnlineRebill != null) {
                payOnlineRebillManager.delete(payOnlineRebill.getId());
            }
            Rebill payOnlineRebillNew = new Rebill();
            payOnlineRebillNew.setActivateDate(new Date());
            payOnlineRebillNew.setContractId(this.contractId);
            payOnlineRebillNew.setDay(day);
            payOnlineRebillNew.setOrderId(order);
            payOnlineRebillNew.setPeriodicity(periodicity);
            payOnlineRebillNew.setSumma(summa);
            payOnlineRebillNew.setId(-1);
            payOnlineRebillManager.update(payOnlineRebillNew);
            this.pay(summa, order);
        }
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        if (this.moduleSetup.getInt("commission.type", 0) == 2) {
            BigDecimal percent = this.moduleSetup.getBigDecimal("commission.percent", BigDecimal.ZERO).add(new BigDecimal(100)).divide(new BigDecimal(100));
            this.sum = this.sum.multiply(percent);
        }
        this.setResultParam("min_summa", Utils.formatBigDecimalSumm((BigDecimal)this.sumMin));
        this.setResultParam("max_summa", Utils.formatBigDecimalSumm((BigDecimal)this.sumMax));
        String uniq = this.moduleSetup.get("rebillUnique", "");
        String order = this.contractId + (String)(uniq.equals("") ? "" : "_" + uniq) + "_" + System.currentTimeMillis() + "_0";
        this.pay(this.sum, order);
    }

    @WebOperation(title="\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    public void deleteAutoPay() throws Exception {
        this.setResultParam("contentType", ActionResultContentType.jsp);
        RebillManager payOnlineRebillManager = new RebillManager(this.con, this.moduleId);
        Rebill payOnlineRebill = payOnlineRebillManager.getTransactionByCid(this.contractId);
        if (payOnlineRebill != null) {
            payOnlineRebillManager.delete(payOnlineRebill.getId());
        }
        payOnlineRebillManager.close();
        this.execute();
    }

    @WebOperation(title="\u0417\u0430\u043f\u0440\u043e\u0441 \u0447\u0435\u043a\u0430")
    public void getPdf() throws Exception {
        long transId = this.req.getLong("transId", -1L);
        if (transId < 0L) {
            throw new BGIllegalArgumentException();
        }
        Contract contract = this.getContract(this.contractId);
        HttpServletResponse response = this.context.getResponse();
        response.setHeader("Content-Disposition", FileDownload.getContentDisposition((HttpServletRequest)this.context.getRequest(), (String)String.valueOf(transId), (boolean)false));
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element data = document.createElement("data");
        Transaction trans = new TransactionManager(this.con, this.moduleId).getByTransId(transId);
        String title = this.makeTitle(contract);
        data.setAttribute("title", title);
        data.setAttribute("trans_id", String.valueOf(trans.getTransactionId()));
        data.setAttribute("date", TimeUtils.formatDate((Date)trans.getTransactionDate()));
        data.setAttribute("time", TimeUtils.format((Date)trans.getTransactionDate(), (String)"HH:mm"));
        data.setAttribute("order_id", String.valueOf(contract.getId()));
        data.setAttribute("contract", contract.getTitle());
        data.setAttribute("summa", Utils.formatBigDecimal((BigDecimal)trans.getSum(), (int)2));
        data.setAttribute("org_header", this.moduleSetup.get("check.org.header", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438"));
        data.setAttribute("org_inn", this.moduleSetup.get("check.org.inn", "\u0418\u041d\u041d \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438"));
        data.setAttribute("org_address", this.moduleSetup.get("check.org.address", "\u0410\u0434\u0440\u0435\u0441 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438"));
        data.setAttribute("org_phone", this.moduleSetup.get("check.org.phone", "\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438"));
        document.appendChild(data);
        response.setContentType("application/pdf");
        try (ServletOutputStream out = response.getOutputStream();){
            XSLManager.getInstance().transform((Source)new DOMSource(document), "payonline_check.xsl", (Result)FOUtils.renderSAXResult((OutputStream)out, (String)"application/pdf"));
            this.setResultParam("contentType", "binary");
            out.flush();
        }
    }

    private void pay(BigDecimal summa, String orderId) throws Exception {
        String merchantId = this.moduleSetup.get("payonline.merchant.id", this.moduleSetup.get("merchant.id", ""));
        String privateSecKey = this.moduleSetup.get("private.security.key", "");
        String payOnlineUrl = this.moduleSetup.get("pay.online.url", "");
        String returnUrl = this.moduleSetup.get("redirect.url", null);
        if (Utils.isBlankString((String)merchantId) || Utils.isBlankString((String)privateSecKey) || Utils.isBlankString((String)payOnlineUrl)) {
            this.execute();
            throw new BGMessageException("\u041c\u043e\u0434\u0443\u043b\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u043e!");
        }
        try {
            StringBuilder url = new StringBuilder(150);
            url.append(payOnlineUrl);
            url.append("?");
            String sb = "MerchantId=" + merchantId + "&";
            sb = sb + "OrderId=" + orderId + "&";
            sb = sb + "Amount=" + Utils.formatBigDecimal((BigDecimal)summa, (int)2) + "&";
            sb = sb + "Currency=RUB&";
            sb = sb + "SecurityKey=" + Utils.bytesToHexString((byte[])MessageDigest.getInstance("md5").digest((sb + "PrivateSecurityKey=" + privateSecKey).getBytes())).toLowerCase();
            url.append(sb);
            url.append('&');
            url.append("ReturnUrl=");
            url.append(URLEncoder.encode(returnUrl, "UTF-8"));
            if (this.moduleSetup.getBoolean("payonline.fiscalization.enable", false)) {
                String email = ContractUtils.getCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId);
                String fiscalData = this.getFiscal("Benefit", orderId, summa, email, ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle());
                url.append('&');
                url.append("FiscalData=");
                url.append(URLEncoder.encode(fiscalData, "UTF-8"));
            }
            this.setResultParam("contentType", "binary");
            this.context.getResponse().sendRedirect(url.toString());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    private String getFiscal(String operation, String transactionId, BigDecimal amount, String email, String contractTitle) {
        JSONObject json = new JSONObject();
        json.put("operation", (Object)operation);
        json.put("transactionId", (Object)transactionId);
        json.put("paymentSystemType", (Object)this.moduleSetup.get("payonline.fiscalization.payment.system.type", "Card"));
        json.put("typeOfPayment", this.moduleSetup.getInt("payonline.fiscalization.type.of.payment", 14));
        json.put("totalAmount", (Object)amount.setScale(2, RoundingMode.HALF_UP));
        JSONArray goods = new JSONArray();
        json.put("goods", (Object)goods);
        JSONObject good = new JSONObject();
        good.put("description", (Object)this.moduleSetup.get("payonline.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
        good.put("quantity", this.moduleSetup.getInt("payonline.fiscalization.receipt.qty", 1));
        good.put("amount", (Object)amount.setScale(2, RoundingMode.HALF_UP));
        good.put("tax", (Object)this.moduleSetup.get("payonline.fiscalization.receipt.tax", "vat18"));
        good.put("paymentMethodType", 1);
        good.put("paymentSubjectType", 2);
        goods.put((Object)good);
        json.put("email", (Object)email);
        return json.toString();
    }

    private String makeTitle(Contract contract) {
        String result = "\u041f\u043b\u0430\u0442\u0435\u0436";
        String conTitle = contract.getTitle();
        for (Map.Entry entry : this.moduleSetup.subIndexed("pdf.check.title.").entrySet()) {
            ParameterMap pm = (ParameterMap)entry.getValue();
            String regex = pm.get("regex", null);
            if (regex == null) continue;
            try {
                Pattern pattern = Pattern.compile(regex);
                if (!pattern.matcher(conTitle).matches()) continue;
                result = pm.get("title", "\u041f\u043b\u0430\u0442\u0435\u0436");
                break;
            }
            catch (PatternSyntaxException patternSyntaxException) {
            }
        }
        return result;
    }
}

