/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server.bean;

import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.common.bean.emuns.PaymentType;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.Transaction;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, "cloudpayments_transaction", moduleId);
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionId(rs.getString("transaction_id"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setStatus(rs.getString("status"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("sum"))).setAutopayment(rs.getBoolean("autopayment"))).build();
    }

    protected Transaction getImpl(int transactionId) throws SQLException {
        return (Transaction)this.getById(transactionId);
    }

    protected String getQueryById() {
        return "SELECT pt.*, c.title AS contract_title FROM " + this.tableName + " AS pt LEFT JOIN contract AS c ON c.id=pt.contract_id WHERE pt.id=?";
    }

    public boolean update(Transaction transaction, TransactionStatus newTransactionStatus) throws SQLException {
        boolean result = false;
        if (transaction != null && newTransactionStatus != null) {
            StringBuilder query = new StringBuilder("UPDATE ").append(this.tableName).append(" SET ").append("status=?").append(" WHERE ").append("status=? AND id=?");
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                int index = 1;
                ps.setString(index++, newTransactionStatus.getCode());
                ps.setString(index++, transaction.getStatus());
                ps.setInt(index++, transaction.getId());
                boolean bl = result = ps.executeUpdate() > 0;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("updateTransactionStatus: " + result);
                    this.getLogger().debug("\ttransaction.getId() = " + transaction.getId());
                    this.getLogger().debug("\ttransaction.getStatus() = " + transaction.getStatus());
                    this.getLogger().debug("\tnewTransactionStatus = " + newTransactionStatus.getCode());
                }
                if (result) {
                    transaction.setStatus(newTransactionStatus.getCode());
                }
            }
        }
        return result;
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, status=?, params=?, sum=?, autopayment=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setBoolean(index++, transaction.isAutopayment());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public void doCheckRequest(int contractId, boolean autopaymentTransaction) throws Exception {
        String statusUrl = this.moduleSetup.get("cloudpayments.status.url", "https://api.cloudpayments.ru/v2/payments/find");
        Page page = new Page(1, 25);
        String[] sort = new String[]{"createDate:1"};
        SearchParam searchParam = new SearchParam().setContractId(contractId).setStatus(TransactionStatus.NEW.getCode()).setType((PaymentType)(autopaymentTransaction ? PaymentType.AUTO : null));
        SearchResult searchResult = new SearchResult(page, sort);
        this.searchTransaction(searchResult, searchParam);
        for (Transaction transaction : searchResult.getList()) {
            boolean success;
            String orderId = String.valueOf(transaction.getId());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("cloudpaymentsTransactionId = {}", (Object)transaction.getId());
            }
            if (orderId == null && System.currentTimeMillis() - transaction.getCreateDate().getTime() > 86400000L) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                this.update(transaction);
                continue;
            }
            JSONObject queryParam = new JSONObject();
            queryParam.put("InvoiceId", (Object)orderId);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + queryParam.toString());
            }
            StringBuilder resultJson = null;
            try {
                HashMap<String, Object> requestProperties = new HashMap<String, Object>();
                requestProperties.put("Content-Type", "application/json");
                requestProperties.put("Authorization", "Basic " + Base64.encodeUTF8((String)(this.moduleSetup.get("cloudpayments.public.id", "") + ":" + this.moduleSetup.get("cloudpayments.api.password", ""))));
                resultJson = this.doConnection(statusUrl, "POST", true, queryParam.toString(), requestProperties);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
                }
            }
            catch (Exception ex) {
                this.getLogger().error(ex.getMessage());
            }
            JSONObject resultJsonObject = null;
            if (resultJson == null || !(success = (resultJsonObject = new JSONObject(resultJson.toString())).optBoolean("Success", false))) continue;
            if (!transaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
                this.getLogger().error("Transaction for ID = " + transaction.getId() + " has status != 'created'");
                continue;
            }
            if (transaction.getPaymentId() > 0) {
                this.getLogger().error("Transaction for ID = " + transaction.getId() + " has paymentId > 0");
                continue;
            }
            this.addTransactionPayment(transaction, TransactionManager.getParamString((JSONObject)resultJsonObject));
        }
    }

    public String paymentOrderBinding(Transaction transaction, Autopayment autopayment) {
        String result = null;
        if (transaction != null && autopayment != null) {
            String userName = this.moduleSetup.get("cloudpayments.autopayment.rest.user.name", "autopaymentUser");
            String userPswd = this.moduleSetup.get("cloudpayments.autopayment.rest.user.pswd", "autopaymentPassword");
            String bindingId = autopayment.getAccessToken();
            if (bindingId != null) {
                try {
                    userName = URLEncoder.encode(userName, "UTF-8");
                    userPswd = URLEncoder.encode(userPswd, "UTF-8");
                    bindingId = URLEncoder.encode(bindingId, "UTF-8");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                StringBuilder spec = new StringBuilder().append("mdOrder=").append(transaction.getTransactionId()).append("&bindingId=").append(bindingId).append("&userName=").append(userName).append("&password=").append(userPswd);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\t\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + spec.toString());
                }
                StringBuilder resultJson = null;
                try {
                    resultJson = this.doConnection("", "POST", true, spec.toString());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
                    }
                }
                catch (Exception ex) {
                    this.getLogger().error(ex.getMessage());
                }
                if (resultJson != null) {
                    StringBuilder resultData = new StringBuilder();
                    JSONObject resultJsonObject = new JSONObject(resultJson.toString());
                    if (resultJsonObject != null) {
                        if (resultJsonObject.has("errorCode")) {
                            resultData.append("errorCode=").append(resultJsonObject.getInt("errorCode")).append("\n");
                        }
                        if (resultJsonObject.has("info")) {
                            resultData.append("info=").append(resultJsonObject.getString("info")).append("\n");
                        }
                        if (resultJsonObject.has("redirect")) {
                            resultData.append("redirect=").append(resultJsonObject.getString("redirect")).append("\n");
                        }
                        result = resultData.toString();
                    }
                }
            } else {
                this.getLogger().error("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d, \u0442\u0430\u043a \u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d bindingId = " + bindingId);
            }
        }
        return result;
    }

    public void addTransactionPayment(Transaction transaction, String transactionParameters) throws Exception {
        if (this.update(transaction, TransactionStatus.APPROVED)) {
            Payment payment = Payment.builder().setDate(new Date()).setTypeId(this.moduleSetup.getInt("cloudpayments.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(this.moduleSetup.get("cloudpayments.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 CloudPayments (#{TRANSACTION_ID})").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).build();
            new PaymentDao(this.con).update((Object)payment);
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
            }
            transaction.setPaymentId(payment.getId());
            transaction.setTransactionDate(new Date());
            TransactionManager.addTransactionParameters(transaction, transactionParameters);
            this.update(transaction);
            EventProcessor.getInstance().publishAfterCommit((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getDate(), payment.getSum()));
        }
    }

    public static void addTransactionParameters(Transaction transaction, String params) {
        if (transaction != null && Utils.notBlankString((String)params)) {
            Object newParams = transaction.getParameters();
            if (newParams != null && !((String)newParams).endsWith("\n")) {
                newParams = (String)newParams + "\n";
            }
            transaction.setParameters((String)newParams + params);
        }
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        connection.setConnectTimeout(this.moduleSetup.getInt("cloudpayments.request.timeout", 10000));
        connection.setReadTimeout(this.moduleSetup.getInt("cloudpayments.request.read.timeout", 5000));
    }
}

