/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.service;

import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.AccessCodes;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetOption;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServOption;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServRestriction;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServSearchParam;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServTypeIPMode;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLink;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServStatus;
import ru.bitel.bgbilling.modules.inet.common.event.InetOptionModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.InetServRestrictionModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetAuthorizationRequestEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServInitEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaStateModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAccountGenerate;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.bean.InetOptionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServMoveManager;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServOptionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServRestrictionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.TrafficTypeDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetServChangingEvent;
import ru.bitel.bgbilling.modules.inet.server.event.InetServModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.ip.AbstractInetServIpHandler;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpHandler;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpHandlerOldMode;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpUtils;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.PatternStringGenerator;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Node;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.worker.Commitable;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceInterfaceService;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;
import ru.bitel.oss.systems.inventory.resource.server.bean.DevicePortDao;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.inet.common.service.InetServService")
public class InetServServiceImpl
extends AbstractService
implements InetServService {
    @Resource
    ResourceService wsResource;
    @Resource
    DeviceInterfaceService deviceInterfaceService;
    private Directory<InetServType> servTypeDirectory = null;
    private Directory<TrafficTypeLink> trafficTypeLinkDirectory = null;
    private InetServDao inetServDao = null;
    private DevicePortDao devicePortDao = null;
    private InetOptionDao inetOptionDao = null;
    private InetDeviceDao inetDeviceDao = null;
    private InetSessionDao inetSessionDao = null;
    private TrafficTypeDao trafficTypeDao = null;
    private InetServOptionDao inetServOptionDao = null;
    private InetServRestrictionDao inetServRestrictionDao = null;
    private ContractUtils contractUtils = null;

    @PostConstruct
    protected void init() throws BGException {
        this.servTypeDirectory = this.context.newDirectory(InetServType.class, this.moduleId);
        this.inetServDao = new InetServDao(this.getConnection(), this.moduleId);
        this.inetServOptionDao = new InetServOptionDao(this.getConnection(), this.moduleId);
        this.inetServRestrictionDao = new InetServRestrictionDao(this.getConnection(), this.moduleId);
        this.inetOptionDao = new InetOptionDao(this.getConnection(), this.moduleId);
        this.trafficTypeDao = new TrafficTypeDao(this.getConnection(), this.moduleId);
        this.trafficTypeLinkDirectory = this.context.getDirectory(TrafficTypeLink.class, this.moduleId);
        this.inetDeviceDao = new InetDeviceDao(this.getConnection(), this.moduleId);
        this.inetSessionDao = new InetSessionDao(this.getConnection(), this.moduleId);
        this.contractUtils = new ContractUtils(this.getConnection());
        this.devicePortDao = new DevicePortDao(this.getConnection(), this.moduleId);
    }

    public InetServType inetServTypeGet(int id) throws BGException {
        return (InetServType)this.servTypeDirectory.get(id);
    }

    public List<InetServType> inetServTypeList() throws Exception {
        return this.servTypeDirectory.list();
    }

    public List<IdTitle> inetServTypeTitleList() throws Exception {
        return this.servTypeDirectory.list().stream().map(IdTitle::toIdTitle).toList();
    }

    public int inetServTypeUpdate(InetServType inetServType) throws Exception {
        InetServType oldInetServType = null;
        if (inetServType.getId() > 0) {
            oldInetServType = (InetServType)this.servTypeDirectory.get(inetServType.getId());
        }
        this.servTypeDirectory.update((Id)inetServType);
        if (oldInetServType != null) {
            Preferences preferences = new Preferences(inetServType.getConfig(), "\n");
            String titlePattern = preferences.get("title.pattern", null);
            Preferences oldPreferences = new Preferences(oldInetServType.getConfig(), "\n");
            String oldTitlePattern = oldPreferences.get("title.pattern", null);
            if (!(titlePattern == null && oldTitlePattern == null || titlePattern != null && oldTitlePattern != null && titlePattern.equals(oldTitlePattern))) {
                HashMap<Integer, InetDevice> deviceMap = new HashMap<Integer, InetDevice>();
                for (InetServ inetServ : this.inetServDao.searchInetServ(new InetServSearchParam().setServiceTypeId(inetServType.getId()), null)) {
                    int deviceId = inetServ.getDeviceId();
                    InetDevice device = (InetDevice)deviceMap.get(deviceId);
                    if (device == null) {
                        device = this.inetDeviceDao.get(deviceId);
                        deviceMap.put(deviceId, device);
                    }
                    if (device == null) continue;
                    inetServ.setTitle(this.getTitlePattern(inetServ, preferences, device));
                    this.inetServDao.update((Entity)inetServ);
                }
            }
        }
        return inetServType.getId();
    }

    public void inetServTypeDelete(int id) throws BGException {
        try {
            this.servTypeDirectory.delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public String inetServTypeIpClass() throws BGException {
        JSONObject json = new JSONObject();
        json.put("iface", (Object)InetServIpHandler.class.getName());
        json.put("superClass", (Object)AbstractInetServIpHandler.class.getName());
        return json.toString();
    }

    public InetServ inetServGet(int servId) throws BGException {
        return (InetServ)this.inetServDao.get(servId);
    }

    public InetServ inetServWithChildGet(int inetServId) throws Exception {
        InetServ inetServ = (InetServ)this.inetServDao.get(inetServId);
        this.inetServLoadChild(inetServ);
        return inetServ;
    }

    private void inetServLoadChild(InetServ inetServ) throws Exception {
        List<InetServ> inetServs = this.inetServDao.listChildren(inetServ.getId());
        if (inetServs != null) {
            for (InetServ childInetServ : inetServs) {
                this.inetServLoadChild(childInetServ);
            }
        }
        inetServ.setChildren(inetServs);
    }

    @Deprecated
    public List<InetServ> inetServList(int contractId) throws BGException {
        return this.inetServList(contractId, null);
    }

    public List<InetServ> inetServList(int contractId, String orderBy) throws BGException {
        List<InetServ> result = Utils.notBlankString((String)orderBy) ? this.inetServDao.list(contractId, orderBy) : this.inetServDao.list(contractId);
        this.setAccessCodeTitle(result);
        return result;
    }

    private void setAccessCodeTitle(List<InetServ> inetServList) {
        for (InetServ inetServ : inetServList) {
            inetServ.setAccessCodeTitle(AccessCodes.toString((ParameterMap)this.getModuleSetup(), (int)inetServ.getAccessCode()));
        }
    }

    public InetServ inetServTree(int contractId) throws Exception {
        List<InetServ> result = this.inetServDao.list(contractId);
        this.setAccessCodeTitle(result);
        InetServ root = new InetServ();
        root.setTitle("\u0421\u0435\u0440\u0432\u0438\u0441\u044b");
        return (InetServ)TreeUtils.tree(result, (Node)root);
    }

    public void inetServStateModify(int inetServId, short state, int accessCode) throws Exception {
        InetServ inetServ = (InetServ)this.inetServDao.get(inetServId);
        if (inetServ == null) {
            throw new BGMessageException("\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        if (accessCode < 0) {
            accessCode = inetServ.getAccessCode();
        }
        EventProcessor.getInstance().publish((Event)new InetSaStateModifyEvent(this.moduleId, this.userId, inetServ, state, accessCode));
    }

    public int inetServUpdate(InetServ inetServ, List<InetServOption> optionList, boolean generateLogin, boolean generatePassword, long saWaitTimeout) throws Exception {
        return this.inetServUpdateInternal(inetServ, optionList, generateLogin, generatePassword, saWaitTimeout, true);
    }

    public int inetServUpdateInternal(InetServ inetServ, List<InetServOption> optionList, boolean generateLogin, boolean generatePassword, long saWaitTimeout, boolean closeChildServices) throws Exception {
        List<InetServ> oldChildrenServs;
        InetServ parentInetServ;
        InetServType servType = (InetServType)this.servTypeDirectory.get(inetServ.getTypeId());
        if (servType == null) {
            throw new BGIllegalArgumentException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u0441\u0435\u0440\u0432\u0438\u0441\u0430");
        }
        InetServIpHandlerOldMode oldIPHandler = null;
        if (servType.getAddressType().getCode() > 0) {
            oldIPHandler = new InetServIpHandlerOldMode();
            oldIPHandler.setModuleId(this.moduleId);
            oldIPHandler.setInetServService(this);
            oldIPHandler.setServerContext(this.context);
        }
        if (!servType.isNeedInterface()) {
            inetServ.setInterfaceId(-1);
        }
        if (!servType.isNeedVlan()) {
            inetServ.setVlan(-1);
        }
        if (servType.isNeedLogin()) {
            this.setAndCheckLoginPassword(inetServ, generateLogin, generatePassword, servType);
        } else if (inetServ.getLogin() == null) {
            inetServ.setLogin("");
        }
        this.checkMacAddress(inetServ);
        if (servType.getAddressType().getCode() > 0) {
            oldIPHandler.checkAddress(inetServ, servType);
        } else {
            JSONObject jsonData = new JSONObject(Optional.ofNullable(servType.getData()).orElse("{}"));
            this.checkAddress(new InetServTypeIPMode(jsonData.optJSONObject("ipv4")), inetServ, servType);
            this.checkAddress(new InetServTypeIPMode(jsonData.optJSONObject("ipv6")), inetServ, servType);
        }
        InetServ oldInetServ = null;
        if (inetServ.getId() > 0 && (oldInetServ = (InetServ)this.inetServDao.get(inetServ.getId())) == null) {
            throw new BGIllegalArgumentException("\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d (\u0443\u0436\u0435 \u0443\u0434\u0430\u043b\u0451\u043d?)");
        }
        inetServ = ((InetServChangingEvent)EventProcessor.getInstance().request((QueueEvent)new InetServChangingEvent(this.moduleId, this.userId, oldInetServ, inetServ))).getInetServ();
        Preferences servTypeConfig = new Preferences(servType.getConfig(), "\n\r");
        int constDeviceId = servTypeConfig.getInt("const.device.id", -1);
        if (constDeviceId > 0) {
            inetServ.setDeviceId(constDeviceId);
        } else if (inetServ.getDeviceId() <= 0 && inetServ.getParentId() > 0 && (parentInetServ = (InetServ)this.inetServDao.get(inetServ.getParentId())) != null) {
            inetServ.setDeviceId(parentInetServ.getDeviceId());
        }
        InetDevice device = this.inetDeviceDao.get(inetServ.getDeviceId());
        if (device == null) {
            throw new BGMessageException("\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e!");
        }
        inetServ.setTitle(this.getTitlePattern(inetServ, servTypeConfig, device));
        try {
            this.inetServDao.update((Entity)inetServ);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        this.inetServOptionDao.update(inetServ.getId(), optionList);
        this.context.publishAfterCommit((Event)new InetServModifiedEvent(this.moduleId, inetServ.getContractId(), this.userId, oldInetServ, inetServ, optionList));
        int subscriberId = inetServ.getId();
        String subscriberTitle = this.contractUtils.getContractTitle(inetServ.getContractId(), true) + ";" + inetServ.getTitle();
        if (servType.isNeedInterface()) {
            this.setInterface(device, inetServ, servType, subscriberId, subscriberTitle);
        }
        if (servType.getAddressType().getCode() > 0) {
            oldIPHandler.setAddress(inetServ, servType, oldInetServ, subscriberId, subscriberTitle);
        } else {
            JSONObject jsonData = new JSONObject(Optional.ofNullable(servType.getData()).orElse("{}"));
            this.setAddress(new InetServTypeIPMode(jsonData.optJSONObject("ipv4")), inetServ, servType, oldInetServ, subscriberId, subscriberTitle);
            this.setAddress(new InetServTypeIPMode(jsonData.optJSONObject("ipv6")), inetServ, servType, oldInetServ, subscriberId, subscriberTitle);
        }
        if (servType.isNeedVlan()) {
            this.setVlan(inetServ, servType, subscriberId, subscriberTitle);
        }
        List<InetServ> newChildrenServs = oldChildrenServs = inetServ.getParentId() > 0 ? null : this.inetServDao.listChildren(inetServ.getId());
        if (inetServ.getParentId() == 0 && oldInetServ != null && oldInetServ.getDeviceId() != inetServ.getDeviceId() && oldChildrenServs != null) {
            newChildrenServs = new ArrayList<InetServ>(oldChildrenServs.size());
            try {
                for (InetServ oldChildServ : oldChildrenServs) {
                    InetServ newChildServ = oldChildServ.clone();
                    newChildrenServs.add(newChildServ);
                    if (oldInetServ.getDeviceId() != oldChildServ.getDeviceId()) continue;
                    newChildServ.setDeviceId(inetServ.getDeviceId());
                    this.inetServDao.update((Entity)newChildServ);
                    this.context.publishAfterCommit((Event)new InetServModifiedEvent(this.moduleId, inetServ.getContractId(), this.userId, oldChildServ, newChildServ, Collections.emptyList()));
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        this.publishEvent(oldInetServ, oldChildrenServs, inetServ, newChildrenServs, optionList, saWaitTimeout);
        if (closeChildServices && oldInetServ != null && oldInetServ.getDateTo() == null && inetServ.getDateTo() != null && inetServ.getChildren() != null) {
            for (InetServ childServ : inetServ.getChildren()) {
                if (childServ.getDateTo() != null) continue;
                childServ.setDateTo(inetServ.getDateTo());
                this.inetServUpdate(childServ, this.inetServOptionList(childServ.getId()), false, false, 0L);
            }
        }
        return inetServ.getId();
    }

    private void checkAddress(InetServTypeIPMode ipMode, InetServ inetServ, InetServType servType) throws BGException, BGMessageException {
        String ipHandlerClassName = ipMode.getIpHandlerClassName();
        if (Utils.notBlankString((String)ipHandlerClassName)) {
            InetServIpHandler inetServIpHandler = (InetServIpHandler)DynamicClassManager.getInstance().newInstance(InetServIpHandler.class, ipHandlerClassName);
            ((AbstractInetServIpHandler)inetServIpHandler).setModuleId(this.moduleId);
            ((AbstractInetServIpHandler)inetServIpHandler).setServerContext(this.context);
            ((AbstractInetServIpHandler)inetServIpHandler).setInetServService(this);
            inetServIpHandler.checkAddress(inetServ, servType);
        }
    }

    private void setAddress(InetServTypeIPMode ipMode, InetServ inetServ, InetServType servType, InetServ oldInetServ, int subscriberId, String subscriberTitle) throws Exception {
        String ipHandlerClassName = ipMode.getIpHandlerClassName();
        if (Utils.notBlankString((String)ipHandlerClassName)) {
            InetServIpHandler inetServIpHandler = (InetServIpHandler)DynamicClassManager.getInstance().newInstance(InetServIpHandler.class, ipHandlerClassName);
            ((AbstractInetServIpHandler)inetServIpHandler).setModuleId(this.moduleId);
            ((AbstractInetServIpHandler)inetServIpHandler).setServerContext(this.context);
            ((AbstractInetServIpHandler)inetServIpHandler).setInetServService(this);
            inetServIpHandler.setAddress(inetServ, servType, oldInetServ, subscriberId, subscriberTitle);
        }
    }

    private void setAndCheckLoginPassword(InetServ inetServ, boolean generateLogin, boolean generatePassword, InetServType inetServType) throws Exception {
        ModuleSetup moduleSetup = this.getModuleSetup();
        if (generateLogin) {
            inetServ.setLogin(this.inetServLoginGenerate(inetServ, inetServType, (ParameterMap)moduleSetup));
        } else {
            this.checkLoginSymbols(inetServ, inetServType);
        }
        String login = inetServ.getLogin();
        List<InetServ> list = this.inetServDao.list(login, inetServ.getDateFrom(), inetServ.getDateTo());
        for (InetServ s : list) {
            if (s.getId() == inetServ.getId()) continue;
            throw new BGMessageException("\u041b\u043e\u0433\u0438\u043d " + login + " \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
        }
        if (generatePassword) {
            if (inetServType != null) {
                moduleSetup = moduleSetup.inherit((ParameterMap)new Preferences(inetServType.getConfig(), "\n"));
            }
            inetServ.setPassword(this.inetServPasswordGenerate(inetServ, inetServType, (ParameterMap)moduleSetup));
        } else {
            String password = Utils.maskNull((String)inetServ.getPassword());
            this.checkPassword(inetServType, password);
        }
    }

    private short detectState(InetServ inetServ) throws BGException {
        ConvergenceBalance balance;
        Contract contract;
        StatusCache statusCache;
        Date now;
        short newDeviceState = inetServ == null ? InetServState.STATE_DELETED.getCode() : (!TimeUtils.dateInRange((Date)(now = new Date()), (Date)inetServ.getDateFrom(), (Date)inetServ.getDateTo()) ? InetServState.STATE_DELETED.getCode() : (inetServ.getStatus() != InetServStatus.STATUS_ON ? InetServState.STATE_DISABLE.getCode() : (!(statusCache = StatusCache.getInstance()).isModuleActiveStatus(this.moduleId, (int)(contract = this.getContract(inetServ.getContractId())).getStatus()) ? InetServState.STATE_DISABLE.getCode() : (!(balance = ConvergenceBalanceManager.getInstance().getBalance(this.getConnectionSet(), Integer.valueOf(inetServ.getContractId()), System.currentTimeMillis())).isBalanceExceedsLimit() ? InetServState.STATE_DISABLE.getCode() : InetServState.STATE_ENABLE.getCode()))));
        return newDeviceState;
    }

    private void setVlan(InetServ inetServ, InetServType servType, int subscriberId, String subscriberTitle) throws Exception {
        if (inetServ.getVlan() <= 0) {
            if (servType.isNullVlan()) {
                return;
            }
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d vlan");
        }
        Set<Integer> vlanResourceCategoryId = this.vlanResourceCategoryIds(inetServ.getDeviceId());
        if (!this.wsResource.vlanResourceSubscribe(inetServ.getVlan(), (short)1, subscriberId, subscriberTitle, inetServ.getDateFrom(), inetServ.getDateTo(), vlanResourceCategoryId, servType.isPersonalVlan())) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 Vlan-\u0440\u0435\u0441\u0443\u0440\u0441!");
        }
    }

    private void setInterface(InetDevice inetDevice, InetServ inetServ, InetServType servType, int subscriberId, String subscriberTitle) throws Exception {
        if (inetServ.getInterfaceId() < 0) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        }
        if (!this.deviceInterfaceService.devicePortSubscribe(subscriberId, subscriberTitle, inetDevice.getInvDeviceId(), inetServ.getInterfaceId(), inetServ.getDateFrom(), inetServ.getDateTo(), servType.isPersonalInterface())) {
            throw new BGException("\u041d\u0435\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441!");
        }
    }

    private String getTitlePattern(InetServ inetServ, Preferences servTypeConfig, InetDevice device) throws Exception {
        DeviceInterface deviceInterface;
        String titlePattern = servTypeConfig.get("title.pattern", "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 title.pattern \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0442\u0438\u043f\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u0430!");
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"deviceIdentifier", (String)device.getIdentifier());
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"deviceHost", (String)device.getHost());
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"deviceTitle", (String)device.getTitle());
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"login", (String)inetServ.getLogin());
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"interfaceId", (String)String.valueOf(inetServ.getInterfaceId()));
        if (inetServ.getDeviceId() > 0 && (deviceInterface = this.devicePortDao.get(device.getInvDeviceId(), inetServ.getInterfaceId())) != null) {
            titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"interfaceTitle", (String)deviceInterface.getTitle());
        }
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"vlan", (String)String.valueOf(inetServ.getVlan()));
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"addressNet", (String)IpNet.toString((byte[])inetServ.getAddressFrom(), (byte[])inetServ.getAddressTo()));
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"addressIp", (String)IpAddress.toString((byte[])inetServ.getAddressFrom()));
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"addressRange", (String)IpRange.toString((byte[])inetServ.getAddressFrom(), (byte[])inetServ.getAddressTo()));
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"mac", (String)Utils.bytesToString((byte[])inetServ.getMacAddressListBytes(), (boolean)true, (String)"-"));
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), Integer.valueOf(inetServ.getContractId()));
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"contractTitle", (String)(contractRuntime != null ? contractRuntime.getContractTitle() : "null"));
        StringBuilder macString = new StringBuilder();
        if (inetServ.getMacAddressList() != null && inetServ.getMacAddressList().size() > 0) {
            for (byte[] mac : inetServ.getMacAddressList()) {
                macString.append(Utils.bytesToString((byte[])mac, (boolean)true, null));
                macString.append(", ");
            }
            macString.setLength(macString.length() - 2);
        }
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"macAddress", (String)macString.toString());
        StringBuilder identifierString = new StringBuilder();
        if (inetServ.getIdentifierList() != null && inetServ.getIdentifierList().size() > 0) {
            for (String identifier : inetServ.getIdentifierList()) {
                identifierString.append(identifier);
                identifierString.append(", ");
            }
            identifierString.setLength(identifierString.length() - 2);
        }
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"identifier", (String)identifierString.toString());
        return titlePattern;
    }

    private void checkMacAddress(InetServ inetServ) throws BGMessageException {
        List macAddressList = inetServ.getMacAddressList();
        if (macAddressList != null) {
            int length = -1;
            for (byte[] macAddress : macAddressList) {
                if (length == -1) {
                    length = macAddress.length;
                    if (length == 6 || length == 8) continue;
                    throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 MAC-\u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0440\u0430\u0432\u043d\u0430 6(8) \u0431\u0430\u0439\u0442\u0430\u043c.");
                }
                if (length == macAddress.length) continue;
                throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 MAC-\u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0434\u043e\u043b\u0436\u043d\u0430 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c.");
            }
        }
    }

    private void checkPassword(InetServType servType, String password) throws BGMessageException {
        ParameterMap config = this.getModuleSetup().inherit((ParameterMap)new Preferences(servType.getConfig(), "\n"));
        int minLength = config.getInt("serv.password.length.min", 0);
        int maxLength = config.getInt("serv.password.length.max", 16);
        String passwordChars = config.get("serv.password.chars", "01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        String passwordCharsDescription = config.get("serv.password.chars.description", null);
        if (password.length() < minLength) {
            throw new BGMessageException("\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f " + minLength + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.");
        }
        if (password.length() > maxLength) {
            throw new BGMessageException("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f " + maxLength + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.");
        }
        if (!PswdGen.checkChars((String)password, (String)passwordChars)) {
            if (Utils.notBlankString((String)passwordCharsDescription)) {
                throw new BGMessageException(passwordCharsDescription);
            }
            throw new BGMessageException("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 " + passwordChars + ".");
        }
    }

    private void checkLoginSymbols(InetServ inetServ, InetServType servType) throws BGMessageException {
        String servLogin = inetServ.getLogin();
        ParameterMap config = this.getModuleSetup().inherit((ParameterMap)new Preferences(servType.getConfig(), "\n"));
        String loginChars = config.get("serv.login.chars", "01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        String loginCharsDescription = config.get("serv.login.chars.description", null);
        int size = servLogin.length();
        for (int i = 0; i < size; ++i) {
            if (loginChars.contains(servLogin.substring(i, i + 1))) continue;
            if (Utils.notBlankString((String)loginCharsDescription)) {
                throw new BGMessageException(loginCharsDescription);
            }
            throw new BGMessageException("\u041b\u043e\u0433\u0438\u043d \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 " + loginChars + ".");
        }
    }

    private void publishEvent(InetServ oldInetServ, List<InetServ> oldChildrenServs, InetServ newInetServ, List<InetServ> newChildrenServs, List<InetServOption> optionList, final long timeout) throws BGException {
        int parentInetServId;
        final EventProcessor ep = EventProcessor.getInstance();
        int inetServId = oldInetServ != null ? oldInetServ.getId() : newInetServ.getId();
        int n = parentInetServId = oldInetServ != null ? oldInetServ.getParentId() : newInetServ.getParentId();
        if (parentInetServId > 0) {
            InetServ oldParentServ = (InetServ)this.inetServDao.get(parentInetServId);
            short newDeviceState = this.detectState(oldParentServ);
            assert (oldChildrenServs == null);
            assert (newChildrenServs == null);
            newChildrenServs = this.inetServDao.listChildren(oldParentServ.getId());
            InetServ newParentServ = oldParentServ.clone();
            oldChildrenServs = new ArrayList<InetServ>(newChildrenServs);
            ListIterator<InetServ> it = oldChildrenServs.listIterator();
            while (it.hasNext()) {
                if (it.next().getId() != inetServId) continue;
                if (oldInetServ == null) {
                    it.remove();
                    break;
                }
                it.set(oldInetServ);
                break;
            }
            if (newInetServ == null && oldInetServ != null) {
                oldChildrenServs.add(oldInetServ);
            }
            oldParentServ.setChildren(oldChildrenServs);
            newParentServ.setChildren(newChildrenServs);
            List<InetServOption> parentOptionList = this.inetServOptionDao.list(newParentServ.getId());
            if (newParentServ != null && newDeviceState == InetServState.STATE_DELETED.getCode()) {
                newParentServ = null;
                optionList = new ArrayList<InetServOption>();
            }
            short oldParentServDeviceState = oldParentServ.getDeviceState();
            if (oldParentServ != null && oldParentServDeviceState == InetServState.STATE_DELETED.getCode() && newParentServ != null) {
                oldParentServ = null;
            }
            if (oldParentServ == null && newParentServ == null) {
                return;
            }
            if (timeout > 0L && newDeviceState == InetServState.STATE_ENABLE.getCode()) {
                newDeviceState = InetServState.STATE_DISABLE.getCode();
            }
            InetSaServModifyEvent e = new InetSaServModifyEvent(this.moduleId, 0, oldParentServ, newParentServ, newDeviceState, parentOptionList);
            if (timeout > 0L) {
                this.context.commit();
                e = (InetSaServModifyEvent)ep.request((Event)e, timeout);
            } else {
                ep.publish((Event)e);
            }
        } else {
            short newDeviceState = this.detectState(newInetServ);
            if (newInetServ != null && newDeviceState == InetServState.STATE_DELETED.getCode()) {
                newInetServ = null;
                optionList = new ArrayList<InetServOption>();
            }
            if (oldInetServ != null && oldInetServ.getDeviceState() == InetServState.STATE_DELETED.getCode() && newInetServ != null) {
                oldInetServ = null;
            }
            if (oldInetServ != null && oldInetServ.getChildren() == null) {
                oldInetServ.setChildren(oldChildrenServs);
            }
            if (newInetServ != null) {
                if (newInetServ.getChildren() == null) {
                    newInetServ.setChildren(newChildrenServs);
                }
            } else {
                newDeviceState = InetServState.STATE_DELETED.getCode();
                optionList = new ArrayList<InetServOption>();
            }
            if (oldInetServ == null && newInetServ == null) {
                return;
            }
            if (timeout > 0L && newDeviceState == InetServState.STATE_ENABLE.getCode()) {
                newDeviceState = InetServState.STATE_DISABLE.getCode();
            }
            final InetSaServModifyEvent e = new InetSaServModifyEvent(this.moduleId, 0, oldInetServ, newInetServ, newDeviceState, optionList);
            if (timeout > 0L) {
                this.context.addCommitable(new Commitable(){

                    public void commit() throws Exception {
                        ep.request((Event)e, timeout);
                    }
                });
            } else {
                this.context.publishAfterCommit((Event)e);
            }
        }
    }

    public void inetServIsActive(InetServ inetServ) throws Exception {
        boolean deviceStateDeleted;
        boolean bl = deviceStateDeleted = inetServ.getParentId() == 0 && inetServ.getDeviceState() == InetServState.STATE_DELETED.getCode();
        if (!deviceStateDeleted && TimeUtils.dateInRange((Date)new Date(), (Date)inetServ.getDateFrom(), (Date)inetServ.getDateTo())) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441 \u0441 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u043c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f.");
        }
        List<InetServType> servTypeList = this.inetServTypeList();
        if (inetServ.getParentId() <= 0) {
            List<InetServ> childrenServs = this.inetServDao.listChildren(inetServ.getId());
            for (InetServ child : childrenServs) {
                if (!deviceStateDeleted && TimeUtils.dateInRange((Date)new Date(), (Date)child.getDateFrom(), (Date)child.getDateTo())) {
                    throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441 \u0441 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u043c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0432 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0445 \u0441\u0435\u0440\u0432\u0438\u0441\u0430\u0445 .");
                }
                if (this.inetSessionDao.listAsLog(servTypeList, null, null, null, null, Collections.singleton(child.getId()), null, null, null, null, null, null, 0, 0, true).size() <= 0) continue;
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441 \u0441 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c\u0438 \u0441\u0435\u0441\u0441\u0438\u044f\u043c\u0438 \u0432 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0445 \u0441\u0435\u0440\u0432\u0438\u0441\u0430\u0445.");
            }
            inetServ.setChildren(childrenServs);
        }
        if (this.inetSessionDao.listAsLog(servTypeList, null, null, null, null, Collections.singleton(inetServ.getId()), null, null, null, null, null, null, 0, 0, true).size() > 0) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441 \u0441 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c\u0438 \u0441\u0435\u0441\u0441\u0438\u044f\u043c\u0438.");
        }
    }

    public void inetServDelete(int id, boolean force) throws Exception {
        InetServ inetServ = (InetServ)this.inetServDao.get(id);
        if (inetServ == null) {
            throw new BGIllegalArgumentException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0441\u0435\u0440\u0432\u0438\u0441");
        }
        if (!force) {
            this.inetServIsActive(inetServ);
        }
        if (inetServ.getParentId() <= 0) {
            List<InetServ> childrenServs = this.inetServDao.listChildren(inetServ.getId());
            for (InetServ child : childrenServs) {
                this.inetServDelete(child, false);
            }
            inetServ.setChildren(childrenServs);
        }
        this.inetServDelete(inetServ, true);
        if (force) {
            InetConnectionDao connectionDao = new InetConnectionDao(this.getConnection(), this.moduleId);
            InetSessionDao sessionDao = new InetSessionDao(this.getConnection(), this.moduleId);
            List<InetConnection> list = connectionDao.list(inetServ.getId());
            for (InetConnection connection : list) {
                for (InetSession session : sessionDao.list(connection.getId(), 1)) {
                    sessionDao.delete(session.getId());
                }
                connectionDao.delete(connection.getId());
            }
            connectionDao.close();
        }
    }

    private void inetServDelete(InetServ inetServ, boolean publishEvent) throws Exception {
        this.inetServDao.delete(inetServ.getId());
        InetServType inetServType = this.inetServTypeGet(inetServ.getTypeId());
        this.inetServOptionDao.deleteByServId(inetServ.getId());
        switch (inetServType.getAddressType()) {
            case DYNAMIC: 
            case NONE: {
                break;
            }
            case DYNAMIC_OR_RANGE: 
            case DYNAMIC_OR_SINGLE: {
                if (inetServ.getAddressFrom() == null) break;
            }
            default: {
                this.wsResource.ipResourceUnsubscribe(inetServ.getId(), inetServ.getIpResourceSubscriptionId(), inetServ.getAddressFrom(), inetServ.getAddressTo());
            }
        }
        this.wsResource.vlanResourceUnsubscribe(inetServ.getId());
        this.deviceInterfaceService.devicePortUnsubscribe(inetServ.getId());
        this.context.publishAfterCommit((Event)new InetServModifiedEvent(this.moduleId, inetServ.getContractId(), this.userId, inetServ, null, null));
        if (publishEvent) {
            this.publishEvent(inetServ, null, null, null, new ArrayList<InetServOption>(), 0L);
        }
    }

    public String inetServLoginGenerate() throws Exception {
        return this.inetServLoginGenerate(null, null, (ParameterMap)this.getModuleSetup());
    }

    private String inetServLoginGenerate(InetServ inetServ, InetServType inetServType, ParameterMap moduleSetup) throws Exception {
        String login = null;
        String accountLoginClass = moduleSetup.get("serv.login.class", moduleSetup.get("account.login.class"));
        if (accountLoginClass != null) {
            try {
                login = DynamicClassManager.getInstance().loadClass(accountLoginClass).asSubclass(InetAccountGenerate.class).getConstructor(new Class[0]).newInstance(new Object[0]).generateLogin(inetServ, inetServType, moduleSetup);
            }
            catch (Exception e) {
                this.logError(e);
                return null;
            }
        }
        if (login == null) {
            int min = moduleSetup.getInt("serv.login.min", moduleSetup.getInt("inetServ.login.startFrom", moduleSetup.getInt("inet.login.start.from", 1)));
            int max = moduleSetup.getInt("serv.login.max", Integer.MAX_VALUE);
            int loginValue = Math.max(this.inetServDao.lastNumericLogin(max) + 1, min);
            login = String.valueOf(loginValue);
        }
        return login;
    }

    public String inetServPasswordGenerate(int inetServTypeId) throws BGException {
        InetServType servType = null;
        if (inetServTypeId > 0) {
            servType = (InetServType)this.servTypeDirectory.get(inetServTypeId);
        }
        ModuleSetup config = this.getModuleSetup();
        if (servType != null) {
            config = config.inherit((ParameterMap)new Preferences(servType.getConfig(), "\n"));
        }
        return this.inetServPasswordGenerate(null, servType, (ParameterMap)config);
    }

    private String inetServPasswordGenerate(InetServ inetServ, InetServType inetServType, ParameterMap moduleSetup) throws BGException {
        String pswd = null;
        String accountPasswordClass = moduleSetup.get("account.password.class");
        if (accountPasswordClass != null) {
            try {
                pswd = DynamicClassManager.getInstance().loadClass(accountPasswordClass).asSubclass(InetAccountGenerate.class).getConstructor(new Class[0]).newInstance(new Object[0]).generatePassword(inetServ, inetServType, moduleSetup);
            }
            catch (Exception e) {
                this.logError(e);
                return null;
            }
        }
        if (pswd == null) {
            int length = moduleSetup.getInt("serv.password.length.auto", 6);
            String passwordChars = moduleSetup.get("serv.password.chars.auto", moduleSetup.get("serv.password.chars", "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"));
            pswd = PswdGen.generatePassword((int)length, (String)passwordChars);
        }
        return pswd;
    }

    public void inetServMove(InetServ inetServ, int cidTo) throws Exception {
        if (inetServ.getParentId() > 0) {
            throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f  \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0438\u0442\u044c \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 ");
        }
        this.inetServMoveInternal(inetServ, cidTo, 0);
    }

    private void inetServMoveInternal(InetServ inetServ, int cidTo, int parentId) throws Exception {
        List childOptionList;
        if (inetServ.getDateFrom() == null) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u0441\u0435\u0440\u0432\u0438\u0441, \u0442.\u043a. \u043e\u043d \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f.");
        }
        int justCreated = 0;
        InetServ newInetServ = inetServ.clone();
        newInetServ.setId(0);
        List<InetServOption> optionList = this.inetServOptionList(inetServ.getId());
        newInetServ.setContractId(cidTo);
        inetServ.setChildren(this.inetServDao.listChildren(inetServ.getId()));
        ArrayList<InetServ> newChildServs = new ArrayList<InetServ>();
        HashMap<Integer, List> childOptionMap = new HashMap<Integer, List>();
        if (inetServ.getParentId() <= 0) {
            for (InetServ childServ : inetServ.getChildren()) {
                InetServ newChildInetServ = childServ.clone();
                newChildInetServ.setContractId(cidTo);
                childOptionList = this.inetServOptionList(childServ.getId());
                newChildServs.add(newChildInetServ);
                childOptionMap.put(childServ.getId(), childOptionList);
            }
        }
        InetServMoveManager inetServMoveManager = new InetServMoveManager(this.getConnection(), this.moduleId);
        if (inetServ.getParentId() <= 0 || parentId > 0) {
            this.inetServCloseInternal(inetServ);
        }
        if (inetServ.getParentId() <= 0 && inetServ.getChildren() != null && inetServ.getChildren() != null) {
            for (InetServ childServ : inetServ.getChildren()) {
                childServ.setStatus(InetServStatus.STATUS_OFF);
                this.inetServDelete(childServ, false);
            }
        }
        if (inetServ.getParentId() <= 0 || parentId > 0) {
            inetServ.setStatus(InetServStatus.STATUS_OFF);
            this.inetServDelete(inetServ.getId(), false);
            if (inetServ.getParentId() > 0 && parentId > 0) {
                newInetServ.setParentId(parentId);
            }
            justCreated = this.inetServUpdate(newInetServ, optionList, false, false, 0L);
            inetServMoveManager.moveSessionData(inetServ, newInetServ);
        }
        if (inetServ.getParentId() <= 0 && justCreated > 0 && inetServ.getChildren() != null) {
            for (InetServ newChildInetServ : newChildServs) {
                childOptionList = (List)childOptionMap.get(newChildInetServ.getId());
                newChildInetServ.setId(0);
                newChildInetServ.setParentId(justCreated);
                justCreated = this.inetServUpdate(newChildInetServ, childOptionList, false, false, 0L);
                inetServMoveManager.moveSessionData(inetServ, newChildInetServ);
            }
        }
        inetServMoveManager.close();
    }

    private void inetServCloseInternal(InetServ inetServ) throws Exception {
        Calendar cal = Calendar.getInstance();
        Date today = cal.getTime();
        cal.add(5, -1);
        Date closeDate = cal.getTime();
        List<InetServOption> optionList = this.inetServOptionList(inetServ.getId());
        inetServ.setDateTo(closeDate);
        InetServMoveManager inetServMoveManager = new InetServMoveManager(this.getConnection(), this.moduleId);
        if (TimeUtils.dateBeforeOrEq((Date)inetServ.getDateFrom(), (Date)today)) {
            inetServMoveManager.checkForCurrentSessions(inetServ);
        }
        inetServMoveManager.close();
        this.inetServUpdate(inetServ, optionList, false, false, 0L);
        if (inetServ.getParentId() <= 0 && inetServ.getChildren() != null) {
            for (InetServ childServ : inetServ.getChildren()) {
                this.inetServCloseInternal(childServ);
            }
        }
    }

    public void inetServWrap(InetServ inetServ, int cidTo, Date openDate) throws Exception {
        if (inetServ.getParentId() > 0) {
            throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f  \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0438\u0442\u044c \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 ");
        }
        this.inetServWrapInternal(inetServ, cidTo, openDate, 0);
    }

    private void inetServWrapInternal(InetServ inetServ, int cidTo, Date openDate, int parentId) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(openDate);
        cal.add(5, -1);
        Date closeDate = cal.getTime();
        Date today = new Date();
        if (inetServ.getDateFrom() == null) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u0441\u0435\u0440\u0432\u0438\u0441, \u0442.\u043a. \u043e\u043d \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f.");
        }
        if (inetServ.getDateTo() != null && TimeUtils.dateBeforeOrEq((Date)inetServ.getDateTo(), (Date)closeDate)) {
            return;
        }
        if (inetServ.getDateFrom() != null && TimeUtils.dateBeforeOrEq((Date)openDate, (Date)inetServ.getDateFrom())) {
            this.inetServMoveInternal(inetServ, cidTo, parentId);
            return;
        }
        InetServ newInetServ = inetServ.clone();
        int justCreated = 0;
        List<InetServOption> optionList = this.inetServOptionList(inetServ.getId());
        newInetServ.setId(0);
        InetServMoveManager inetServMoveManager = new InetServMoveManager(this.getConnection(), this.moduleId);
        if (inetServ.getParentId() <= 0 || parentId > 0) {
            newInetServ.setDateFrom(openDate);
            newInetServ.setContractId(cidTo);
            if (inetServ.getParentId() > 0 && parentId > 0) {
                newInetServ.setParentId(parentId);
            }
            inetServ.setDateTo(closeDate);
            if (TimeUtils.dateBeforeOrEq((Date)openDate, (Date)today)) {
                inetServ.setStatus(InetServStatus.STATUS_OFF);
                inetServMoveManager.checkForCurrentSessions(inetServ);
            }
            this.inetServUpdateInternal(inetServ, optionList, false, false, 0L, false);
            if (TimeUtils.dateBeforeOrEq((Date)openDate, (Date)today)) {
                this.inetServDao.updateDeviceStateAndOptions(inetServ.getId(), InetServState.STATE_DELETED.getCode(), null, 20);
            }
            justCreated = this.inetServUpdate(newInetServ, optionList, false, false, 0L);
            inetServMoveManager.wrapSessionData(inetServ, newInetServ);
        }
        inetServMoveManager.close();
        if (inetServ.getParentId() <= 0 && inetServ.getChildren() != null) {
            for (InetServ childServ : inetServ.getChildren()) {
                this.inetServWrapInternal(childServ, cidTo, openDate, justCreated);
            }
        }
    }

    public InetOption inetOptionGet(int id) throws BGException {
        return (InetOption)this.inetOptionDao.get(id);
    }

    public List<InetOption> inetOptionList() throws BGException {
        return this.inetOptionDao.list();
    }

    public InetOption inetOptionTree() throws Exception {
        return this.inetOptionDao.tree();
    }

    public int inetOptionUpdate(InetOption b) throws Exception {
        InetOption oldOption = (InetOption)this.inetOptionDao.getAndUpdate((Id)b);
        this.context.publishAfterCommit((Event)new InetOptionModifiedEvent(this.moduleId, this.userId, oldOption, b));
        return b.getId();
    }

    public void inetOptionDelete(int id) throws BGException {
        if (this.inetServOptionDao.optionIsUsed(id)) {
            throw new BGMessageException("\u041e\u043f\u0446\u0438\u044e \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d\u0430 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a \u0441\u0435\u0440\u0432\u0438\u0441\u0430\u043c \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445 ");
        }
        try {
            InetOption oldOption = (InetOption)this.inetOptionDao.getAndDelete(id);
            this.context.publishAfterCommit((Event)new InetOptionModifiedEvent(this.moduleId, this.userId, oldOption, null));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void inetOptionMove(int newParentId, Set<Integer> ids) throws Exception {
        HashMap<Integer, InetOption> oldMap = new HashMap<Integer, InetOption>();
        for (Integer id : ids) {
            oldMap.put(id, (InetOption)this.inetOptionDao.get(id));
        }
        this.inetOptionDao.move(newParentId, ids);
        for (Integer id : ids) {
            InetOption oldOption = (InetOption)oldMap.get(id);
            InetOption newOption = (InetOption)this.inetOptionDao.get(id);
            this.context.publishAfterCommit((Event)new InetOptionModifiedEvent(this.moduleId, this.userId, oldOption, newOption));
        }
    }

    public TrafficType trafficTypeGet(int id) throws BGException {
        return (TrafficType)this.trafficTypeDao.get(id);
    }

    public List<TrafficType> trafficTypeList() throws BGException {
        return this.trafficTypeDao.list();
    }

    public int trafficTypeUpdate(TrafficType b) throws BGException {
        try {
            this.trafficTypeDao.update(b);
            return b.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void trafficTypeDelete(int id) throws BGException {
        try {
            this.trafficTypeDao.delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public TrafficTypeLink trafficTypeLinkGet(int id) throws BGException {
        return (TrafficTypeLink)this.trafficTypeLinkDirectory.get(id);
    }

    public List<TrafficTypeLink> trafficTypeLinkList() throws Exception {
        return this.trafficTypeLinkDirectory.list();
    }

    public int trafficTypeLinkUpdate(TrafficTypeLink b) throws BGException {
        try {
            this.trafficTypeLinkDirectory.update((Id)b);
            return b.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void trafficTypeLinkDelete(int id) throws BGException {
        try {
            this.trafficTypeLinkDirectory.delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<InetServOption> inetServOptionList(int servId) throws BGException {
        return this.inetServOptionDao.list(servId);
    }

    public List<InetServRestriction> inetServRestrictionList(int servId) throws BGException {
        return this.inetServRestrictionDao.list(servId);
    }

    public List<InetServRestriction> inetServRestrictionList(int contractId, int servId) throws BGException {
        return this.inetServRestrictionDao.list(servId);
    }

    public void inetServRestrictionListUpdate(int inetServId, List<InetServRestriction> restrictionList) throws BGException {
        this.inetServRestrictionListUpdate(-1, inetServId, restrictionList);
    }

    public void inetServRestrictionListUpdate(int contractId, int inetServId, List<InetServRestriction> restrictionList) throws BGException {
        InetServ inetServ = this.inetServGet(inetServId);
        if (contractId > 0 && inetServ.getContractId() != contractId) {
            throw new BGIllegalArgumentException("inetServId");
        }
        this.inetServRestrictionDao.update(inetServId, restrictionList);
        this.context.publishAfterCommit((Event)new InetServRestrictionModifiedEvent(this.moduleId, inetServ.getContractId(), inetServId, this.userId));
    }

    @Deprecated
    public int vlanResourceCategoryId(int deviceId) throws Exception {
        InetDeviceMap.InetDeviceMapItem deviceMap = InetDeviceMap.getInstance(this.moduleId).get(deviceId);
        int vlanResourceCategoryId = deviceMap.getConfig().getInt("vlan.resource.category", -1);
        if (vlanResourceCategoryId == -1) {
            throw new BGException("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430 VLAN \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430!");
        }
        return vlanResourceCategoryId;
    }

    public Set<Integer> vlanResourceCategoryIds(int deviceId) throws Exception {
        InetDeviceMap.InetDeviceMapItem deviceMap = InetDeviceMap.getInstance(this.moduleId).get(deviceId);
        Set vlanResourceCategoryIds = Utils.toIntegerSet((String)deviceMap.getConfig().get("vlan.resource.category", null));
        vlanResourceCategoryIds.remove(-1);
        if (vlanResourceCategoryIds.size() == 0) {
            throw new BGMessageException("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430 vlan \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430!!");
        }
        return vlanResourceCategoryIds;
    }

    public List<Integer> ipResourceCategoryIds(int deviceId, int interfaceId, int servTypeId) throws Exception {
        InetDevice inetDevice;
        DeviceInterface iface;
        if (deviceId <= 0) {
            throw new BGMessageException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e!");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (interfaceId >= 0 && (iface = this.deviceInterfaceService.devicePort((inetDevice = this.inetDeviceDao.get(deviceId)).getInvDeviceId(), interfaceId)) != null && iface.getIpCategoryId() > 0) {
            result.add(iface.getIpCategoryId());
        }
        InetDeviceMap.InetDeviceMapItem device = InetDeviceMap.getInstance(this.moduleId).get(deviceId);
        Map<Integer, List<Integer>> netflowLink = InetDeviceMap.parseFlowAgentMap(device.getDevice().getInvDeviceId(), deviceId, device.getConfig(), this.devicePortDao);
        for (Map.Entry<Integer, List<Integer>> entry : netflowLink.entrySet()) {
            int devId = entry.getKey();
            List<Integer> ifaces = entry.getValue();
            List realIfaces = this.deviceInterfaceService.devicePortList(devId, false);
            for (Integer iface2 : ifaces) {
                for (DeviceInterface riface : realIfaces) {
                    if (riface.getPort() != iface2.intValue() || riface.getIpCategoryId() <= 0 || riface.getStatus() != 1 || devId == deviceId && interfaceId >= 0 && interfaceId != iface2 || result.contains(riface.getIpCategoryId())) continue;
                    result.add(riface.getIpCategoryId());
                }
            }
        }
        ParameterMap deviceCategoryIds = device.getConfig().sub("ip.resource.categoryId.");
        for (Map.Entry e : deviceCategoryIds.entrySet()) {
            String key = (String)e.getKey();
            if (Utils.isBlankString((String)key) || !Utils.toIntegerSet((String)key).contains(servTypeId)) continue;
            List ipResourceCategoryIds = Utils.toIntegerList((String)((String)e.getValue()));
            for (Integer ipResourceCategoryId : ipResourceCategoryIds) {
                if (result.contains(ipResourceCategoryId)) continue;
                result.add(ipResourceCategoryId);
            }
        }
        List list = Utils.toIntegerList((String)device.getConfig().get("ip.resource.categoryId", device.getConfig().get("ip.resource.category", null)));
        for (Integer ipResourceCategoryId : list) {
            if (result.contains(ipResourceCategoryId)) continue;
            result.add(ipResourceCategoryId);
        }
        if (result.size() == 0) {
            throw new BGMessageException("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f IP-\u0440\u0435\u0441\u0443\u0440\u0441\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
        }
        return result;
    }

    public SearchResult<InetServ> searchInetServ(InetServSearchParam searchParam, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setList(this.inetServDao.searchInetServ(searchParam, page));
        return searchResult;
    }

    public void inetServSaReinit(int id) throws BGException {
        InetServ inetServ = (InetServ)this.inetServDao.get(id);
        if (inetServ == null) {
            throw new BGException("\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        EventProcessor.getInstance().publish((Event)new InetSaServInitEvent(this.moduleId, this.userId, inetServ.getDeviceId(), inetServ.getId()));
    }

    public String ipResourceLinkCheck() throws Exception {
        List<InetServ> inetServList = this.inetServDao.listByWrongIpResourceIds(new Date(), new Page(1, 5));
        if (inetServList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            int size = inetServList.size();
            for (int i = 0; i < size && i < 10; ++i) {
                InetServ inetServ = inetServList.get(0);
                sb.append("id: ").append(inetServ.getId()).append(", contractId: ").append(inetServ.getContractId()).append(", deviceId: ").append(inetServ.getDeviceId()).append(", title: ").append(inetServ.getTitle()).append('\n');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }
        return null;
    }

    public void ipResourceLinkSet() throws Exception {
        List<InetServ> inetServList = this.inetServDao.listByWrongIpResourceIds(new Date(), null);
        for (InetServ inetServ : inetServList) {
            try {
                List<InetServOption> optionList = this.inetServOptionList(inetServ.getId());
                this.inetServUpdate(inetServ, optionList, false, false, 0L);
            }
            catch (Exception ex) {
                throw new BGException("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + inetServ.getContractId() + ", ID \u0441\u0435\u0440\u0432\u0438\u0441\u0430: " + inetServ.getId() + ". " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public byte[] inetGetIpFromParent(InetServ serv) throws BGException {
        InetServ parent = null;
        if (serv.getParentId() <= 0 || (parent = (InetServ)this.inetServDao.get(serv.getParentId())) == null) {
            throw new BGException("\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442!!");
        }
        if (parent.getAddressFrom() == null || parent.getAddressTo() == null) {
            throw new BGMessageException("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u043d\u0430 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u043c \u0441\u0435\u0440\u0432\u0438\u0441\u0435");
        }
        byte[] result = null;
        if (parent != null) {
            List<InetServ> childs = this.inetServDao.listChildren(parent.getId());
            HashSet<IpAddress> used = new HashSet<IpAddress>();
            for (InetServ child : childs) {
                used.add(new IpAddress(child.getAddressFrom()));
            }
            InetServType servType = (InetServType)this.servTypeDirectory.get(serv.getTypeId());
            Preferences servTypeConfig = new Preferences(servType.getConfig(), "\n\r");
            byte[] addressFrom = InetServIpUtils.getStartAddressFromParent(parent, servTypeConfig);
            byte[] addressTo = InetServIpUtils.getEndAddressFromParent(parent, servTypeConfig);
            byte[] addr = addressFrom;
            while (IpAddress.compare((byte[])addr, (byte[])addressTo) <= 0) {
                if (!used.contains(new IpAddress(addr))) {
                    result = addr;
                    break;
                }
                IpAddress.increment((byte[])addr);
            }
        }
        if (result == null) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0439 ip \u043d\u0430 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u043c \u0441\u0435\u0440\u0432\u0438\u0441\u0435");
        }
        return result;
    }

    public int authorizationRequest(int contractId, int servId, boolean accountingPeriodActivate, long timeout) throws Exception {
        if (timeout <= 0L) {
            timeout = 10000L;
        }
        InetServ inetServ = this.inetServGet(servId);
        int accountingRootDeviceId = InetUtils.getAccountingRootDeviceId(this.context.getSetup(), this.moduleId, inetServ.getDeviceId());
        InetAuthorizationRequestEvent e = (InetAuthorizationRequestEvent)EventProcessor.getInstance().request((Event)new InetAuthorizationRequestEvent(this.moduleId, this.userId, accountingRootDeviceId, inetServ.getDeviceId(), servId, accountingPeriodActivate), timeout);
        if (e == null) {
            throw new BGMessageException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e Access \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d");
        }
        return e.getAccessCode();
    }
}

