/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.eap;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.MSUtils;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPMessage;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPSession;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPTLSAuthenticator;
import ru.bitel.bgbilling.kernel.network.radius.info.BinaryInfo;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class EAPTTLSAuthenticator0<N extends Nas<?, ?, ?>, P>
extends EAPTLSAuthenticator<N, P> {
    private static final Logger logger = LogManager.getLogger();
    public static final byte[] TTLSv0_START_A = new byte[]{32};
    private State state = State.auth;
    private RadiusPacket internalRequest;
    private static final Random random = new Random();
    private static final byte[] LABEL_KEYING_MATERIAL_TTLS = EAPTTLSAuthenticator0.getBytes("ttls keying material");

    public EAPTTLSAuthenticator0(EAPSession<N, P> session) {
        super(session);
    }

    @Override
    public EAPMessage start() {
        logger.debug("Start eap-ttls");
        this.session.identifier = (byte)(this.session.identifier + 1);
        return new EAPMessage(1, this.session.identifier, 21, ByteBuffer.wrap(TTLSv0_START_A));
    }

    @Override
    protected byte tunneledAuthentificating(EAPMessage _eap, RadiusSession<N, P> radiusSession, RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId) throws Exception {
        byte[] in = this.tunnel.getAppBuffer();
        if (logger.isTraceEnabled()) {
            logger.trace("Tunnel in:" + Utils.bytesToString((byte[])in));
        }
        switch (this.state.ordinal()) {
            case 1: {
                this.internalRequest = this.parsePacket(ByteBuffer.wrap(in));
                this.session.acceptPacket = new RadiusPacket(0, 0);
                this.internalRequest.addOptions(request);
                Object username = this.internalRequest.getAttribute(-1, 1);
                if (username != null) {
                    this.session.acceptPacket.setAttribute((RadiusAttribute<?>)((RadiusAttribute)username).clone());
                }
                int errorCode = radiusSession.authentication(processor, req, nas, this.internalRequest, this.session.acceptPacket, connectionSet, logRecordId);
                byte[] msChap2Response = this.internalRequest.getByteAttribute(311, 25, null);
                if (msChap2Response != null) {
                    byte chapIdent = msChap2Response[0];
                    if (errorCode == 0) {
                        ByteBuffer bb = this.writePacket(this.session.acceptPacket, true, chapIdent);
                        this.tunnel.putAppBuffer(Utils.byteBufferAsArray((ByteBuffer)bb, (int)bb.limit()));
                        logger.debug("Accepting");
                        if (logger.isTraceEnabled()) {
                            logger.trace("Tunnel out: " + Utils.bytesToString((byte[])Utils.byteBufferAsArray((ByteBuffer)bb, (int)bb.limit())));
                        }
                        this.state = State.accepting;
                        return 11;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("E=691 R=0 C=");
                    byte[] challenge = new byte[32];
                    random.nextBytes(challenge);
                    sb.append(Utils.bytesToHexString((byte[])challenge));
                    sb.append(" V=3");
                    byte[] authMessage = sb.toString().getBytes("cp1251");
                    byte[] error = new byte[authMessage.length + 1];
                    error[0] = 63;
                    System.arraycopy(authMessage, 0, error, 1, authMessage.length);
                    this.session.acceptPacket.setAttribute(new RadiusAttribute(311, 2, ByteBuffer.wrap(error)));
                    ByteBuffer bb = this.writePacket(this.session.acceptPacket, false, chapIdent);
                    this.tunnel.putAppBuffer(Utils.byteBufferAsArray((ByteBuffer)bb, (int)bb.limit()));
                    logger.debug("Rejecting");
                    if (logger.isTraceEnabled()) {
                        logger.trace("Tunnel out: " + Utils.bytesToString((byte[])Utils.byteBufferAsArray((ByteBuffer)bb, (int)bb.limit())));
                    }
                    this.state = State.rejecting;
                    this.session.rejecting();
                    return 11;
                }
                if (errorCode == 0) {
                    logger.debug("CHAP/PAP Accepted");
                    this.session.acceptPacket.removeAttributes(-1, 79);
                    this.session.acceptPacket.removeAttributes(-1, 80);
                    this.session.acceptPacket.removeAttributes(311, 26);
                    this.session.acceptPacket.removeAttributes(311, 16);
                    this.session.acceptPacket.removeAttributes(311, 17);
                    response.addAttributes(this.session.acceptPacket);
                    return 2;
                }
                return 3;
            }
            case 2: {
                logger.debug("Accepting ok");
                boolean success = true;
                if (in.length > 0) {
                    success = false;
                    logger.warn("Radius client return error");
                    this.internalRequest = this.parsePacket(ByteBuffer.wrap(in));
                    logger.warn("Radius client packet: " + String.valueOf(this.internalRequest));
                }
                logger.info((Object)success);
                if (success) {
                    this.session.acceptPacket.removeAttributes(-1, 79);
                    this.session.acceptPacket.removeAttributes(-1, 80);
                    this.session.acceptPacket.removeAttributes(311, 26);
                    this.session.acceptPacket.removeAttributes(311, 16);
                    this.session.acceptPacket.removeAttributes(311, 17);
                    response.addAttributes(this.session.acceptPacket);
                    return 2;
                }
                return 3;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return -1;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public byte getAuthentificatorType() {
        return 21;
    }

    @Override
    public boolean checkPassword(RadiusAttributeSet _request, RadiusAttributeSet _response, String openPassw, byte[] secret, byte[] authenticator) {
        logger.debug("Checking password");
        RadiusAttribute.RadiusAttributeString pswd = (RadiusAttribute.RadiusAttributeString)this.internalRequest.getAttribute(-1, 2);
        if (pswd != null) {
            int len;
            byte[] pswdBytes = pswd.getDataAsByteArray();
            for (len = pswdBytes.length - 1; len >= 0 && pswdBytes[len] == 0; --len) {
            }
            try {
                String userPassw = new String(pswdBytes, 0, len + 1, "UTF-8");
                if (userPassw != null && openPassw != null && (userPassw.equals(openPassw) || Utils.getDigest((String)userPassw, (String)"cp1251").equals(openPassw))) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (RadiusUtils.checkChapPassword(this.internalRequest, authenticator, openPassw)) {
            return true;
        }
        return MSUtils.checkMSChapV2Password(this.internalRequest, this.session.acceptPacket, openPassw, secret, authenticator, false);
    }

    protected RadiusAttributeSet parseAttributes(ByteBuffer bb) {
        RadiusAttributeSet result = new RadiusAttributeSet();
        int maxPosition = bb.limit();
        while (bb.position() < maxPosition) {
            RadiusAttribute<?> attr = this.parseAttribute(bb);
            logger.debug(attr);
            result.addAttribute(attr);
        }
        return result;
    }

    protected RadiusPacket parsePacket(ByteBuffer bb) {
        RadiusPacket result = new RadiusPacket(0, 0);
        int maxPosition = bb.limit();
        while (bb.position() < maxPosition) {
            RadiusAttribute<?> attr = this.parseAttribute(bb);
            logger.debug(attr);
            result.addAttribute(attr);
        }
        return result;
    }

    protected ByteBuffer writePacket(RadiusPacket packet, boolean result, byte chapIdent) {
        ByteBuffer bb = ByteBuffer.allocate(500);
        if (result) {
            Object attr = packet.getAttribute(311, 26);
            if (attr != null) {
                int pos = bb.position();
                this.writeAttribute((RadiusAttribute<?>)attr, bb, true);
                bb.put(pos + 12, chapIdent);
            }
        } else {
            Object attr = packet.getAttribute(311, 2);
            if (attr != null) {
                this.writeAttribute((RadiusAttribute<?>)attr, bb, true);
            }
        }
        bb.flip();
        return bb;
    }

    private void writeAttribute(RadiusAttribute<?> attr, ByteBuffer _bb, boolean mandatory) {
        byte flags;
        ByteBuffer bb = ByteBuffer.allocate(1000);
        ByteBuffer data = attr.getData();
        int length = data.limit();
        bb.putInt(((RadiusAttributeInfo)attr.info).type);
        byte by = flags = mandatory ? (byte)64 : 0;
        if (((RadiusAttributeInfo)attr.info).vendor != -1) {
            flags = (byte)(flags | 0xFFFFFF80);
            length += 12;
        } else {
            length += 8;
        }
        bb.put(flags);
        byte[] lengthBytes = Utils.convertIntToBytes((int)length);
        bb.put(lengthBytes[1]);
        bb.put(lengthBytes[2]);
        bb.put(lengthBytes[3]);
        if (((RadiusAttributeInfo)attr.info).vendor != -1) {
            bb.putInt(((RadiusAttributeInfo)attr.info).vendor);
        }
        bb.put(data);
        int padding = length % 4;
        if (padding > 0) {
            for (int i = padding; i < 4; ++i) {
                bb.put((byte)0);
            }
        }
        bb.flip();
        _bb.put(bb);
        bb.rewind();
        logger.debug("Write attribute " + Utils.bytesToString((byte[])Utils.byteBufferAsArray((ByteBuffer)bb.slice())));
    }

    protected RadiusAttribute<?> parseAttribute(ByteBuffer bb) {
        int vendor;
        int type = bb.getInt();
        byte flags = bb.get();
        int length = 0xFF0000 & bb.get() << 16;
        length |= 0xFF00 & bb.get() << 8;
        int padding = (length |= 0xFF & bb.get()) % 4;
        if ((flags & 0x80) > 0) {
            vendor = bb.getInt();
            length -= 12;
        } else {
            vendor = -1;
            length -= 8;
        }
        RadiusAttributeInfo.RadiusAttributeHeader header = new RadiusAttributeInfo.RadiusAttributeHeader();
        header.vendor = vendor;
        header.type = type;
        header.length = length;
        logger.debug("vendor=" + vendor);
        logger.debug("type=" + type);
        logger.debug("length=" + length);
        BinaryInfo info = RadiusDictionary.getAttributeInfo(vendor, type);
        if (info == null) {
            String name = "UNKNOWN[" + header.vendor + "-" + header.type + "]";
            info = new BinaryInfo(header.vendor, header.type, name, 0, 1, 1, false, false, null);
        }
        RadiusAttribute<?> result = info.read(bb, header);
        if (padding > 0) {
            bb.position(bb.position() + (4 - padding));
        }
        return result;
    }

    @Override
    public byte[][] getMppeKeys() {
        byte[] key = this.tunnel.getKeyMaterial(LABEL_KEYING_MATERIAL_TTLS);
        byte[] recv = new byte[32];
        byte[] send = new byte[32];
        System.arraycopy(key, 0, recv, 0, 32);
        System.arraycopy(key, 32, send, 0, 32);
        return new byte[][]{recv, send};
    }

    private static byte[] getBytes(String s) {
        return s.getBytes(StandardCharsets.ISO_8859_1);
    }

    static enum State {
        none,
        auth,
        accepting,
        rejecting,
        rejectingNAK;

    }

    protected static final class TLV {
        public static final byte[] tlvResultSuccess = TLV.getBytesData(true, 3, new byte[]{0, 1});
        public static final byte[] tlvResultFailure = TLV.getBytesData(true, 3, new byte[]{0, 2});
        public final boolean mandatory;
        public final int type;
        public final byte[] value;

        protected TLV(boolean mandatory, int type, byte[] value) {
            this.mandatory = mandatory;
            this.type = type;
            this.value = value;
        }

        public byte[] getBytesData() {
            byte[] result = new byte[this.value.length + 4];
            result[0] = (byte)(this.type >> 8);
            result[1] = (byte)(this.type & 0xFF);
            result[0] = (byte)(result[0] & 0xBF);
            result[0] = this.mandatory ? (byte)(result[0] | 0x80) : (byte)(result[0] & 0x7F);
            result[2] = (byte)(this.value.length >> 8);
            result[3] = (byte)(this.value.length & 0xFF);
            System.arraycopy(this.value, 0, result, 4, this.value.length);
            return result;
        }

        public static byte[] getBytesData(boolean mandatory, int type, byte[] value) {
            byte[] result = new byte[value.length + 4];
            result[0] = (byte)(type >> 8);
            result[1] = (byte)(type & 0xFF);
            result[0] = (byte)(result[0] & 0xBF);
            result[0] = mandatory ? (byte)(result[0] | 0x80) : (byte)(result[0] & 0x7F);
            result[2] = (byte)(value.length >> 8);
            result[3] = (byte)(value.length & 0xFF);
            System.arraycopy(value, 0, result, 4, value.length);
            return result;
        }
    }
}

