/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.agr.server.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.agr.common.bean.AGREnvironment;
import ru.bitel.bgbilling.modules.agr.common.bean.Transaction;
import ru.bitel.bgbilling.modules.agr.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.agr.server.bean.AGRAction;
import ru.bitel.bgbilling.modules.agr.server.bean.AGRErrorCode;
import ru.bitel.bgbilling.modules.agr.server.bean.AGRException;
import ru.bitel.bgbilling.modules.agr.server.bean.AGRRequest;
import ru.bitel.bgbilling.modules.agr.server.bean.AGRRequestEvent;
import ru.bitel.bgbilling.modules.agr.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.worker.ThreadContext;

@WebServlet(name="AGRExecutor", urlPatterns={"/agrexecutor/*"})
public class ModuleExecutor
extends CommonExecutor {
    private ObjectMapper mapper = new ObjectMapper();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServerContext context = new ServerContext(this.setup, 0, -1);
        ThreadContext parentContext = ThreadContext.push((ThreadContext)context);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        TransactionManager transactionDao = null;
        try {
            Connection con = context.getConnection();
            try {
                this.getLogger().debug("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f");
                int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)req);
                this.getLogger().debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 mid \u0438\u0437 url => mid = {}", (Object)moduleId);
                transactionDao = new TransactionManager(con, moduleId);
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                DecimalFormat decimalFormat = new DecimalFormat(moduleSetup.get("agr.transaction.format", "BG000000000"));
                this.getLogger().debug("\u0421\u0447\u0438\u0442\u044b\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                ServletInputStream is = req.getInputStream();
                StringBuilder jsonString = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        jsonString.append(line);
                    }
                }
                AGRRequest agrRequest = AGRRequest.parseRequest(jsonString.toString(), req.getPathInfo());
                this.checkSign(agrRequest, moduleSetup);
                AGRAction action = agrRequest.getAction();
                switch (action) {
                    case INFO: {
                        this.getLogger().debug("INFO");
                        String merchantTransId = agrRequest.getMerchantTransId();
                        this.getLogger().debug("\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438 \u0438\u0449\u0435\u043c \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e");
                        int contractId = -1;
                        try (ContractDao contractDao = new ContractDao(con, 0);){
                            Contract contract = contractDao.getByTitle(merchantTransId);
                            if (contract != null) {
                                contractId = contract.getId();
                            }
                        }
                        try {
                            int transactionId = decimalFormat.parse(merchantTransId).intValue();
                            Transaction transaction = transactionDao.getTransaction(transactionId);
                            contractId = transaction.getContractId();
                        }
                        catch (ParseException transactionId) {
                            // empty catch block
                        }
                        if (contractId <= 0) {
                            throw new AGRException(AGRErrorCode.USER_DOES_NOT_EXIST, "Contract with merchantTransId=" + merchantTransId + " does not exist");
                        }
                        this.getLogger().debug("contractId = {}", (Object)contractId);
                        this.getLogger().debug("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u043f\u0443\u0441\u0442\u0443\u044e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e");
                        Transaction transaction = new Transaction().setContractId(contractId).setStatus(TransactionStatus.NEW.getCode()).setCreateDate(new Date());
                        new TransactionManager(con, moduleId).update(transaction);
                        this.getLogger().debug("transactionId = {}", (Object)transaction.getId());
                        this.getLogger().debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
                        AGRRequestEvent requestEvent = new AGRRequestEvent(moduleId, agrRequest, req, contractId);
                        requestEvent = (AGRRequestEvent)EventProcessor.getInstance().request((QueueEvent)requestEvent);
                        Map<String, String> eventParameters = requestEvent.getParameters();
                        if (eventParameters == null) break;
                        resultMap.put("PARAMETERS", eventParameters);
                        break;
                    }
                    case PAY: {
                        this.getLogger().debug("PAY");
                        this.getLogger().debug("\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438 \u0438\u0449\u0435\u043c \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e");
                        Transaction transaction = transactionDao.getTransaction(agrRequest.getAgrTransId());
                        if (transaction != null) {
                            throw new AGRException(AGRErrorCode.ALREADY_PAID, "Already paid");
                        }
                        int contractId = -1;
                        String merchantTransId = agrRequest.getMerchantTransId();
                        try (ContractDao contractDao = new ContractDao(con, 0);){
                            Contract contract = contractDao.getByTitle(merchantTransId);
                            if (contract != null) {
                                contractId = contract.getId();
                                SearchParam searchParam = new SearchParam().setContractId(contractId).setStatus(TransactionStatus.NEW.getCode());
                                SearchResult searchResult = new SearchResult();
                                transactionDao.searchTransaction((SearchResult<Transaction>)searchResult, searchParam, null);
                                if (searchResult.getList().size() > 0) {
                                    transaction = (Transaction)searchResult.getList().get(0);
                                }
                            }
                        }
                        try {
                            int transactionId = decimalFormat.parse(merchantTransId).intValue();
                            transaction = transactionDao.getTransaction(transactionId);
                            contractId = transaction.getContractId();
                        }
                        catch (ParseException transactionId) {
                            // empty catch block
                        }
                        if (contractId <= 0 || transaction == null) {
                            throw new AGRException(AGRErrorCode.USER_DOES_NOT_EXIST, "Contract with merchantTransId=" + merchantTransId + " does not exist");
                        }
                        this.getLogger().debug("contractId = {}; transactionId = {}", (Object)contractId, (Object)transaction.getId());
                        BigDecimal sum = agrRequest.getMerchantTransAmount();
                        BigDecimal minSum = moduleSetup.getBigDecimal("agr.sum.min", new BigDecimal(100));
                        BigDecimal maxSum = moduleSetup.getBigDecimal("agr.sum.max", new BigDecimal(5000));
                        if (sum.compareTo(minSum) < 0) {
                            throw new AGRException(AGRErrorCode.INCORRECT_PARAMETER_AMOUNT, "Minimal transaction amount is " + Utils.formatBigDecimalSumm((BigDecimal)minSum) + "!");
                        }
                        if (sum.compareTo(maxSum) > 0) {
                            throw new AGRException(AGRErrorCode.INCORRECT_PARAMETER_AMOUNT, "Maximal transaction amount is " + Utils.formatBigDecimalSumm((BigDecimal)maxSum) + "!");
                        }
                        transaction.setSum(sum);
                        transaction.setEnvironment(agrRequest.getEnvironment());
                        transaction.setAgrPaymentName(agrRequest.getPaymentName());
                        transaction.setTransactionId(agrRequest.getAgrTransId());
                        transactionDao.update(transaction);
                        resultMap.put("VENDOR_TRANS_ID", transaction.getId());
                        break;
                    }
                    case NOTIFY: {
                        this.getLogger().debug("NOTIFY");
                        long transactionId = agrRequest.getVendorTransId();
                        Transaction transaction = this.getTransaction(transactionDao, transactionId);
                        TransactionStatus status = agrRequest.getStatus();
                        if (status.getCode().equals(transaction.getStatus())) break;
                        this.getLogger().debug("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438.");
                        transaction.setStatus(status.getCode());
                        transactionDao.update(transaction);
                        if (!status.equals((Object)TransactionStatus.PAYD)) break;
                        try {
                            this.getLogger().debug("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440. \u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430");
                            transaction.setTransactionDate(new Date());
                            transactionDao.update(transaction);
                            String comment = moduleSetup.get("agr.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 AGR. \u041a\u043e\u0434 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 {TRANSACTION_ID}; \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 {PAYMENT_NAME}");
                            if (transactionId > 0L) {
                                comment = comment.replace("{TRANSACTION_ID}", String.valueOf(transactionId));
                            }
                            if (Utils.notBlankString((String)transaction.getAgrPaymentName())) {
                                comment = comment.replace("{PAYMENT_NAME}", transaction.getAgrPaymentName());
                            }
                            Payment payment = Payment.builder().setDate(transaction.getTransactionDate()).setTypeId(this.getPaymentTypeIdByPaymentName(moduleSetup, transaction.getAgrPaymentName())).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(comment).build();
                            ((PaymentService)context.getService(PaymentService.class, 0)).paymentUpdate(payment, null);
                            break;
                        }
                        catch (Exception ex) {
                            throw new AGRException(AGRErrorCode.SYSTEM_ERROR, ex.getMessage());
                        }
                    }
                    case CANCEL: {
                        this.getLogger().debug("CANCEL");
                        long transactionId = agrRequest.getVendorTransId();
                        Transaction transaction = this.getTransaction(transactionDao, transactionId);
                        transaction.setStatus(TransactionStatus.CANCELED.getCode());
                        transactionDao.update(transaction);
                        this.getLogger().debug("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0441 \u043a\u043e\u0434\u043e\u043c {} \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441 CANCEL", (Object)transactionId);
                        break;
                    }
                    case STATEMENT: {
                        this.getLogger().debug("STATEMENT");
                        Date from = agrRequest.getFrom();
                        Date to = agrRequest.getTo();
                        if (from == null || to == null) {
                            throw new AGRException(AGRErrorCode.ERROR_IN_REQUEST_FROM_AGR, "Parameter FROM and/or TO not specified");
                        }
                        SearchParam searchParam = new SearchParam().setContractId(-1);
                        SearchResult searchResult = new SearchResult(new Period(from, to), null);
                        transactionDao.searchTransaction((SearchResult<Transaction>)searchResult, searchParam, null);
                        List transactionList = searchResult.getList();
                        List<Map<String, String>> result = this.getTransactionList(transactionList, moduleSetup);
                        resultMap.put("TRANSACTIONS", result);
                        break;
                    }
                    case UNKNOWN: {
                        throw new AGRException(AGRErrorCode.ACTION_NOT_FOUND, "unknown action");
                    }
                }
                this.getLogger().debug("SUCCESS");
                resultMap.put("ERROR", AGRErrorCode.SUCCESS.getCode());
                resultMap.put("ERROR_NOTE", "Success");
            }
            catch (Exception e) {
                throw new AGRException(AGRErrorCode.SYSTEM_ERROR, e.getMessage(), e);
            }
        }
        catch (AGRException ex) {
            if (ex.getErrorCode() == AGRErrorCode.SYSTEM_ERROR) {
                this.logError(ex);
            } else {
                this.getLogger().warn(ex.getMessage());
            }
            resultMap.put("ERROR", ex.getErrorCode().getCode());
            resultMap.put("ERROR_NOTE", ex.getMessage());
        }
        finally {
            try {
                context.commit();
            }
            catch (BGException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        String result = this.mapper.writeValueAsString(resultMap);
        this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \u041f\u0421: {}", (Object)result);
        resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
        ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
    }

    private Transaction getTransaction(TransactionManager transactionDao, long transactionId) throws AGRException, SQLException {
        Transaction transaction = transactionDao.getTransaction((int)transactionId);
        if (transaction == null) {
            throw new AGRException(AGRErrorCode.TRANSACTION_DOES_NOT_EXIST, "Transaction (vendorTransId=" + transactionId + ") does not exist");
        }
        return transaction;
    }

    private List<Map<String, String>> getTransactionList(List<Transaction> transactionList, ModuleSetup moduleSetup) throws BGException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(transactionList.size());
        try {
            DecimalFormat decimalFormat = new DecimalFormat(moduleSetup.get("agr.transaction.format", "BG000000000"));
            for (Transaction transaction : transactionList) {
                if (transaction.getStatus().equals(TransactionStatus.PAYD.getCode()) && transaction.getStatus().equals(TransactionStatus.CANCELED.getCode())) continue;
                HashMap<String, String> item = new HashMap<String, String>(7);
                item.put("ENVIRONMENT", transaction.getEnvironment().name());
                item.put("AGR_TRANS_ID", transaction.getTransactionId());
                item.put("VENDOR_TRANS_ID", decimalFormat.format(transaction.getId()));
                item.put("MERCHANT_TRANS_ID", String.valueOf(transaction.getId()));
                item.put("MERCHANT_TRANS_AMOUNT", transaction.getSum().toString());
                item.put("STATE", transaction.getStatus());
                if (transaction.getTransactionDate() != null) {
                    item.put("DATE", String.valueOf(transaction.getTransactionDate().getTime()));
                }
                result.add(item);
            }
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private int getPaymentTypeIdByPaymentName(ModuleSetup moduleSetup, String paymentName) throws AGRException {
        this.getLogger().debug("\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438.");
        ParameterMap typeMap = moduleSetup.sub("agr.payment.type.");
        int result = typeMap.getInt(paymentName, -1);
        if (result < 0) {
            result = moduleSetup.getInt("agr.default.payment.type", -1);
        }
        if (result < 0) {
            throw new AGRException(AGRErrorCode.SYSTEM_ERROR, "Payment type id not specified at module config");
        }
        return result;
    }

    private void checkSign(AGRRequest agrRequest, ModuleSetup moduleSetup) throws AGRException {
        this.getLogger().debug("\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0438");
        String requestSign = agrRequest.getSignString();
        if (Utils.isBlankString((String)requestSign)) {
            throw new AGRException(AGRErrorCode.SIGN_CHECK_FAILED, "SIGN param not specified");
        }
        String secret = moduleSetup.get("agr.secret");
        if (Utils.isBlankString((String)secret)) {
            throw new AGRException(AGRErrorCode.SYSTEM_ERROR, "Secret not specified at module configuration");
        }
        String bgSignString = null;
        String signTime = String.valueOf(agrRequest.getSignTime());
        switch (agrRequest.getAction()) {
            case INFO: {
                String merchantTransId = agrRequest.getMerchantTransId();
                bgSignString = merchantTransId + signTime;
                break;
            }
            case PAY: {
                String agrTransId = String.valueOf(agrRequest.getAgrTransId());
                String vendorId = String.valueOf(agrRequest.getVendorId());
                String paymentId = String.valueOf(agrRequest.getPaymentId());
                String paymentName = agrRequest.getPaymentName();
                String merchantTransId = agrRequest.getMerchantTransId();
                String merchantTransAmount = agrRequest.getMerchantTransAmount().toString();
                AGREnvironment environment = agrRequest.getEnvironment();
                bgSignString = agrTransId + vendorId + paymentId + paymentName + merchantTransId + merchantTransAmount + environment.name() + signTime;
                break;
            }
            case NOTIFY: {
                String agrTransId = String.valueOf(agrRequest.getAgrTransId());
                String vendorTransId = String.valueOf(agrRequest.getVendorTransId());
                String status = agrRequest.getStatus().getCode();
                bgSignString = agrTransId + vendorTransId + status + signTime;
                break;
            }
            case CANCEL: {
                String agrTransId = String.valueOf(agrRequest.getAgrTransId());
                String vendorTransId = String.valueOf(agrRequest.getVendorTransId());
                bgSignString = agrTransId + vendorTransId + signTime;
                break;
            }
            case STATEMENT: {
                String from = String.valueOf(agrRequest.getFrom().getTime());
                String to = String.valueOf(agrRequest.getTo().getTime());
                bgSignString = from + to + signTime;
                break;
            }
        }
        String bgSign = Utils.getDigest((String)(secret + bgSignString), (String)"UTF-8");
        this.getLogger().debug("\t\u0421\u0442\u0440\u043e\u043a\u0430, \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0431\u0438\u043b\u043b\u0438\u043d\u0433 \u0444\u043e\u0440\u043c\u0438\u0440\u0443\u0435\u0442 \u043f\u043e\u0434\u043f\u0438\u0441\u044c: {}", (Object)bgSignString);
        this.getLogger().debug("\t\u0421\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u044c: {}", (Object)bgSign.toLowerCase());
        if (Utils.notBlankString((String)bgSign) && !requestSign.equalsIgnoreCase(bgSign)) {
            throw new AGRException(AGRErrorCode.SIGN_CHECK_FAILED, "Sign check failed");
        }
        this.getLogger().debug("\t\u041f\u043e\u0434\u043f\u0438\u0441\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430");
    }
}

