/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.CardDealerEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.CardLoadEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.CustomEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.DosyncEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.GetSubscribeInfoEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.PairingEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.PasswordEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.PinCodeEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.SendMessageEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.common.AvailableEditors;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Card;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Dealer;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardActionsService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.DealerService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.UserCardService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Result;

public class ServiceConfigManagerCard
extends BGUTabPanel {
    private boolean init = false;
    private BGEditor editor;
    private JButton loadButton = new JButton();
    private JButton dealerAddButton = new JButton();
    private JButton dealerDeleteButton = new JButton();
    private JPanel editCardPanel = new JPanel();
    private JLabel countLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u043a\u0430\u0440\u0442: 0");
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGTextField filterNum = new BGTextField();
    private BGUList<Dealer> dealerList = new BGUList();
    private BGUTable table;
    private CardTableModel model;
    private BGUComboBox<KeyValue> contractStatusCombo = new BGUComboBox();
    private BGUComboBox<KeyValue> dealerStatusCombo = new BGUComboBox();

    public ServiceConfigManagerCard() {
        this.model = new CardTableModel();
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.pagePanel.setKey(((Object)((Object)this)).getClass().getName());
        this.editCardPanel.setVisible(false);
        this.contractStatusCombo.setData(Arrays.asList(new KeyValue("all", "\u0432\u0441\u0435"), new KeyValue("no", "\u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435"), new KeyValue("yes", "\u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435")));
        this.dealerStatusCombo.setData(Arrays.asList(new KeyValue("all", "\u0432\u0441\u0435"), new KeyValue("yes", "\u0434\u0438\u043b\u0435\u0440\u0443 \u0432\u044b\u0434\u0430\u043d\u0430"), new KeyValue("no", "\u0434\u0438\u043b\u0435\u0440\u0443 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u0430")));
    }

    protected void jbInit() throws Exception {
        this.filterNum.setPreferredSize(new Dimension(55, 24));
        this.filterNum.setHorizontalAlignment(0);
        JPanel numberFilter = new JPanel(new GridBagLayout());
        numberFilter.setBorder((Border)new BGTitleBorder("\u041d\u043e\u043c\u0435\u0440\u0430 \u043a\u0430\u0440\u0442 (n, n+k)"));
        numberFilter.add((Component)this.filterNum, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.setBorder(null);
        filterPanel.add((Component)numberFilter, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editor = new BGEditor();
        this.editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this.table, "enabled", "oldValue"));
        this.editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this.dealerList, "enabled", "oldValue"));
        this.editor.addActionListener("ok", (ActionListener)this.getActionMap().get("refresh"));
        JPanel cardPanel = new JPanel(new GridBagLayout());
        cardPanel.add((Component)this.gettoolBarPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        cardPanel.add((Component)this.editCardPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        cardPanel.add((Component)this.editor, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        cardPanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel servicesPanel = new JPanel(new GridBagLayout());
        servicesPanel.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        servicesPanel.add((Component)cardPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel dealerListPanel = new JPanel(new GridBagLayout());
        dealerListPanel.setBorder((Border)new BGTitleBorder("\u0414\u0438\u043b\u0435\u0440\u044b"));
        dealerListPanel.add((Component)new JScrollPane((Component)this.dealerList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel statusFilter = new JPanel(new GridBagLayout());
        statusFilter.setBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        statusFilter.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        statusFilter.add((Component)this.contractStatusCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        statusFilter.add((Component)this.dealerStatusCombo, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)statusFilter, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dealerList.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)dealerListPanel, (Component)servicesPanel, 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pagePanel.addToHandler(a -> this.performAction("refresh"));
    }

    private JPanel gettoolBarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.loadButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.dealerAddButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.dealerDeleteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        JButton filterApplyButton = new JButton(">>>");
        filterApplyButton.setRequestFocusEnabled(true);
        filterApplyButton.addActionListener(e -> this.performAction("refresh"));
        JButton filterResetButton = new JButton("X");
        filterResetButton.addActionListener(e -> {
            this.filterNum.setText("");
            this.contractStatusCombo.setSelectedIndex(0);
            this.dealerStatusCombo.setSelectedIndex(0);
            this.dealerList.clearSelection();
            this.performAction("refresh");
        });
        panel.add((Component)filterApplyButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 5, 0, 0), 0, 0));
        panel.add((Component)filterResetButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add(Box.createHorizontalStrut(1), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.countLabel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 15), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        return panel;
    }

    private boolean filter(Map<String, String> request) {
        String[] num_count = this.filterNum.getText().split("\\+");
        Dealer li = (Dealer)this.dealerList.getSelectedValue();
        String dealer = li != null ? String.valueOf(li.getId()) : null;
        String dealerStatus = ((KeyValue)this.dealerStatusCombo.getSelectedItem()).getKey();
        if (dealerStatus.equals("yes") && dealer == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u043b\u0435\u0440\u0430");
            return false;
        }
        request.put("dealer", dealer);
        request.put("dealer_status", dealerStatus);
        request.put("contract_status", ((KeyValue)this.contractStatusCombo.getSelectedItem()).getKey());
        if (num_count.length > 0) {
            request.put("number", num_count[0]);
        }
        if (num_count.length > 1) {
            request.put("count", num_count[1]);
        }
        return true;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            HashMap<String, String> request;
            if (!this.init) {
                this.init1();
                this.init = true;
            }
            if (!this.filter(request = new HashMap<String, String>())) {
                return;
            }
            Result result = ((CardActionsService)((ClientContext)this.getContext()).getPort(CardActionsService.class)).cardTable(this.pagePanel.getPage(), new MapHolder(request));
            this.model.setData(result.getList());
            this.pagePanel.setPage(result.getPage());
            this.countLabel.setText("\u0412\u0441\u0435\u0433\u043e \u043a\u0430\u0440\u0442: " + String.valueOf(result.getPage().getRecordCount()));
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            Card selectedCard = (Card)this.model.getSelectedRow();
            if (selectedCard != null && ClientUtils.confirmDelete((Object)("\u043a\u0430\u0440\u0442\u0443 " + selectedCard.getNumber()))) {
                ((CardActionsService)((ClientContext)this.getContext()).getPort(CardActionsService.class)).deleteCard(selectedCard.getNumber());
                this.performAction("refresh");
            }
        });
    }

    private void init1() throws Exception {
        List list = ((DealerService)((ClientContext)this.getContext()).getPort(DealerService.class)).dealerList();
        this.dealerList.setData(list);
        MapHolder dm = ((UserCardService)((ClientContext)this.getContext()).getPort(UserCardService.class)).getSystemInfo();
        String sa = (String)dm.getMap().get("sa");
        JComponent c = null;
        c = this.editor.addForm((JComponent)((Object)new CardDealerEditor(this.table, this.dealerList)));
        this.dealerAddButton.setAction(c.getActionMap().get("card.cardDealer.give"));
        this.dealerDeleteButton.setAction(c.getActionMap().get("card.cardDealer.take"));
        c = this.editor.addForm((JComponent)((Object)new CardLoadEditor(this.dealerList)));
        this.loadButton.setAction(c.getActionMap().get(c.getName()));
        if (AvailableEditors.SendMessageEditor.isEnable(sa)) {
            this.editor.addForm((JComponent)((Object)new SendMessageEditor(this.table, false){

                @Override
                protected boolean filter(Map<String, String> req) {
                    return ServiceConfigManagerCard.this.filter(req);
                }
            }));
        }
        if (AvailableEditors.PinCodeEditor.isEnable(sa)) {
            this.editor.addForm((JComponent)((Object)new PinCodeEditor(this.table)));
        }
        if (AvailableEditors.GetSubscribeInfoEditor.isEnable(sa)) {
            this.editor.addForm((JComponent)((Object)new GetSubscribeInfoEditor(this.table)));
        }
        if (AvailableEditors.PairingEditor.isEnable(sa)) {
            this.editor.addForm((JComponent)((Object)new PairingEditor(this.table)));
        }
        this.editor.addForm((JComponent)((Object)new PasswordEditor(this.table)));
        this.editor.addForm((JComponent)((Object)new DosyncEditor(this.table)));
        for (String ce : AvailableEditors.getCustomEditors((String)sa)) {
            this.editor.addForm((JComponent)((Object)new CustomEditor(this.table, ce)));
        }
        BGSwingUtilites.buildPopupMenu((JComponent)this.table, (Container)this.editor, (String)"");
    }

    class CardTableModel
    extends BGTableModel<Card> {
        public CardTableModel() {
            super(CardTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("cid", 0, 0, 0, "contractId", false);
            this.addColumn("\u041d\u043e\u043c\u0435\u0440", 150, 150, 150, "number", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 150, 150, 150, "contractTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 100, 100, -1, "contractComment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0438\u043b\u0435\u0440", 300, 300, 300, "dealerTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421 \u0434\u0430\u0442\u044b", 100, 100, 100, "contractDate", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0414\u0430\u0442\u0430 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438", 130, 130, 130, "passDate", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("Pairing", 100, 100, 100, "pairingModule", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(Card card, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("contractDate".equals(identifier)) {
                return TimeUtils.formatDate((Calendar)card.getContractDate());
            }
            if ("passDate".equals(identifier)) {
                return TimeUtils.formatDate((Calendar)card.getPassDate());
            }
            return super.getValue((Object)card, column);
        }
    }
}

