/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import java.math.BigDecimal;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;

public class MultCostTariffTreeNode
extends DefaultTariffTreeNode {
    private BigDecimal multiplier = BigDecimal.ZERO;

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> dataHash = this.getDataInHash();
        this.multiplier = new BigDecimal(dataHash.get("value"));
    }

    @Override
    public void processRequest(TariffRequest request) {
        Float minCost = (Float)request.getResponseParam("min_cost");
        Object cost = request.getResponseParam("cost");
        if (minCost != null) {
            minCost = Float.valueOf(minCost.floatValue() * this.multiplier.floatValue());
            request.setResponseParam("min_cost", minCost);
        } else if (cost != null) {
            if (cost instanceof Float) {
                request.setResponseParam("cost", Float.valueOf(((Float)cost).floatValue() * this.multiplier.floatValue()));
            } else if (cost instanceof Double) {
                request.setResponseParam("cost", (Double)cost * this.multiplier.doubleValue());
            } else if (cost instanceof BigDecimal) {
                request.setResponseParam("cost", ((BigDecimal)cost).multiply(this.multiplier));
            }
        }
    }
}

