/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.table.client.ParamRowData;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.Page;
import ru.bitel.oss.systems.inventory.resource.client.IPResourceSubcriptionPanel;
import ru.bitel.oss.systems.inventory.resource.client.InetIpCategoryTreePanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class IpResourcePanel
extends BGUPanel {
    private ParamRowData paramGateway = new ParamRowData("gateway", "\u0420\u043e\u0443\u0442\u0435\u0440", "");
    private ParamRowData paramNetmask = new ParamRowData("netmask", "\u041c\u0430\u0441\u043a\u0430 \u043f\u043e\u0434\u0441\u0435\u0442\u0438", "");
    private ParamRowData paramDns = new ParamRowData("dns", "DNS", "");
    private ParamRowData paramIPv6PrefixLength = new ParamRowData("IPv6PrefixLength", "\u0414\u043b\u0438\u043d\u0430 \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u0430 (IPv6)", "");
    private ParamRowData paramReserveStart = new ParamRowData("reserveStart", "\u0420\u0435\u0437\u0435\u0440\u0432. \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430", "");
    private ParamRowData paramReserveEnd = new ParamRowData("reserveEnd", "\u0420\u0435\u0437\u0435\u0440\u0432. \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430", "");
    private List<ParamRowData> params = Arrays.asList(this.paramIPv6PrefixLength, this.paramGateway, this.paramNetmask, this.paramDns, this.paramReserveStart, this.paramReserveEnd);
    private IpResourceTableModel model = new IpResourceTableModel();
    private InetIpCategoryTreePanel categoryPanel;
    private ResourceService resourceService = null;

    public IpResourcePanel() {
        super(new BorderLayout());
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> this.categoryPanel.performAction("refresh"));
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGActionRefresh("list", "", e -> {
            IpCategory category = this.categoryPanel.getSelectedCategory();
            this.model.setData(this.getResourceService().ipResourceList(Collections.singleton(category != null ? category.getId() : -1)));
        });
        new AbstractBGUPanel.BGActionNew(e -> {
            IpCategory ipCategory = new IpCategory();
            IpCategory category = this.categoryPanel.getSelectedCategory();
            if (category != null) {
                ipCategory.setParentId(category.getId());
            }
            new IpCategoryEditorDialog("\u041d\u043e\u0432\u0430\u044f \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", ipCategory).open();
            this.categoryPanel.performAction("refresh");
        });
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGActionNew("resource", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441", e -> {
            IpCategory category = this.categoryPanel.getSelectedCategory();
            if (category == null || category.getId() <= 0) {
                return;
            }
            IpResource ipResource = IpResource.builder().setCategoryId(category.getId()).build();
            new IpResourceEditor("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u0430", ipResource).open();
        }).setIcon(ClientUtils.getIcon("item_add"));
        new AbstractBGUPanel.BGActionEdit(e -> {
            IpCategory ipCategory = this.categoryPanel.getSelectedCategory();
            if (ipCategory == null) {
                ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
                return;
            }
            new IpCategoryEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", ipCategory).open();
        });
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGActionEdit("resource", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u0430", e -> {
            IpResource ipResource = (IpResource)this.model.getSelectedRow();
            if (ipResource != null) {
                new IpResourceEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0440\u0435\u0441\u0443\u0440\u0441\u0430", ipResource).open();
            }
        }).setIcon(ClientUtils.getIcon("item_edit"));
        new AbstractBGUPanel.BGActionDelete(e -> {
            IpCategory category = this.categoryPanel.getSelectedCategory();
            if (category != null && ClientUtils.confirmDelete(category.getGuiTitle())) {
                this.getResourceService().ipCategoryDelete(category.getId());
                this.categoryPanel.performAction("refresh");
            }
        });
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGActionDelete("resource", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", e -> {
            IpResource resource = (IpResource)this.model.getSelectedRow();
            if (resource == null || !BGSwingUtilites.confirmDelete("IP-\u0440\u0435\u0441\u0443\u0440\u0441", resource)) {
                return;
            }
            if (this.getResourceService().ipSubscriptionList(resource.getId(), null, null, new Page(1, 1)).getList().size() > 0 && !BGSwingUtilites.confirm("\u041d\u0430 IP-\u0440\u0435\u0441\u0443\u0440\u0441 \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438. \u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c", null)) {
                return;
            }
            this.getResourceService().ipResourceDelete(resource.getId(), true);
            this.performAction("list.refresh");
            this.getActionMap().get("ipResourceLinkSet").actionPerformed(e);
        }).setIcon(ClientUtils.getIcon("item_delete"));
        new AbstractBGUPanel.DefaultAction("ipResourceLinkCheck", "\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 IP-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                String errorServs = ((ClientContext)IpResourcePanel.this.getContext()).getPort(InetServService.class).ipResourceLinkCheck();
                if (Utils.notBlankString(errorServs)) {
                    ClientUtils.showErrorMessageDialog("\u041d\u0430\u0439\u0434\u0435\u043d\u044b \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u043a IP-\u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c!\n" + errorServs);
                } else {
                    ClientUtils.showMessageDialog("\u041e\u0448\u0438\u0431\u043e\u043a \u0432 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0435 IP-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("ipResourceLinkSet", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 IP-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (BGSwingUtilites.confirm("\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u043e\u043a \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u043a IP-\u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c", null)) {
                    ((ClientContext)IpResourcePanel.this.getContext()).getPort(InetServService.class).ipResourceLinkSet();
                }
            }
        };
    }

    @Override
    protected void jbInit() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        BGUTable table = new BGUTable(this.model);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName("table");
        panel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 0, 3, 0), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        BGSwingUtilites.buildToolBar(toolBar, (JComponent)this, "resource.new", "resource.edit", "resource.delete");
        toolBar.compact();
        BGSwingUtilites.handleEdit("resource", table, this);
        BGEditor mainEditor = new BGEditor("table");
        mainEditor.addForm(panel);
        mainEditor.addForm(new IPResourceSubcriptionPanel());
        BGSwingUtilites.buildPopupMenu(table, (Container)mainEditor, "ipResource");
        this.add((Component)new BGSplitPaneNoBorder(1, this.getLeftPanel(), (Component)mainEditor, 400L), "Center");
    }

    private JPanel getLeftPanel() {
        this.categoryPanel = new InetIpCategoryTreePanel(e -> {
            if (e.getActionCommand().equals("ip.category.selected")) {
                this.performAction("list.refresh");
            } else if (e.getActionCommand().equals("ip.category.edit")) {
                this.performAction("edit");
            }
        }, true, (ClientContext)this.getContext());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.categoryPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new BGButton(this.getActionMap().get("ipResourceLinkCheck")), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)new BGButton(this.getActionMap().get("ipResourceLinkSet")), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private ResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = ((ClientContext)this.getContext()).getPort(ResourceService.class);
        }
        return this.resourceService;
    }

    class IpResourceTableModel
    extends BGTableModel<IpResource> {
        public IpResourceTableModel() {
            super(IpResourceTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d/\u0441\u0435\u0442\u044c", 200, 300, 400, null, true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 150, 180, 200, null, true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 300, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(IpResource val, int column) throws Exception {
            switch (column) {
                case 1: {
                    if (IPUtils.isRangeValidNet(val.getAddressFrom(), val.getAddressTo())) {
                        return IpAddress.toRFCString(val.getAddressFrom()) + "/" + IpNet.getMask(val.getAddressFrom(), val.getAddressTo());
                    }
                    return IpAddress.toString(val.getAddressFrom()) + "-" + IpAddress.toString(val.getAddressTo());
                }
                case 2: {
                    return TimeUtils.formatPeriod(val.getDateFrom(), val.getDateTo());
                }
            }
            return super.getValue(val, column);
        }
    }

    class IpResourceEditor
    extends BGEditorDialog<IpResource> {
        private BGTextField addressFrom;
        private BGTextField addressTo;
        private BGTextField mask;
        private JLabel addressDash;
        private JLabel netSlash;
        private JTabbedPane tabPane;
        private BGControlPanelPeriodNoB period;
        private BGTextArea comment;
        private BGConfigEditorPane config;
        private IpResourceParamTableModel ipResourceParamTableModel;
        private KeyValue[] modeValues;
        private JComboBox<KeyValue> mode;

        public IpResourceEditor(String title, IpResource data) {
            super(title, data);
            this.addressFrom = new BGTextField(20);
            this.addressTo = new BGTextField(20);
            this.mask = new BGTextField();
            this.addressDash = new JLabel(" - ");
            this.netSlash = new JLabel(" / ");
            this.tabPane = new JTabbedPane();
            this.period = new BGControlPanelPeriod();
            this.comment = new BGTextArea();
            this.config = new BGConfigEditorPane();
            this.ipResourceParamTableModel = new IpResourceParamTableModel();
            this.modeValues = new KeyValue[]{new KeyValue("range", "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d"), new KeyValue("net", "\u0421\u0435\u0442\u044c")};
            this.mode = new JComboBox<KeyValue>(this.modeValues);
        }

        @Override
        public void doDialogPanel() {
            this.tabPane.addTab("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", this.getParamPanel());
            this.tabPane.addTab("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", BGSwingUtilites.wrapScrollPane(this.config, 700, 300));
            this.tabPane.addTab("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", BGSwingUtilites.wrapScrollPane(this.comment, 700, 300));
            this.panel.add((Component)this.tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (IPUtils.isRangeValidNet(((IpResource)this.data).getAddressFrom(), ((IpResource)this.data).getAddressTo())) {
                this.mode.setSelectedItem(this.modeValues[1]);
            } else {
                this.mode.setSelectedItem(this.modeValues[0]);
            }
            this.selectMode();
            this.addressFrom.setText(Optional.ofNullable(((IpResource)this.data).getAddressFrom()).map(a -> IpAddress.toRFCString(a)).orElse(""));
            this.addressTo.setText(Optional.ofNullable(((IpResource)this.data).getAddressTo()).map(a -> IpAddress.toRFCString(a)).orElse(""));
            this.setMask();
            this.period.setFromEnabled(((IpResource)this.data).getId() == 0);
            this.period.setDateCalendar1(TimeUtils.convertDateToCalendar(((IpResource)this.data).getDateFrom()));
            this.period.setDateCalendar2(TimeUtils.convertDateToCalendar(((IpResource)this.data).getDateTo()));
            IpResourcePanel.this.paramIPv6PrefixLength.setValue(((IpResource)this.data).getPrefixLength() > 0 ? String.valueOf(((IpResource)this.data).getPrefixLength()) : "");
            IpResourcePanel.this.paramGateway.setValue(((IpResource)this.data).getRouter());
            IpResourcePanel.this.paramNetmask.setValue(((IpResource)this.data).getSubnetMask());
            IpResourcePanel.this.paramDns.setValue(((IpResource)this.data).getDns());
            IpResourcePanel.this.paramReserveStart.setValue(String.valueOf(((IpResource)this.data).isReserveStart()));
            IpResourcePanel.this.paramReserveEnd.setValue(String.valueOf(((IpResource)this.data).isReserveEnd()));
            this.config.setText(((IpResource)this.data).getConfig());
            this.comment.setText(((IpResource)this.data).getComment());
            boolean rangeEnable = ((IpResource)this.data).getId() == 0;
            this.mode.setEnabled(rangeEnable);
            this.addressFrom.setEditable(rangeEnable);
            this.addressTo.setEditable(rangeEnable);
            this.mask.setEditable(rangeEnable);
        }

        private JPanel getParamPanel() {
            final BGUTable table = new BGUTable(this.ipResourceParamTableModel);
            table.putClientProperty("terminateEditOnFocusLost", true);
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ParamRowData paramRowData;
                    int row = table.convertRowIndexToModel(table.rowAtPoint(e.getPoint()));
                    int column = table.convertColumnIndexToModel(table.columnAtPoint(e.getPoint()));
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && column == 1 && (IpResourcePanel.this.paramReserveStart == (paramRowData = (ParamRowData)IpResourceEditor.this.ipResourceParamTableModel.getSelectedRow()) || IpResourcePanel.this.paramReserveEnd == paramRowData)) {
                        paramRowData.setValue("true".equals(paramRowData.getValue()) ? "false" : "true");
                        IpResourceEditor.this.ipResourceParamTableModel.fireTableCellUpdated(row, column);
                    }
                }
            });
            this.ipResourceParamTableModel.setData(IpResourcePanel.this.params);
            JPanel panel = new JPanel(new GridBagLayout());
            this.addFieldV("", this.getNetRangePanel(), panel);
            this.addFieldV("", this.period, panel);
            this.addFieldV("", BGSwingUtilites.wrapScrollPane(table, 100, 200), panel);
            return panel;
        }

        private JPanel getNetRangePanel() {
            this.addressFrom.setHorizontalAlignment(0);
            this.addressTo.setHorizontalAlignment(0);
            this.mask.setPreferredSize(new Dimension(100, (int)this.mask.getPreferredSize().getHeight()));
            this.mode.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.selectMode();
                }
            });
            JPanel panel = BGSwingUtilites.wrapBorder(new JPanel(new GridBagLayout()), "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432 / \u0441\u0435\u0442\u044c");
            panel.add(this.mode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.addressFrom, new GridBagConstraints(-1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.addressDash, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.netSlash, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.mask, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.addressTo, new GridBagConstraints(-1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private void selectMode() {
            int index = this.mode.getSelectedIndex();
            this.ipResourceParamTableModel.getRows().remove(IpResourcePanel.this.paramReserveStart);
            this.ipResourceParamTableModel.getRows().remove(IpResourcePanel.this.paramReserveEnd);
            boolean rangeSelect = index == 0;
            this.addressFrom.setColumns(rangeSelect ? 20 : 0);
            this.addressTo.setVisible(rangeSelect);
            this.addressDash.setVisible(rangeSelect);
            this.netSlash.setVisible(!rangeSelect);
            this.mask.setVisible(!rangeSelect);
            if (!rangeSelect) {
                this.ipResourceParamTableModel.getRows().add(IpResourcePanel.this.paramReserveStart);
                this.ipResourceParamTableModel.getRows().add(IpResourcePanel.this.paramReserveEnd);
                this.setMask();
            }
            this.ipResourceParamTableModel.fireTableDataChanged();
        }

        private void setMask() {
            try {
                byte[] from = InetAddress.getByName(this.addressFrom.getText()).getAddress();
                byte[] to = InetAddress.getByName(this.addressTo.getText()).getAddress();
                this.mask.setText(IPUtils.isRangeValidNet(from, to) ? String.valueOf(IpNet.getMask(from, to)) : "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean doApply() throws Exception {
            try {
                if (this.mode.getSelectedIndex() == 0) {
                    if (Utils.isBlankString(this.addressFrom.getText())) {
                        BGToolTip.showErrorMessage(this.addressFrom, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430");
                        return false;
                    }
                    if (Utils.isBlankString(this.addressTo.getText())) {
                        BGToolTip.showErrorMessage(this.addressTo, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430");
                        return false;
                    }
                } else if (this.mode.getSelectedIndex() == 1) {
                    if (Utils.isBlankString(this.addressFrom.getText())) {
                        BGToolTip.showErrorMessage(this.addressFrom, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0441\u0435\u0442\u044c");
                        return false;
                    }
                    if (Utils.isBlankString(this.mask.getText())) {
                        BGToolTip.showErrorMessage(this.mask, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043c\u0430\u0441\u043a\u0443 \u0441\u0435\u0442\u0438");
                        return false;
                    }
                }
                ((IpResource)this.data).setAddressFrom(InetAddress.getByName(this.addressFrom.getText()).getAddress());
                if (this.mode.getSelectedItem().equals(this.modeValues[0])) {
                    ((IpResource)this.data).setAddressTo(InetAddress.getByName(this.addressTo.getText()).getAddress());
                } else {
                    IpNet net = new IpNet(((IpResource)this.data).getAddressFrom(), Utils.parseInt(this.mask.getText(), ((IpResource)this.data).getAddressFrom().length * 8));
                    ((IpResource)this.data).setAddressTo(net.getBroadcast());
                }
                if (((IpResource)this.data).getId() < 1) {
                    if (this.period.getDateFrom() == null) {
                        this.period.showErrorToolTipFrom("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
                        return false;
                    }
                    if (this.period.getLocalDateFrom().isBefore(LocalDate.now())) {
                        ClientUtils.showErrorMessageDialog("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0441\u0435\u0433\u043e\u0434\u043d\u044f \u0438\u043b\u0438 \u043f\u043e\u0437\u0436\u0435");
                        return false;
                    }
                    ((IpResource)this.data).setDateFrom(this.period.getDateFrom());
                }
                if (this.period.getDateTo() != null) {
                    if (this.period.getLocalDateFrom() != null && this.period.getLocalDateTo().isBefore(this.period.getLocalDateFrom())) {
                        ClientUtils.showErrorMessageDialog("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0440\u0430\u043d\u044c\u0448\u0435 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
                        return false;
                    }
                    if (this.period.getLocalDateTo().isBefore(LocalDate.now())) {
                        ClientUtils.showErrorMessageDialog("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0441\u0435\u0433\u043e\u0434\u043d\u044f \u0438\u043b\u0438 \u043f\u043e\u0437\u0436\u0435");
                        return false;
                    }
                }
                ((IpResource)this.data).setDateTo(this.period.getDateTo());
                ((IpResource)this.data).setRouter(IpResourcePanel.this.paramGateway.getValue());
                ((IpResource)this.data).setSubnetMask(IpResourcePanel.this.paramNetmask.getValue());
                ((IpResource)this.data).setDns(IpResourcePanel.this.paramDns.getValue());
                ((IpResource)this.data).setReserveStart(Boolean.valueOf(IpResourcePanel.this.paramReserveStart.getValue()).booleanValue());
                ((IpResource)this.data).setReserveEnd(Boolean.valueOf(IpResourcePanel.this.paramReserveEnd.getValue()).booleanValue());
                ((IpResource)this.data).setConfig(this.config.getText());
                ((IpResource)this.data).setComment(this.comment.getText());
                ((IpResource)this.data).setPrefixLength((short)Utils.parseInt(IpResourcePanel.this.paramIPv6PrefixLength.getValue(), 0));
                if (((IpResource)this.data).getId() > 0 && IpResourcePanel.this.getResourceService().ipSubscriptionList(((IpResource)this.data).getId(), null, null, new Page(1, 1)).getList().size() > 0) {
                    if (!BGSwingUtilites.confirm("\u041d\u0430 IP-\u0440\u0435\u0441\u0443\u0440\u0441 \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438. \u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c", null)) {
                        return false;
                    }
                    int id = IpResourcePanel.this.getResourceService().ipResourceUpdate((IpResource)this.data, true);
                    IpResourcePanel.this.performAction("list.refresh");
                    IpResourcePanel.this.model.setSelectedRow(id);
                    IpResourcePanel.this.getActionMap().get("ipResourceLinkCheck").actionPerformed(new ActionEvent(this, 1, ""));
                } else {
                    int id = IpResourcePanel.this.getResourceService().ipResourceUpdate((IpResource)this.data, true);
                    IpResourcePanel.this.performAction("list.refresh");
                    IpResourcePanel.this.model.setSelectedRow(id);
                }
            }
            catch (UnknownHostException ex) {
                throw new BGException(ex);
            }
            return super.doApply();
        }
    }

    class IpCategoryEditorDialog
    extends BGEditorDialog<IpCategory> {
        private BGTextField title;
        private BGTextField comment;

        public IpCategoryEditorDialog(String title, IpCategory data) {
            super(title, data);
            this.title = new BGTextField(30);
            this.comment = new BGTextField(30);
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 3, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 3, 0, 0), 0, 0));
            this.panel.add((Component)this.comment, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.title.setText(((IpCategory)this.data).getTitle());
            this.comment.setText(((IpCategory)this.data).getComment());
        }

        @Override
        public boolean doApply() throws Exception {
            ((IpCategory)this.data).setTitle(this.title.getText());
            ((IpCategory)this.data).setComment(this.comment.getText());
            try {
                int id = IpResourcePanel.this.getResourceService().ipCategoryUpdate((IpCategory)this.data);
                IpResourcePanel.this.performAction("list.refresh");
                IpResourcePanel.this.categoryPanel.getTreeModel().setSelectedRow(id);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
                return false;
            }
            return true;
        }
    }

    class IpResourceParamTableCellRenderer
    extends DefaultTableCellRenderer {
        IpResourceParamTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                Boolean val = (Boolean)value;
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(val);
                Color fg = null;
                Color bg = null;
                if (isSelected) {
                    checkBox.setForeground(fg == null ? table.getSelectionForeground() : fg);
                    checkBox.setBackground(bg == null ? table.getSelectionBackground() : bg);
                } else {
                    checkBox.setForeground(table.getForeground());
                    checkBox.setBackground(table.getBackground());
                }
                return checkBox;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class IpResourceParamTableModel
    extends BGTableModel<ParamRowData> {
        public IpResourceParamTableModel() {
            super(IpResourceParamTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, 400, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 400, -1, "value", false, new IpResourceParamTableCellRenderer());
        }

        @Override
        public Object getValue(ParamRowData paramRowData, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("value".equals(identifier) && (paramRowData == IpResourcePanel.this.paramReserveStart || paramRowData == IpResourcePanel.this.paramReserveEnd)) {
                return Boolean.valueOf(paramRowData.getValue());
            }
            return super.getValue(paramRowData, column);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ParamRowData paramRowData = (ParamRowData)this.getRows().get(this.table.convertRowIndexToModel(rowIndex));
            if ("value".equals(this.getIdentifier(columnIndex))) {
                paramRowData.setValue(String.valueOf(value));
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ParamRowData paramRowData = (ParamRowData)this.getRows().get(rowIndex);
            return columnIndex == 1 && paramRowData != IpResourcePanel.this.paramReserveEnd && paramRowData != IpResourcePanel.this.paramReserveStart;
        }
    }
}

