/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLink;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLinkBlock;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLinkDoc;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLinkJavaBlock;
import ru.bitel.bgbilling.modules.bill.server.bean.BillLinkDao;
import ru.bitel.bgbilling.modules.bill.server.bean.BillLinkDocDao;
import ru.bitel.bgbilling.server.util.Setup;

@WebServlet(name="BillLinkExecutor", urlPatterns={"/billlink/*"})
public class BillLinkExecutor
extends CommonExecutor {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int moduleId = 0;
        try {
            moduleId = BillLinkExecutor.getModuleId((HttpServletRequest)request);
        }
        catch (Exception ex) {
            this.sendError(ex, response);
            return;
        }
        String pathInfo = request.getPathInfo();
        String queryBillLink = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        if (queryBillLink == null || queryBillLink.isEmpty() || queryBillLink.length() < 13) {
            this.sendError("\"queryBillLink\" not found!", response);
            return;
        }
        Setup setup = Setup.getSetup();
        Connection con = setup.getDBConnection(true);
        BillLinkDoc billLinkDoc = null;
        try (BillLinkDocDao billLinkDocDao = new BillLinkDocDao(con, moduleId);){
            billLinkDoc = billLinkDocDao.getBillLinkDoc(this.getLinkDatetime(queryBillLink.substring(0, 12)), queryBillLink.substring(12));
        }
        catch (Exception ex) {
            this.sendError(ex, response);
            return;
        }
        if (billLinkDoc == null) {
            this.sendError("\"linkDoc\" not found!", response);
            return;
        }
        BillLink billLink = null;
        try (BillLinkDao billLinkDao = new BillLinkDao(con, moduleId);){
            billLink = billLinkDao.get(billLinkDoc.getLinkId());
        }
        catch (BGException ex) {
            this.sendError((Exception)((Object)ex), response);
            return;
        }
        if (billLink == null) {
            this.sendError("\"link\" not found!", response);
            return;
        }
        StringBuffer result = new StringBuffer();
        for (BillLinkBlock billLinkBlock : billLink.getLinkBlocks()) {
            switch (billLinkBlock.getType()) {
                case DOCUMENT: {
                    result.append(this.doDocumentBlock(billLinkBlock, billLinkDoc, con, request));
                    break;
                }
                case HTML: {
                    result.append(this.doHtmlBlock(billLinkBlock, con, request));
                    break;
                }
                case SQL: {
                    result.append(this.doSqlBlock(billLinkBlock, con, request));
                    break;
                }
                case JAVA: {
                    result.append(this.doJavaBlock(billLinkBlock, con, request));
                    break;
                }
            }
        }
        URL webrootURL = BillLinkExecutor.class.getResource("/webroot");
        if (webrootURL == null) {
            this.sendError("\"/webroot\" not found!", response);
            return;
        }
        try {
            File billLinkFile;
            boolean needSave;
            File webrootDir = new File(webrootURL.toURI());
            File publicBilllinkDir = new File(webrootDir, "public" + File.separatorChar + "billlink");
            if (!publicBilllinkDir.exists()) {
                publicBilllinkDir.mkdirs();
            }
            boolean bl = needSave = !(billLinkFile = new File(publicBilllinkDir, billLink.getId() + ".jsp")).exists() || billLinkFile.lastModified() < billLink.getLastModified().getTime();
            if (needSave) {
                FileOutputStream fileOutputStream = new FileOutputStream(billLinkFile);
                fileOutputStream.write(result.toString().getBytes("UTF-8"));
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.getRequestDispatcher("/public/billlink/" + billLink.getId() + ".jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private String doDocumentBlock(BillLinkBlock billLinkBlock, BillLinkDoc billLinkDoc, Connection con, HttpServletRequest request) {
        return "";
    }

    private String doHtmlBlock(BillLinkBlock billLinkBlock, Connection con, HttpServletRequest request) {
        return billLinkBlock.getData();
    }

    private String doSqlBlock(BillLinkBlock billLinkBlock, Connection con, HttpServletRequest request) {
        ArrayList list = new ArrayList();
        try {
            String query = billLinkBlock.getData();
            PreparedStatement ps = con.prepareStatement(query, 1);
            ResultSet resultSet = ps.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                for (int columnIndex = 1; columnIndex <= resultSetMetaData.getColumnCount(); ++columnIndex) {
                    System.out.println("ColumnType = " + resultSetMetaData.getColumnType(columnIndex));
                    System.out.println("ColumnTypeName = " + resultSetMetaData.getColumnTypeName(columnIndex));
                    rowMap.put(resultSetMetaData.getColumnName(columnIndex), resultSet.getString(columnIndex));
                }
                list.add(rowMap);
            }
            resultSet.close();
            ps.close();
            request.setAttribute(billLinkBlock.getKey(), list);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return "";
    }

    private String doJavaBlock(BillLinkBlock billLinkBlock, Connection con, HttpServletRequest request) {
        String javaBlockClass = billLinkBlock.getData();
        String result = "";
        try {
            result = Class.forName(javaBlockClass).asSubclass(BillLinkJavaBlock.class).getConstructor(new Class[0]).newInstance(new Object[0]).doBlock(billLinkBlock, con, request);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    private void sendError(Exception ex, HttpServletResponse response) throws IOException {
        this.sendError(ex.getMessage(), response);
        ex.printStackTrace();
    }

    private void sendError(String message, HttpServletResponse response) throws IOException {
        this.getLogger().error(message);
        response.sendError(500, message);
    }

    private Date getLinkDatetime(String value) {
        Date linkDatetime = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
            linkDatetime = dateFormat.parse(value);
        }
        catch (ParseException ex) {
            this.logError(ex);
        }
        return linkDatetime;
    }
}

