/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import bitel.billing.server.admin.bean.AddressManager;
import bitel.billing.server.contract.ContractRemover;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.tariff.TariffTreeBuilder;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractFilters;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractModuleManager;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNoteDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class ScriptUtils
extends BGLogger
implements AutoCloseable {
    private DefaultServerSetup setup;
    private Connection con;
    private ContractParameterPrefDao _contractParameterPrefDao;
    private ContractTariffDao _contractTariffDao;
    private ContractRemover _remover;
    private ContractManager _contractManager;
    private BalanceUtils _balanceUtils;
    private ContractModuleManager _contractModuleManager;
    private ContractDao _contractDao;
    private PaymentDao _paymentDao;
    private ChargeDao _chargeDao;
    private ContractStatusDao _contractStatusDao;

    public ScriptUtils(DefaultServerSetup setup, Connection con) {
        this.setup = setup;
        this.con = con;
    }

    public ScriptUtils(Connection con) {
        this(Setup.getSetup(), con);
    }

    private ContractParameterPrefDao contractParameterPrefDao() {
        if (this._contractParameterPrefDao == null) {
            this._contractParameterPrefDao = new ContractParameterPrefDao(this.con);
        }
        return this._contractParameterPrefDao;
    }

    private ContractTariffDao contractTariffDao() {
        if (this._contractTariffDao == null) {
            this._contractTariffDao = new ContractTariffDao(this.con);
        }
        return this._contractTariffDao;
    }

    private ContractRemover contractRemover() throws SQLException {
        if (this._remover == null) {
            this._remover = new ContractRemover(this.con, null);
        }
        return this._remover;
    }

    private ContractManager contractManager() {
        if (this._contractManager == null) {
            this._contractManager = new ContractManager(this.con);
        }
        return this._contractManager;
    }

    private BalanceUtils balanceUtils() {
        if (this._balanceUtils == null) {
            this._balanceUtils = new BalanceUtils(this.con);
        }
        return this._balanceUtils;
    }

    private ContractModuleManager contractModuleManager() {
        if (this._contractModuleManager == null) {
            this._contractModuleManager = new ContractModuleManager(this.con);
        }
        return this._contractModuleManager;
    }

    private PaymentDao paymentDao() {
        if (this._paymentDao == null) {
            this._paymentDao = new PaymentDao(this.con);
        }
        return this._paymentDao;
    }

    private ChargeDao chargeDao() {
        if (this._chargeDao == null) {
            this._chargeDao = new ChargeDao(this.con);
        }
        return this._chargeDao;
    }

    private ContractStatusDao contractStatusDao() {
        if (this._contractStatusDao == null) {
            this._contractStatusDao = new ContractStatusDao(this.con);
        }
        return this._contractStatusDao;
    }

    @Override
    public void close() throws BGException {
        if (this._remover != null) {
            this._remover.close();
        }
        if (this._balanceUtils != null) {
            this._balanceUtils.close();
        }
        if (this._contractDao != null) {
            this._contractDao.close();
        }
    }

    public void addContractParameter(int contractId, int parameterId, String value) throws Exception {
        this.addContractParameter(contractId, parameterId, value, null);
    }

    public void addContractParameter(int contractId, int parameterId, String value, String comment) throws Exception {
        if (Utils.isEmptyString((String)value)) {
            return;
        }
        ContractParameterPrefDao contractParameterPrefDao = this.contractParameterPrefDao();
        ContractParameterPref cpp = (ContractParameterPref)contractParameterPrefDao.get(parameterId);
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            switch (cpp.getType()) {
                case TYPE_TEXT: {
                    contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrText(contractId, parameterId, value));
                    return;
                }
                case TYPE_EMAIL: {
                    EntityAttrEmail attrEmail = contractDao.getContractParameterEmail(contractId, parameterId).orElse(new EntityAttrEmail(contractId, parameterId));
                    attrEmail.addContact(value, comment);
                    contractDao.updateContractParameter(contractId, (EntityAttr)attrEmail);
                    return;
                }
                case TYPE_DATE: {
                    if (Utils.isBlankString((String)comment)) {
                        comment = "dd.MM.yyyy";
                    }
                    Date date = TimeUtils.parseDate((String)value, (String)comment);
                    contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrDate(contractId, parameterId, date));
                    return;
                }
                case TYPE_PHONE: {
                    EntityAttrPhone attrPhone = contractDao.getContractParameterPhone(contractId, parameterId).orElse(new EntityAttrPhone(contractId, parameterId));
                    attrPhone.addContact(value, comment);
                    contractDao.updateContractParameter(contractId, (EntityAttr)attrPhone);
                    return;
                }
                case TYPE_FLAG: {
                    contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrBoolean(contractId, parameterId, Utils.parseBoolean((String)value)));
                    return;
                }
                case TYPE_LIST: {
                    int foundId = -1;
                    try {
                        String query = "SELECT id, title FROM contract_parameter_type_7_values WHERE pid=?";
                        PreparedStatement ps = this.con.prepareStatement(query);
                        ps.setInt(1, parameterId);
                        ResultSet rs = ps.executeQuery();
                        while (rs.next()) {
                            int id = rs.getInt(1);
                            String title = rs.getString(2);
                            if (!Utils.notBlankString((String)title) || !value.trim().equalsIgnoreCase(title.trim())) continue;
                            foundId = id;
                            break;
                        }
                        rs.close();
                        ps.close();
                    }
                    catch (Exception e) {
                        throw new BGException("error get list values", (Throwable)e);
                    }
                    if (foundId > 0) {
                        contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrList(contractId, parameterId, foundId, ""));
                    } else {
                        throw new BGMessageException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 (" + value + ") \u0434\u043b\u044f pid=" + parameterId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e, cid=" + contractId);
                    }
                    return;
                }
            }
            throw new RuntimeException("unsupported type '" + String.valueOf((Object)cpp.getType()) + "' parameter " + parameterId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContractParameter(int contractId, int parameterId) throws Exception {
        ContractParameterPrefDao contractParameterPrefDao = this.contractParameterPrefDao();
        ContractParameterPref cpp = (ContractParameterPref)contractParameterPrefDao.get(parameterId);
        if (cpp == null) {
            throw new BGException("parameter pid=" + parameterId + " not found");
        }
        try (ContractDao contractDao = new ContractDao(this.con, 0);
             ContractParameterManager contractParameterManager = new ContractParameterManager(this.con);){
            switch (cpp.getType()) {
                case TYPE_TEXT: {
                    String string = contractDao.optContractParameterTextAsString(contractId, parameterId).orElse(null);
                    return string;
                }
                case TYPE_EMAIL: 
                case TYPE_PHONE: {
                    String string = contractParameterManager.getTextlikeParam(contractId, parameterId);
                    return string;
                }
                case TYPE_FLAG: {
                    String string = contractDao.getContractParameterBoolean(contractId, parameterId, false).toString();
                    return string;
                }
                case TYPE_LIST: {
                    String string = contractDao.getContractParameterListAsString(contractId, parameterId).orElse(null);
                    return string;
                }
                case TYPE_MULTILIST: {
                    String string = contractDao.getContractParameterMultiListAsString(contractId, parameterId).orElse(null);
                    return string;
                }
                case TYPE_ADDRESS: {
                    String string = contractDao.getContractParameterAddressAsString(contractId, parameterId).orElse(null);
                    return string;
                }
            }
            throw new BGException("unsupported type '" + String.valueOf((Object)cpp.getType()) + "' parameter pid=" + parameterId);
        }
    }

    public AddressStruct getContractParameterAddress(int contractId, int pidAddress) {
        return new AddressManager(this.con).getAddress(contractId, pidAddress);
    }

    public Optional<AddressStruct> optContractParameterAddress(int contractId, int pidAddress) {
        return Optional.ofNullable(new AddressManager(this.con).getAddress(contractId, pidAddress));
    }

    public boolean isContractParameterAddress(int pidAddress) throws Exception {
        ContractParameterPrefDao contractParameterPrefDao = this.contractParameterPrefDao();
        ContractParameterPref cpp = (ContractParameterPref)contractParameterPrefDao.get(pidAddress);
        if (cpp == null) {
            return false;
        }
        return cpp.getType() == ContractParameterPrefType.TYPE_ADDRESS;
    }

    public void addContractAddressParameter(int cid, int pid, int countryId, int cityId, int streetId, int houseId, String flat, String streetUserValue, String houseUserValue) throws Exception {
        String comment = "";
        EntityAttrAddress address = null;
        if (houseId > 0) {
            AddressStruct addressStruct = AddressUtils.getAddressStruct(this.con, houseId, flat, "", null, null, comment);
            address = EntityAttrAddress.builder((int)cid, (int)pid).setHouseId(houseId).setFlat(addressStruct.getFlat()).setRoom(addressStruct.getRoom()).setPod(0).setFloor(0).setComment(comment).setFormatKey("0").setTitle(AddressUtils.getAddress(this.setup, addressStruct, "0")).build();
        } else {
            address = EntityAttrAddress.builder((int)cid, (int)pid).setHouseId(0).setFlat(null).setRoom("").setPod(0).setFloor(0).setComment(comment).setFormatKey(null).setTitle(streetUserValue + ", " + houseUserValue + " - " + flat).build();
        }
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            contractDao.updateContractParameter(cid, (EntityAttr)address);
        }
        new CommentPatternManager(this.con).updateContractComment(cid);
    }

    public Map<String, Integer> getBillingTariffMap() throws SQLException {
        HashMap<String, Integer> tarifMap = new HashMap<String, Integer>();
        String query = "SELECT id, title FROM tariff_plan";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            tarifMap.put(rs.getString(2).toLowerCase(), rs.getInt(1));
        }
        rs.close();
        ps.close();
        return tarifMap;
    }

    public int addNewTariff(String title) throws Exception {
        int treeId = new TariffTreeBuilder(this.con).createTree();
        String query = "INSERT INTO tariff_plan SET title=?, tree_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, title);
            ps.setInt(2, treeId);
            ps.executeUpdate();
            int n = ServerUtils.lastInsertId(ps);
            return n;
        }
    }

    public void addContractTariff(int cid, int tariffId, Date date1, String comment) throws Exception {
        ContractTariff contractTariff = new ContractTariff();
        contractTariff.setContractId(cid);
        contractTariff.setTariffPlanId(tariffId);
        contractTariff.getPeriod().setDateFrom(date1);
        contractTariff.setComment(comment);
        this.contractTariffDao().update(contractTariff);
    }

    public void addContractGroup(int contractId, int groupId) throws BGException {
        this.contractManager().addContractGroup(contractId, groupId);
    }

    public void deleteContractGroup(int contractId, int groupId) throws BGException {
        this.contractManager().deleteContractGroup(contractId, groupId);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean checkOnGroup(int contractId, long contractGroups) throws BGException {
        try {
            String query = "SELECT id FROM contract WHERE id=" + contractId + " AND contract.gr&" + contractGroups + ">0 ";
            try (Statement ps = this.con.createStatement();){
                boolean bl;
                block14: {
                    ResultSet rs = ps.executeQuery(query);
                    try {
                        bl = rs.next();
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return bl;
            }
        }
        catch (SQLException e) {
            throw new BGException("error sql check on group", (Throwable)e);
        }
    }

    public List<Contract> getGroupContracts(long groupMask) throws BGException {
        ContractFilters contractFilters = ContractFilters.builder().setTitle(null).setComment(null).setFaceType(-2).setGroupMask(groupMask).setSubContracts(true).setClosed(false).setHidden(false).build();
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            List<Contract> list = contractDao.list(contractFilters, null, "title", null);
            return list;
        }
    }

    public int removeContracts(int group) throws Exception {
        return this.removeContracts(Utils.enumToMask((String)String.valueOf(group)));
    }

    public int removeContracts(long groups) throws Exception {
        return this.removeContracts(groups, null);
    }

    public int removeContracts(long groups, String exceptIds) throws Exception {
        ContractRemover remover = this.contractRemover();
        Object query = "SELECT id FROM contract WHERE gr & ? > 0 ";
        if (Utils.notBlankString((String)exceptIds)) {
            query = (String)query + " AND id NOT IN (" + exceptIds + ")";
        }
        int count = 0;
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            ps.setLong(1, groups);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int cid = rs.getInt(1);
                    remover.removeContract(cid, false);
                    ++count;
                    if (this.con.getAutoCommit()) continue;
                    this.con.commit();
                }
            }
        }
        return count;
    }

    public void removeContractsMultiThread(int group, String exceptIds, int theadCount) throws SQLException, BGException {
        long groups = Utils.enumToMask((String)String.valueOf(group));
        Object query = "SELECT id FROM contract WHERE gr & ? > 0 ";
        if (Utils.notBlankString((String)exceptIds)) {
            query = (String)query + " AND id NOT IN (" + exceptIds + ")";
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(theadCount);
        ArrayList<RemoveThread> threads = new ArrayList<RemoveThread>();
        for (int i = 0; i < theadCount; ++i) {
            RemoveThread thread = new RemoveThread((Setup)this.setup);
            threads.add(thread);
            service.execute(thread);
        }
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            ps.setLong(1, groups);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int cid = rs.getInt(1);
                    int idx = cid % theadCount;
                    ((RemoveThread)threads.get(idx)).addContract(cid);
                }
            }
            for (int i = 0; i < theadCount; ++i) {
                ((RemoveThread)threads.get(i)).finish();
            }
            service.shutdown();
            service.awaitTermination(5L, TimeUnit.HOURS);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public void setBalance(int contractId, Date date) throws BGException {
        this.balanceUtils().updateBalance(date, contractId);
    }

    public BigDecimal getBalance(Date time, int contractId) throws BGException {
        return this.balanceUtils().getBalance(time, contractId);
    }

    public void addContractPayment(int cid, int paymentTypeId, Date date, BigDecimal sum, String comment) throws Exception {
        this.paymentDao().update(Payment.builder().setDate(date).setContractId(cid).setTypeId(paymentTypeId).setUserId(0).setSum(sum).setComment(comment).build());
    }

    public void addContractCharge(int cid, int chargeTypeId, Date date, BigDecimal sum, String comment) throws Exception {
        this.chargeDao().update(new Charge().setDate(date).setContractId(cid).setTypeId(chargeTypeId).setUserId(0).setSum(sum).setComment(comment));
    }

    public void addContractModule(int contractId, int moduleId) throws Exception {
        this.contractModuleManager().addContractModule(contractId, moduleId);
    }

    public void updateNote(int contractId, String title, String text) throws Exception {
        if (text == null) {
            return;
        }
        new ContractNoteDao(this.con).update((Object)ContractNote.builder().setTitle(title).setComment(text).setContractId(contractId).setUserId(0).setVisible(false).setDateTime(LocalDateTime.now()).build());
    }

    public void setStatus(int contractId, int status, Date dateFrom, String comment) throws Exception {
        this.setStatus(contractId, status, dateFrom, comment, false);
    }

    public void setStatus(int contractId, int status, Date dateFrom, String comment, boolean processEvent) throws Exception {
        ContractStatus newStatus = new ContractStatus().setContractId(contractId).setStatus(status).setDateFrom(dateFrom).setComment(comment);
        this.contractStatusDao().changeStatus(newStatus, 0, processEvent);
    }

    private static class RemoveThread
    implements Runnable {
        BlockingQueue<Integer> queue = new LinkedBlockingQueue<Integer>();
        private final Setup setup;

        public RemoveThread(Setup setup) {
            this.setup = setup;
        }

        public void addContract(int contractId) throws InterruptedException {
            this.queue.put(contractId);
        }

        public void finish() throws InterruptedException {
            this.queue.put(-1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerContext context = null;
            ThreadContext parentContext = null;
            try {
                try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
                     Connection con = connectionSet.getConnection();
                     ContractRemover remover = new ContractRemover(con, null);){
                    context = new ServerContext(this.setup, connectionSet, 0, 0);
                    parentContext = ServerContext.push((ThreadContext)context);
                    Integer cid = null;
                    while ((cid = this.queue.take()) != -1) {
                        remover.removeContract(cid, false);
                        if (con.getAutoCommit()) continue;
                        con.commit();
                    }
                }
                ServerContext.pop((ThreadContext)context, (ThreadContext)parentContext);
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
            finally {
                ServerContext.pop(context, parentContext);
            }
        }
    }
}

