/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.tariff.TariffTreeBuilder;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffChangeData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffCounter;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffEntry;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffMasterData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffMasterDataParam;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.PersonalTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService;
import ru.bitel.bgbilling.kernel.contract.api.server.ContractTariffMasterDataDefaultHandler;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractModuleManager;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffEntryDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffGroupDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffMasterDataHandler;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.PersonalTariffManager;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.CancelTariffEvent;
import ru.bitel.bgbilling.kernel.event.events.ChangeTariffByTaskEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffGroupListEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.GetChangeTariffDatesEvent;
import ru.bitel.bgbilling.kernel.event.events.GetTariffListEvent;
import ru.bitel.bgbilling.kernel.event.events.PersonalTariffDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.PersonalTariffUpdateEvent;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffCounterType;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroupTariff;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffGroupDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffBeforeUpdateEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeCache;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeMetaData;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService")
public class ContractTariffServiceImpl
extends AbstractService
implements ContractTariffService {
    private ContractTariffDao contractTariffDao;
    private ContractTariffGroupDao contractTariffGroupDao;
    private ContractTariffEntryDao contractTariffEntryDao;

    private ContractTariffDao getContractTariffDao() {
        if (this.contractTariffDao == null) {
            this.contractTariffDao = new ContractTariffDao(this.getConnection());
        }
        return this.contractTariffDao;
    }

    private ContractTariffGroupDao getContractTariffGroupDao() {
        if (this.contractTariffGroupDao == null) {
            this.contractTariffGroupDao = new ContractTariffGroupDao(this.getConnection());
        }
        return this.contractTariffGroupDao;
    }

    private ContractTariffEntryDao getContractTariffEntryDao() {
        if (this.contractTariffEntryDao == null) {
            this.contractTariffEntryDao = new ContractTariffEntryDao(this.getConnection());
        }
        return this.contractTariffEntryDao;
    }

    @Override
    public List<ContractTariff> contractTariffList(int contractId, boolean hiddenClosed, int entityModuleId, int entityId) throws BGException {
        return this.tryReturn(() -> this.getContractTariffDao().list(contractId, hiddenClosed, entityModuleId, entityId));
    }

    @Override
    public ContractTariff contractTariffGet(int id) throws BGException {
        return this.tryReturn(() -> (ContractTariff)this.getContractTariffDao().get(id));
    }

    @Override
    public int contractTariffUpdate(ContractTariff contractTariff) throws BGException {
        return this.tryReturn(() -> {
            ContractTariffBeforeUpdateEvent beforeActivate = EventProcessor.getInstance().request(new ContractTariffBeforeUpdateEvent(contractTariff.getContractId(), this.userId, contractTariff));
            if (beforeActivate.getError() != null) {
                throw new BGMessageException(beforeActivate.getError());
            }
            boolean isAdd = contractTariff.getId() < 1;
            ServerUtils.checkPeriod((Date)contractTariff.getPeriod().getDateFrom(), (Date)contractTariff.getPeriod().getDateTo());
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionUpdateContractTariffPlan", (int)this.moduleId, (int)this.userId);
            if (closedDate != null) {
                ContractTariff old = (ContractTariff)this.getContractTariffDao().get(contractTariff.getId());
                Date olddate1 = null;
                Date olddate2 = null;
                if (old != null) {
                    olddate1 = old.getPeriod().getDateFrom();
                    olddate2 = old.getPeriod().getDateTo();
                }
                ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)olddate1, (Date)olddate2, (Date)contractTariff.getPeriod().getDateFrom(), (Date)contractTariff.getPeriod().getDateTo());
                if (old != null && contractTariff.getTariffPlanId() != old.getTariffPlanId()) {
                    ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)olddate1, (Date)new Date());
                }
            }
            this.getContractTariffDao().update(contractTariff);
            this.context.publishAfterCommit(new ContractTariffChangedEvent(contractTariff.getContractId()));
            this.context.publishAfterCommit(new ContractTariffUpdateEvent(this.userId, contractTariff.getContractId(), contractTariff, isAdd));
            return contractTariff.getId();
        });
    }

    @Override
    public void contractTariffDelete(int id) throws BGException {
        this.tryCall(() -> {
            ContractTariff tar;
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionDeleteContractTariffPlan", (int)this.moduleId, (int)this.userId);
            if (closedDate != null && (tar = (ContractTariff)this.getContractTariffDao().get(id)) != null) {
                ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)tar.getPeriod().getDateFrom());
            }
            ContractTariff contractTariff = (ContractTariff)this.getContractTariffDao().getAndDelete(id);
            this.context.publishAfterCommit(new ContractTariffChangedEvent(contractTariff.getContractId()));
            this.context.publishAfterCommit(new ContractTariffDeleteEvent(this.userId, contractTariff.getContractId(), id));
        });
    }

    private void contractTariffDelete(ContractTariff contractTariff) throws BGException {
        this.tryCall(() -> {
            ContractTariff tar;
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionDeleteContractTariffPlan", (int)this.moduleId, (int)this.userId);
            if (closedDate != null && (tar = (ContractTariff)this.getContractTariffDao().get(contractTariff.getId())) != null) {
                ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)tar.getPeriod().getDateFrom());
            }
            this.getContractTariffDao().delete(contractTariff.getId());
            this.context.publishAfterCommit(new ContractTariffChangedEvent(contractTariff.getContractId()));
            this.context.publishAfterCommit(new ContractTariffDeleteEvent(this.userId, contractTariff.getContractId(), contractTariff.getId()));
        });
    }

    @Override
    public List<ContractTariffEntry> contractTariffEntryList(int contractId, Date date, int entityMid, int entityId) throws BGException {
        List<ContractTariffEntry> result = this.getContractTariffEntryDao().list(contractId, date, entityMid, entityId);
        Date now = new Date();
        for (ContractTariffEntry e : result) {
            if (e.isPersonal() || e.getReplacedFromContractTariffId() <= 0 || !TimeUtils.dateBefore(now, e.getDateFrom())) continue;
            e.setCanCancel(true);
        }
        return result;
    }

    @Override
    public String contractTariffChangeByCustomer(int contractId, ContractTariffChangeData data) throws BGException {
        String message = null;
        ContractTariff fromContractTariff = this.contractTariffGet(data.getFromContractTariffId());
        if (fromContractTariff.getContractId() != contractId) {
            throw new BGIllegalArgumentException();
        }
        Date nowDate = new Date();
        TariffGroup tariffGroup = this.context.getDirectory(TariffGroup.class, 0).get(data.getTariffGroupId());
        this.checkTariffGroup(tariffGroup, data.getToTariffPlanId(), nowDate);
        TariffPlan toTariff = this.context.getDirectory(TariffPlan.class, 0).get(data.getToTariffPlanId());
        if (toTariff == null) {
            throw new BGIllegalArgumentException();
        }
        ChangeTariffByTaskEvent event = new ChangeTariffByTaskEvent(this.userId, contractId, tariffGroup, fromContractTariff, toTariff, data.getFromDate());
        event = EventProcessor.getInstance().request(event);
        if (Utils.notBlankString(event.getError())) {
            throw new BGMessageException(event.getError());
        }
        if (Utils.notBlankString(event.getMessage())) {
            message = event.getMessage();
        }
        if (!event.isProcessed() && fromContractTariff != null) {
            fromContractTariff.getPeriod().setDateTo(TimeUtils.getPrevDay(data.getFromDate()));
            if (TimeUtils.dateBefore(fromContractTariff.getPeriod().getDateTo(), fromContractTariff.getPeriod().getDateFrom())) {
                this.contractTariffDelete(fromContractTariff);
            } else {
                this.contractTariffUpdate(fromContractTariff);
            }
            this.contractTariffUpdate(ContractTariff.builder().setContractId(contractId).setPeriod(new Period(data.getFromDate(), null)).setComment(data.getComment()).setPosition(tariffGroup.getPos()).setTariffGroupId(fromContractTariff.getTariffGroupId()).setTariffPlanId(data.getToTariffPlanId()).setReplacedFromContractTariffId(fromContractTariff.getId()).build());
        }
        this.context.publishAfterCommit(new ContractTariffChangedEvent(contractId));
        return message;
    }

    private void checkTariffGroup(TariffGroup tariffGroup, int toTariffPlanId, Date nowDate) throws BGException {
        if (tariffGroup == null) {
            throw new BGMessageException("\u0422\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
        }
        boolean toFound = false;
        for (TariffGroupTariff groupTariff : tariffGroup.getPlanList()) {
            if (!TimeUtils.dateInRange(nowDate, groupTariff.getDate1(), groupTariff.getDate2()) || groupTariff.getId() != toTariffPlanId) continue;
            toFound = true;
            break;
        }
        if (!toFound) {
            throw new BGMessageException("\u0426\u0435\u043b\u0435\u0432\u043e\u0439 \u0442\u0430\u0440\u0438\u0444 \u043d\u0435 \u0438\u0437 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b.");
        }
    }

    @Override
    public MapHolder<Integer, List<Integer>> contractTariffChangeAvailableMap(int contractId) throws BGException {
        Date now = new Date();
        HashMap result = new HashMap();
        Directory<TariffGroup> tariffGroupDirectory = this.context.getDirectory(TariffGroup.class, 0);
        List<ContractTariff> contractTariffs = this.contractTariffList(contractId, false, 0, 0);
        for (ContractTariff contractTariff : contractTariffs) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("contractTariff = " + String.valueOf(contractTariff));
                this.getLogger().debug("contractTariff.getDateTo() = " + String.valueOf(contractTariff.getPeriod().getDateTo()));
                this.getLogger().debug("contractTariff.getDateFrom() = " + String.valueOf(contractTariff.getPeriod().getDateFrom()));
            }
            if (contractTariff.getPeriod().getDateTo() != null || contractTariff.getPeriod().getDateFrom() != null && TimeUtils.dateBefore(now, contractTariff.getPeriod().getDateFrom())) continue;
            TariffGroup tariffGroup = tariffGroupDirectory.get(this.getTariffGroupId(contractTariff));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("tariffGroup = " + String.valueOf(tariffGroup));
            }
            if (tariffGroup == null) continue;
            GetTariffListEvent tariffListEvent = new GetTariffListEvent(contractId, contractTariff, tariffGroup, this.userId);
            tariffListEvent = EventProcessor.getInstance().request(tariffListEvent);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("tariffListEvent = " + String.valueOf(tariffListEvent));
            }
            List<TariffPlan> tariffListFromEvent = tariffListEvent.getTariffList();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("tariffListFromEvent = " + String.valueOf(tariffListFromEvent));
            }
            if (tariffListFromEvent != null) {
                if (tariffListFromEvent.size() <= 0) continue;
                ArrayList<Integer> ids = new ArrayList<Integer>(tariffListFromEvent.size());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("(event)contractTariff.getId() = " + contractTariff.getId());
                    this.getLogger().debug("(event)ids = " + String.valueOf(ids));
                }
                result.put(contractTariff.getId(), ids);
                for (TariffPlan tariff : tariffListFromEvent) {
                    ids.add(tariff.getId());
                }
                continue;
            }
            try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.getConnection());){
                ArrayList<Integer> ids = new ArrayList<Integer>();
                for (TariffGroupTariff tariffGroupTariff : Utils.maskNull(tariffGroup.getPlanList())) {
                    TariffPlan tariffPlan;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("TariffGroupTariff = " + String.valueOf(tariffGroupTariff));
                        this.getLogger().debug("now = " + String.valueOf(now));
                        this.getLogger().debug("groupTariff.getDate1() = " + String.valueOf(tariffGroupTariff.getDate1()));
                        this.getLogger().debug("groupTariff.getDate2() = " + String.valueOf(tariffGroupTariff.getDate2()));
                    }
                    if ((tariffPlan = (TariffPlan)tariffPlanDao.get(tariffGroupTariff.getId())) == null || !tariffPlan.isUsed() || tariffGroupTariff.getId() == contractTariff.getTariffPlanId() || !TimeUtils.dateInRange(now, tariffGroupTariff.getDate1(), tariffGroupTariff.getDate2())) continue;
                    ids.add(tariffGroupTariff.getId());
                }
                if (ids != null && ids.size() > 0) {
                    result.put(contractTariff.getId(), ids);
                }
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("contractTariff.getId() = " + contractTariff.getId());
                this.getLogger().debug("ids = " + String.valueOf(ids));
            }
        }
        return new MapHolder<Integer, List<Integer>>(result);
    }

    private int getTariffGroupId(ContractTariff contractTariff) throws BGException {
        return this.tryReturn(() -> {
            ContractTariffGroup contractTariffGroup;
            int tariffGroupId = contractTariff.getTariffGroupId();
            if (tariffGroupId < 0 && (contractTariffGroup = (ContractTariffGroup)this.getContractTariffGroupDao().get(contractTariff.getContractId())) != null) {
                tariffGroupId = contractTariffGroup.getTariffGroupId();
            }
            return tariffGroupId;
        });
    }

    @Override
    public List<Date> contractTariffChangeAvailableDateList(int contractId, int tariffGroupId, int fromTariffPlanId, int toTariffPlanId) throws BGException {
        return this.tryReturn(() -> {
            List<Object> result = new ArrayList();
            Date nowDate = new Date();
            TariffGroup tariffGroup = this.context.getDirectory(TariffGroup.class, 0).get(tariffGroupId);
            this.checkTariffGroup(tariffGroup, toTariffPlanId, nowDate);
            GetChangeTariffDatesEvent event = new GetChangeTariffDatesEvent(this.userId, contractId, tariffGroup, new Date(), fromTariffPlanId, toTariffPlanId);
            event = EventProcessor.getInstance().request(event);
            if (event.getDateList() != null) {
                result = event.getDateList();
            } else {
                GregorianCalendar now = new GregorianCalendar();
                int transferMode = tariffGroup.getTransferMode();
                if (transferMode != 1) {
                    if (transferMode == 4) {
                        ((Calendar)now).add(6, 1);
                    } else if (transferMode == 2) {
                        ((Calendar)now).add(3, 1);
                        now.set(7, 2);
                    } else {
                        ((Calendar)now).add(2, 1);
                        now.set(5, 1);
                    }
                }
                Calendar limitDate = (Calendar)((Calendar)now).clone();
                limitDate.add(6, tariffGroup.getDaysForward());
                while (now.before(limitDate)) {
                    result.add(now.getTime());
                    if (transferMode == 1 || transferMode == 4) {
                        ((Calendar)now).add(6, 1);
                        continue;
                    }
                    if (transferMode == 2) {
                        ((Calendar)now).add(3, 1);
                        continue;
                    }
                    ((Calendar)now).add(2, 1);
                }
            }
            return result;
        });
    }

    @Override
    public String contractTariffCancelByCustomer(int contractId, int contractTariffId) throws BGException {
        return this.tryReturn(() -> {
            String result = null;
            ContractTariff contractTariff = this.contractTariffGet(contractTariffId);
            if (contractTariff == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariffId + ")");
            }
            if (contractTariff.getContractId() != contractId) {
                throw new BGMessageException("\u042d\u0442\u043e \u043d\u0435 \u0432\u0430\u0448 \u0442\u0430\u0440\u0438\u0444");
            }
            if (contractTariff.getReplacedFromContractTariffId() <= 0) {
                throw new BGMessageException("\u041d\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043d\u0430 \u0447\u0442\u043e \u043e\u0442\u043c\u0435\u043d\u044f\u0442\u044c");
            }
            ContractTariff contractTariffPrevious = this.contractTariffGet(contractTariff.getReplacedFromContractTariffId());
            if (contractTariffPrevious == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u043c \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariff.getReplacedFromContractTariffId() + ")");
            }
            CancelTariffEvent event = new CancelTariffEvent(this.userId, contractId, contractTariff, contractTariffPrevious);
            event = EventProcessor.getInstance().request(event);
            if (Utils.notBlankString(event.getError())) {
                throw new BGMessageException(event.getError());
            }
            if (Utils.notBlankString(event.getMessage())) {
                result = event.getMessage();
            }
            if (!event.isProcessed()) {
                contractTariffPrevious.getPeriod().setDateTo(null);
                this.getContractTariffDao().update(contractTariffPrevious);
                this.getContractTariffDao().delete(contractTariff.getId());
            }
            this.context.publishAfterCommit(new ContractTariffChangedEvent(contractId));
            this.context.publishAfterCommit(new ContractTariffUpdateEvent(this.userId, contractId, contractTariffPrevious, false));
            this.context.publishAfterCommit(new ContractTariffDeleteEvent(this.userId, contractId, contractTariff.getId()));
            return result;
        });
    }

    @Override
    public List<IdTitle> contractTariffListByParam(int contractId, int tariffPlanId, int moduleId, boolean showUsed, boolean useFilter, int tariffGroupId) throws BGException {
        return this.tryReturn(() -> {
            ArrayList<IdTitle> contractTariffs = new ArrayList<IdTitle>();
            int localTariffGroupId = tariffGroupId;
            if (localTariffGroupId == -1) {
                ContractTariffGroup contractTariffGroup = (ContractTariffGroup)this.getContractTariffGroupDao().get(contractId);
                int n = localTariffGroupId = contractTariffGroup != null ? contractTariffGroup.getTariffGroupId() : 0;
            }
            if (!useFilter) {
                this.listAvaliableTariffPlans(contractTariffs, contractId, tariffPlanId, showUsed, localTariffGroupId != 0, localTariffGroupId, moduleId);
            } else if (contractId > 0) {
                Contract contract = this.getContract(contractId);
                List<Integer> contractLabelIds = new ContractLabelManager(this.getConnection()).getContractLabelIds(contractId);
                this.listAvaliableTariffPlans(contractTariffs, contractId, tariffPlanId, showUsed, moduleId, contractLabelIds, contract.getPersonType(), contract.getTitle(), localTariffGroupId != 0, localTariffGroupId);
            }
            return contractTariffs;
        });
    }

    private void listAvaliableTariffPlans(List<IdTitle> contractTariffs, int contractId, int defaultTariffPlanId, boolean getUsed, boolean tariffGroupFilter, int tariffGroupId, int moduleId) throws BGException {
        Connection con = this.getConnection();
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(con);
             TariffGroupDao tariffGroupDao = new TariffGroupDao(con);){
            for (TariffPlan tariffPlan : tariffPlanDao.list()) {
                if (tariffPlan.getId() != defaultTariffPlanId && (getUsed && !tariffPlan.isUsed() || !tariffPlanDao.usesModule(tariffPlan.getId(), moduleId) && moduleId >= 0 || tariffGroupFilter && !this.isPlanInContractTariffGroup(contractId, tariffPlan.getId(), tariffGroupId, tariffGroupDao))) continue;
                contractTariffs.add(new IdTitle(tariffPlan.getId(), tariffPlan.getTitle()));
            }
        }
    }

    private void listAvaliableTariffPlans(List<IdTitle> contractTariffs, int contractId, int defaultTariffPlanId, boolean getUsed, int moduleId, List<Integer> contractLabelIds, int face, String title, boolean tariffGroupFilter, int tariffGroupId) throws BGException {
        Connection con = this.getConnection();
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(con);
             TariffGroupDao tariffGroupDao = new TariffGroupDao(con);){
            for (TariffPlan plan : tariffPlanDao.getTariffPlanList(defaultTariffPlanId, contractLabelIds, face, title)) {
                if (plan.getId() != defaultTariffPlanId && (getUsed && !plan.isUsed() || !tariffPlanDao.usesModule(plan.getId(), moduleId) && moduleId >= 0 || tariffGroupFilter && !this.isPlanInContractTariffGroup(contractId, plan.getId(), tariffGroupId, tariffGroupDao))) continue;
                contractTariffs.add(new IdTitle(plan.getId(), plan.getTitle()));
            }
        }
    }

    private boolean isPlanInContractTariffGroup(int contractId, int tariffPlanId, int tariffGroupId, TariffGroupDao tariffGroupDao) throws BGException {
        boolean result = false;
        Date dt = new Date();
        TariffGroup tariffGroup = (TariffGroup)tariffGroupDao.get(tariffGroupId);
        if (tariffGroup != null) {
            List<TariffGroupTariff> tariffGroupItems = tariffGroup.getPlanList();
            for (TariffGroupTariff tariffItem : tariffGroupItems) {
                if (!TimeUtils.dateInRange(dt, tariffItem.getDate1(), tariffItem.getDate2()) || tariffItem.getId() != tariffPlanId) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public void groupOperationSetTariffGroup(String contractIds, String mode, int tariffPlanId, int tariffGroupId) throws BGException {
        this.tryCall(() -> {
            for (int contractId : Utils.toIntArray(contractIds)) {
                if ("tariff".equals(mode)) {
                    for (ContractTariff contractTariff : this.getContractTariffDao().list(contractId, true)) {
                        if (contractTariff.getTariffPlanId() != tariffPlanId) continue;
                        contractTariff.setTariffGroupId(tariffGroupId);
                        this.getContractTariffDao().update(contractTariff);
                    }
                    continue;
                }
                if (!"group".equals(mode)) continue;
                this.getContractTariffGroupDao().update(ContractTariffGroup.builder().setContractId(contractId).setTariffGroupId(tariffGroupId).build());
            }
        });
    }

    @Override
    public ContractTariffGroup contractTariffGroupGet(int contractId) throws BGException {
        return this.tryReturn(() -> (ContractTariffGroup)this.getContractTariffGroupDao().get(contractId));
    }

    @Override
    public void contractTariffGroupSet(int contractId, int tariffGroupId) throws BGException {
        this.tryCall(() -> this.getContractTariffGroupDao().update(ContractTariffGroup.builder().setContractId(contractId).setTariffGroupId(tariffGroupId).build()));
    }

    @Override
    public List<TariffGroup> contractTariffGroupList(int contractId) throws BGException {
        return this.tryReturn(() -> {
            Contract contract = this.context.getService(ContractService.class, 0).contractGet(contractId);
            int domainId = contract != null ? contract.getDomainId() : 0;
            ArrayList<TariffGroup> tariffGroups = new ArrayList<TariffGroup>();
            for (String value : Utils.toList(this.getSetup().get("contract.tariff.group", "default,noSet,domain"))) {
                TariffGroup tariffGroup = null;
                switch (value) {
                    case "default": {
                        tariffGroup = new TariffGroup();
                        tariffGroup.setId(-1);
                        tariffGroup.setDomainId(domainId);
                        tariffGroup.setTitle("<\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e>");
                        tariffGroups.add(tariffGroup);
                        break;
                    }
                    case "noSet": {
                        tariffGroup = new TariffGroup();
                        tariffGroup.setId(0);
                        tariffGroup.setDomainId(domainId);
                        tariffGroup.setTitle("<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>");
                        tariffGroups.add(tariffGroup);
                        break;
                    }
                    case "domain": {
                        this.context.getService(TariffService.class, 0).tariffGroupList().stream().filter(a -> a.getDomainId() == domainId).forEach(a -> tariffGroups.add((TariffGroup)a));
                        break;
                    }
                    case "nodomain": {
                        this.context.getService(TariffService.class, 0).tariffGroupList().stream().filter(a -> a.getDomainId() == 0).forEach(a -> tariffGroups.add((TariffGroup)a));
                        break;
                    }
                    case "all": {
                        this.context.getService(TariffService.class, 0).tariffGroupList().forEach(a -> tariffGroups.add((TariffGroup)a));
                        break;
                    }
                }
            }
            ContractTariffGroupListEvent event = new ContractTariffGroupListEvent(this.userId, contractId, tariffGroups);
            event = EventProcessor.getInstance().request(event);
            return event.getTariffGroups();
        });
    }

    @Override
    public List<ContractTariffVar> contractTariffVars(int contractTariffId) throws BGException {
        return this.tryReturn(() -> this.getContractTariffDao().getContractTariffVars(contractTariffId));
    }

    @Override
    public void contractTariffVarUpdate(ContractTariffVar contractTariffVar) throws BGException {
        this.tryCall(() -> this.getContractTariffDao().updateContractTariffVar(contractTariffVar));
    }

    @Override
    public void contractTariffVarDelete(ContractTariffVar contractTariffVar) throws BGException {
        this.tryCall(() -> this.getContractTariffDao().deleteContractTariffVar(contractTariffVar));
    }

    @Override
    public PersonalTariff personalTariffGet(int id) throws BGException {
        return this.tryReturn(() -> new PersonalTariffManager(this.getConnection()).getPersonalTariff(id));
    }

    @Override
    public int personalTariffUpdate(int contractId, PersonalTariff personalTariff) throws BGException {
        return this.tryReturn(() -> {
            PersonalTariffManager manager = new PersonalTariffManager(this.getConnection());
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionUpdatePersonalTariff", (int)0, (int)this.userId);
            if (closedDate != null) {
                PersonalTariff tariff = manager.getPersonalTariff(personalTariff.getId());
                Calendar oldDate1 = null;
                Calendar oldDate2 = null;
                if (tariff != null) {
                    oldDate1 = tariff.getDate1();
                    oldDate2 = tariff.getDate2();
                }
                ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Calendar)oldDate1, (Calendar)oldDate2, (Calendar)personalTariff.getDate1(), (Calendar)personalTariff.getDate2());
            }
            manager.updatePersonalTariff(personalTariff);
            this.context.publishAfterCommit(new ContractTariffChangedEvent(contractId));
            this.context.publishAfterCommit(new PersonalTariffUpdateEvent(this.userId, contractId, personalTariff.getId()));
            return personalTariff.getId();
        });
    }

    @Override
    public int personalTariffDelete(int contractId, int personalTariffId) throws BGException {
        return this.tryReturn(() -> {
            PersonalTariffManager manager = new PersonalTariffManager(this.getConnection());
            PersonalTariff tariff = manager.getPersonalTariff(personalTariffId);
            if (tariff != null) {
                String error;
                Calendar closedDate = null;
                closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionDeletePersonalTariff", (int)0, (int)this.userId);
                if (closedDate != null) {
                    ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Calendar)tariff.getDate1());
                }
                if (Utils.notBlankString(error = new TariffTreeBuilder(this.getConnection()).deleteTree(tariff.getTreeId()))) {
                    throw new BGMessageException(error);
                }
                String query = "DELETE FROM contract_tree_link WHERE tree_id=?";
                try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
                    ps.setInt(1, tariff.getTreeId());
                    ps.executeUpdate();
                }
                manager.deletePersonalTariff(personalTariffId);
                this.context.publishAfterCommit(new ContractTariffChangedEvent(contractId));
                this.context.publishAfterCommit(new PersonalTariffDeleteEvent(this.userId, contractId, personalTariffId));
            }
            return 0;
        });
    }

    @Override
    public List<PersonalTariff> personalTariffList(int contractId) throws BGException {
        return this.tryReturn(() -> new PersonalTariffManager(this.getConnection()).getPersonalTariffList(contractId));
    }

    @Override
    public List<IdTitle> contractTariffModuleList(int contractId) throws BGException {
        return this.tryReturn(() -> {
            HashSet ids = new HashSet();
            HashSet<String> moduleExclude = new HashSet<String>(Arrays.asList("bill", "card", "email", "license"));
            new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).forEach(a -> {
                try {
                    Class<?> clazz = Class.forName(ModuleCache.getInstance().getModule((int)a).getInstalledModule().getPackageServer() + ".Module");
                    if (!clazz.isAnnotationPresent(BGPaymentModule.class)) {
                        ids.add(a);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return ModuleCache.getInstance().getModulesList().stream().filter(a -> ids.contains(a.getId()) && !moduleExclude.contains(a.getName())).map(IdTitle::toIdTitle).toList();
        });
    }

    @Override
    public List<ContractTariffCounter> contractTariffCounters(int contractTariffId) throws BGException {
        return this.tryReturn(() -> {
            ArrayList counters = new ArrayList();
            try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.getConnection());){
                ContractTariffDao contractTariffDao = new ContractTariffDao(this.getConnection());
                ContractTariff contractTariff = (ContractTariff)contractTariffDao.get(contractTariffId);
                if (contractTariff != null) {
                    int entityId = contractTariff.getEntityId();
                    int treeId = tariffPlanDao.getTariffPlanTreeId(contractTariff.getTariffPlanId());
                    Map<Integer, Integer> moduleTreesMap = tariffPlanDao.getModuleTrees(treeId);
                    for (Map.Entry<Integer, Integer> entry : moduleTreesMap.entrySet()) {
                        if (entityId > 0 && contractTariff.getEntityMid() != entry.getValue().intValue()) continue;
                        ModuleCache.getInstance().optModule(entry.getValue()).ifPresent(module -> {
                            TariffModuleTree tariffModuleTree = TariffTreeCache.getInstance().getModuleTree(this.getConnection(), treeId, (Integer)entry.getValue(), module.getName()).get();
                            if (tariffModuleTree != null) {
                                this.buildTariffCounterList(counters, tariffModuleTree.getRootNode(), entityId > 0 ? TariffCounterType.ACCOUNT : TariffCounterType.CONTRACT, (Integer)entry.getValue(), entityId);
                            }
                        });
                    }
                }
            }
            return counters;
        });
    }

    private void buildTariffCounterList(List<ContractTariffCounter> counters, TariffTreeNodeHolder treeNodeHolder, TariffCounterType counterType, int moduleId, int entityId) {
        TariffTreeNodeMetaData metaData = treeNodeHolder.node.getMetaData();
        if (metaData != null && metaData.isRange()) {
            ContractTariffCounter counter = ContractTariffCounter.builder().setId((int)(treeNodeHolder.treeNodeId & 0xFFFFFFFFFFFFFFFFL)).setModuleId(moduleId).setEntityId(entityId).setCounterType(counterType).setTitle(metaData.getRangeTitle()).build();
            counters.add(counter);
        }
        if (treeNodeHolder.children != null) {
            for (TariffTreeNodeHolder childTreeNodeHolder : treeNodeHolder.children) {
                this.buildTariffCounterList(counters, childTreeNodeHolder, counterType, moduleId, entityId);
            }
        }
    }

    @Override
    public void contractTariffCounterUpdate(ContractTariffCounter contractTariffCounter) throws BGException {
    }

    @Override
    public void contractTariffCounterDelete(ContractTariffCounter contractTariffCounter) throws BGException {
    }

    @Override
    public List<KeyValue> contractTariffMasterFilters(ContractTariffMasterDataParam contractTariffMasterDataParam) throws BGException {
        return this.tryReturn(() -> {
            String handlerClassName = Setup.getSetup().get("contract.tariff.master.class");
            if (handlerClassName != null) {
                return DynamicClassManager.getInstance().newInstance(ContractTariffMasterDataHandler.class, handlerClassName).filters(contractTariffMasterDataParam, this.userId);
            }
            return new ContractTariffMasterDataDefaultHandler().filters(contractTariffMasterDataParam, this.userId);
        });
    }

    @Override
    public ContractTariffMasterData contractTariffMasterDataGet(ContractTariffMasterDataParam contractTariffMasterDataParam) throws BGException {
        return this.tryReturn(() -> {
            String handlerClassName = Setup.getSetup().get("contract.tariff.master.class");
            if (handlerClassName != null) {
                return DynamicClassManager.getInstance().newInstance(ContractTariffMasterDataHandler.class, handlerClassName).get(contractTariffMasterDataParam, this.userId);
            }
            return new ContractTariffMasterDataDefaultHandler().get(contractTariffMasterDataParam, this.userId);
        });
    }
}

