/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.account;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ModuleAccountManager {
    private Map<Integer, ModuleAccount> serviceAmountMap = new HashMap<Integer, ModuleAccount>();
    private List<ModuleAccount> serviceAmountList = new ArrayList<ModuleAccount>();

    public ModuleAccountManager(Preferences setup) throws BGException {
        for (Map.Entry e_entry : setup.subIndexed("module.account.").entrySet()) {
            Map entry = ((ParameterMap)e_entry.getValue()).getMap();
            entry.put("id", String.valueOf(e_entry.getKey()));
            ModuleAccount set = null;
            String className = (String)entry.get("class");
            if (Utils.notBlankString((String)className)) {
                try {
                    Class clazz = DynamicClassManager.getInstance().loadClass(className);
                    if (ModuleAccount.class.isAssignableFrom(clazz)) {
                        set = (ModuleAccount)((Object)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (set == null) continue;
            set.setId((Integer)e_entry.getKey());
            set.setModuleId(Utils.parseInt((String)((String)entry.get("mid"))));
            set.setServiceIds(Utils.toIntegerList((String)((String)entry.get("sids"))));
            set.setTitle((String)entry.get("title"));
            if (set.getId() < 0 || set.getModleId() < 0 || !Utils.notBlankString((String)set.getTitle())) continue;
            this.serviceAmountList.add(set);
            this.serviceAmountMap.put(set.getId(), set);
        }
    }

    public Map<Integer, ModuleAccount> getModuleAccountMap() {
        return this.serviceAmountMap;
    }

    public List<ModuleAccount> getModuleAccountList() {
        return this.serviceAmountList;
    }
}

