/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.range;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicRange;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Idable;

public class VoiceGeographicRangeDao
extends AbstractIdDao<VoiceGeographicRange> {
    public VoiceGeographicRangeDao(Connection con, int moduleId) {
        super(con, "voice_geographic_range", moduleId);
    }

    public List<VoiceGeographicRange> list(int operatorId) throws SQLException {
        Object[] objectArray;
        String string = operatorId > 0 ? "operatorId=?" : "";
        if (operatorId > 0) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = operatorId;
        } else {
            objectArray = new Object[]{};
        }
        return this.list(string, "codeFrom", objectArray);
    }

    public List<VoiceGeographicRange> list(int operatorId, String filterText) throws SQLException {
        long a1 = Utils.parseLong((String)(filterText + "0".repeat(11 - filterText.length())));
        long a2 = Utils.parseLong((String)(filterText + "9".repeat(11 - filterText.length())));
        return operatorId > 0 ? this.list("operatorId=? and codeFrom <= ? and codeTo >= ?", "codeFrom", new Object[]{operatorId, a2, a1}) : this.list("codeFrom <= ? and codeTo >= ?", "codeFrom", new Object[]{a2, a1});
    }

    public Map<Integer, Integer> getDestinationLinkCountMap(Set<Integer> destionationIds) throws SQLException {
        HashMap<Integer, Integer> links = new HashMap<Integer, Integer>();
        String query = "SELECT `destinationId`, COUNT(*) FROM " + this.tableName + (String)(destionationIds != null && !destionationIds.isEmpty() ? " WHERE `destinationId` IN ( " + Utils.toString(destionationIds) + " ) " : "") + " GROUP BY `destinationId`";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                links.put(rs.getInt(1), rs.getInt(2));
            }
        }
        return links;
    }

    protected VoiceGeographicRange getFromRS(ResultSet rs) throws SQLException {
        return VoiceGeographicRange.builder().setId(rs.getInt("id")).setRangeFrom(rs.getLong("codeFrom")).setRangeTo(rs.getLong("codeTo")).setDestinationId(rs.getInt("destinationId")).setOperatorId(rs.getInt("operatorId")).setMobileId(rs.getString("mobileId")).build();
    }

    protected void updateImpl(VoiceGeographicRange range) throws SQLException {
        String querySet = "codeFrom=?, codeTo=?, destinationId=?, operatorId=?, mobileId=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)range, querySet);){
            int index = 1;
            ps.setLong(index++, range.getRangeFrom());
            ps.setLong(index++, range.getRangeTo());
            ps.setInt(index++, range.getDestinationId());
            ps.setInt(index++, range.getOperatorId());
            ps.setString(index++, range.getMobileId());
            this.executeUpdate((Id)range, index, ps);
        }
    }

    public List<IdTitle> getGeographicRangeTitles(int operatorId) throws SQLException {
        ArrayList<IdTitle> rangeTitles = new ArrayList<IdTitle>();
        String query = "SELECT id, codeFrom, codeTo, destinationId FROM " + this.tableName + " WHERE operatorId=? ORDER BY codeFrom";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, operatorId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    rangeTitles.add(new IdTitle(rs.getInt("id"), rs.getString("codeFrom") + " - " + rs.getString("codeTo")));
                }
            }
        }
        return rangeTitles;
    }

    public List<VoiceGeographicRange> list(List<Integer> rangeIds) throws SQLException {
        return this.list("id IN ( " + Utils.toString(rangeIds) + " )", null, new Object[0]);
    }
}

