/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.common.Utils;

public class DialogElemenCheckBoxFilterPanel
extends JPanel {
    private final List<FilterCheckBox> filtres = new ArrayList<FilterCheckBox>(4);
    private final Set<FilterCheckBox> selectedFiltres = new HashSet<FilterCheckBox>();
    private FilterChangeListener filterChangeListener;

    public DialogElemenCheckBoxFilterPanel(FilterChangeListener filterChangeListener) {
        this.filterChangeListener = filterChangeListener;
        FilterCheckBox allFilter = new FilterCheckBox(null);
        FilterCheckBox textFilter = new FilterCheckBox(BotDialogElementType.TEXT);
        FilterCheckBox buttonFilter = new FilterCheckBox(BotDialogElementType.BUTTON);
        FilterCheckBox linkFilter = new FilterCheckBox(BotDialogElementType.LINK);
        FilterCheckBox attachmentFilter = new FilterCheckBox(BotDialogElementType.ATTACHMENT);
        this.filtres.addAll(Arrays.asList(allFilter, buttonFilter, textFilter, attachmentFilter, linkFilter));
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0);
        this.add((Component)allFilter, constraints);
        this.add((Component)textFilter, constraints);
        this.add((Component)buttonFilter, constraints);
        this.add((Component)linkFilter, constraints);
        this.add((Component)attachmentFilter, constraints);
    }

    public List<BotDialogElementType> getSelectedTypes() {
        return this.selectedFiltres.stream().map(FilterCheckBox::getFilterType).collect(Collectors.toList());
    }

    public void setSelectedType(List<BotDialogElementType> selectedTypes) {
        if (Utils.isEmptyCollection(selectedTypes)) {
            this.selectedFiltres.clear();
            this.filtres.forEach(f -> f.setSelected(false));
        } else {
            this.filtres.forEach(filter -> {
                if (selectedTypes.contains(filter.getFilterType())) {
                    filter.setSelected(true);
                    this.selectedFiltres.add((FilterCheckBox)filter);
                } else {
                    filter.setSelected(false);
                    this.selectedFiltres.remove(filter);
                }
            });
        }
    }

    protected void onFilterChange() {
        if (this.filterChangeListener != null) {
            this.filterChangeListener.onFilterChange();
        }
    }

    static interface FilterChangeListener {
        public void onFilterChange();
    }

    private final class FilterCheckBox
    extends JCheckBox {
        private BotDialogElementType filterType;

        private FilterCheckBox(BotDialogElementType filterType) {
            this.filterType = filterType;
            this.setText(filterType == null ? "\u0412\u0441\u0435" : filterType.getGuiTitle());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DialogElemenCheckBoxFilterPanel.this.filtres.forEach(f -> {
                        if (f.isSelected()) {
                            DialogElemenCheckBoxFilterPanel.this.selectedFiltres.add((FilterCheckBox)f);
                        } else {
                            DialogElemenCheckBoxFilterPanel.this.selectedFiltres.remove(f);
                        }
                    });
                    if (DialogElemenCheckBoxFilterPanel.this.filterChangeListener != null) {
                        DialogElemenCheckBoxFilterPanel.this.filterChangeListener.onFilterChange();
                    }
                }
            });
        }

        public BotDialogElementType getFilterType() {
            return this.filterType;
        }
    }
}

