/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.common.bean;

public enum SupportedFileFormat {
    DOCX(0, "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 MS Office Word 2007-2010"),
    XLSX(1, "\u0422\u0430\u0431\u043b\u0438\u0446\u0430 MS Office Excel 2007-2010"),
    ODT(2, "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 OpenOffice");

    private int extensionId;
    private String extensionTitle;

    private SupportedFileFormat(int id, String title) {
        this.extensionId = id;
        this.extensionTitle = title;
    }

    public int getExtensionId() {
        return this.extensionId;
    }

    public String getExtensionTitle() {
        return this.extensionTitle;
    }

    public static SupportedFileFormat getSupportedFormat(String extension) {
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        switch (extension) {
            case "docx": {
                return DOCX;
            }
            case "xlsx": {
                return XLSX;
            }
            case "odt": {
                return ODT;
            }
        }
        return DOCX;
    }
}

