/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.service;

import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.config.server.bean.ConfigDAO;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.bgbilling.modules.npay.server.Recalculator;
import ru.bitel.bgbilling.modules.npay.server.bean.NPayServiceStatusDao;
import ru.bitel.bgbilling.modules.npay.server.bean.RecalculatorParameters;
import ru.bitel.bgbilling.modules.npay.server.bean.object.ServiceObjectManager;
import ru.bitel.bgbilling.modules.npay.server.bean.sets.ServiceSetManager;
import ru.bitel.bgbilling.modules.npay.server.event.ContractNpayChangedEvent;
import ru.bitel.bgbilling.modules.npay.server.utils.NpayUtils;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.npay.common.service.NPayService")
public class NPayServiceImpl
extends AbstractService
implements NPayService {
    final int RECALCTYPE_NO = 0;
    final int RECALCTYPE_ALL_MONTHS = 1;
    final int RECALCTYPE_CURRENT_MONTH_ONLY = 2;

    public BigDecimal precalculateAccount(int contractId, int serviceSet, Date dateFrom, Date dateTo, int status) throws Exception {
        return NpayUtils.precalculateAccount(this.moduleId, serviceSet, contractId, dateFrom, dateTo, status);
    }

    public BigDecimal getAmountForUnlock(int contractId) throws Exception {
        return NpayUtils.getAmountForUnlock(this.getConnection(), this.moduleId, contractId);
    }

    public List<ServiceObject> serviceObjectList(int contractId, int objectId, int entityModuleId, int entityId, boolean actualItemsOnly, Date actualItemsDate) throws Exception {
        return new ServiceObjectManager(this.getConnection(), this.moduleId).getServiceObjectList(contractId, objectId, entityModuleId, entityId, actualItemsOnly && actualItemsDate != null ? actualItemsDate : null);
    }

    public ServiceObject serviceObjectGet(int id) throws Exception {
        return new ServiceObjectManager(this.getConnection(), this.moduleId).getServiceObject(id);
    }

    public void serviceObjectUpdate(int contractId, ServiceObject serviceObject) throws Exception {
        if (serviceObject == null || serviceObject.getContractId() != contractId) {
            throw new BGMessageException("serviceObject == null \u0438\u043b\u0438 \u043d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0437\u0430\u0434\u0430\u043d contractId");
        }
        TimeUtils.checkPeriod((Date)serviceObject.getDate1(), (Date)serviceObject.getDate2());
        Service service = null;
        for (Service service2 : ModuleCache.getInstance().getModuleServicesList(this.moduleId)) {
            if (service2.getId() != serviceObject.getServiceId()) continue;
            service = service2;
            break;
        }
        Period period = service.getActivePeriod();
        if (serviceObject.getDate1() == null || !TimeUtils.dateInPeriod((Date)serviceObject.getDate1(), (Period)period)) {
            throw new BGMessageException(String.format("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430\n[%s => %s]", TimeUtils.format((Date)serviceObject.getDate1(), (String)"dd.MM.yyyy"), period));
        }
        ServiceObjectManager serviceObjectManager = new ServiceObjectManager(this.getConnection(), this.moduleId);
        ServiceObject oldServiceObject = null;
        Date recalcFrom = serviceObject.getDate1();
        int typeOperation = 1;
        if (serviceObject.getId() > 0) {
            oldServiceObject = serviceObjectManager.getServiceObject(serviceObject.getId());
            typeOperation = 3;
            if (oldServiceObject.getDate1() == null) {
                oldServiceObject.setDate1(TimeUtils.convertLocalDateToDate((LocalDate)LocalDate.now().withDayOfMonth(1)));
            }
            recalcFrom = serviceObject.getDate1().before(oldServiceObject.getDate1()) ? serviceObject.getDate1() : oldServiceObject.getDate1();
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionServiceObjectUpdate", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            Date olddate1 = null;
            Date olddate2 = null;
            if (oldServiceObject != null) {
                olddate1 = oldServiceObject.getDate1();
                olddate2 = oldServiceObject.getDate2();
            }
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)olddate1, (Date)olddate2, (Date)serviceObject.getDate1(), (Date)serviceObject.getDate2());
        }
        serviceObject.setUserId(this.userId);
        serviceObjectManager.updateServiceObject(serviceObject);
        int recalcOnServiceChange = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).getInt("recalculate.on.service.change", 0);
        if (recalcOnServiceChange != 0 && recalcFrom != null) {
            this.recalculate(serviceObject.getContractId(), recalcFrom, recalcOnServiceChange, "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u043e\u0431\u044c\u0435\u043a\u0442\u0435");
        }
        EventProcessor.getInstance().publishAfterCommit((Event)new ContractNpayChangedEvent(this.moduleId, serviceObject.getContractId(), this.userId, typeOperation, serviceObject));
    }

    public void serviceObjectDelete(int contractId, int serviceId) throws Exception {
        ServiceObjectManager serviceObjectManager = new ServiceObjectManager(this.getConnection(), this.moduleId);
        ServiceObject serviceObject = serviceObjectManager.getServiceObject(serviceId);
        if (serviceObject == null || serviceObject.getContractId() != contractId) {
            throw new BGMessageException("\u0410\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0438\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 contractId");
        }
        Date recalcFrom = serviceObject.getDate1();
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionServiceObjectDelete", (int)this.moduleId, (int)this.userId);
        if (closedDate != null && serviceObject != null) {
            ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)serviceObject.getDate1());
        }
        serviceObjectManager.deleteServiceObject(serviceId, this.userId);
        int recalcOnServiceChange = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).getInt("recalculate.on.service.change", 0);
        if (recalcOnServiceChange != 0 && recalcFrom != null) {
            this.recalculate(serviceObject.getContractId(), recalcFrom, recalcOnServiceChange, "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u043e\u0431\u044c\u0435\u043a\u0442\u0435");
        }
        EventProcessor.getInstance().publish((Event)new ContractNpayChangedEvent(this.moduleId, serviceObject.getContractId(), this.userId, 2, serviceObject));
    }

    public List<ServiceObject> serviceObjectChangeLog(int contractId, int serviceObjectId) throws Exception {
        return new ServiceObjectManager(this.getConnection(), this.moduleId).getServiceObjectLogList(contractId, serviceObjectId);
    }

    public Boolean[][] serviceStatusMatrixGet(List<Integer> serviceIds, List<Integer> statusIds, boolean replaceDefaultToValue) throws Exception {
        return new NPayServiceStatusDao(this.getConnection(), this.moduleId).getServiceStatusValues(serviceIds, statusIds, replaceDefaultToValue);
    }

    public void serviceStatusMatrixUpdate(List<Integer> serviceIds, List<Integer> statusIds, Boolean[][] values) throws Exception {
        new NPayServiceStatusDao(this.getConnection(), this.moduleId).updateServiceStatusValues(serviceIds, statusIds, values);
    }

    public List<Integer> serviceSetGet(int serviceSetId) throws Exception {
        ServiceSetManager setManager = new ServiceSetManager(this.getConnection(), this.moduleId, (Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)));
        return setManager.getServiceSetMap().get(serviceSetId).getServiceIds();
    }

    private void recalculate(int contractId, Date recalcFrom, int recalcType, String taskComment) {
        Date closedDate;
        if (TimeUtils.monthsDelta((Date)recalcFrom, (Date)new Date()) < 0) {
            return;
        }
        if (recalcType == 2) {
            Calendar firstDayOfMonth = new GregorianCalendar();
            firstDayOfMonth.set(5, 1);
            firstDayOfMonth = TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)firstDayOfMonth);
            recalcFrom = firstDayOfMonth.getTime();
        }
        if ((closedDate = TimeUtils.convertCalendarToDate((Calendar)ClosedDateChecker.getInstance().getClosePeriodDate(1))) != null) {
            recalcFrom = TimeUtils.dateBeforeOrEq((Date)recalcFrom, (Date)closedDate) ? TimeUtils.getNextDay((Date)closedDate) : recalcFrom;
        }
        GregorianCalendar now = new GregorianCalendar();
        Calendar from = TimeUtils.convertDateToCalendar((Date)recalcFrom);
        RunTaskDataManager runTaskDataManager = new RunTaskDataManager(this.getConnection());
        Setup setup = Setup.getSetup();
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(this.moduleId));
        RecalculatorParameters parameters = RecalculatorParameters.builder().setEmail(setup.get("auto.recalculate.email", null)).setServiceSet(moduleSetup.getInt("auto.recalculate.email.service.set", 0)).setContractIds(Arrays.asList(contractId)).setComment(taskComment).setDetail(moduleSetup.getBoolean("npay.recalculate.detail", true)).build();
        do {
            runTaskDataManager.addTask((RunTask)new Recalculator(this.moduleId, from, parameters));
            from.add(2, 1);
        } while (TimeUtils.monthsDelta((Calendar)from, (Calendar)now) >= 0);
    }

    public List<IdTitle> serviceSetList() throws Exception {
        return new ServiceSetManager(this.getConnection(), this.moduleId, (Preferences)this.getModuleSetup()).getServiceSetList().stream().map(a -> new IdTitle(a.getId(), a.getTitle())).collect(Collectors.toList());
    }

    public List<KeyValue> configValueList() throws Exception {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        this.getModuleSetup().getMap().forEach((a, b) -> keyValues.add(new KeyValue(a, b)));
        return keyValues;
    }

    public void configValueUpdate(List<KeyValue> keyValues) throws Exception {
        if (keyValues != null) {
            ConfigDAO configDAO = new ConfigDAO(this.getConnection());
            ConfigData configData = configDAO.getActiveConfig(this.moduleId);
            if (configData == null) {
                if (configDAO.list(this.moduleId).isEmpty()) {
                    configData = new ConfigData();
                    configDAO.update((Object)configData);
                    configDAO.setActiveModuleConfig(this.moduleId, configData.getId());
                } else {
                    throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043c\u043e\u0434\u0443\u043b\u044f");
                }
            }
            String config = configData.getConfig();
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.addAll(Arrays.asList(config.split("\n")));
            for (KeyValue keyValue : keyValues) {
                boolean update = false;
                int len = lines.size();
                for (int index = 0; index < len; ++index) {
                    Object line = ((String)lines.get(index)).trim();
                    while (((String)line).startsWith(keyValue.getKey() + " ")) {
                        line = keyValue.getKey() + ((String)line).substring(keyValue.getKey().length());
                    }
                    if (!((String)line).startsWith(keyValue.getKey() + "=")) continue;
                    line = keyValue.getKey() + "=" + keyValue.getValue();
                    lines.set(index, line);
                    update = true;
                    break;
                }
                if (update) continue;
                lines.add(keyValue.getKey() + "=" + keyValue.getValue());
            }
            configData.setConfig(Utils.toString(lines, (String)"\n"));
            configDAO.update((Object)configData);
            EventProcessor.getInstance().publishAfterCommit((Event)new ModuleConfigModifiedEvent(this.moduleId, this.userId));
        }
    }

    public void accountClear(Period period, List<Integer> contractIds, List<Integer> contractLabelIds, int serviceSet) throws Exception {
        Connection con = this.getConnection();
        Calendar cal = period.getDateFrom() != null ? period.getDateFromCalendar() : new GregorianCalendar();
        cal.set(5, 1);
        period.setDateFrom(cal.getTime());
        cal = period.getDateFrom() != null ? period.getDateToCalendar() : new GregorianCalendar();
        cal.set(5, cal.getActualMaximum(5));
        period.setDateTo(cal.getTime());
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionClearAccount", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            try {
                ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)period.getDateFrom());
            }
            catch (BGMessageException ex) {
                throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043e\u0447\u0438\u0449\u0430\u0442\u044c \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435");
            }
        }
        List<Integer> serviceIds = new ServiceSetManager(con, this.moduleId, (Preferences)this.getModuleSetup()).getServiceSetMap().get(serviceSet).getServiceIds();
        String querySelect = "SELECT DISTINCT account.cid FROM contract_account AS account WHERE account.sid IN ( " + Utils.toString(serviceIds) + " ) AND account.yy=? AND account.mm=?";
        if (!contractIds.isEmpty()) {
            querySelect = querySelect + " AND account.cid IN (" + Utils.toString(contractIds) + ")";
        }
        if (!contractLabelIds.isEmpty()) {
            querySelect = querySelect + " AND account.cid IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString(contractLabelIds) + " ))";
        }
        try (PreparedStatement psSelect = con.prepareStatement(querySelect);
             BalanceDao balanceDao = new BalanceDao(con);
             BalanceUtils bu = new BalanceUtils(con);){
            cal = period.getDateFromCalendar();
            while (cal.getTime().before(period.getDateTo())) {
                int yy = cal.get(1);
                int mm = cal.get(2) + 1;
                HashSet<Integer> contracts = new HashSet<Integer>();
                psSelect.setInt(1, yy);
                psSelect.setInt(2, mm);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        contracts.add(rs.getInt(1));
                    }
                }
                String srvIds = Utils.toString(serviceIds);
                balanceDao.accountClear(yy, mm, contractIds, contractLabelIds, srvIds);
                balanceDao.accountDetailClear(yy, mm, contractIds, contractLabelIds, srvIds);
                for (Integer cid : contracts) {
                    bu.setBalanceFromAccount(cid.intValue(), cal);
                }
                cal.add(2, 1);
            }
        }
    }

    public void recalculatePay(Period period, List<Integer> contractIds, List<Integer> contractLabelIds, int serviceSet, boolean detail, String comment, String email) throws Exception {
        Calendar cal = null;
        cal = period.getDateFrom() != null ? period.getDateFromCalendar() : new GregorianCalendar();
        cal.set(5, 1);
        period.setDateFrom(cal.getTime());
        cal = period.getDateFrom() != null ? period.getDateToCalendar() : new GregorianCalendar();
        cal.set(5, cal.getActualMaximum(5));
        period.setDateTo(cal.getTime());
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionRecalculatePay", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            try {
                ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)period.getDateFrom());
            }
            catch (BGMessageException ex) {
                throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435");
            }
        }
        if (TimeUtils.monthsDelta((Calendar)new GregorianCalendar(), (Calendar)period.getDateToCalendar()) > 0) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0443 \u0437\u0430 \u0431\u0443\u0434\u0443\u0449\u0438\u0435 \u043c\u0435\u0441\u044f\u0446\u044b!");
        }
        RecalculatorParameters parameters = RecalculatorParameters.builder().setEmail(email).setServiceSet(serviceSet).setContractIds(contractIds).setContractLabelIds(contractLabelIds).setComment(comment).setDetail(detail).build();
        cal = period.getDateFromCalendar();
        while (cal.getTime().before(period.getDateTo())) {
            new RunTaskDataManager(this.getConnection()).addTask((RunTask)new Recalculator(this.moduleId, cal, parameters));
            cal.add(2, 1);
        }
    }
}

