/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocType;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;
import ru.bitel.common.Utils;

public class ContractDocTypeManager
extends AbstarctDaoConstant {
    private final String TABLE_BILL_DOC_TYPE;

    public ContractDocTypeManager(Connection con, int moduleId) {
        super(con, "bill_contract_doc_type", moduleId);
        this.TABLE_BILL_DOC_TYPE = "bill_doc_type_" + moduleId;
    }

    public ContractDocType getContractDocType(int id) throws SQLException {
        ContractDocType result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getDocTypeFromRs(rs);
                }
            }
        }
        return result;
    }

    public List<ContractDocType> getContractTypeList(int contractId, DocumentType documentType, String docTypes) throws SQLException {
        ArrayList<ContractDocType> result = new ArrayList<ContractDocType>();
        String query = "SELECT * FROM " + this.tableName + " AS contract_type INNER JOIN " + this.TABLE_BILL_DOC_TYPE + " AS doc_type ON contract_type.doc_type=doc_type.id WHERE contract_type.cid=? AND doc_type.type=?";
        if (Utils.notBlankString((String)docTypes)) {
            query = query + " AND contract_type.doc_type IN ( " + docTypes + ")";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, documentType.getCode());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getDocTypeFromRs(rs));
                }
            }
        }
        return result;
    }

    public List<DocType> getContractDocTypeList(int contractId, DocumentType documentType) {
        ArrayList<DocType> result = new ArrayList<DocType>();
        String query = "SELECT doc_type.* FROM " + this.tableName + " AS contract_type INNER JOIN " + this.TABLE_BILL_DOC_TYPE + " AS doc_type ON contract_type.doc_type=doc_type.id WHERE contract_type.cid=? AND doc_type.type=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, documentType.getCode());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(DocTypeManager.getTypeFromRs(rs));
                }
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void addContractType(ContractDocType contractType) {
        try {
            String query = "INSERT INTO " + this.tableName + "( doc_type, cid ) VALUES (?, ?)";
            PreparedStatement insertContractDocType = this.con.prepareStatement(query);
            insertContractDocType.setInt(1, contractType.getDocTypeId());
            insertContractDocType.setInt(2, contractType.getContractId());
            insertContractDocType.executeUpdate();
            insertContractDocType.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean checkDocTypeExist(ContractDocType contractType) {
        try {
            String query = "SELECT id FROM " + this.tableName + " WHERE cid=? AND doc_type=?";
            PreparedStatement getContractDocTypePS = this.con.prepareStatement(query);
            getContractDocTypePS.setInt(1, contractType.getContractId());
            getContractDocTypePS.setInt(2, contractType.getDocTypeId());
            ResultSet rs = getContractDocTypePS.executeQuery();
            boolean result = rs.next();
            getContractDocTypePS.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void deleteContractType(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public void deleteContractType(int contractId, int docType) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE cid=? AND doc_type=? ";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, docType);
            ps.executeUpdate();
        }
    }

    private ContractDocType getDocTypeFromRs(ResultSet rs) throws SQLException {
        return new ContractDocType().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setDocTypeId(rs.getInt("doc_type"));
    }
}

