/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentPosition;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.common.Utils;
import ru.bitel.common.model.ContractIdable;

public class PositionValue
implements ContractIdable {
    private int positionId;
    private int contractId;
    private String name;
    private BigDecimal cost = BigDecimal.ZERO;
    private BigDecimal sum;
    private BigDecimal nds = BigDecimal.ZERO;
    private BigDecimal sumUnscaled;
    private BigDecimal sumScaled;
    private BigDecimal quantity;
    private int qtyNumsAfterComma = 0;
    private int qtyNumsRoundingMode = 4;
    private String unit;
    private String unitCode;
    private List<PositionValue> extractPositions;
    private Position position;
    private boolean inSumm;
    private boolean awlz;
    private Map<String, String> params = new HashMap<String, String>();

    @Deprecated
    public int getCid() {
        return this.getContractId();
    }

    public int getContractId() {
        return this.contractId;
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public List<PositionValue> getExtractPositions() {
        return this.extractPositions;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getNds() {
        return this.nds;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Position getPosition() {
        return this.position;
    }

    public int getPositionId() {
        return this.positionId;
    }

    public int getQtyNumsAfterComma() {
        return this.qtyNumsAfterComma;
    }

    public int getQtyNumsRoundingMode() {
        return this.qtyNumsRoundingMode;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public BigDecimal getSumScaled() {
        return this.sumScaled;
    }

    public BigDecimal getSumUnscaled() {
        return this.sumUnscaled;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public boolean isAddWhenLessZero() {
        return this.awlz;
    }

    public boolean isInSumm() {
        return this.inSumm;
    }

    public PositionValue setAddWhenLessZero(boolean awlz) {
        this.awlz = awlz;
        return this;
    }

    public PositionValue setContractId(int contractId) {
        this.contractId = contractId;
        return this;
    }

    public PositionValue setCost(BigDecimal cost) {
        this.cost = cost;
        return this;
    }

    public PositionValue setExtractPositions(List<PositionValue> extractPositions) {
        this.extractPositions = extractPositions;
        return this;
    }

    public PositionValue setInSumm(boolean inSumm) {
        this.inSumm = inSumm;
        return this;
    }

    public PositionValue setName(String name) {
        this.name = name;
        return this;
    }

    public PositionValue setNds(BigDecimal nds) {
        this.nds = nds;
        return this;
    }

    public PositionValue setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public PositionValue setPosition(Position position) {
        this.position = position;
        if (position != null) {
            this.params = position.getParams();
        }
        return this;
    }

    public PositionValue setPositionId(int positionId) {
        this.positionId = positionId;
        return this;
    }

    public PositionValue setQtyNumsAfterComma(int qtyNumsAfterComma) {
        this.qtyNumsAfterComma = qtyNumsAfterComma;
        return this;
    }

    public PositionValue setQtyNumsRoundingMode(int qtyNumsRoundingMode) {
        this.qtyNumsRoundingMode = qtyNumsRoundingMode;
        return this;
    }

    public PositionValue setQuantity(BigDecimal val) {
        this.quantity = val;
        return this;
    }

    public PositionValue setSum(BigDecimal sum) {
        this.sum = sum.setScale(2, RoundingMode.HALF_UP);
        return this;
    }

    public PositionValue setSumScaled(BigDecimal sumRounded) {
        this.sumScaled = sumRounded;
        return this;
    }

    public PositionValue setSumUnscaled(BigDecimal sumUnscaled) {
        this.sumUnscaled = sumUnscaled;
        return this;
    }

    public PositionValue setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public PositionValue setUnitCode(String unitCode) {
        this.unitCode = unitCode;
        return this;
    }

    public DocumentPosition toDocumentPosition() {
        return new DocumentPosition().setAmount(this.sum).setAmountScaled(this.sumScaled).setAmountUnscaled(this.sumUnscaled).setAwlz(this.awlz).setContractId(this.contractId).setCount(this.quantity).setCountNumsAfterComma(this.qtyNumsAfterComma).setCountNumsRoundingMode(this.qtyNumsRoundingMode).setExtractPositions(this.extractPositions == null ? null : this.extractPositions.stream().map(a -> a.toDocumentPosition()).collect(Collectors.toList())).setInTotal(this.inSumm).setName(this.name).setParams(this.params).setPositionId(this.positionId).setPositionSpec(this.position == null ? null : this.position.toDocumentPositionSpec()).setUnit(this.unit).setUnitCode(this.unitCode);
    }

    public void toElement(Element el) {
        el.setAttribute("position_id", String.valueOf(this.positionId));
        el.setAttribute("name", this.name);
        el.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)this.sum));
        el.setAttribute("nds", String.valueOf(this.nds));
        el.setAttribute("sumUnscaled", Utils.formatBigDecimal((BigDecimal)(this.sumUnscaled != null ? this.sumUnscaled : this.sum), (int)5));
        el.setAttribute("unit", this.unit);
        el.setAttribute("unitCode", this.unitCode);
        el.setAttribute("quantity", Utils.maskNull((BigDecimal)this.quantity).setScale(this.qtyNumsAfterComma, this.qtyNumsRoundingMode).toString());
        el.setAttribute("qtynums", String.valueOf(this.qtyNumsAfterComma));
        el.setAttribute("qtynumsRnd", String.valueOf(this.qtyNumsRoundingMode));
        el.setAttribute("insum", this.inSumm ? "1" : "0");
        el.setAttribute("awlz", this.awlz ? "1" : "0");
        if (this.params != null) {
            for (String name : this.params.keySet()) {
                el.setAttribute(name, this.params.get(name));
            }
        }
    }

    public void toElement(XMLStreamWriter el) throws XMLStreamException {
        el.writeAttribute("position_id", String.valueOf(this.positionId));
        el.writeAttribute("name", this.name != null ? this.name : "");
        el.writeAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)this.sum));
        el.writeAttribute("nds", String.valueOf(this.nds));
        if (this.sumUnscaled != null) {
            el.writeAttribute("sumUnscaled", Utils.formatBigDecimal((BigDecimal)this.sumUnscaled, (int)5));
        } else {
            el.writeAttribute("sumUnscaled", Utils.formatBigDecimal((BigDecimal)this.sum, (int)5));
        }
        el.writeAttribute("unit", this.unit != null ? this.unit : "");
        el.writeAttribute("unitCode", this.unitCode != null ? this.unitCode : "");
        el.writeAttribute("quantity", Utils.maskNull((BigDecimal)this.quantity).setScale(this.qtyNumsAfterComma, this.qtyNumsRoundingMode).toString());
        el.writeAttribute("qtynums", String.valueOf(this.qtyNumsAfterComma));
        el.writeAttribute("qtynumsRnd", String.valueOf(this.qtyNumsRoundingMode));
        el.writeAttribute("insum", this.inSumm ? "1" : "0");
        el.writeAttribute("awlz", this.awlz ? "1" : "0");
        for (String name : this.params.keySet()) {
            String value = this.params.get(name);
            el.writeAttribute(name, value);
        }
    }
}

