/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServStatus;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.AbstractTreeNode;
import ru.bitel.common.model.Contractable;
import ru.bitel.common.model.TreeNode;

public final class InetServ
extends AbstractTreeNode<InetServ>
implements Cloneable,
TreeNode<InetServ>,
Contractable {
    private static final String PARAM_FRAMED_IP_ADDRESS = "framed_ip_address";
    private static final String PARAM_FRAMED_IPV6_ADDRESS = "framed_ipv6_address";
    private static final String PARAM_FRAMED_IPV6_ADDRESS_RESOURCE_ID = "framed_ipv6_address_resource_id";
    private static final String PARAM_FRAMED_IPV6_PREFIX = "framed_ipv6_prefix";
    private static final String PARAM_FRAMED_IPV6_PREFIX_LENGTH = "framed_ipv6_prefix_length";
    private static final String PARAM_FRAMED_IPV6_PREFIX_RESOURCE_ID = "framed_ipv6_prefix_resource_id";
    private static final String PARAM_FRAMED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID = "framed_ipv6_prefix_resource_subscription_id";
    private static final String PARAM_DELEGATED_IPV6_PREFIX = "delegated_ipv6_prefix";
    private static final String PARAM_DELEGATED_IPV6_PREFIX_LENGTH = "delegated_ipv6_prefix_length";
    private static final String PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_ID = "delegated_ipv6_prefix_resource_id";
    private static final String PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID = "delegated_ipv6_prefix_resource_subscription_id";
    private int contractId;
    private String contractTitle;
    private String contractComment;
    private int superContractId;
    private int typeId;
    private String typeTitle;
    private String login;
    private String password;
    private int deviceId;
    private String deviceTitle;
    private int interfaceId = -1;
    private String interfaceTitle;
    private int vlan = -1;
    private List<String> identifierList;
    private List<byte[]> macAddressList;
    private int ipResourceId;
    private int ipResourceSubscriptionId;
    private byte[] addressFrom;
    private byte[] addressTo;
    private Date dateFrom;
    private Date dateTo;
    private String data = "{}";
    private InetServStatus status = InetServStatus.STATUS_ON;
    private int sessionCountLimit;
    private String comment;
    private volatile short deviceState;
    private volatile Set<Integer> deviceOptions;
    private String accessCodeTitle;
    private int accessCode;
    private String config;
    private int contractObjectId;

    public InetServ clone() {
        try {
            return (InetServ)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    @XmlAttribute
    public int getAccessCode() {
        return this.accessCode;
    }

    public String getAccessCodeTitle() {
        return this.accessCodeTitle;
    }

    @XmlAttribute(name="addrFrom")
    public byte[] getAddressFrom() {
        return this.addressFrom;
    }

    @XmlAttribute(name="addrTo")
    public byte[] getAddressTo() {
        return this.addressTo;
    }

    public String getComment() {
        return this.comment;
    }

    public String getConfig() {
        return this.config;
    }

    @XmlAttribute
    public String getContractComment() {
        return this.contractComment;
    }

    @XmlAttribute(name="cid")
    public int getContractId() {
        return this.contractId;
    }

    @XmlAttribute(name="coid")
    public int getContractObjectId() {
        return this.contractObjectId;
    }

    @XmlAttribute
    public String getContractTitle() {
        return this.contractTitle;
    }

    @XmlElement(name="data")
    public String getData() {
        return this.data;
    }

    private String getDataParamValue(String paramName) {
        String value = null;
        if (this.data != null && !this.data.isEmpty()) {
            value = new JSONObject(this.data).optString(paramName);
        }
        return value;
    }

    @XmlAttribute
    public Date getDateFrom() {
        return this.dateFrom;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.dateTo;
    }

    @XmlAttribute(name="DelegatedIPv6Prefix")
    public byte[] getDelegatedIPv6Prefix() {
        return Utils.hexStringToBytes((String)this.getDataParamValue(PARAM_DELEGATED_IPV6_PREFIX));
    }

    @XmlAttribute(name="DelegatedIPv6PrefixLength")
    public short getDelegatedIPv6PrefixLength() {
        return (short)Utils.parseInt((String)this.getDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_LENGTH));
    }

    @XmlAttribute(name="DelegatedIPv6PrefixResourceId")
    public int getDelegatedIPv6PrefixResourceId() {
        return Utils.parseInt((String)this.getDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_ID));
    }

    @XmlAttribute(name="DelegatedIPv6PrefixResourceSubscriptionId")
    public int getDelegatedIPv6PrefixResourceSubscriptionId() {
        return Utils.parseInt((String)this.getDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID));
    }

    @XmlAttribute(name="did")
    public int getDeviceId() {
        return this.deviceId;
    }

    @XmlAttribute(name="devOpts")
    public Set<Integer> getDeviceOptions() {
        return this.deviceOptions;
    }

    @XmlAttribute(name="devState")
    public short getDeviceState() {
        return this.deviceState;
    }

    @XmlAttribute
    public String getDeviceTitle() {
        return this.deviceTitle;
    }

    @XmlAttribute(name="FramedIPAddress")
    public byte[] getFramedIPAddress() {
        return Utils.hexStringToBytes((String)this.getDataParamValue(PARAM_FRAMED_IP_ADDRESS));
    }

    @XmlAttribute(name="FramedIPv6Address")
    public byte[] getFramedIPv6Address() {
        return Utils.hexStringToBytes((String)this.getDataParamValue(PARAM_FRAMED_IPV6_ADDRESS));
    }

    @XmlAttribute(name="FramedIPv6AddressResourceId")
    public int getFramedIPv6AddressResourceId() {
        return Utils.parseInt((String)this.getDataParamValue(PARAM_FRAMED_IPV6_ADDRESS_RESOURCE_ID));
    }

    @XmlAttribute(name="FramedIPv6Prefix")
    public byte[] getFramedIPv6Prefix() {
        return Utils.hexStringToBytes((String)this.getDataParamValue(PARAM_FRAMED_IPV6_PREFIX));
    }

    @XmlAttribute(name="FramedIPv6PrefixLength")
    public short getFramedIPv6PrefixLength() {
        return (short)Utils.parseInt((String)this.getDataParamValue(PARAM_FRAMED_IPV6_PREFIX_LENGTH));
    }

    @XmlAttribute(name="FramedIPv6PrefixResourceId")
    public int getFramedIPv6PrefixResourceId() {
        return Utils.parseInt((String)this.getDataParamValue(PARAM_FRAMED_IPV6_PREFIX_RESOURCE_ID));
    }

    @XmlAttribute(name="FramedIPv6PrefixResourceSubscriptionId")
    public int getFramedIPv6PrefixResourceSubscriptionId() {
        return Utils.parseInt((String)this.getDataParamValue(PARAM_FRAMED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID));
    }

    @XmlElementWrapper(name="identifierList")
    @XmlElements(value={@XmlElement(name="identifier")})
    public List<String> getIdentifierList() {
        return this.identifierList;
    }

    @XmlAttribute(name="ifaceId")
    public int getInterfaceId() {
        return this.interfaceId;
    }

    @XmlAttribute
    public String getInterfaceTitle() {
        return this.interfaceTitle;
    }

    @XmlAttribute(name="ipResId")
    public int getIpResourceId() {
        return this.ipResourceId;
    }

    @XmlAttribute(name="ipResSubsriptionId")
    public int getIpResourceSubscriptionId() {
        return this.ipResourceSubscriptionId;
    }

    @XmlAttribute(name="uname")
    public String getLogin() {
        return this.login;
    }

    @XmlElementWrapper(name="macList")
    @XmlElements(value={@XmlElement(name="mac")})
    public List<byte[]> getMacAddressList() {
        return this.macAddressList;
    }

    @XmlTransient
    public byte[] getMacAddressListBytes() {
        if (this.macAddressList == null) {
            return null;
        }
        int size = this.macAddressList.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return this.macAddressList.get(0);
            }
        }
        int length = this.macAddressList.get(0).length;
        byte[] result = new byte[length * size];
        for (int i = 0; i < size; ++i) {
            byte[] mac = this.macAddressList.get(i);
            System.arraycopy(mac, 0, result, i * length, length);
        }
        return result;
    }

    @XmlAttribute(name="passw")
    public String getPassword() {
        return this.password;
    }

    @XmlAttribute(name="sessCntLimit")
    public int getSessionCountLimit() {
        return this.sessionCountLimit;
    }

    @XmlAttribute
    public InetServStatus getStatus() {
        return this.status;
    }

    @XmlAttribute(name="scid")
    @Deprecated
    public int getSuperContractId() {
        return this.superContractId;
    }

    @XmlAttribute(name="typeId")
    public int getTypeId() {
        return this.typeId;
    }

    @XmlAttribute
    public String getTypeTitle() {
        return this.typeTitle;
    }

    @XmlAttribute
    public int getVlan() {
        return this.vlan;
    }

    public InetServ setAccessCode(int accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    public InetServ setAccessCodeTitle(String deviceStateTitle) {
        this.accessCodeTitle = deviceStateTitle;
        return this;
    }

    public InetServ setAddressFrom(byte[] addressFrom) {
        this.addressFrom = addressFrom;
        return this;
    }

    public InetServ setAddressTo(byte[] addressTo) {
        this.addressTo = addressTo;
        return this;
    }

    public InetServ setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public InetServ setConfig(String config) {
        this.config = config;
        return this;
    }

    public InetServ setContractComment(String contractComment) {
        this.contractComment = contractComment;
        return this;
    }

    public InetServ setContractId(int contractId) {
        this.contractId = contractId;
        return this;
    }

    public InetServ setContractObjectId(int contractObjectId) {
        this.contractObjectId = contractObjectId;
        return this;
    }

    public InetServ setContractTitle(String contractTitle) {
        this.contractTitle = contractTitle;
        return this;
    }

    public InetServ setData(String data) {
        this.data = data;
        return this;
    }

    private InetServ setDataParamValue(String paramName, String value) {
        JSONObject json = new JSONObject(this.data == null || this.data.isEmpty() ? "{}" : this.data);
        json.put(paramName, (Object)value);
        this.data = json.toString();
        return this;
    }

    public InetServ setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public InetServ setDateTo(Date dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public InetServ setDelegatedIPv6Prefix(byte[] prefix) {
        this.setDataParamValue(PARAM_DELEGATED_IPV6_PREFIX, Utils.bytesToHexString((byte[])prefix));
        return this;
    }

    public InetServ setDelegatedIPv6PrefixLength(short length) {
        this.setDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_LENGTH, String.valueOf(length));
        return this;
    }

    public InetServ setDelegatedIPv6PrefixResourceId(int resourceId) {
        this.setDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_ID, String.valueOf(resourceId));
        return this;
    }

    public InetServ setDelegatedIPv6PrefixResourceSubscriptionId(int subscriptionId) {
        this.setDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID, String.valueOf(subscriptionId));
        return this;
    }

    public InetServ setDeviceId(int inetDeviceId) {
        this.deviceId = inetDeviceId;
        return this;
    }

    public InetServ setDeviceOptions(Set<Integer> currentInetOptionSet) {
        this.deviceOptions = currentInetOptionSet;
        return this;
    }

    public InetServ setDeviceState(short currentState) {
        this.deviceState = currentState;
        return this;
    }

    public InetServ setDeviceTitle(String deviceTitle) {
        this.deviceTitle = deviceTitle;
        return this;
    }

    public InetServ setFramedIPAddress(byte[] address) {
        this.setDataParamValue(PARAM_FRAMED_IP_ADDRESS, Utils.bytesToHexString((byte[])address));
        return this;
    }

    public InetServ setFramedIPv6Address(byte[] address) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_ADDRESS, Utils.bytesToHexString((byte[])address));
        return this;
    }

    public InetServ setFramedIPv6AddressResourceId(int resourceId) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_ADDRESS_RESOURCE_ID, String.valueOf(resourceId));
        return this;
    }

    public InetServ setFramedIPv6Prefix(byte[] prefix) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_PREFIX, Utils.bytesToHexString((byte[])prefix));
        return this;
    }

    public InetServ setFramedIPv6PrefixLength(short length) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_PREFIX_LENGTH, String.valueOf(length));
        return this;
    }

    public InetServ setFramedIPv6PrefixResourceId(int resourceId) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_PREFIX_RESOURCE_ID, String.valueOf(resourceId));
        return this;
    }

    public InetServ setFramedIPv6PrefixResourceSubscriptionId(int subscriptionId) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID, String.valueOf(subscriptionId));
        return this;
    }

    public InetServ setIdentifierList(List<String> identifierList) {
        this.identifierList = identifierList;
        return this;
    }

    public InetServ setInterfaceId(int portId) {
        this.interfaceId = portId;
        return this;
    }

    public InetServ setInterfaceTitle(String interfaceTitle) {
        this.interfaceTitle = interfaceTitle;
        return this;
    }

    public InetServ setIpResourceId(int ipResourceId) {
        this.ipResourceId = ipResourceId;
        return this;
    }

    public InetServ setIpResourceSubscriptionId(int ipResourceSubscriptionId) {
        this.ipResourceSubscriptionId = ipResourceSubscriptionId;
        return this;
    }

    public InetServ setLogin(String login) {
        this.login = login;
        return this;
    }

    public InetServ setMacAddressList(List<byte[]> macAddress) {
        this.macAddressList = macAddress;
        return this;
    }

    public InetServ setMacAddressListBytes(byte[] macAddressListBytes) {
        if (macAddressListBytes == null) {
            this.setMacAddressList(Collections.emptyList());
            return this;
        }
        if (macAddressListBytes.length <= 8) {
            this.setMacAddressList(Collections.singletonList(macAddressListBytes));
            return this;
        }
        if (macAddressListBytes.length % 6 == 0) {
            int size = macAddressListBytes.length / 6;
            ArrayList<byte[]> macAddressList = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                byte[] mac = new byte[6];
                System.arraycopy(macAddressListBytes, i * 6, mac, 0, 6);
                macAddressList.add(mac);
            }
            this.setMacAddressList(macAddressList);
            return this;
        }
        if (macAddressListBytes.length % 8 == 0) {
            int size = macAddressListBytes.length / 8;
            ArrayList<byte[]> macAddressList = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                byte[] mac = new byte[8];
                System.arraycopy(macAddressListBytes, i * 8, mac, 0, 8);
                macAddressList.add(mac);
            }
            this.setMacAddressList(macAddressList);
            return this;
        }
        this.setMacAddressList(Collections.singletonList(macAddressListBytes));
        return this;
    }

    public InetServ setPassword(String password) {
        this.password = password;
        return this;
    }

    public InetServ setSessionCountLimit(int sessions) {
        this.sessionCountLimit = sessions;
        return this;
    }

    public InetServ setStatus(InetServStatus status) {
        this.status = status;
        return this;
    }

    @Deprecated
    public InetServ setSuperContractId(int superContractId) {
        this.superContractId = superContractId;
        return this;
    }

    public InetServ setTypeId(int inetServId) {
        this.typeId = inetServId;
        return this;
    }

    public InetServ setTypeTitle(String servTypeTitle) {
        this.typeTitle = servTypeTitle;
        return this;
    }

    public InetServ setVlan(int vlanId) {
        this.vlan = vlanId;
        return this;
    }

    public String toString() {
        return this.title;
    }

    public static String toString(InetServ val) {
        StringBuilder data = new StringBuilder();
        if (Utils.notBlankString((String)val.getLogin())) {
            data.append("\u041b\u043e\u0433\u0438\u043d: ").append(val.getLogin());
        }
        if (Utils.notBlankString((String)val.getInterfaceTitle())) {
            if (data.length() > 0) {
                data.append("; ");
            }
            data.append("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441: ").append(val.getInterfaceTitle());
        }
        if (val.getAddressFrom() != null || val.getAddressTo() != null) {
            if (data.length() > 0) {
                data.append("; ");
            }
            data.append("\u0410\u0434\u0440\u0435\u0441(\u0430): ");
            IpAddress from = new IpAddress(val.getAddressFrom());
            IpAddress to = new IpAddress(val.getAddressTo());
            if (val.getAddressTo() == null) {
                data.append(from.toString());
            } else {
                data.append(from.toString()).append("-").append(to.toString());
            }
        }
        return data.toString();
    }
}

