/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Date;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.Id;

public class IpResource
extends Id
implements GuiTitlable {
    private int categoryId;
    private byte[] addressFrom;
    private byte[] addressTo;
    private short prefixLength;
    private Date dateFrom;
    private Date dateTo;
    private String router;
    private String subnetMask;
    private String dns;
    private boolean reserveStart = false;
    private boolean reserveEnd = false;
    private String config;
    private String comment;

    @XmlAttribute
    public byte[] getAddressFrom() {
        return this.addressFrom;
    }

    @XmlAttribute
    public byte[] getAddressTo() {
        return this.addressTo;
    }

    @XmlAttribute
    public int getCategoryId() {
        return this.categoryId;
    }

    @XmlElement
    public String getComment() {
        return this.comment;
    }

    public String getConfig() {
        return this.config;
    }

    @XmlAttribute
    public Date getDateFrom() {
        return this.dateFrom;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.dateTo;
    }

    @XmlAttribute
    public String getDns() {
        return this.dns;
    }

    @Override
    @XmlTransient
    public String getGuiTitle() {
        return this.toString();
    }

    @XmlAttribute
    public short getPrefixLength() {
        return this.prefixLength;
    }

    @XmlAttribute
    public String getRouter() {
        return this.router;
    }

    @XmlAttribute
    public String getSubnetMask() {
        return this.subnetMask;
    }

    @XmlAttribute
    public boolean isReserveEnd() {
        return this.reserveEnd;
    }

    @XmlAttribute
    public boolean isReserveStart() {
        return this.reserveStart;
    }

    public IpResource setAddressFrom(byte[] addressFrom) {
        this.addressFrom = addressFrom;
        return this;
    }

    public IpResource setAddressTo(byte[] addressTo) {
        this.addressTo = addressTo;
        return this;
    }

    public IpResource setCategoryId(int categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    public IpResource setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public IpResource setConfig(String config) {
        this.config = config;
        return this;
    }

    public IpResource setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public IpResource setDateTo(Date dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public IpResource setDns(String dns) {
        this.dns = dns;
        return this;
    }

    public IpResource setPrefixLength(short prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public IpResource setReserveEnd(boolean reserveEnd) {
        this.reserveEnd = reserveEnd;
        return this;
    }

    public IpResource setReserveStart(boolean reserveStart) {
        this.reserveStart = reserveStart;
        return this;
    }

    @Override
    public IpResource setId(int id) {
        super.setId(id);
        return this;
    }

    public IpResource setRouter(String router) {
        this.router = router;
        return this;
    }

    public IpResource setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
        return this;
    }

    @Override
    public String toString() {
        if (this.addressFrom.length == 16) {
            return IpNet.toRFCString(this.addressFrom, this.addressTo) + " (" + this.id + ")";
        }
        return IpAddress.toString(this.addressFrom) + "-" + IpAddress.toString(this.addressTo) + " (" + this.id + ")";
    }
}

