/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.period.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.period.common.bean.ContractPeriod;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class ContractPeriodDao
extends AbstractIdDao<ContractPeriod> {
    public ContractPeriodDao(Connection con) {
        super(con, "contract_period");
    }

    public void searchContractPeriod(SearchResult<ContractPeriod> searchResult, int contractId) throws SQLException {
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        if (page == null) {
            page = new Page(1, -1);
        }
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE true";
        if (contractId > 0) {
            query = query + " AND contract_id=?";
        }
        query = query + Page.toSqlLimit((Page)page);
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int parameterIndex = 1;
            if (contractId > 0) {
                ps.setInt(parameterIndex++, contractId);
            }
            try (ResultSet resultSet = ps.executeQuery();){
                while (resultSet.next()) {
                    list.add(this.getFromRS(resultSet));
                }
            }
        }
        Page.setRecordCount((Page)page, (int)ServerUtils.foundRows(this.con));
    }

    public boolean setSentCloseEventFlag(int id) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET generate_event=2 WHERE  id=? AND generate_event=1";
        try (PreparedStatement psUpdateSet = this.con.prepareStatement(query, 1);){
            psUpdateSet.setInt(1, id);
            boolean bl = psUpdateSet.executeUpdate() > 0;
            return bl;
        }
    }

    protected ContractPeriod getFromRS(ResultSet rs) throws SQLException {
        int generateEvent = rs.getInt("generate_event");
        return new ContractPeriod(rs.getInt("id")).setContractId(rs.getInt("contract_id")).setUserId(rs.getInt("user_id")).setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to"))).setLastUpdate(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("lm"))).setGenerateCloseEvent(generateEvent > 0).setSentCloseEvent(generateEvent > 1).setJobId(rs.getLong("job_id"));
    }

    protected void updateImpl(ContractPeriod contractPeriod) throws SQLException {
        Objects.requireNonNull(contractPeriod);
        boolean update = contractPeriod.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET contract_id =?, date_from=?, date_to=?, generate_event=?, user_id=?, job_id=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, contractPeriod.getContractId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractPeriod.getPeriod().getDateFrom()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractPeriod.getPeriod().getDateTo()));
            ps.setInt(index++, contractPeriod.isGenerateCloseEvent() ? (contractPeriod.isSentCloseEvent() ? 2 : 1) : 0);
            ps.setInt(index++, contractPeriod.getUserId());
            ps.setLong(index++, contractPeriod.getJobId());
            this.executeUpdate(contractPeriod, index, ps);
        }
    }

    public List<ContractPeriod> getContractPeriodList(long period) throws SQLException {
        ArrayList<ContractPeriod> list = new ArrayList<ContractPeriod>();
        String query = "SELECT * FROM " + this.tableName + " WHERE date_to < ? AND generate_event=1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            LocalDateTime date = LocalDateTime.now().plusSeconds(period);
            ps.setTimestamp(1, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)date));
            try (ResultSet resultSet = ps.executeQuery();){
                while (resultSet.next()) {
                    list.add(this.getFromRS(resultSet));
                }
            }
        }
        return list;
    }

    public void deleteForContract(int contractId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE contract_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }
}

