/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.convert;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

@Deprecated
public class ConvertUtil
implements AutoCloseable {
    private DefaultServerSetup setup;
    private Connection con;
    private ContractDao contractDao;

    public ConvertUtil(DefaultServerSetup setup, Connection con) throws BGException {
        this.setup = setup;
        this.con = con;
        this.contractDao = new ContractDao(con, 0);
    }

    @Override
    public void close() throws BGException {
        this.contractDao.close();
    }

    public void removeCerberCryptGarbage(int mid_cc) throws SQLException, BGException {
        String query = "SELECT uc.id, contract.id FROM user_card_" + mid_cc + " AS uc LEFT JOIN contract ON uc.cid = contract.id WHERE contract.id IS NULL";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        ArrayList<Integer> ucids = new ArrayList<Integer>();
        while (rs.next()) {
            ucids.add(rs.getInt(1));
        }
        rs.close();
        ps.close();
        query = "SELECT cp.id, contract.id FROM card_packet_" + mid_cc + " AS cp LEFT JOIN contract ON cp.cid = contract.id WHERE contract.id IS NULL";
        ps = this.con.prepareStatement(query);
        rs = ps.executeQuery();
        ArrayList<Integer> cpids = new ArrayList<Integer>();
        while (rs.next()) {
            cpids.add(rs.getInt(1));
        }
        rs.close();
        ps.close();
        if (ucids.size() > 0) {
            System.out.println("remove " + ucids.size() + " garbage user_card_" + mid_cc + "...");
            query = "DELETE FROM user_card_" + mid_cc + " WHERE id IN (" + Utils.toString(ucids) + ")";
            ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
        if (cpids.size() > 0) {
            System.out.println("remove " + cpids.size() + " garbage card_packet_" + mid_cc + "...");
            query = "DELETE FROM card_packet_" + mid_cc + " WHERE id IN (" + Utils.toString(cpids) + ")";
            ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
    }

    public Map<Integer, Map<String, Map<String, Object>>> getBillingStreetMap() throws SQLException {
        HashMap<Integer, Map<String, Map<String, Object>>> result = new HashMap<Integer, Map<String, Map<String, Object>>>();
        String query = "SELECT id, title, cityid FROM address_street";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            HashMap<String, Object> map;
            int cityId = rs.getInt("cityid");
            String title = rs.getString("title");
            int streetId = rs.getInt("id");
            HashMap streets = (HashMap)result.get(cityId);
            if (streets == null) {
                streets = new HashMap();
                result.put(cityId, streets);
            }
            if ((map = (HashMap<String, Object>)streets.get(title.toLowerCase())) != null) continue;
            map = new HashMap<String, Object>();
            map.put("id", streetId);
            map.put("origin_title", title);
            streets.put(title.toLowerCase(), map);
        }
        rs.close();
        ps.close();
        return result;
    }

    public static List<Map<String, String>> loadTxtDB(String filePath, String charsetName, String splitRegexp, String ... fields) throws UnsupportedEncodingException, IOException {
        String[] lines;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        StringBuffer strBuffer = new StringBuffer();
        try (FileInputStream stream = new FileInputStream(filePath);){
            int count = 0;
            byte[] buff = new byte[1024];
            while ((count = ((InputStream)stream).read(buff, 0, 1024)) > 0) {
                strBuffer.append(new String(buff, 0, count, charsetName));
            }
        }
        for (String line : lines = strBuffer.toString().split("\n")) {
            line = line.trim();
            HashMap<String, String> map = new HashMap<String, String>();
            String[] words = line.split(splitRegexp, -1);
            int idx = 0;
            for (String fieldName : fields) {
                map.put(fieldName, idx < words.length ? words[idx++].trim() : null);
            }
            result.add(map);
        }
        return result;
    }

    public Map<Integer, Map<String, Integer>> getBillingHouseMap(String delim) throws SQLException {
        HashMap<Integer, Map<String, Integer>> result = new HashMap<Integer, Map<String, Integer>>();
        String query = "SELECT streetid, house, id, frac FROM address_house";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int steetId = rs.getInt(1);
            int house = rs.getInt(2);
            int houseId = rs.getInt(3);
            String frac = rs.getString(4);
            HashMap<String, Integer> houses = (HashMap<String, Integer>)result.get(steetId);
            if (houses == null) {
                houses = new HashMap<String, Integer>();
                result.put(steetId, houses);
            }
            String key = ConvertUtil.getHouseKey(house, frac, delim);
            houses.put(key, houseId);
        }
        rs.close();
        ps.close();
        return result;
    }

    private static String getHouseKey(int house, String frac, String delim) {
        Object result = String.valueOf(house);
        if (frac != null) {
            frac = frac.trim();
        }
        if (!Utils.isEmptyString((String)frac)) {
            result = (String)result + delim + frac.toLowerCase();
        }
        return result;
    }

    public Map<String, Map<String, Object>> getBillingCityMap() throws SQLException {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        String query = "SELECT id, title FROM address_city";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String title = rs.getString("title");
            int cityId = rs.getInt("id");
            HashMap<String, Object> map = (HashMap<String, Object>)result.get(title.toLowerCase());
            if (map == null) {
                map = new HashMap<String, Object>();
                map.put("id", cityId);
                map.put("origin_title", title);
                result.put(title.toLowerCase(), map);
                continue;
            }
            System.err.println("dublicate city " + title);
        }
        rs.close();
        ps.close();
        return result;
    }

    public Map<String, Map<String, Object>> getBillingCountryMap() throws SQLException {
        HashMap<String, Map<String, Object>> tarifMap = new HashMap<String, Map<String, Object>>();
        String query = "SELECT id, title FROM address_country";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int id = rs.getInt(1);
            String title = rs.getString(2);
            map.put("id", id);
            map.put("origin_title", title);
            tarifMap.put(title.toLowerCase(), map);
        }
        rs.close();
        ps.close();
        return tarifMap;
    }

    public Contract createContract(int pattern_id, String title, String comment, Date date1) throws Exception {
        String passwd = PswdGen.generatePassword((ParameterMap)this.setup);
        ContractCreateData data = new ContractCreateData().setPatternId(pattern_id).setTitle(title).setDateFrom(date1).setPassword(passwd);
        Contract contract = this.contractDao.createFromPattern(data, true);
        if (contract != null && comment != null) {
            contract.setComment(comment);
            this.contractDao.update((Object)contract);
        }
        return contract;
    }

    public void closeContract(int contractId, Date date, boolean fast) throws Exception {
        if (fast) {
            Contract contract = (Contract)this.contractDao.get(contractId);
            contract.setDateTo(date);
            this.contractDao.update((Object)contract);
        } else {
            this.contractDao.closeContract(contractId, 0, 0, date);
        }
    }

    public Contract findContract(int pid, int houseId, String flat) throws SQLException, BGException {
        Contract contract = null;
        String query = "SELECT cid FROM contract_parameter_type_2 WHERE pid=? AND hid=? AND flat=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, pid);
            ps.setInt(2, houseId);
            ps.setString(3, flat);
            try (ResultSet rs = ps.executeQuery();){
                int contractId;
                if (rs.next() && (contract = (Contract)this.contractDao.get(contractId = rs.getInt(1))) == null) {
                    System.err.println("error contract on contract_parameter_type_2.cid=" + contractId);
                }
            }
        }
        return contract;
    }
}

