/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paymaster.server.bean;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.paymaster.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paymaster.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, "paymaster_transaction", moduleId);
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDatetime", "create_date");
        this.fields.put("transactionDatetime", "payment_date");
        this.fields.put("sum", "sum");
    }

    public void searchTransactionList(SearchResult<Transaction> searchResult, int paymasterId, int contractId) throws BGException {
        this.searchTransactionList(searchResult, paymasterId, contractId, null);
    }

    public void searchTransactionList(SearchResult<Transaction> searchResult, int paymasterId, int contractId, String status) throws BGException {
        if (searchResult == null) {
            throw new BGException("searchResult is null!");
        }
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        try {
            String queryWhere = this.getQueryWhere(paymasterId, contractId, period, status);
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(this.tableName).append(" LEFT JOIN contract c ON c.id=contract_id").append(queryWhere).append(this.getSQLOrder(sort, this.fields)).append(Page.toSqlLimit((Page)page));
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                this.psSetPeriod(ps, 1, period);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        Transaction transaction = this.getFromRS(rs);
                        transaction.setContractTitle(rs.getString("c.title"));
                        list.add(transaction);
                    }
                }
            }
            query.setLength(0);
            query.append("SELECT COUNT(*), SUM(`sum`) FROM ").append(this.tableName).append(queryWhere);
            ps = this.con.prepareStatement(query.toString());
            try {
                this.psSetPeriod(ps, 1, period);
                this.executeQuerySumPage(ps, searchResult);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private String getQueryWhere(int paymasterId, int contractId, Period period, String status) {
        StringBuilder query = new StringBuilder(" WHERE true");
        if (paymasterId > 0) {
            query.append(" AND sys_payment_id=").append(paymasterId);
        }
        if (contractId > 0) {
            query.append(" AND contract_id=").append(contractId);
        }
        query.append(this.queryPeriod(period, "payment_date"));
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            if (TransactionStatus.PAY.getCode().equals(status)) {
                query.append(" AND payment_id>0");
            } else if (TransactionStatus.NOPAY.getCode().equals(status)) {
                query.append(" AND payment_id<1");
            }
        }
        return query.toString();
    }

    public List<Transaction> getTransactionList(int contractId, Date fromDate, Date toDate) throws BGException {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(this.tableName).append(" WHERE true");
            if (contractId > 0) {
                query.append(" AND contract_id=").append(contractId);
            }
            if (fromDate != null) {
                query.append(" AND payment_date>=?");
            }
            if (toDate != null) {
                query.append(" AND payment_date<=?");
            }
            ps = this.con.prepareStatement(query.toString());
            int index = 1;
            if (fromDate != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)fromDate));
            }
            if (toDate != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)toDate));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            ps.close();
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Transaction getTransaction(int id) throws BGException {
        Transaction result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public static Map<String, String> getToken(String serverURL, String tokenCode, String clientId, String redirectUri, String secret) {
        JSONObject resultJsonObject;
        HashMap<String, String> tokenData = null;
        String iat = TransactionManager.getIat();
        StringBuilder body = new StringBuilder();
        try {
            body.append("client_id").append("=").append(clientId).append("&");
            body.append("code").append("=").append(tokenCode).append("&");
            body.append("grant_type").append("=").append("authorization_code").append("&");
            body.append("redirect_uri").append("=").append(URLEncoder.encode(redirectUri, "UTF-8"));
            body.append("&").append("type").append("=").append("rest");
            if (LogManager.getLogger().isDebugEnabled()) {
                LogManager.getLogger().debug("\u0422\u0435\u043b\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e\u0433\u043e \u0442\u043e\u043a\u0435\u043d\u0430: " + body.toString());
            }
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        StringBuilder str = new StringBuilder(body);
        try {
            str.append("&").append("sign").append("=").append(URLEncoder.encode(TransactionManager.doSign(body.toString(), iat, secret), "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        str.append("&").append("iat").append("=").append(iat);
        if (LogManager.getLogger().isDebugEnabled()) {
            LogManager.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e\u0433\u043e \u0442\u043e\u043a\u0435\u043d\u0430: " + str.toString());
        }
        if ((resultJsonObject = TransactionManager.doRequest(serverURL, str.toString())).has("error")) {
            LogManager.getLogger().error("\u041e\u0442\u0432\u0435\u0442:" + resultJsonObject.getString("error"));
        } else {
            tokenData = new HashMap<String, String>();
            tokenData.put("access_token", resultJsonObject.getString("access_token"));
            tokenData.put("expires_in", String.valueOf(resultJsonObject.getLong("expires_in")));
            tokenData.put("account_identifier", resultJsonObject.getString("account_identifier"));
        }
        return tokenData;
    }

    public Transaction directPaymentInit(String serverURL, String accessToken, String merchantId, String description, BigDecimal sum, String secret, int contractId) {
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setStatus(TransactionStatus.NOPAY.getCode())).setPaymentId(-1)).setCreateDate(new Date())).setAutopayment(true)).setSum(sum)).build();
        try {
            this.update(transaction);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String iat = TransactionManager.getIat();
        StringBuilder body = new StringBuilder();
        try {
            body.append("access_token").append("=").append(accessToken);
            body.append("&").append("merchant_id").append("=").append(merchantId);
            body.append("&").append("merchant_transaction_id").append("=").append(transaction.getId());
            body.append("&").append("amount").append("=").append(sum.toPlainString());
            body.append("&").append("currency").append("=").append("RUB");
            body.append("&").append("description").append("=").append(URLEncoder.encode(description, "UTF-8"));
            body.append("&").append("type").append("=").append("rest");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        if (LogManager.getLogger().isDebugEnabled()) {
            LogManager.getLogger().debug("\u0422\u0435\u043b\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \"\u0418\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430\": " + body.toString());
        }
        StringBuilder str = new StringBuilder(body);
        try {
            str.append("&").append("sign").append("=").append(URLEncoder.encode(TransactionManager.doSign(body.toString(), iat, secret), "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        str.append("&").append("iat").append("=").append(iat);
        if (LogManager.getLogger().isDebugEnabled()) {
            LogManager.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441 \"\u0418\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430\": " + str.toString());
        }
        transaction.setStatus(TransactionStatus.ERROR.getCode());
        JSONObject resultJsonObject = TransactionManager.doRequest(serverURL, str.toString());
        if (LogManager.getLogger().isDebugEnabled()) {
            LogManager.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \"\u0418\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430\": " + (resultJsonObject != null ? resultJsonObject.toString() : "null"));
        }
        if (resultJsonObject != null && resultJsonObject.has("status")) {
            String status = resultJsonObject.optString("status");
            if ("success".equals(status)) {
                transaction.setStatus(TransactionStatus.INPAY.getCode());
            } else if (resultJsonObject.has("error")) {
                LogManager.getLogger().error("\u041e\u0442\u0432\u0435\u0442 \"\u0418\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430\": " + resultJsonObject.getString("error"));
            }
        }
        try {
            this.update(transaction);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return transaction;
    }

    public JSONObject directPaymentComplete(String serverURL, String accessToken, String merchantId, Transaction transaction, String secret) {
        String iat = TransactionManager.getIat();
        StringBuilder body = new StringBuilder();
        body.append("access_token").append("=").append(accessToken);
        body.append("&").append("merchant_id").append("=").append(merchantId);
        body.append("&").append("merchant_transaction_id").append("=").append(transaction.getId());
        body.append("&").append("type").append("=").append("rest");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0422\u0435\u043b\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \"\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\": " + body.toString());
        }
        StringBuilder str = new StringBuilder(body);
        try {
            str.append("&").append("sign").append("=").append(URLEncoder.encode(TransactionManager.doSign(body.toString(), iat, secret), "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        str.append("&").append("iat").append("=").append(iat);
        JSONObject resultJsonObject = TransactionManager.doRequest(serverURL, str.toString());
        if (resultJsonObject != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \"\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\": " + resultJsonObject.toString());
            }
            if (resultJsonObject.has("error")) {
                this.getLogger().error("\u041e\u0442\u0432\u0435\u0442 \"\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\": " + resultJsonObject.getString("error"));
            }
        }
        return resultJsonObject;
    }

    private static JSONObject doRequest(String serverURL, String outputData) {
        JSONObject jsonObject = null;
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(serverURL)).POST(HttpRequest.BodyPublishers.ofString(outputData, StandardCharsets.UTF_8)).build();
            jsonObject = new JSONObject(httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jsonObject;
    }

    private static String getIat() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    public static String doSign(String body, String iat, String secret) {
        byte[] bytes = new byte[]{};
        try {
            bytes = (body + ";" + iat + ";" + secret).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return Base64.getEncoder().encodeToString(Utils.getDigestBytes((byte[])bytes, (String)"SHA-256"));
    }

    public Payment addPayment(String transactionId, int contractId, int paymentTypeId, BigDecimal sum, String comment) {
        Payment payment = new Payment().setDate(new Date()).setTypeId(paymentTypeId).setContractId(contractId).setSum(sum).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(transactionId).setComment(comment);
        try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
            new PaymentDao(this.con).update((Object)payment);
            ServerUtils.commitConnection((Connection)this.con);
            balanceUtils.updateBalance(payment.getDate(), contractId);
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contractId, 3, payment.getSum()));
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return payment;
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, payment_date=?, autopayment=?, status=?, `sum`=?, sys_payment_data=?, sys_payment_id=?, sys_payment_date=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setBoolean(index++, transaction.isAutopayment());
            ps.setString(index++, transaction.getStatus());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setString(index++, transaction.getSysPaymentData());
            ps.setString(index++, transaction.getTransactionId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("payment_date"))).setAutopayment(rs.getBoolean("autopayment"))).setStatus(rs.getString("status"))).setSum(rs.getBigDecimal("sum"))).setSysPaymentData(rs.getString("sys_payment_data")).setTransactionId(rs.getString("sys_payment_id"))).setTransactionDate((Date)rs.getTimestamp("sys_payment_date"))).build();
    }
}

