/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.twpg.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.twpg.common.bean.Transaction;
import ru.bitel.bgbilling.modules.twpg.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.twpg.server.bean.Constants;
import ru.bitel.bgbilling.modules.twpg.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.KeyStoreUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.security.EyelessHostnameVerifier;
import ru.bitel.common.security.PEMCertificate;

@WebAction(title="TWPG")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("twpg");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("twpg.gate.url"));
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = new SearchParam().setPage(this.getPage()).setSort(new String[]{"createDate:1", "transactionDate:1"}).setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        SearchResult searchResult = new SearchResult(searchParam);
        new TransactionManager(this.con, this.moduleId).searchTransaction((SearchResult<Transaction>)searchResult, searchParam);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    public void createOrder() throws Exception {
        Document xmlDocument;
        Element responseElement;
        this.checkModuleOnContract(this.moduleId, "\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("twpg.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("twpg.sum.max", new BigDecimal(5000));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        this.setResultParam("contentType", ActionResultContentType.json);
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        Transaction twpgTransaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(this.contractId)).setCreateDate(new Date())).build();
        transactionManager.update(twpgTransaction);
        Document requestDoc = XMLUtils.newDocument();
        Element requestElement = XMLUtils.createElement((Element)XMLUtils.createElement((Document)requestDoc, (String)"TKKPG"), (String)"Request");
        XMLUtils.createElement((Element)requestElement, (String)"Operation").setTextContent("CreateOrder");
        XMLUtils.createElement((Element)requestElement, (String)"Language").setTextContent(this.moduleSetup.get("twpg.language", "RU"));
        Element orderElement = XMLUtils.createElement((Element)requestElement, (String)"Order");
        XMLUtils.createElement((Element)orderElement, (String)"Merchant").setTextContent(this.moduleSetup.get("twpg.merchant.id", "POS_1"));
        XMLUtils.createElement((Element)orderElement, (String)"Amount").setTextContent(sum.toPlainString());
        XMLUtils.createElement((Element)orderElement, (String)"Currency").setTextContent(this.moduleSetup.get("twpg.currency", "643"));
        XMLUtils.createElement((Element)orderElement, (String)"Description").setTextContent(this.moduleSetup.get("twpg.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116" + this.getContractTitle()));
        XMLUtils.createElement((Element)orderElement, (String)"ApproveURL").setTextContent(this.moduleSetup.get("twpg.approve.url", this.moduleSetup.get("twpg.lk.url") + "?module=twpg&action=TWPG&operation=approve&mid=" + this.moduleId + "&transaction=" + twpgTransaction.getId()));
        XMLUtils.createElement((Element)orderElement, (String)"CancelURL").setTextContent(this.moduleSetup.get("twpg.cancel.url", this.moduleSetup.get("twpg.lk.url") + "?module=twpg&action=TWPG&operation=cancel&mid=" + this.moduleId + "&transaction=" + twpgTransaction.getId()));
        XMLUtils.createElement((Element)orderElement, (String)"DeclineURL").setTextContent(this.moduleSetup.get("twpg.decline.url", this.moduleSetup.get("twpg.lk.url") + "?module=twpg&action=TWPG&operation=decline&mid=" + this.moduleId + "&transaction=" + twpgTransaction.getId()));
        XMLUtils.createElement((Element)orderElement, (String)"OrderType").setTextContent(this.moduleSetup.get("twpg.order.type", "Purchase"));
        String resultXml = this.doRequest(requestDoc);
        if (resultXml != null && (responseElement = XMLUtils.selectElement((Node)(xmlDocument = XMLUtils.parseDocument((String)resultXml)), (String)"/TKKPG/Response")) != null) {
            String status = XMLUtils.selectText((Node)responseElement, (String)"Status/text()");
            this.setResultParam("STATUS", status);
            if ("00".equals(status)) {
                this.setResultParam("ORDERID", XMLUtils.selectText((Node)responseElement, (String)"Order/OrderID/text()"));
                this.setResultParam("SESSIONID", XMLUtils.selectText((Node)responseElement, (String)"Order/SessionID/text()"));
                this.setResultParam("ACTION", XMLUtils.selectText((Node)responseElement, (String)"Order/URL/text()"));
            } else {
                String errorDescription = XMLUtils.getAttribute((Element)responseElement, (String)"ErrorDescription/text()");
                this.getLogger().error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: {} - {}", (Object)status, (Object)errorDescription);
                this.setResultParam("ErrorDescription", errorDescription);
            }
            StringBuilder str = new StringBuilder();
            for (String name : this.getResult().keySet()) {
                str.append(name).append(" = ").append(this.getResultParam(name)).append("\n");
            }
            twpgTransaction.setParameters(str.toString());
            transactionManager.update(twpgTransaction);
        }
    }

    public void approve() throws Exception {
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        int transactionId = this.req.getInt("transaction", -1);
        Transaction twpgTransaction = (Transaction)transactionManager.get(transactionId);
        if (twpgTransaction != null && twpgTransaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
            Document xmlDocument;
            Element responseElement;
            HashMap<String, String> twpgTransactionParameters = new HashMap<String, String>();
            for (String param : twpgTransaction.getParameters().split("\n")) {
                String[] nameValue = param.split("=");
                if (nameValue == null || nameValue.length != 2) continue;
                twpgTransactionParameters.put(nameValue[0], nameValue[1]);
            }
            Document requestDoc = XMLUtils.newDocument();
            Element requestElement = XMLUtils.createElement((Element)XMLUtils.createElement((Document)requestDoc, (String)"TKKPG"), (String)"Request");
            XMLUtils.createElement((Element)requestElement, (String)"Operation").setTextContent("GetOrderStatus");
            XMLUtils.createElement((Element)requestElement, (String)"Language").setTextContent(this.moduleSetup.get("twpg.language", "RU"));
            Element orderElement = XMLUtils.createElement((Element)requestElement, (String)"Order");
            XMLUtils.createElement((Element)orderElement, (String)"Merchant").setTextContent(this.moduleSetup.get("twpg.merchant.id", "POS_1"));
            XMLUtils.createElement((Element)orderElement, (String)"OrderID").setTextContent((String)twpgTransactionParameters.get("ORDERID"));
            XMLUtils.createElement((Element)requestElement, (String)"SessionID").setTextContent((String)twpgTransactionParameters.get("SESSIONID"));
            String resultXml = this.doRequest(requestDoc);
            if (resultXml != null && (responseElement = XMLUtils.selectElement((Node)(xmlDocument = XMLUtils.parseDocument((String)resultXml)), (String)"/TKKPG/Response")) != null) {
                String status = XMLUtils.selectText((Node)responseElement, (String)"Status/text()");
                this.setResultParam("STATUS", status);
                if ("00".equals(status)) {
                    String orderStatus = XMLUtils.selectText((Node)responseElement, (String)"Order/OrderStatus/text()");
                    if ("APPROVED".equalsIgnoreCase(orderStatus)) {
                        twpgTransaction.setStatus(TransactionStatus.APPROVED.getCode());
                        transactionManager.update(twpgTransaction);
                    }
                } else {
                    String errorDescription = XMLUtils.getAttribute((Element)responseElement, (String)"ErrorDescription/text()");
                    this.getLogger().error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + status + " - " + errorDescription);
                    this.setResultParam("ErrorDescription", errorDescription);
                }
                StringBuilder str = new StringBuilder();
                for (String name : this.getResult().keySet()) {
                    str.append(name).append(" = ").append(this.getResultParam(name)).append("\n");
                }
            }
        }
        this.execute();
    }

    public void cancel() throws Exception {
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        int transactionId = this.req.getInt("transaction", -1);
        Transaction twpgTransaction = (Transaction)transactionManager.get(transactionId);
        if (twpgTransaction != null && twpgTransaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
            twpgTransaction.setStatus(TransactionStatus.CANCELED.getCode());
            transactionManager.update(twpgTransaction);
        }
        this.execute();
    }

    public void decline() throws Exception {
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        int transactionId = this.req.getInt("transaction", -1);
        Transaction twpgTransaction = (Transaction)transactionManager.get(transactionId);
        if (twpgTransaction != null && twpgTransaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
            twpgTransaction.setStatus(TransactionStatus.DECLINED.getCode());
            transactionManager.update(twpgTransaction);
        }
        this.execute();
    }

    private String doRequest(Document requestDoc) throws BGException {
        StringBuilder resultXml;
        block11: {
            resultXml = null;
            try {
                File fileCaCrt = new File(this.moduleSetup.get("twpg.cert.path.ca.crt", "cert/twpg/ca.pem"));
                File fileCertCrt = new File(this.moduleSetup.get("twpg.cert.path.crt", "cert/twpg/POS_1_cert.pem"));
                File fileCertKey = new File(this.moduleSetup.get("twpg.cert.path.key", "cert/twpg/POS_1_key.pem"));
                File fileHostCrt = new File(this.moduleSetup.get("twpg.cert.path.key", "cert/twpg/mpit_minbank_ru_cert.pem"));
                SSLContext sslContext = null;
                if (fileCaCrt.exists() && fileCertCrt.exists() && fileCertKey.exists()) {
                    X509Certificate[] chain = new X509Certificate[]{PEMCertificate.getPemCertificate((File)fileCertCrt), PEMCertificate.getPemCertificate((File)fileCaCrt)};
                    String keyPassword = this.moduleSetup.get("twpg.cert.key.password", "");
                    sslContext = KeyStoreUtils.createSSLContext((File)fileCertKey, (String)keyPassword, (X509Certificate[])chain, (File[])new File[]{fileHostCrt, fileCaCrt});
                }
                URL url = URI.create("https://" + this.moduleSetup.get("twpg.pg.host", "62.117.79.234") + ":" + this.moduleSetup.get("twpg.pg.port", "5443") + "/Exec").toURL();
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                if (sslContext != null) {
                    connection.setSSLSocketFactory(sslContext.getSocketFactory());
                    connection.setHostnameVerifier((HostnameVerifier)EyelessHostnameVerifier.INSTANCE);
                }
                connection.setDoOutput(true);
                connection.setDoInput(true);
                XMLUtils.serialize((Node)requestDoc.getDocumentElement(), (OutputStream)connection.getOutputStream(), (String)"utf-8");
                if (connection.getResponseCode() != 200) break block11;
                resultXml = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    if (br.ready()) {
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            resultXml.append(line);
                        }
                    }
                }
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 TWEC PG: {}", (Object)resultXml);
            }
            catch (Exception e) {
                throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0441\u044f \u043a \u0448\u043b\u044e\u0437\u0443. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438: " + e.getMessage(), (Throwable)e);
            }
        }
        return resultXml == null ? null : resultXml.toString();
    }
}

