#!/bin/bash

cd ${0%${0##*/}}./..

. ./bin/setenv.sh

if [ ! -e lib/app/kernel-server.jar ]
then
    echo "not updated?"
    exit 0
fi

PWD="$($(which pwd))"
NAME_SHORT=${PWD##*/}

APP_HOME=.
CLASSPATH=$APP_HOME:$APP_HOME/lib/*:$APP_HOME/lib/app/*:$APP_HOME/lib/ext/*:$APP_HOME/lib/custom/*
COMPAT_PARAMS="--add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.util.regex=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED"
COMMON_PARAMS="-Dapp.name=$NAME_SHORT -Dnetworkaddress.cache.ttl=3600 -Djava.net.preferIPv4Stack=true ${COMPAT_PARAMS}"
LOG_PARAMS="-Dlog.dir.path=log/ -Dlog.prefix=$NAME_SHORT -Dlog4j.configurationFile=conf/log4j2.xml"
MEMORY=-Xmx256m

${JAVA_HOME}/bin/java ${COMMON_PARAMS} -cp ${CLASSPATH} ru.bitel.bgbilling.apps.inet.accounting.detail.FlowExport $@
