/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import bitel.billing.common.VersionInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoBillFileGenerator;
import ru.bitel.bgbilling.plugins.edo.server.utils.EdoFnsXmlGenerator;
import ru.bitel.bgbilling.plugins.edo.server.utils.MissingDocParamException;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ScriptUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;

public abstract class FnsFileGenerator
implements EdoBillFileGenerator {
    protected Connection con;
    protected BillDoc doc;
    protected Document xml;
    protected ScriptUtils scriptUtils;
    protected ParameterMap documentSetup;
    protected ContragentInfos contragentInfos;
    private Contract contract;

    @Override
    public void init(Setup setup, Connection con, int billModuleId, ParameterMap billModuleSetup, ParameterMap documentSetup, BillDoc doc, ContragentInfos contragentInfos) throws Exception {
        this.con = con;
        this.doc = doc;
        this.xml = doc.getDocument();
        if (this.xml == null) {
            throw new BGException("error parse xml data BillDoc#" + doc.getId());
        }
        this.scriptUtils = new ScriptUtils((DefaultServerSetup)setup, con);
        this.documentSetup = documentSetup;
        this.contragentInfos = contragentInfos;
    }

    public abstract EdoFnsXmlGenerator getDocument() throws BGException;

    @Override
    public InputStream getFileContent() throws BGException {
        try {
            return new ByteArrayInputStream(this.getDocument().serialize("cp1251"));
        }
        catch (Exception e) {
            throw new BGException("error serialze document (" + e.toString() + ")", (Throwable)e);
        }
    }

    protected Contract getContract() throws BGException {
        if (this.contract == null) {
            try (ContractDao cd = new ContractDao(this.con, 0);){
                this.contract = (Contract)cd.get(this.doc.getContractId());
            }
        }
        return this.contract;
    }

    protected String value(String nameValue, boolean required) throws Exception {
        String value = this.value_raw(nameValue, required);
        if (value == null) {
            return null;
        }
        if (value.startsWith("pid:")) {
            int pid = -1;
            try {
                pid = Integer.valueOf(value.substring(4));
            }
            catch (Exception e) {
                throw new BGException("\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 " + nameValue + "=" + value);
            }
            value = this.scriptUtils.getContractParameter(this.doc.getContractId(), pid);
        } else if (value.startsWith("bill_attr:")) {
            value = value.substring(10);
            value = XMLUtils.selectText((Node)this.xml, (String)("/data/bill/attributes/@" + value));
        } else if (value.startsWith("contract:")) {
            value = value.substring(9).strip();
            Contract contract = this.getContract();
            Field f = Contract.class.getDeclaredField(value);
            f.setAccessible(true);
            Object vieldval = f.get(contract);
            value = vieldval.toString();
        }
        return value != null ? value.strip() : null;
    }

    protected String value(String nameValue) throws Exception {
        return this.value(nameValue, true);
    }

    protected String value_raw(String nameValue, boolean required) throws MissingDocParamException {
        String value = this.documentSetup.get(nameValue);
        if (required && value == null) {
            throw new MissingDocParamException(nameValue);
        }
        return value;
    }

    protected String value_oneof_req(String nameValue1, String nameValue2) throws Exception {
        String \u041d\u0430\u0438\u043c = this.value(nameValue1, false);
        if (Utils.isBlankString((String)\u041d\u0430\u0438\u043c)) {
            \u041d\u0430\u0438\u043c = this.value(nameValue2);
        }
        return \u041d\u0430\u0438\u043c;
    }

    protected EdoFnsXmlGenerator.S \u0424\u0418\u041e\u0422\u0438\u043f(final String F, final String I, final String O) {
        return new EdoFnsXmlGenerator.S(){
            {
                this.A("\u0424\u0430\u043c\u0438\u043b\u0438\u044f", F);
                this.A("\u0418\u043c\u044f", I);
                this.A("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e", O);
            }
        };
    }

    protected String \u0414\u0430\u0442\u0430\u0422\u0438\u043f(Date date) {
        return date != null ? TimeUtils.format((Date)date, (String)"dd.MM.yyyy") : null;
    }

    protected String \u0412\u0440\u0435\u043c\u044f\u0422\u0438\u043f(Date date) {
        return date != null ? TimeUtils.format((Date)date, (String)"HH.mm.ss") : null;
    }

    protected EdoFnsXmlGenerator.S \u0422\u0435\u043a\u0441\u0442\u0418\u043d\u0444\u0422\u0438\u043f(final String id, final String val) {
        return new EdoFnsXmlGenerator.S(){
            {
                this.A("\u0418\u0434\u0435\u043d\u0442\u0438\u0444", id);
                this.A("\u0417\u043d\u0430\u0447\u0435\u043d", val);
            }
        };
    }

    protected String \u0412\u0435\u0440\u0441\u041f\u0440\u043e\u0433() {
        VersionInfo vi = VersionInfo.getVersionInfo((String)"kernel");
        Object version = "BGBilling " + vi.getVersionString();
        int idxslash = ((String)version).indexOf("/");
        if (idxslash >= 0) {
            version = ((String)version).substring(0, idxslash);
        }
        return ((String)version).strip();
    }

    protected \u0410\u0434\u0440\u0435\u0441\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 getAddress(String valueFrom) throws Exception {
        String val;
        \u0410\u0434\u0440\u0435\u0441\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 result = new \u0410\u0434\u0440\u0435\u0441\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430();
        String \u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442 = this.value(valueFrom + ".\u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442", false);
        if (Utils.notBlankString((String)\u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442)) {
            String \u041a\u043e\u0434\u0421\u0442\u0440 = this.value(valueFrom + ".\u041a\u043e\u0434\u0421\u0442\u0440", false);
            String \u041d\u0430\u0438\u043c\u0421\u0442\u0440\u0430\u043d = this.value(valueFrom + ".\u041d\u0430\u0438\u043c\u0421\u0442\u0440\u0430\u043d", false);
            if (Utils.isBlankString((String)\u041a\u043e\u0434\u0421\u0442\u0440) && Utils.isBlankString((String)\u041d\u0430\u0438\u043c\u0421\u0442\u0440\u0430\u043d)) {
                \u041a\u043e\u0434\u0421\u0442\u0440 = "643";
                \u041d\u0430\u0438\u043c\u0421\u0442\u0440\u0430\u043d = "\u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0430\u044f \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u044f";
            }
            result.\u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442 = \u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442;
            result.\u041a\u043e\u0434\u0421\u0442\u0440 = \u041a\u043e\u0434\u0421\u0442\u0440;
            result.\u041d\u0430\u0438\u043c\u0421\u0442\u0440\u0430\u043d = \u041d\u0430\u0438\u043c\u0421\u0442\u0440\u0430\u043d;
            return result;
        }
        AddressStruct _address = null;
        String \u0410\u0434\u0440\u0435\u0441 = this.value_raw(valueFrom, false);
        if (Utils.notBlankString((String)\u0410\u0434\u0440\u0435\u0441)) {
            if (!\u0410\u0434\u0440\u0435\u0441.startsWith("pid:")) {
                throw new BGException(valueFrom + " \u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e pid \u043d\u0430 \u0430\u0434\u0440\u0435\u0441\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
            }
            \u0410\u0434\u0440\u0435\u0441 = \u0410\u0434\u0440\u0435\u0441.substring(4);
            if (!this.scriptUtils.isContractParameterAddress(Utils.parseInt((String)\u0410\u0434\u0440\u0435\u0441))) {
                throw new BGException(valueFrom + " \u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f pid=" + \u0410\u0434\u0440\u0435\u0441 + " \u043d\u0430 \u0430\u0434\u0440\u0435\u0441\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
            }
            _address = this.scriptUtils.getContractParameterAddress(this.doc.getContractId(), Utils.parseInt((String)\u0410\u0434\u0440\u0435\u0441));
        }
        if (_address == null) {
            _address = new AddressStruct();
        }
        if (Utils.notBlankString((String)(val = this.value(valueFrom + ".\u0418\u043d\u0434\u0435\u043a\u0441", false)))) {
            _address.setIndex(val);
        }
        if (Utils.notBlankString((String)(val = this.value(valueFrom + ".\u0420\u0430\u0439\u043e\u043d", false)))) {
            _address.setArea(val);
        }
        if (Utils.notBlankString((String)(val = this.value(valueFrom + ".\u0413\u043e\u0440\u043e\u0434", false)))) {
            _address.setCity(val);
        }
        if (Utils.notBlankString((String)(val = this.value(valueFrom + ".\u0423\u043b\u0438\u0446\u0430", false)))) {
            _address.setStreet(val);
        }
        if (Utils.notBlankString((String)(val = this.value(valueFrom + ".\u0414\u043e\u043c", false)))) {
            _address.setHouse(val);
        }
        if (Utils.notBlankString((String)(val = this.value(valueFrom + ".\u041a\u043e\u0440\u043f\u0443\u0441", false)))) {
            _address.setFrac(val);
        }
        if (Utils.notBlankString((String)(val = this.value(valueFrom + ".\u041a\u0432\u0430\u0440\u0442", false)))) {
            _address.setFlat(val);
        }
        result.\u0418\u043d\u0434\u0435\u043a\u0441 = _address.getIndex();
        result.\u041a\u043e\u0434\u0420\u0435\u0433\u0438\u043e\u043d = this.value(valueFrom + ".\u041a\u043e\u0434\u0420\u0435\u0433\u0438\u043e\u043d", false);
        result.\u0420\u0430\u0439\u043e\u043d = _address.getArea();
        result.\u0413\u043e\u0440\u043e\u0434 = _address.getCity();
        result.\u041d\u0430\u0441\u0435\u043b\u041f\u0443\u043d\u043a\u0442 = this.value(valueFrom + ".\u041d\u0430\u0441\u0435\u043b\u041f\u0443\u043d\u043a\u0442", false);
        result.\u0423\u043b\u0438\u0446\u0430 = _address.getStreet();
        result.\u0414\u043e\u043c = _address.getHouse();
        result.\u041a\u043e\u0440\u043f\u0443\u0441 = _address.getFrac();
        result.\u041a\u0432\u0430\u0440\u0442 = _address.getFlat();
        return result;
    }

    protected static class \u0410\u0434\u0440\u0435\u0441\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 {
        public String \u041a\u043e\u0434\u0421\u0442\u0440;
        public String \u041d\u0430\u0438\u043c\u0421\u0442\u0440\u0430\u043d;
        public String \u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442;
        public String \u0418\u043d\u0434\u0435\u043a\u0441;
        public String \u041a\u043e\u0434\u0420\u0435\u0433\u0438\u043e\u043d;
        public String \u0420\u0430\u0439\u043e\u043d;
        public String \u0413\u043e\u0440\u043e\u0434;
        public String \u041d\u0430\u0441\u0435\u043b\u041f\u0443\u043d\u043a\u0442;
        public String \u0423\u043b\u0438\u0446\u0430;
        public String \u0414\u043e\u043c;
        public String \u041a\u043e\u0440\u043f\u0443\u0441;
        public String \u041a\u0432\u0430\u0440\u0442;

        protected \u0410\u0434\u0440\u0435\u0441\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430() {
        }
    }
}

