/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class PaymentDao
extends AbstractIdDao<Payment> {
    public PaymentDao(Connection con) {
        super(con, "contract_payment");
    }

    public SearchResult<Payment> getPaymentList(int contractId, Period period, int members) throws SQLException {
        SearchResult<Payment> searchResult = new SearchResult<Payment>(period, null);
        this.searchPaymentList(searchResult, contractId, members);
        return searchResult;
    }

    public void searchPaymentList(SearchResult<Payment> searchResult, int contractId, int members) throws SQLException {
        this.searchPaymentList(searchResult, Utils.toIntegerList(ContractUtils.getCidsStringForQuery((int)contractId, (int)members, (Connection)this.con)));
    }

    public List<Payment> getPaymentList(List<Integer> contractIds, Period period, Holder<BigDecimal> totalSum) throws SQLException {
        SearchResult<Payment> searchResult = new SearchResult<Payment>();
        searchResult.setPeriod(period);
        this.searchPaymentList(searchResult, contractIds);
        if (totalSum != null) {
            totalSum.value = searchResult.getSum();
        }
        return searchResult.getList();
    }

    public void searchPaymentList(SearchResult<Payment> searchResult, List<Integer> contractIds) throws SQLException {
        Objects.requireNonNull(searchResult);
        Objects.requireNonNull(contractIds);
        if (contractIds.isEmpty()) {
            return;
        }
        Period period = searchResult.getPeriod();
        List<Payment> result = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.tableName + " WHERE cid IN (" + Utils.toString(contractIds) + ")").append(this.queryPeriod(period, "dt")).append(" ORDER BY dt");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            this.psSetPeriod(ps, 1, period);
            try (ResultSet rs = ps.executeQuery();){
                BigDecimal sumL = BigDecimal.ZERO;
                while (rs.next()) {
                    sumL = sumL.add(rs.getBigDecimal("summa"));
                    result.add(this.getFromRS(rs));
                }
                searchResult.setSum(sumL);
            }
        }
    }

    public void searchLastPaymentList(SearchResult<Payment> searchResult, int contractId, int members, int lastPayments) throws SQLException {
        this.searchLastPaymentList(searchResult, Utils.toIntegerList(ContractUtils.getCidsStringForQuery((int)contractId, (int)members, (Connection)this.con)), lastPayments);
    }

    public void searchLastPaymentList(SearchResult<Payment> searchResult, List<Integer> contractIds, int lastPayments) throws SQLException {
        if (searchResult == null || contractIds == null || contractIds.isEmpty()) {
            return;
        }
        List<Payment> result = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.tableName + " WHERE cid IN (" + Utils.toString(contractIds) + ")").append(" ORDER BY dt DESC");
        if (lastPayments > 0) {
            query.append(" LIMIT ").append(lastPayments);
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());
             ResultSet rs = ps.executeQuery();){
            BigDecimal sumL = BigDecimal.ZERO;
            while (rs.next()) {
                sumL = sumL.add(rs.getBigDecimal("summa"));
                result.add(this.getFromRS(rs));
            }
            searchResult.setSum(sumL);
        }
    }

    @Override
    protected void updateImpl(Payment payment) throws SQLException {
        Objects.requireNonNull(payment);
        String querySet = "dt=?, cid=?, pt=?, uid=?, summa=?, comment=?, data=?, module_id=?, transaction_id=?";
        try (PreparedStatement ps = this.prepareStatement(payment, querySet);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(payment.getDate()));
            ps.setInt(index++, payment.getContractId());
            ps.setInt(index++, payment.getTypeId());
            ps.setInt(index++, payment.getUserId());
            ps.setBigDecimal(index++, payment.getSum());
            ps.setString(index++, payment.getComment());
            ps.setString(index++, payment.getData());
            this.psSetInteger(ps, index++, payment.getModuleId());
            ps.setString(index++, payment.getTransactionId());
            this.executeUpdate(payment, index, ps);
        }
    }

    private void psSetInteger(PreparedStatement ps, int index, Integer value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 4);
        } else {
            ps.setInt(index, value);
        }
    }

    public void zeroBalancePayment(Date date, int contractId, int paymentTypeId) throws Exception {
        this.zeroBalancePayment(date, contractId, paymentTypeId, "\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0434\u043b\u044f \u043e\u0431\u043d\u0443\u043b\u0435\u043d\u0438\u044f \u0431\u0430\u043b\u0430\u043d\u0441\u0430");
    }

    public void zeroBalancePayment(Date date, int contractId, int paymentTypeId, String paymentComment) throws Exception {
        if (date != null) {
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                BigDecimal balance = balanceUtils.getBalance(date, contractId);
                if (balance.compareTo(BigDecimal.ZERO) >= 0) {
                    return;
                }
                BigDecimal delta = balance.abs();
                this.update(new Payment().setTypeId(paymentTypeId).setContractId(contractId).setDate(date).setSum(delta).setComment(paymentComment).setUserId(0).setModuleId(0));
                balanceUtils.updateBalance(date, contractId);
            }
        }
    }

    public List<Payment> getPaymentsById(List<Integer> paymentIds) throws SQLException {
        Objects.requireNonNull(paymentIds);
        if (paymentIds.isEmpty()) {
            return new ArrayList<Payment>();
        }
        String idList = Utils.toString(paymentIds);
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN (" + idList + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            List<Payment> list;
            block13: {
                ResultSet rs = ps.executeQuery();
                try {
                    list = this.getListFromRS(rs);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    @Override
    protected int deleteImpl(int id) throws SQLException {
        String query = "INSERT INTO " + this.tableName + "_deleted SELECT * FROM " + this.tableName + " WHERE id=" + id;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
        return super.deleteImpl(id);
    }

    public void deletePaymentsById(List<Integer> paymentIds) throws SQLException {
        Objects.requireNonNull(paymentIds);
        if (paymentIds.isEmpty()) {
            return;
        }
        String idList = Utils.toString(paymentIds);
        String query = "INSERT INTO " + this.tableName + "_deleted SELECT * FROM " + this.tableName + " WHERE id IN (" + idList + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
        query = "DELETE FROM " + this.tableName + " WHERE id IN (" + idList + ")";
        ps = this.con.prepareStatement(query);
        try {
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    @Override
    protected Payment getFromRS(ResultSet rs) throws SQLException {
        return new Payment().setId(rs.getInt("id")).setTypeId(rs.getInt("pt")).setContractId(rs.getInt("cid")).setDate(rs.getDate("dt")).setSum(rs.getBigDecimal("summa")).setComment(rs.getString("comment")).setUserId(rs.getInt("uid")).setModuleId(this.getInteger(rs, "module_id")).setTransactionId(rs.getString("transaction_id")).setTimeChange(rs.getTimestamp("lm")).setData(rs.getString("data"));
    }

    private Integer getInteger(ResultSet rs, String name) throws SQLException {
        int value = rs.getInt(name);
        return rs.wasNull() ? null : Integer.valueOf(value);
    }
}

