/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;

public class MegafonContractProductDao
extends AbstractIdDao<MegafonContractProduct> {
    public MegafonContractProductDao(Connection con, int moduleId) {
        super(con, "megafon_contract_product", moduleId);
    }

    public Result<MegafonContractProduct> list(Page page, String filter, String orderBy, Object ... params) throws SQLException {
        return super.list(page, filter, orderBy, params);
    }

    protected MegafonContractProduct getFromRS(ResultSet rs) throws SQLException {
        MegafonContractProduct contractProduct = new MegafonContractProduct();
        contractProduct.setId(rs.getInt("id"));
        contractProduct.setContractId(rs.getInt("contract_id"));
        contractProduct.setProductId(rs.getInt("product_id"));
        contractProduct.setStatus(MegafonContractProductStatus.getStatusByCode((int)rs.getInt("status")));
        contractProduct.setMsisdn(rs.getString("msisdn"));
        contractProduct.setAdditionalMsisdn(rs.getString("additional_msisdn"));
        contractProduct.setStartTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("start_time")));
        contractProduct.setEndTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("end_time")));
        contractProduct.setOrderId(rs.getLong("order_id"));
        contractProduct.setMnpOrderComment(rs.getString("mnp_comment"));
        contractProduct.setTariffId(rs.getInt("tariff_id"));
        contractProduct.setMnpProcessNumber(rs.getString("mnp_process_number"));
        contractProduct.setReserveId(rs.getInt("reserve_id"));
        contractProduct.setIcc(rs.getString("icc"));
        contractProduct.setImsi(rs.getString("imsi"));
        return contractProduct;
    }

    protected void updateImpl(MegafonContractProduct contractProduct) throws SQLException {
        try (PreparedStatement ps = this.prepareStatement((Idable)contractProduct, "product_id=?, status=?, msisdn=?, additional_msisdn=?, start_time=?, end_time=?, contract_id=?, mnp_comment=?, tariff_id=?, order_id=?, mnp_process_number=?, reserve_id=?, icc=?, imsi=?");){
            int index = 1;
            ps.setInt(index++, contractProduct.getProductId());
            ps.setInt(index++, contractProduct.getStatus() != null ? contractProduct.getStatus().getStatus() : -1);
            ps.setString(index++, contractProduct.getMsisdn());
            ps.setString(index++, contractProduct.getAdditionalMsisdn());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)contractProduct.getStartTime()));
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)contractProduct.getEndTime()));
            ps.setInt(index++, contractProduct.getContractId());
            ps.setString(index++, contractProduct.getMnpOrderComment());
            ps.setInt(index++, contractProduct.getTariffId());
            ps.setLong(index++, contractProduct.getOrderId());
            ps.setString(index++, contractProduct.getMnpProcessNumber());
            ps.setInt(index++, contractProduct.getReserveId());
            ps.setString(index++, contractProduct.getIcc());
            ps.setString(index++, contractProduct.getImsi());
            this.executeUpdate((Id)contractProduct, index, ps);
        }
    }
}

