/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import jakarta.activation.DataSource;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.EdoDocumentType;
import ru.bitel.bgbilling.plugins.edo.common.bean.ExtDocument;
import ru.bitel.bgbilling.plugins.edo.server.bean.ContractConfigManager;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoBillFileGenerator;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoDocumentTypeDao;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoExtDocumentDao;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoManager;
import ru.bitel.bgbilling.plugins.edo.server.bean.SignatoryDao;
import ru.bitel.bgbilling.plugins.edo.server.provider.sbis.SbisAPI;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

public class EdoBillManager {
    private Connection con;
    private int billModuleId;
    private int userId;
    private Setup setup = Setup.getSetup();
    private Preferences billModuleSetup;
    private BillManager billManager;
    private InvoiceManager invoiceManager;
    private EdoDocumentTypeDao edoDocumentTypeDao;
    private SignatoryDao signatoryDao;
    private ContractConfigManager contractConfigManager;
    private EdoManager edoManager;

    public EdoBillManager(Connection con, int billModuleId, int userId) {
        this.con = con;
        this.billModuleId = billModuleId;
        this.userId = userId;
        if (billModuleId > 0) {
            this.billModuleSetup = this.setup.getModuleSetup(Integer.valueOf(billModuleId));
            this.billManager = new BillManager(con, billModuleId);
            this.invoiceManager = new InvoiceManager(con, billModuleId);
        }
        this.edoDocumentTypeDao = new EdoDocumentTypeDao(con);
        this.signatoryDao = new SignatoryDao(con);
        this.contractConfigManager = new ContractConfigManager(con);
        this.edoManager = new EdoManager(con, userId);
    }

    private BillDoc getBillDoc(DocumentType billDocType, Integer billDocId) throws Exception {
        Bill doc;
        if (billDocType == DocumentType.BILL) {
            doc = this.billManager.getBill(billDocId.intValue());
            doc.setXmlData(this.billManager.getXMLData(billDocId.intValue()));
        } else {
            doc = this.invoiceManager.getInvoice(billDocId.intValue());
            doc.setXmlData(this.invoiceManager.getXMLData(billDocId.intValue()));
        }
        return doc;
    }

    private ProcessedDocument processDocument(int edoDocumentTypeId, int signatoryId, ContragentInfos contragentInfos, DocumentType billDocType, Integer billDocId) throws Exception {
        EdoBillFileGenerator fileGenerator;
        BillDoc doc = this.getBillDoc(billDocType, billDocId);
        EdoDocumentType document = (EdoDocumentType)this.edoDocumentTypeDao.get(edoDocumentTypeId);
        String dynClassName = document.getClazz();
        ParameterMap documentSetup = this.edoManager.getDocumentSetup(edoDocumentTypeId, signatoryId, doc.getContractId());
        try {
            fileGenerator = (EdoBillFileGenerator)DynamicClassManager.getInstance().newInstance(EdoBillFileGenerator.class, dynClassName);
            fileGenerator.init(this.setup, this.con, this.billModuleId, (ParameterMap)this.billModuleSetup, documentSetup, doc, contragentInfos);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (BGException e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u044d\u0434\u043e-\u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 " + dynClassName + ": " + e.getMessage());
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u044d\u0434\u043e-\u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 " + dynClassName + ": " + e.getMessage(), (Throwable)e);
        }
        try {
            final InputStream is = fileGenerator.getFileContent();
            final String fn = Utils.normalizeFileName((String)fileGenerator.getFileName());
            ProcessedDocument processedDocument = new ProcessedDocument();
            processedDocument.dataSource = new DataSource(){

                public InputStream getInputStream() {
                    return is;
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    return null;
                }

                public String getName() {
                    return fn;
                }
            };
            processedDocument.documentSetup = documentSetup;
            processedDocument.billDoc = doc;
            return processedDocument;
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u044d\u0434\u043e-\u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 " + dynClassName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public DataSource getDataSource(int edoDocumentTypeId, int signatoryId, ContragentInfos contragentInfos, DocumentType billDocType, Integer billDocId) throws Exception {
        return this.processDocument((int)edoDocumentTypeId, (int)signatoryId, (ContragentInfos)contragentInfos, (DocumentType)billDocType, (Integer)billDocId).dataSource;
    }

    public ExtDocument sendEdo(int edoDocumentTypeId, int signatoryId, ContragentInfos contragentInfos, DocumentType billDocType, Integer billDocId) throws Exception {
        ProcessedDocument processedDocument = this.processDocument(edoDocumentTypeId, signatoryId, contragentInfos, billDocType, billDocId);
        SbisAPI sbisAPI = new SbisAPI(this.userId);
        String base64data = Base64.encode((InputStream)processedDocument.dataSource.getInputStream());
        SbisAPI.WriteDoc writeDoc = sbisAPI.writeDocs(processedDocument.dataSource.getName(), base64data, processedDocument.documentSetup);
        EdoExtDocumentDao edd = new EdoExtDocumentDao(this.con);
        ExtDocument extDocument = new ExtDocument();
        BillDoc billDoc = processedDocument.billDoc;
        extDocument.setDocumentTypeId(edoDocumentTypeId);
        extDocument.setSignatoryId(signatoryId);
        if (billDocType == DocumentType.BILL) {
            extDocument.setBillId(billDocId.intValue());
        } else {
            extDocument.setInvoiceId(billDocId.intValue());
        }
        extDocument.setExtLink(writeDoc.link);
        extDocument.setExtTitle(writeDoc.title);
        extDocument.setDate(new Date());
        extDocument.setUserId(this.userId);
        extDocument.setContractId(billDoc.getContractId());
        extDocument.setBillModuleId(this.billModuleId);
        extDocument.setBillingDocTitle(billDoc.getFormatNumber() + " (" + billDoc.getTypeTitle() + ")");
        edd.update(extDocument);
        return extDocument;
    }

    public static class ProcessedDocument {
        DataSource dataSource;
        ParameterMap documentSetup;
        BillDoc billDoc;
    }
}

