/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class AccountManager
extends AbstarctDaoConstant {
    public AccountManager(Connection con, int moduleId) {
        super(con, "email_account", moduleId);
    }

    public int getContractAccountsCount(int contractId, Date date) throws SQLException {
        int result = 0;
        String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date));
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }

    public List<Account> getContractAccountList(int contractId) {
        return this.getContractAccountList(contractId, null);
    }

    public List<Account> getContractAccountList(int contractId, Date date) {
        ArrayList<Account> result = new ArrayList<Account>();
        try {
            StringBuilder query = new StringBuilder().append("SELECT * FROM ").append(this.tableName).append(" WHERE cid=?");
            if (date != null) {
                query.append(" AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)");
            }
            query.append(" ORDER BY account");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            if (date != null) {
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getAccountFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Account> findAccounts(String mask, int domainId) {
        ArrayList<Account> result = new ArrayList<Account>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE did=? AND UPPER(account) LIKE ? ORDER BY cid, account";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, domainId);
            ps.setString(2, "%" + mask.toUpperCase() + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getAccountFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public String checkAccount(Account account) {
        String result = null;
        try {
            String query = "SELECT contract.title FROM " + this.tableName + " AS account LEFT JOIN contract ON account.cid=contract.id WHERE account.id!=? AND account.did=? AND account.account=? AND (? IS NULL OR account.date2 IS NULL OR ?<=account.date2) AND (? IS NULL OR account.date1 IS NULL OR ?>=account.date1) LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, account.getId());
            ps.setInt(2, account.getDomainId());
            ps.setString(3, account.getAccount());
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)account.getDate1()));
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)account.getDate1()));
            ps.setDate(6, TimeUtils.convertDateToSqlDate((Date)account.getDate2()));
            ps.setDate(7, TimeUtils.convertDateToSqlDate((Date)account.getDate2()));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 E-Mail \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c " + rs.getString(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public Account getAccountByID(int id) {
        return this.getAccountById(id);
    }

    public Account getAccountById(int id) {
        Account result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getAccountFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public void updateAccount(String id, Account account) throws BGException {
        account.setId(Utils.parseInt((String)id));
        this.updateAccount(account);
    }

    public void updateAccount(Account account) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (account.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " ( cid, account, did, quota, status, comment, password, date1, date2, need_open, need_close ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET cid=?, account=?, did=?, quota=?, status=?, comment=?, password=?, date1=?, date2=?, need_open=?, need_close=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(12, account.getId());
            }
            ps.setInt(1, account.getContractId());
            ps.setString(2, account.getAccount());
            ps.setInt(3, account.getDomainId());
            ps.setLong(4, account.getQuota());
            ps.setInt(5, account.getStatus());
            ps.setString(6, account.getComment());
            ps.setString(7, account.getPassword());
            ps.setDate(8, TimeUtils.convertDateToSqlDate((Date)account.getDate1()));
            ps.setDate(9, TimeUtils.convertDateToSqlDate((Date)account.getDate2()));
            ps.setBoolean(10, account.isNeedOpen());
            ps.setBoolean(11, account.isNeedClose());
            ps.executeUpdate();
            if (account.getId() <= 0) {
                account.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void deleteAccount(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        query = "DELETE FROM email_forward_" + this.moduleId + " WHERE aid=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public List<Account> getNeedOpenAccountList(Date date) {
        ArrayList<Account> result = new ArrayList<Account>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE need_open=1 AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getAccountFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Account> getNeedCloseAccountList(Date date) {
        ArrayList<Account> result = new ArrayList<Account>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE need_close=1 AND date2 IS NOT NULL AND date2<?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getAccountFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Account getAccountFromRS(ResultSet rs) throws SQLException {
        Account result = new Account();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setAccount(rs.getString("account"));
        result.setDomainId(rs.getInt("did"));
        result.setQuota(rs.getLong("quota"));
        result.setStatus(rs.getInt("status"));
        result.setComment(rs.getString("comment"));
        result.setPassword(rs.getString("password"));
        result.setDate1(rs.getDate("date1"));
        result.setDate2(rs.getDate("date2"));
        result.setNeedOpen(rs.getBoolean("need_open"));
        result.setNeedClose(rs.getBoolean("need_close"));
        return result;
    }
}

