/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.action.pub;

import bitel.billing.server.ActionBase;
import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Card;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class ActionCreateContract
extends ActionBase {
    public void doAction() throws Exception {
        this.rootNode.setAttribute("xslt", "cerbercrypt_create_contract.xsl");
        long number = this.getLongParameter("number", -1L);
        String pswd = this.getParameter("pswd");
        int street = this.getIntParameter("street", -1);
        String house = this.getParameter("house", "");
        String frac = AddressUtils.getHouseFrac((String)house);
        house = AddressUtils.getHouse((String)house);
        int flat = this.getIntParameter("flat", 0);
        String room = this.getParameter("room", "");
        String fio = this.getParameter("fio", "");
        Element streetList = this.createElement(this.rootNode, "street_list");
        String sql = "SELECT DISTINCT t1.id, t1.title FROM address_street AS t1 INNER JOIN address_house AS t2 ON t1.id=t2.streetid ORDER BY t1.title";
        PreparedStatement ps = this.con.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Element item = this.createElement(streetList, "item");
            item.setAttribute("id", rs.getString(1));
            item.setAttribute("title", rs.getString(2));
        }
        rs.close();
        ps.close();
        if (number <= 0L || Utils.isBlankString((String)pswd)) {
            return;
        }
        int mid = this.getIntParameter("mid", -1);
        if (mid <= 0) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 mid!");
        }
        CardManager cardManager = new CardManager(this.con, mid, this.userId);
        Card card = cardManager.getCard(number);
        if (card == null) {
            throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
        }
        if (card.getContractId() > 0) {
            this.addContract(card.getContractId(), false);
            throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430!");
        }
        if (card.getDealerId() == 0 || TimeUtils.dateBefore((Calendar)new GregorianCalendar(), (Calendar)card.getPassDate())) {
            throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u0430!");
        }
        if (!card.getPassword().equals(pswd)) {
            throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c!");
        }
        ModuleSetup moduleSetup = new ModuleSetup(this.con, mid);
        String prefix = "web.create.";
        int patternId = moduleSetup.getInt("web.create.pattern", -1);
        int subscrOffset = moduleSetup.getInt("web.create.subscr.offset", -1);
        int addressPid = moduleSetup.getInt("web.create.address.param", 0);
        int fioPid = moduleSetup.getInt("web.create.fio.param", 0);
        boolean allowChange = this.getParameter("allow_change") != null;
        boolean setAddress = this.getParameter("set_address") != null;
        boolean setFio = this.getParameter("set_fio") != null;
        GregorianCalendar now = new GregorianCalendar();
        String namePattern = moduleSetup.get("web.create.name.pattern", "\u0426\u041a00000");
        String contractName = new DecimalFormat(namePattern).format(card.getNumber()) + "-" + TimeUtils.format((Calendar)now, (String)"yy");
        PreparedStatement psSetAddressParam = null;
        if (setAddress && addressPid > 0) {
            if (street > 0 && Utils.notBlankString((String)house) && flat > 0) {
                StringBuffer query = new StringBuffer(300);
                query.append("SELECT address_house.*, address_street.title AS street, ");
                query.append("address_city.title AS city, address_quarter.title AS quarter, address_area.title AS area ");
                query.append("FROM address_house ");
                query.append("INNER JOIN address_street ON address_house.streetid=address_street.id ");
                query.append("LEFT JOIN address_city ON  address_street.cityid=address_city.id ");
                query.append("LEFT JOIN address_quarter ON address_house.quarterid=address_quarter.id ");
                query.append("LEFT JOIN address_area ON address_house.areaid=address_area.id ");
                query.append("WHERE address_house.house=");
                query.append(house);
                if (frac != null && frac.length() > 0) {
                    query.append(" AND frac='");
                    query.append(frac);
                    query.append("'");
                }
                query.append(" AND address_house.streetid=");
                query.append(street);
                ps = this.con.prepareStatement(query.toString());
                rs = ps.executeQuery();
                if (!rs.next()) {
                    rs.close();
                    ps.close();
                    throw new BGMessageException("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0432\u0430\u043c\u0438 \u0434\u043e\u043c \u043d\u0435 \u0437\u0430\u0432\u0435\u0434\u0435\u043d \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435!");
                }
                AddressStruct addressStruct = new AddressStruct().setIndex(rs.getString("box_index")).setCity(rs.getString("city")).setArea(rs.getString("area")).setQuarter(rs.getString("quarter")).setStreet(rs.getString("street")).setHouse(rs.getString("house")).setFrac(rs.getString("frac")).setFlat(String.valueOf(flat)).setRoom(room).setFloor("").setPod("");
                String q = "INSERT INTO contract_parameter_type_2 SET cid=?, pid=?, hid=?, flat=?, room=?, address=?";
                psSetAddressParam = this.con.prepareStatement(q);
                psSetAddressParam.setInt(2, addressPid);
                psSetAddressParam.setInt(3, rs.getInt("id"));
                psSetAddressParam.setInt(4, flat);
                psSetAddressParam.setString(5, room);
                psSetAddressParam.setString(6, AddressUtils.getAddress((Preferences)this.setup, (AddressStruct)addressStruct, (String)("cp." + addressPid)));
                rs.close();
                ps.close();
            } else {
                throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u0434\u043e\u043c\u0430 \u0438 \u0443\u043b\u0438\u0446\u0443 \u0438 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u0443!");
            }
        }
        Contract contract = null;
        try (ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());){
            ContractCreateData data = new ContractCreateData().setPatternId(patternId).setTitle(contractName).setDateFrom(now.getTime()).setPassword(card.getPassword());
            contract = contractDao.createFromPattern(data, true);
        }
        catch (Exception e) {
            throw new BGException(e.getMessage());
        }
        this.cid = contract.getId();
        this.addContract(this.cid, true);
        UserCard userCard = new UserCard().setContractId(this.cid).setNumber(card.getNumber()).setDate1(new Date()).setComment("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c");
        if (allowChange && subscrOffset >= 0) {
            GregorianCalendar date = new GregorianCalendar();
            ((Calendar)date).add(6, subscrOffset);
            userCard.setSubscrDate(TimeUtils.convertCalendarToDate((Calendar)date));
        }
        new UserCardManager(this.con, mid, 0).update((Id)userCard);
        card.setContractId(this.cid);
        cardManager.updateCardContract(card, new Date());
        if (psSetAddressParam != null) {
            psSetAddressParam.setInt(1, this.cid);
            psSetAddressParam.executeUpdate();
            psSetAddressParam.close();
        }
        if (setFio && Utils.notBlankString((String)fio) && fioPid > 0) {
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                contractDao.updateContractParameter(this.cid, (EntityAttr)new EntityAttrText(this.cid, fioPid, fio));
            }
            String query = "UPDATE contract SET comment=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, fio);
            ps.setInt(2, this.cid);
            ps.executeUpdate();
            ps.close();
        }
        ParameterMap pairs = moduleSetup.sub("web.create.packet.");
        for (Map.Entry entry : pairs.entrySet()) {
            int packet = Utils.parseInt((String)((String)entry.getKey()), (int)0);
            Calendar date = null;
            boolean add = false;
            int days = Utils.parseInt((String)((String)entry.getValue()), (int)-1);
            if (days > 0) {
                date = new GregorianCalendar();
                ((Calendar)date).add(6, days);
                add = true;
            } else if (days == 0) {
                add = true;
            } else {
                date = TimeUtils.parseCalendar((String)((String)entry.getValue()), (String)"dd.MM.yyyy");
                boolean bl = add = date != null;
            }
            if (packet == 0 || !add) continue;
            CardPacket cardPacket = new CardPacket();
            cardPacket.setContractId(this.cid);
            cardPacket.setUsercardId(userCard.getId());
            cardPacket.setPacketId(packet);
            cardPacket.setDateFrom(new Date());
            cardPacket.setDateTo(TimeUtils.convertCalendarToDate((Calendar)date));
            new CardPacketManager(this.con, mid).updateCardPacket(cardPacket);
        }
    }

    private void addContract(int cid, boolean created) {
        ContractUtils cu = new ContractUtils(this.con);
        String title = cu.getContractTitle(cid, false, null);
        if (title != null) {
            Element contractEl = this.createElement(this.rootNode, "contract");
            contractEl.setAttribute("title", title);
            contractEl.setAttribute("created", created ? "yes" : "no");
        }
    }
}

