/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.SessionTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusModifiedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.SystemLimitChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.ContractTariffOptionChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.InetServRestrictionModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetServDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.event.InetAccountingPeriodModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.event.InetServModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.DeduplicateDelayQueue;
import ru.bitel.common.util.FrequencyCounter;
import ru.bitel.common.worker.Recyclable;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifiedEvent;

public class EventTrackingWorker
extends AccountingWorkerTask {
    private final Accounting accounting;
    private final SessionTarifficationManager tarifficationManager;
    private static final Map<Integer, ContractEventListener> MODULE_MAP = new HashMap<Integer, ContractEventListener>();
    private final ContractEventListener contractEventListener;
    private final FrequencyCounter processedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private final FrequencyCounter processedContractsPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private static final ThreadLocal<Boolean> workerThread = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTrackingWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, ParameterMap processingParams, ParameterMap defaultParams) {
        super(scheduledExecutorService, "event", processingParams, defaultParams);
        boolean servDeviceState = processingParams.getInt("servDeviceState", 1) > 0;
        boolean payment = processingParams.getInt("payment", 1) > 0;
        long eventProcessDelay = processingParams.getLong("processDelay", 1500L);
        int capacity = processingParams.getInt("capacity", 10000);
        this.getLogger().info("Add event worker: delay=" + this.getDelay() + ", batchSize=" + this.batchSize + ", servDeviceState=" + servDeviceState + ", payment=" + payment + ", processDelay=" + eventProcessDelay + ", capacity=" + capacity);
        this.accounting = accounting;
        this.tarifficationManager = new SessionTarifficationManager(accounting);
        Class<EventTrackingWorker> clazz = EventTrackingWorker.class;
        synchronized (EventTrackingWorker.class) {
            ContractEventListener contractEventListener = MODULE_MAP.get(accounting.moduleId);
            if (contractEventListener == null) {
                try {
                    contractEventListener = new ContractEventListener(accounting.moduleId, servDeviceState, payment, eventProcessDelay, capacity);
                    MODULE_MAP.put(accounting.moduleId, contractEventListener);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
            this.contractEventListener = contractEventListener;
            // ** MonitorExit[var10_9] (shouldn't be in output)
            return;
        }
    }

    public static boolean isWorkerThread() {
        return workerThread.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl() {
        InetTariffWorkerContext workerContext = new InetTariffWorkerContext(this.tarifficationManager.accounting.setup, this.tarifficationManager.accounting.moduleId);
        ThreadContext parentContext = ThreadContext.push((ThreadContext)workerContext);
        workerThread.set(Boolean.TRUE);
        try {
            this.runImpl(workerContext);
            workerContext.commit();
            if (parentContext != null && parentContext instanceof ServerContext) {
                ((ServerContext)parentContext).commit();
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            workerThread.remove();
            ThreadContext.pop((ThreadContext)workerContext, (ThreadContext)parentContext);
            if (parentContext != null && parentContext instanceof Recyclable) {
                ((Recyclable)parentContext).recycle();
            }
        }
    }

    private void runImpl(InetTariffWorkerContext workerContext) throws BGException, InterruptedException {
        Task task;
        this.getLogger().trace("Run event processing...");
        long millis = System.currentTimeMillis();
        Long hour = InetUtils.getHour(millis);
        ConnectionSet connectionSet = workerContext.getConnectionSet();
        EventProcessor ep = EventProcessor.getInstance();
        InetServRuntimeMap inetServRuntimeMap = this.accounting.inetServRuntimeMap;
        InetDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
        HashSet<Integer> processedContractIds = new HashSet<Integer>();
        int count = 0;
        int contractCount = 0;
        int batchSize = this.batchSize;
        while (count < batchSize && (task = (Task)this.contractEventListener.contractIdQueue.poll(200L, TimeUnit.MILLISECONDS)) != null) {
            Integer contractId = task.contractId;
            boolean contractProcessed = false;
            if (task.inetServId <= 0) {
                List<InetServRuntime> inetServRuntimeList;
                if (!processedContractIds.add(contractId) || (inetServRuntimeList = inetServRuntimeMap.list(contractId)) == null) continue;
                this.getLogger().info("process contract " + task.contractId);
                int size = inetServRuntimeList.size();
                for (int i = 0; i < size; ++i) {
                    if (!this.process(ep, workerContext, connectionSet, rootDeviceRuntime, this.tarifficationManager, inetServRuntimeList.get(i), hour, millis, false)) continue;
                    contractProcessed = true;
                    ++count;
                }
            } else {
                InetServRuntime inetServRuntime = inetServRuntimeMap.get(task.inetServId);
                if (inetServRuntime == null) continue;
                this.getLogger().info("process inetServ " + task.inetServId);
                if (this.process(ep, workerContext, connectionSet, rootDeviceRuntime, this.tarifficationManager, inetServRuntime, hour, millis, true)) {
                    ++count;
                }
            }
            if (!contractProcessed) continue;
            ++contractCount;
        }
        long millis2 = System.currentTimeMillis();
        long duration = millis2 - millis;
        this.processedPerMinute.add(millis2, (long)count);
        this.processedContractsPerMinute.add(millis2, (long)contractCount);
        this.processTimePerMinute.add(millis2, duration);
        this.processTimePerTenMinutes.add(millis2, duration);
        this.invokePerMinute.add(millis2, 1L);
        this.invokePerTenMinutes.add(millis2, 1L);
        if (count > 0 && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Processed {} inetServs for {} ms.", (Object)count, (Object)duration);
        }
    }

    private boolean process(EventProcessor ep, InetTariffWorkerContext workerContext, ConnectionSet connectionSet, InetDeviceRuntime rootDeviceRuntime, SessionTarifficationManager tarifficationManager, InetServRuntime inetServRuntime, Long hour, long millis, boolean connections) throws BGException {
        InetServ inetServ = inetServRuntime.getInetServ();
        if (inetServ.getDeviceId() != rootDeviceRuntime.inetDeviceId.intValue() && !rootDeviceRuntime.descendantIds.contains(inetServ.getDeviceId())) {
            return false;
        }
        List<InetConnectionRuntime> connectionRuntimeList = inetServRuntime.getConnectionList();
        if (connectionRuntimeList != null) {
            for (InetConnectionRuntime connectionRuntime : connectionRuntimeList) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("EventTrackingWorker: Tarifficating session " + (connectionRuntime.connection != null ? " for connection " + connectionRuntime.connection.getId() : "id " + connectionRuntime.sessionId));
                }
                if (this.process(workerContext, connectionSet, tarifficationManager, connectionRuntime, hour, millis, true, 200L)) {
                    connections = true;
                    continue;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("EventTrackingWorker: Tracking session " + (connectionRuntime.connection != null ? " for connection " + connectionRuntime.connection.getId() : "id " + connectionRuntime.sessionId));
                }
                if (!this.trackingProcess(this.accounting, connectionSet, connectionRuntime, hour, millis, 200L, true)) continue;
                connections = true;
            }
        }
        if (connections) {
            return true;
        }
        this.trackingProcess(this.accounting, connectionSet, ep, null, inetServRuntime, millis, null, false, false, 200L);
        return true;
    }

    @MBeanAttribute
    public long getQueueSize() {
        return this.contractEventListener.contractIdQueue.size();
    }

    @MBeanAttribute
    public long getProcessedPerMinute() {
        return this.processedPerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getProcessedContractsPerMinute() {
        return this.processedContractsPerMinute.get(System.currentTimeMillis());
    }

    private class ContractEventListener
    implements EventListener<Event> {
        private final long eventProcessDelay;
        private final int capacity;
        public final DeduplicateDelayQueue<Task> contractIdQueue = new DeduplicateDelayQueue();

        public ContractEventListener(int moduleId, boolean servDeviceState, boolean payment, long eventProcessDelay, int capacity) throws BGException {
            this.eventProcessDelay = eventProcessDelay;
            this.capacity = capacity;
            EventProcessor ep = EventProcessor.getInstance();
            ep.addListener((EventListener)this, ContractTariffOptionChangedEvent.class);
            ep.addListener((EventListener)this, ProductPeriodModifiedEvent.class);
            ep.addListener((EventListener)this, ContractStatusChangedTopicEvent.class);
            ep.addListener((EventListener)this, ContractStatusModifiedEvent.class);
            ep.addListener((EventListener)this, ContractModifiedEvent.class);
            ep.addListener((EventListener)this, ContractTariffChangedEvent.class);
            ep.addListener((EventListener)this, SystemLimitChangedEvent.class);
            ep.addListener((EventListener)this, InetServModifiedEvent.class, moduleId, null);
            if (servDeviceState) {
                ep.addListener((EventListener)this, InetServDeviceStateAndOptionsModifiedEvent.class, moduleId, null);
            }
            ep.addListener((EventListener)this, InetAccountingPeriodModifiedEvent.class, moduleId, null);
            ep.addListener((EventListener)this, InetServRestrictionModifiedEvent.class, moduleId, null);
            if (payment) {
                ep.addListener((EventListener)this, ContractBalanceChangedEvent.class, 0, null);
            }
        }

        public void notify(Event e, EventListenerContext ctx) throws BGException {
            List<InetServRuntime> inetServRuntimeList;
            assert (e.getContractId() != 0);
            int contractId = Integer.MIN_VALUE;
            int inetServId = 0;
            long eventProcessDelay = this.eventProcessDelay;
            if (e instanceof InetServDeviceStateAndOptionsModifiedEvent) {
                InetServDeviceStateAndOptionsModifiedEvent ee = (InetServDeviceStateAndOptionsModifiedEvent)e;
                if (ee.getDeviceState() == InetServState.STATE_NULL.getCode()) {
                    return;
                }
                inetServId = ((InetServDeviceStateAndOptionsModifiedEvent)e).getServId();
                if (e.getContractId() > 0) {
                    contractId = e.getContractId();
                } else {
                    InetServRuntime inetServRuntime = EventTrackingWorker.this.accounting.inetServRuntimeMap.get(inetServId);
                    if (inetServRuntime == null) {
                        return;
                    }
                    contractId = inetServRuntime.contractRuntime.contractId;
                }
                eventProcessDelay += 3100L;
            } else if (e instanceof ContractBalanceChangedEvent && ((ContractBalanceChangedEvent)e).getType() != 3) {
                return;
            }
            if (contractId == Integer.MIN_VALUE) {
                contractId = e.getContractId();
            }
            if ((inetServRuntimeList = EventTrackingWorker.this.accounting.inetServRuntimeMap.list(contractId)) == null) {
                return;
            }
            Task t = new Task(contractId, inetServId, System.currentTimeMillis() + eventProcessDelay);
            int size = this.contractIdQueue.size();
            if (size > this.capacity) {
                size = Math.max(10, size - this.capacity - 1);
                if (this.contractIdQueue.poll() != null) {
                    this.contractIdQueue.drainTo(new ArrayList(size), size);
                }
            }
            if (EventTrackingWorker.this.getLogger().isDebugEnabled()) {
                EventTrackingWorker.this.getLogger().debug("caught event " + e.getClass().getSimpleName() + ". Add contract " + contractId + " to queue for processing");
            }
            this.contractIdQueue.offer((Delayed)t);
        }
    }

    private static final class Task
    implements Delayed {
        final int contractId;
        final int inetServId;
        final long time;

        public Task(int contractId, int inetServId, long time) {
            this.contractId = contractId;
            this.inetServId = inetServId;
            this.time = time;
        }

        @Override
        public int compareTo(Delayed o) {
            Task t = (Task)o;
            return Long.compare(this.time, t.time);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        public int hashCode() {
            return 31 * (31 + this.contractId) + this.inetServId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Task other = (Task)obj;
            return this.contractId == other.contractId && this.inetServId == other.inetServId;
        }
    }
}

