package ru.bitel.bgbilling.modules.inet.dyn.device.cisco;

import java.util.List;

import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.common.Utils;

public class CiscoUtils
{
	/**
	 * Извлечение строкового аттрибута. Если значение лежит в cisco-avpair, то используется prefix для поиска и извлечения значения.
	 * В других случаях просто возвращается значение атрибута.
	 * @param packet RADIUS-пакет.
	 * @param vendor RADIUS-vendor атрибута.
	 * @param type тип RADIUS-атрибута.
	 * @param prefix префикс, если атрибут - это cisco-avpair.
	 * @param defaultValue - значение по умолчанию.
	 * @return
	 */
	public static String getStringAttribute( final RadiusPacket packet, final int vendor, final int type, final String prefix, final String defaultValue )
	{
		// если значение находится в cisco-avpair - то нужно искать по префиксу
		if ( type == 1 )
		{
			// смотрим во всех cisco-avpair атрибутах
			final List<RadiusAttribute<?>> attributes = packet.getAttributes( vendor, type );
			if ( attributes != null )
			{
				for ( RadiusAttribute<?> attr : attributes )
				{
					@SuppressWarnings("unchecked")
					final String value = ((RadiusAttribute<String>)attr).getValue();
					if ( value.startsWith( prefix ) )
					{
						return value.substring( prefix.length() );
					}
				}
			}

			return defaultValue;
		}
		else
		{
			return packet.getStringAttribute( vendor, type, defaultValue );
		}
	}

	/**
	 * NAS-Port-Id=0/0/0/10.802
	 * @param nasPortId
	 * @return
	 */
	public static int[] getVlanFromNasPortId( String nasPortId )
	{
		int i = nasPortId.lastIndexOf( "/" );
		if ( i < 0 )
		{
			return null;
		}

		nasPortId = nasPortId.substring( i + 1 );

		int vlan;
		int svlan;

		i = nasPortId.lastIndexOf( "." );
		if ( i < 0 )
		{
			vlan = Utils.parseInt( nasPortId );
			svlan = 0;
		}
		else
		{
			vlan = Utils.parseInt( nasPortId.substring( 0, i ) );
			svlan = Utils.parseInt( nasPortId.substring( i + 1 ) );
		}

		return new int[] { vlan, svlan };
	}
}
