/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.task;

import java.sql.Connection;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Card;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardManager;
import ru.bitel.common.TimeUtils;

public class CardContractSetter
extends TaskBase {
    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Cerbercrypt. \u0417\u0430\u0434\u0430\u0447\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043a\u0430\u0440\u0442\u0430\u043c. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             Connection conSlave = this.setup.getDBSlaveConnectionFromPool();){
            this.getLogger().info("card contract updating...");
            CardManager cardManager = new CardManager(con, this.moduleId, 0);
            CardManager cardManagerSlave = new CardManager(conSlave, this.moduleId, 0);
            List<Card> fullCardList = cardManagerSlave.getFullCardList();
            this.getLogger().info("full card list size: " + fullCardList.size());
            for (Card card : fullCardList) {
                if (!cardManager.updateCardContract(card, TimeUtils.convertCalendarToDate((Calendar)this.getOperatingTime()))) continue;
                this.getLogger().info("card " + card.getNumber() + " was updated: contract=" + String.valueOf(card.getContractId() > 0 ? Integer.valueOf(card.getContractId()) : "unset"));
            }
        }
        catch (Exception e) {
            this.getLogger().error("error CardContractSetter task", (Throwable)e);
        }
    }
}

