/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access;

import bitel.billing.server.util.ConsoleTable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingEvent;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingManageEvent;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingManagePoolEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventProcessorException;
import ru.bitel.bgbilling.kernel.event.MessageHandler;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetConnectionStatus;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetConnectionDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetConnectionCommandEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaConnectionCloseEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.concurrent.ConcurrentUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.CopyOnWriteListMap;
import ru.bitel.common.util.TimeoutMapOld;

public class InetConnectionManager
extends BGLogger
implements EventListener<Event>,
CommandListener {
    private final TimeoutMapOld<IdKey, Boolean> stoppedConnectionIds;
    private final Access access;
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentMap<Integer, ConcurrentMap<Long, InetConnectionRuntime>> deviceConnectionIdMap;
    private final ConcurrentMap<Integer, ConcurrentMap<String, InetConnectionRuntime>> deviceConnectionMap;
    private final CopyOnWriteListMap<Integer, InetConnectionRuntime> inetServConnectionMap;
    private final CopyOnWriteListMap<Long, InetConnection> serviceConnectionMap;
    private final CopyOnWriteListMap<String, InetConnectionRuntime> callingStationIdConnectionMap;
    private final ConcurrentMap<Integer, PoolEventPublisher<InetAccountingManagePoolEvent>> inetAccountingManagePoolEpMap = new ConcurrentHashMap<Integer, PoolEventPublisher<InetAccountingManagePoolEvent>>();
    private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetConnectionManager(Access access, Connection con) throws BGException {
        this.access = access;
        this.deviceConnectionIdMap = new ConcurrentHashMap<Integer, ConcurrentMap<Long, InetConnectionRuntime>>();
        this.deviceConnectionMap = new ConcurrentHashMap<Integer, ConcurrentMap<String, InetConnectionRuntime>>();
        this.inetServConnectionMap = new CopyOnWriteListMap(512, 2);
        this.serviceConnectionMap = new CopyOnWriteListMap(128, 4);
        this.callingStationIdConnectionMap = new CopyOnWriteListMap(512, 1);
        this.stoppedConnectionIds = new TimeoutMapOld(new DelayQueue(), access.getScheduledExecutorService(), 180L, 30L, TimeUnit.SECONDS);
        this.lock.lock();
        try {
            boolean grouping;
            InetDeviceRuntime rootDeviceRuntime = access.deviceMap.get(access.rootDeviceId);
            if (rootDeviceRuntime != null) {
                grouping = rootDeviceRuntime.config.getInt("access.group", 0) == 1;
            } else {
                boolean bl = grouping = access.setup.getInt("access.group", 0) == 1;
            }
            if (grouping) {
                if (access.accountingRootDeviceIds.size() > 0) {
                    EventProcessor.getInstance().addListener((EventListener)this, InetAccountingEvent.class, access.moduleId, this.access.accountingRootDeviceIdsQuery);
                } else {
                    this.getLogger().error("No accounting root devices found.");
                }
                EventProcessor.getInstance().addListener((EventListener)this, InetConnectionDeviceStateAndOptionsModifiedEvent.class, access.moduleId, "rootDeviceId=" + access.rootDeviceId);
            } else {
                EventProcessor.getInstance().addListener((EventListener)this, InetAccountingEvent.class, access.moduleId, null);
                EventProcessor.getInstance().addListener((EventListener)this, InetConnectionDeviceStateAndOptionsModifiedEvent.class, access.moduleId, null);
            }
            if (access.accountingRootDeviceIds.size() <= 5) {
                for (Integer accountingRootDeviceId : access.accountingRootDeviceIds) {
                    this.getManageEventPublisher(accountingRootDeviceId);
                }
            }
            InetConnectionDao inetConnectionDao = new InetConnectionDao(con, access.moduleId);
            this.getLogger().info("Loading connections from database.");
            List<InetConnection> connectionList = grouping ? inetConnectionDao.list(access.childrenDeviceIds, true) : inetConnectionDao.list(null, true);
            block7: for (InetConnection connection : connectionList) {
                ConcurrentHashMap<Long, InetConnectionRuntime> deviceConnectionIdMap;
                switch (connection.getConnectionStatus()) {
                    case STATUS_ALIVE: 
                    case STATUS_SUSPENDED: {
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                ConcurrentHashMap<String, InetConnectionRuntime> deviceConnectionMap = (ConcurrentHashMap<String, InetConnectionRuntime>)this.deviceConnectionMap.get(connection.getDeviceId());
                if (deviceConnectionMap == null) {
                    deviceConnectionMap = new ConcurrentHashMap<String, InetConnectionRuntime>();
                    this.deviceConnectionMap.put(connection.getDeviceId(), deviceConnectionMap);
                }
                if ((deviceConnectionIdMap = (ConcurrentHashMap<Long, InetConnectionRuntime>)this.deviceConnectionIdMap.get(connection.getDeviceId())) == null) {
                    deviceConnectionIdMap = new ConcurrentHashMap<Long, InetConnectionRuntime>();
                    this.deviceConnectionIdMap.put(connection.getDeviceId(), deviceConnectionIdMap);
                }
                InetConnectionRuntime connectionRuntime = new InetConnectionRuntime(connection);
                deviceConnectionIdMap.put(connection.getId(), connectionRuntime);
                String acctSessionId = connection.getAcctSessionId();
                if (acctSessionId != null) {
                    deviceConnectionMap.put(connection.getAcctSessionId(), connectionRuntime);
                }
                this.inetServConnectionMap.add((Object)connection.getServId(), (Object)connectionRuntime);
                if (connection.getParentConnectionId() > 0L) {
                    this.serviceConnectionMap.add((Object)connection.getParentConnectionId(), (Object)connection);
                }
                if (Utils.notEmptyString((String)connection.getCallingStationId())) {
                    this.callingStationIdConnectionMap.add((Object)connection.getCallingStationId(), (Object)connectionRuntime);
                }
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Restore connection: " + String.valueOf(connection));
            }
            Application.getInstance().getCommandPortListener().addListener((CommandListener)this);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Event _e, EventListenerContext ctx) throws BGException {
        block18: {
            this.lock.lock();
            try {
                if (_e instanceof InetAccountingEvent) {
                    InetAccountingEvent e = (InetAccountingEvent)_e;
                    InetConnection connection = e.getConnection();
                    switch (e.getType()) {
                        case 1: {
                            this.add(connection);
                            break;
                        }
                        case 2: {
                            this.remove(connection);
                            break;
                        }
                        case 3: {
                            this.update(connection);
                            break;
                        }
                    }
                    break block18;
                }
                if (!(_e instanceof InetConnectionDeviceStateAndOptionsModifiedEvent)) break block18;
                InetConnectionDeviceStateAndOptionsModifiedEvent e = (InetConnectionDeviceStateAndOptionsModifiedEvent)_e;
                this.getLogger().info("Processing event " + String.valueOf(e));
                Integer servId = e.getServId();
                InetServRuntime servRuntime = this.access.inetServRuntimeMap.get(servId);
                if (servRuntime == null) {
                    this.getLogger().info("InetServRuntime not found with id=" + servId + " for con opt/state modify");
                    return;
                }
                servRuntime.lock();
                try {
                    List<InetConnectionRuntime> connections;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Updating the connection runtime state and/or options");
                    }
                    if ((connections = this.getByServId(e.getServId())) == null) break block18;
                    for (InetConnectionRuntime connectionRuntime : connections) {
                        InetConnection connection = connectionRuntime.connection;
                        if (connection.getId() != e.getConnectionId()) continue;
                        this.getLogger().info("Processing connection " + connection.getId());
                        if (e.getDeviceState() != InetServState.STATE_NULL.getCode()) {
                            this.getLogger().info("Changing state to " + e.getDeviceState());
                            connection.setDeviceState(e.getDeviceState());
                            InetConnection.setType((InetConnection)connection, (int)8, (boolean)true);
                        }
                        if (e.getDeviceOptions() != null) {
                            this.getLogger().info("Changing options to " + Utils.toString((Iterable)e.getDeviceOptions()));
                            connection.setDeviceOptions(e.getDeviceOptions());
                        }
                        break;
                    }
                }
                finally {
                    servRuntime.unlock();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void update(InetConnection connection) throws BGException {
        List list = this.inetServConnectionMap.get((Object)connection.getServId());
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                InetConnectionRuntime connectionRuntime = (InetConnectionRuntime)list.get(i);
                InetConnection oldConnection = connectionRuntime.connection;
                if (oldConnection.getId() != connection.getId()) continue;
                if (oldConnection.getInetAddressBytes() == null || oldConnection.getInetAddressBytes().length == 0) {
                    this.getLogger().info("Update connection: " + String.valueOf(oldConnection));
                    oldConnection.setInetAddressBytes(connection.getInetAddressBytes());
                    EventProcessor.getInstance().request((QueueEvent)new ConnectionUpdateEvent(oldConnection));
                }
                return;
            }
        }
        if (!this.stoppedConnectionIds.containsKey((Object)new IdKey(this, connection.getId(), 0L))) {
            this.add(connection);
        } else {
            this.getLogger().warn("Connection was closed but update event recieved. Discard");
        }
    }

    private InetConnectionRuntime add(InetConnection connection) throws BGException {
        String login;
        InetServRuntime inetServRuntime;
        String username;
        ConcurrentMap<Long, InetConnectionRuntime> deviceConnectionIdMap;
        ConcurrentMap<String, InetConnectionRuntime> deviceConnectionMap = (ConcurrentHashMap<String, InetConnectionRuntime>)this.deviceConnectionMap.get(connection.getDeviceId());
        if (deviceConnectionMap == null) {
            ConcurrentHashMap<String, InetConnectionRuntime> newDeviceConnectionMap = new ConcurrentHashMap<String, InetConnectionRuntime>(64);
            deviceConnectionMap = this.deviceConnectionMap.putIfAbsent(connection.getDeviceId(), newDeviceConnectionMap);
            if (deviceConnectionMap == null) {
                deviceConnectionMap = newDeviceConnectionMap;
            }
        }
        if ((deviceConnectionIdMap = (ConcurrentHashMap<Long, InetConnectionRuntime>)this.deviceConnectionIdMap.get(connection.getDeviceId())) == null) {
            ConcurrentHashMap<Long, InetConnectionRuntime> newDeviceConnectionIdMap = new ConcurrentHashMap<Long, InetConnectionRuntime>(64);
            deviceConnectionIdMap = this.deviceConnectionIdMap.putIfAbsent(connection.getDeviceId(), newDeviceConnectionIdMap);
            if (deviceConnectionIdMap == null) {
                deviceConnectionIdMap = newDeviceConnectionIdMap;
            }
        }
        if ((username = connection.getUsername()) != null && (inetServRuntime = this.access.inetServRuntimeMap.get(connection.getServId())) != null && username.equals(login = inetServRuntime.getInetServ().getLogin())) {
            connection.setUsername(login);
        }
        InetConnectionRuntime connectionRuntime = new InetConnectionRuntime(connection);
        deviceConnectionIdMap.putIfAbsent(connection.getId(), connectionRuntime);
        if (connection.getAcctSessionId() != null) {
            deviceConnectionMap.putIfAbsent(connection.getAcctSessionId(), connectionRuntime);
        }
        boolean added = this.inetServConnectionMap.addIfAbsent((Object)connection.getServId(), (Object)connectionRuntime);
        if (connection.getParentConnectionId() > 0L) {
            this.serviceConnectionMap.addIfAbsent((Object)connection.getParentConnectionId(), (Object)connection);
        }
        if (Utils.notEmptyString((String)connection.getCallingStationId())) {
            this.callingStationIdConnectionMap.addIfAbsent((Object)connection.getCallingStationId(), (Object)connectionRuntime);
        }
        if (added) {
            this.getLogger().info("Add connection: " + String.valueOf(connection));
            EventProcessor.getInstance().request((QueueEvent)new ConnectionAddEvent(connection));
        } else {
            this.getLogger().info("Already added: " + String.valueOf(connection));
        }
        return connectionRuntime;
    }

    void remove(InetConnection connection) throws BGException {
        ConcurrentMap deviceConnectionMap;
        InetConnectionRuntime connectionRuntime = new InetConnectionRuntime(connection);
        ConcurrentMap deviceConnectionIdMap = (ConcurrentMap)this.deviceConnectionIdMap.get(connection.getDeviceId());
        if (deviceConnectionIdMap != null) {
            deviceConnectionIdMap.remove(connection.getId(), connectionRuntime);
        }
        if ((deviceConnectionMap = (ConcurrentMap)this.deviceConnectionMap.get(connection.getDeviceId())) != null && connection.getAcctSessionId() != null) {
            deviceConnectionMap.remove(connection.getAcctSessionId(), connectionRuntime);
        }
        this.inetServConnectionMap.remove((Object)connection.getServId(), (Object)connectionRuntime);
        if (connection.getParentConnectionId() > 0L) {
            this.serviceConnectionMap.remove((Object)connection.getParentConnectionId(), (Object)connection);
        }
        if (Utils.notEmptyString((String)connection.getCallingStationId())) {
            this.callingStationIdConnectionMap.remove((Object)connection.getCallingStationId(), (Object)connectionRuntime);
        }
        this.stoppedConnectionIds.put((Object)new IdKey(this, connection.getId(), System.currentTimeMillis() + 60000L), (Object)Boolean.TRUE);
        this.getLogger().info("Remove connection: " + String.valueOf(connection));
        EventProcessor.getInstance().request((QueueEvent)new ConnectionRemoveEvent(connection));
    }

    public InetConnection getByDeviceAcctSessionId(int deviceId, String acctSessionId) {
        ConcurrentMap deviceConnectionMap = (ConcurrentMap)this.deviceConnectionMap.get(deviceId);
        if (deviceConnectionMap != null) {
            InetConnectionRuntime result = (InetConnectionRuntime)deviceConnectionMap.get(acctSessionId);
            return result != null ? result.connection : null;
        }
        return null;
    }

    public InetConnectionRuntime get(int deviceId, Long connectionId) {
        ConcurrentMap deviceConnectionIdMap = (ConcurrentMap)this.deviceConnectionIdMap.get(deviceId);
        if (deviceConnectionIdMap != null) {
            return (InetConnectionRuntime)deviceConnectionIdMap.get(connectionId);
        }
        return null;
    }

    public InetConnectionRuntime getByServ(int servId, long connectionId) {
        List<InetConnectionRuntime> connectionRuntimeList = this.getByServId(servId);
        if (connectionRuntimeList == null) {
            return null;
        }
        if (connectionRuntimeList.size() > 30 && connectionRuntimeList.size() > this.deviceConnectionIdMap.size()) {
            for (Map map : this.deviceConnectionIdMap.values()) {
                InetConnectionRuntime connectionRuntime = (InetConnectionRuntime)map.get(connectionId);
                if (connectionRuntime == null) continue;
                if (connectionRuntime.connection.getServId() == servId) {
                    return connectionRuntime;
                }
                break;
            }
        } else {
            int size = connectionRuntimeList.size();
            for (int i = 0; i < size; ++i) {
                InetConnectionRuntime connectionRuntime = connectionRuntimeList.get(i);
                if (connectionRuntime.connection.getId() != connectionId) continue;
                return connectionRuntime;
            }
        }
        return null;
    }

    public List<InetConnectionRuntime> getByServId(Integer id) {
        return this.inetServConnectionMap.get((Object)id);
    }

    public Set<Map.Entry<Integer, List<InetConnectionRuntime>>> inetServEntrySet() {
        return this.inetServConnectionMap.entrySet();
    }

    public Set<Map.Entry<Integer, ConcurrentMap<String, InetConnectionRuntime>>> deviceConnectionEntrySetOld() {
        return this.deviceConnectionMap.entrySet();
    }

    public Set<Map.Entry<Integer, ConcurrentMap<Long, InetConnectionRuntime>>> deviceConnectionEntrySet() {
        return this.deviceConnectionIdMap.entrySet();
    }

    public List<InetConnection> getServiceSessions(Long id) {
        return this.serviceConnectionMap.get((Object)id);
    }

    public void removeListeners() throws BGException {
        EventProcessor.getInstance().removeListener((EventListener)this);
    }

    public void destroy() throws BGException {
        Application.getInstance().getCommandPortListener().removeListener((CommandListener)this);
        this.deviceConnectionIdMap.clear();
        this.deviceConnectionMap.clear();
        this.inetServConnectionMap.clear();
        this.serviceConnectionMap.clear();
        this.callingStationIdConnectionMap.clear();
        for (PoolEventPublisher p : this.inetAccountingManagePoolEpMap.values()) {
            p.close();
        }
        this.inetAccountingManagePoolEpMap.clear();
    }

    public InetConnection accountingStart(InetServ inetServ, InetConnection connection, long timeout) throws BGException {
        int accountingRootDeviceId = this.access.getAccountingRootDeviceId(connection.getDeviceId());
        InetAccountingManageEvent e = new InetAccountingManageEvent(this.access.moduleId, inetServ.getContractId(), -1, accountingRootDeviceId, connection, 1, timeout);
        e = (InetAccountingManageEvent)EventProcessor.getInstance().request((Event)e, timeout);
        if (e != null) {
            InetConnection result = e.getConnection();
            InetConnectionRuntime connectionRuntime = this.add(result);
            connectionRuntime.setWantDeviceState(connection.getDeviceState());
            return result;
        }
        throw new BGException("accountingStart: timeout waiting for answer from InetAccounting for servId:" + inetServ.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void accountingStop(InetServ inetServ, InetConnection connection, long timeout) throws BGException {
        int accountingRootDeviceId = this.access.getAccountingRootDeviceId(connection.getDeviceId());
        InetAccountingManageEvent e = new InetAccountingManageEvent(this.access.moduleId, inetServ.getContractId(), -1, accountingRootDeviceId, connection, 2, timeout);
        if (timeout > 0L) {
            e = (InetAccountingManageEvent)EventProcessor.getInstance().request((Event)e, timeout);
            if (e == null) throw new BGException("accountingStop: timeout waiting for answer from InetAccounting!");
            this.remove(e.getConnection());
            return;
        } else {
            EventProcessor.getInstance().publish((Event)e);
        }
    }

    public void accountingUpdate(InetServ inetServ, InetConnection connection) throws BGException {
        int accountingRootDeviceId = this.access.getAccountingRootDeviceId(connection.getDeviceId());
        EventProcessor.getInstance().publish((Event)new InetAccountingManageEvent(this.access.moduleId, inetServ.getContractId(), -1, accountingRootDeviceId, connection, 3, 0L));
    }

    private PoolEventPublisher<InetAccountingManagePoolEvent> getManageEventPublisher(final Integer accountingRootDeviceId) {
        PoolEventPublisher p = (PoolEventPublisher)this.inetAccountingManagePoolEpMap.get(accountingRootDeviceId);
        if (p == null) {
            PoolEventPublisher newP = EventProcessor.getInstance().newPoolQueueEventPublisher(InetAccountingManagePoolEvent.class, this.access.moduleId, 500, 500L);
            newP.setMessageHandler(new MessageHandler(){

                public void prepareMessage(Message message) throws JMSException {
                    message.setIntProperty("accountingRootDeviceId", accountingRootDeviceId.intValue());
                }
            });
            p = this.inetAccountingManagePoolEpMap.putIfAbsent(accountingRootDeviceId, (PoolEventPublisher<InetAccountingManagePoolEvent>)newP);
            if (p == null) {
                p = newP;
            } else {
                newP.close();
            }
        }
        return p;
    }

    public void accountingUpdatePool(InetServ inetServ, InetConnection connection) throws BGException {
        Integer accountingRootDeviceId = this.access.getAccountingRootDeviceId(connection.getDeviceId());
        PoolEventPublisher<InetAccountingManagePoolEvent> p = this.getManageEventPublisher(accountingRootDeviceId);
        p.publish((Event)new InetAccountingManagePoolEvent(this.access.moduleId, inetServ.getContractId(), -1, (int)accountingRootDeviceId, connection, 3));
    }

    public String executeCommand(String cmd, String param) {
        String result = null;
        try {
            if ("conlist".equals(cmd)) {
                String[] columns = new String[]{"ID", "NAS_ID", "NAS_IP", "Session", "Start", "UserName", "IP", "FromNum", "Contract", "Status"};
                int[] widths = new int[]{10, 15, 15, 30, 20, 30, 15, 20, 15, 10};
                ConsoleTable table = new ConsoleTable(columns, widths);
                for (Map.Entry<Integer, List<InetConnectionRuntime>> me : this.access.connectionManager.inetServEntrySet()) {
                    for (InetConnectionRuntime connectionRuntime : me.getValue()) {
                        InetConnection connection = connectionRuntime.connection;
                        String[] row = new String[]{String.valueOf(connection.getId()), "DID: " + connection.getDeviceId(), "", connection.getAcctSessionId(), TimeUtils.format((Date)connection.getConnectionStart(), (String)"dd.MM.yyyy HH:mm:ss"), connection.getUsername(), IpAddress.toString((byte[])connection.getInetAddressBytes()), connection.getCallingStationId(), "CID: " + connection.getContractId(), String.valueOf(connection.getConnectionStatus())};
                        table.addRow(row);
                    }
                }
                result = table.toString();
            } else if ("condrop".equals(cmd)) {
                long conId = Utils.parseLong((String)param, (long)-1L);
                if (conId < 0L) {
                    result = "Connection id not defined.";
                } else {
                    InetConnection connection = null;
                    block4: for (Map.Entry<Integer, List<InetConnectionRuntime>> me : this.access.connectionManager.inetServEntrySet()) {
                        for (InetConnectionRuntime connectionRuntime : me.getValue()) {
                            InetConnection con = connectionRuntime.connection;
                            if (con.getId() != conId) continue;
                            connection = con;
                            break block4;
                        }
                    }
                    if (connection == null) {
                        result = "Connection not found.";
                    } else {
                        InetServRuntime servRuntime = this.access.inetServRuntimeMap.get(connection.getServId());
                        if (servRuntime == null) {
                            result = "InetServ not found.";
                        } else {
                            this.accountingStop(servRuntime.getInetServ(), connection, 0L);
                            result = "Drop command sended.";
                        }
                    }
                }
            }
        }
        catch (BGException ex) {
            this.logError(ex);
            result = ex.getMessage();
        }
        return result;
    }

    public String getCommandsHelp() {
        return "conlist - show connections list\n" + "condrop <id> - drop connection with id\n";
    }

    public boolean checkChanged(ConnectionSet connectionSet, List<InetConnectionRuntime> connectionList) throws BGException {
        boolean result = false;
        try (InetConnectionDao connectionDao = new InetConnectionDao(connectionSet.getConnection(), this.access.moduleId);){
            if (connectionList != null) {
                int size = connectionList.size();
                for (int i = 0; i < size; ++i) {
                    InetConnectionRuntime connectionRuntime = connectionList.get(i);
                    InetConnection connection = connectionDao.get(connectionRuntime.connection.getDeviceId(), connectionRuntime.connection.getId());
                    if (connection != null && connection.getConnectionStatus().getCode() < InetConnectionStatus.STATUS_CLOSED.getCode()) continue;
                    this.remove(connectionRuntime.connection);
                    result = true;
                }
            }
        }
        return result;
    }

    public List<InetConnectionRuntime> getAllConnections(List<InetConnectionRuntime> connectionList, List<InetServRuntime> children, String singlesignonRealm) {
        List<InetConnectionRuntime> allConnectionList = connectionList;
        if (children != null && children.size() > 0) {
            allConnectionList = allConnectionList == null ? new ArrayList<InetConnectionRuntime>() : new ArrayList<InetConnectionRuntime>(allConnectionList);
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                List<InetConnectionRuntime> childConnectionList;
                InetServRuntime child = children.get(i);
                if (InetUtils.getSessionCountLimit(child.inetServTypeRef.get().inetServType, child.getInetServ()) > 0 || (childConnectionList = this.getByServId(child.inetServId)) == null || childConnectionList.size() <= 0) continue;
                allConnectionList.addAll(childConnectionList);
            }
        }
        return allConnectionList;
    }

    private List<InetConnectionRuntime> getAllConnections(InetServRuntime inetServRuntime, List<InetServRuntime> children, String singlesignonRealm) {
        List<InetConnectionRuntime> connectionList = this.getByServId(inetServRuntime.inetServId);
        List<InetConnectionRuntime> allConnectionList = this.getAllConnections(connectionList, children, singlesignonRealm);
        if (singlesignonRealm != null && allConnectionList != null) {
            connectionList = new ArrayList<InetConnectionRuntime>();
            int size = allConnectionList.size();
            for (int i = 0; i < size; ++i) {
                InetConnectionRuntime connectionRuntime = allConnectionList.get(i);
                if (!singlesignonRealm.equals(InetUtils.getRealm(connectionRuntime.connection.getUsername()))) continue;
                connectionList.add(connectionRuntime);
            }
            allConnectionList = connectionList;
        }
        return allConnectionList;
    }

    public boolean checkDuplicateSession(int contractId, List<InetConnectionRuntime> connectionList, String sessionIdentifier, boolean username, int checkDuplicateSessionOnSessionLimit) throws BGException {
        if (checkDuplicateSessionOnSessionLimit % 10 > 0 && connectionList != null) {
            int size = connectionList.size();
            for (int i = 0; i < size; ++i) {
                InetConnection connection = connectionList.get((int)i).connection;
                if (connection.getParentConnectionId() > 0L || (username ? !sessionIdentifier.equals(connection.getUsername()) : !sessionIdentifier.equals(connection.getCallingStationId()))) continue;
                this.getLogger().debug("Found duplicate session " + sessionIdentifier + ". Perform close mode=" + checkDuplicateSessionOnSessionLimit % 10);
                EventProcessor ep = EventProcessor.getInstance();
                return this.closeDuplicateSession(contractId, ep, connection, checkDuplicateSessionOnSessionLimit % 10);
            }
        }
        if ((checkDuplicateSessionOnSessionLimit = checkDuplicateSessionOnSessionLimit / 10 % 10) > 0 && connectionList != null && connectionList.size() > 0) {
            Date limitMillis = new Date(System.currentTimeMillis() - 60000L);
            int size = connectionList.size();
            for (int i = 0; i < size; ++i) {
                InetConnection connection = connectionList.get((int)i).connection;
                if (connection.getConnectionStatus() != InetConnectionStatus.STATUS_ALIVE || connection.getDeviceState() != InetServState.STATE_ENABLE.getCode() || connection.getParentConnectionId() > 0L) continue;
                if (connection.getConnectionStart().before(limitMillis)) {
                    this.getLogger().debug("Duplicate session " + sessionIdentifier + " not found. Perform close mode=" + checkDuplicateSessionOnSessionLimit % 10 + " for oldest session.");
                    EventProcessor ep = EventProcessor.getInstance();
                    return this.closeDuplicateSession(contractId, ep, connection, checkDuplicateSessionOnSessionLimit % 10);
                }
                this.getLogger().info("Oldest session started 1 min ago. Skip close oldest session.");
                return false;
            }
        }
        return false;
    }

    private boolean closeDuplicateSession(int contractId, final EventProcessor ep, final InetConnection connection, int checkDuplicateSessionOnSessionLimit) throws BGException {
        this.getLogger().info("Close duplicate session method " + checkDuplicateSessionOnSessionLimit);
        switch (checkDuplicateSessionOnSessionLimit) {
            case 1: {
                ep.publish((Event)new InetSaConnectionCloseEvent(this.access.moduleId, 0, connection));
                break;
            }
            case 2: {
                int accountingRootDeviceId = this.access.getAccountingRootDeviceId(connection.getDeviceId());
                ep.publish((Event)new InetSaConnectionCloseEvent(this.access.moduleId, 0, connection));
                ep.publish((Event)new InetConnectionCommandEvent(this.access.moduleId, 0, accountingRootDeviceId, connection.getDeviceId(), connection.getServId(), connection.getId(), "finish"));
                break;
            }
            case 3: {
                int accountingRootDeviceId = this.access.getAccountingRootDeviceId(connection.getDeviceId());
                ep.publish((Event)new InetConnectionCommandEvent(this.access.moduleId, 0, accountingRootDeviceId, connection.getDeviceId(), connection.getServId(), connection.getId(), "finish"));
                break;
            }
            case 4: {
                ep.publish((Event)new InetSaConnectionCloseEvent(this.access.moduleId, 0, connection));
                EXECUTOR_SERVICE.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int accountingRootDeviceId = InetConnectionManager.this.access.getAccountingRootDeviceId(connection.getDeviceId());
                            ep.publish((Event)new InetConnectionCommandEvent(InetConnectionManager.this.access.moduleId, 0, accountingRootDeviceId, connection.getDeviceId(), connection.getServId(), connection.getId(), "finish"));
                        }
                        catch (Exception ex) {
                            InetConnectionManager.this.logError(ex);
                        }
                    }
                }, 5L, TimeUnit.SECONDS);
                break;
            }
            case 5: {
                int accountingRootDeviceId = this.access.getAccountingRootDeviceId(connection.getDeviceId());
                ep.publish((Event)new InetSaConnectionCloseEvent(this.access.moduleId, 0, connection));
                ep.publish((Event)new InetConnectionCommandEvent(this.access.moduleId, 0, accountingRootDeviceId, connection.getDeviceId(), connection.getServId(), connection.getId(), "finish"));
                return true;
            }
            case 6: {
                int accountingRootDeviceId = this.access.getAccountingRootDeviceId(connection.getDeviceId());
                ep.publish((Event)new InetConnectionCommandEvent(this.access.moduleId, 0, accountingRootDeviceId, connection.getDeviceId(), connection.getServId(), connection.getId(), "finish"));
                return true;
            }
            case 7: {
                long millis = (System.currentTimeMillis() / 1000L - 1L) * 1000L;
                connection.setConnectionStop(new Date(millis));
                if (connection.getConnectionStop().before(connection.getConnectionStart())) {
                    connection.setConnectionStop(connection.getConnectionStart());
                }
                ep.request((Event)new InetSaConnectionCloseEvent(this.access.moduleId, 0, connection), 5000L);
                this.forceConnectionStop(contractId, connection);
                break;
            }
            case 8: {
                long millis = (System.currentTimeMillis() / 1000L - 1L) * 1000L;
                connection.setConnectionStop(new Date(millis));
                if (connection.getConnectionStop().before(connection.getConnectionStart())) {
                    connection.setConnectionStop(connection.getConnectionStart());
                }
                ep.publish((Event)new InetSaConnectionCloseEvent(this.access.moduleId, 0, connection));
                this.forceConnectionStop(contractId, connection);
                return true;
            }
            case 9: {
                long millis = (System.currentTimeMillis() / 1000L - 1L) * 1000L;
                connection.setConnectionStop(new Date(millis));
                if (connection.getConnectionStop().before(connection.getConnectionStart())) {
                    connection.setConnectionStop(connection.getConnectionStart());
                }
                this.forceConnectionStop(contractId, connection);
                return true;
            }
        }
        return false;
    }

    private void forceConnectionStop(int contractId, InetConnection connection) throws BGException {
        ArrayList<Future<InetAccountingManageEvent>> futures = new ArrayList<Future<InetAccountingManageEvent>>();
        List serviceConnectionList = this.serviceConnectionMap.get((Object)connection.getId());
        if (serviceConnectionList != null) {
            int size = serviceConnectionList.size();
            for (int i = 0; i < size; ++i) {
                InetConnection inetConnection = (InetConnection)serviceConnectionList.get(i);
                futures.add(this.accountingStopAsync(contractId, inetConnection, 20000L));
            }
        }
        futures.add(this.accountingStopAsync(contractId, connection, 20000L));
        try {
            boolean result = ConcurrentUtils.awaitFutures(futures, (long)20000L, (TimeUnit)TimeUnit.MILLISECONDS);
            for (Future future : futures) {
                if (!future.isDone() || future.isCancelled()) continue;
                this.remove(((InetAccountingManageEvent)((Object)future.get())).getConnection());
            }
            if (!result) {
                throw new BGException("Timeout exceed!");
            }
        }
        catch (ExecutionException ex) {
            throw new BGException((Throwable)ex);
        }
        catch (InterruptedException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private Future<InetAccountingManageEvent> accountingStopAsync(int contractId, InetConnection connection, long timeout) throws EventProcessorException {
        int accountingRootDeviceId = this.access.getAccountingRootDeviceId(connection.getDeviceId());
        InetAccountingManageEvent e = new InetAccountingManageEvent(this.access.moduleId, contractId, -1, accountingRootDeviceId, connection, 2, timeout);
        return EventProcessor.getInstance().requestAsync((Event)e, timeout);
    }

    public List<InetConnectionRuntime> getByCallingStationId(String callingStationId) {
        return this.callingStationIdConnectionMap.get((Object)callingStationId);
    }

    public static final class ConnectionUpdateEvent
    extends ConnectionAddEvent {
        public ConnectionUpdateEvent(InetConnection con) {
            super(con);
        }
    }

    final class IdKey
    implements Delayed {
        private final long id;
        private final long expire;

        public IdKey(InetConnectionManager this$0, long id, long expire) {
            this.id = id;
            this.expire = expire;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            IdKey other = (IdKey)obj;
            return this.id == other.id;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            IdKey x = (IdKey)other;
            long diff = this.expire - x.expire;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }

    public static class ConnectionAddEvent
    extends LocalEvent {
        private final InetConnection inetConnection;

        public ConnectionAddEvent(InetConnection con) {
            this.inetConnection = con;
        }

        public InetConnection getInetConnection() {
            return this.inetConnection;
        }
    }

    public static final class ConnectionRemoveEvent
    extends ConnectionAddEvent {
        public ConnectionRemoveEvent(InetConnection con) {
            super(con);
        }
    }
}

