/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.BGSbpQrUtils;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.Constants;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.YoomoneyPaymentType;
import ru.bitel.bgbilling.modules.yoomoney.server.event.YoomoneyCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u042e\u041a\u0430\u0441\u0441\u0430")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("yoomoney");
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = new SearchParam().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL)).setPage(this.getPage()).setSort(new String[]{"paymentDateTime:desc"});
        SearchResult searchResult = new SearchResult(searchParam);
        new TransactionManager(this.con, this.moduleId).searchTransactionList((SearchResult<Transaction>)searchResult, searchParam);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432")
    public void check() throws Exception {
        EventProcessor.getInstance().publish((Event)new YoomoneyCheckEvent(this.moduleId, this.contractId, this.req.get("paymentId")));
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        ArrayList<String[]> paymentTypes = new ArrayList<String[]>();
        String paymentTypesString = this.moduleSetup.get("yoomoney.payment.types", null);
        if (paymentTypesString != null) {
            for (String paymentTypeItem : paymentTypesString.split(";")) {
                paymentTypes.add(paymentTypeItem.split(":"));
            }
        } else {
            for (Map.Entry paymentType : this.moduleSetup.subIndexed("paymentType.").entrySet()) {
                String[] paymentTypeData = new String[]{((ParameterMap)paymentType.getValue()).get("paymentType"), ((ParameterMap)paymentType.getValue()).get("title")};
                paymentTypes.add(paymentTypeData);
            }
        }
        if (!paymentTypes.isEmpty()) {
            this.setResultParam("paymentTypes", paymentTypes);
        }
        this.setResultParam("paymentSumAmount", this.moduleSetup.get("yoomoney.payment.sum.amount", this.moduleSetup.get("paymentSumAmount", null)));
        this.setResultParam("paymentSumPercent", Utils.parseInt((String)this.moduleSetup.get("yoomoney.payment.sum.percent", this.moduleSetup.get("paymentSumPercent", "0"))));
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        String contractTitle = this.getContractTitle();
        String formUrl = "";
        if (this.moduleSetup.get("yoomoney.api.key") != null) {
            TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
            boolean sbp = this.moduleSetup.getBoolean("yoomoney.sbp.enable", false) && this.req.getBoolean("sbp", false);
            JSONObject data = transactionManager.getPaymentRequestJSON(this.sum, this.contractId, contractTitle, null, sbp ? YoomoneyPaymentType.SBP : YoomoneyPaymentType.CARD);
            String resultJson = transactionManager.doPaymentRequest(data.toString(), Setup.getSetup().get("billing.name", "") + System.currentTimeMillis());
            if (resultJson == null) {
                this.getLogger().error("resultJson = null");
                this.execute();
                throw new BGMessageException("resultJson = null");
            }
            JSONObject result = new JSONObject(resultJson);
            if (sbp) {
                Object object = result.optQuery("/confirmation/confirmation_data");
                if (object == null) {
                    this.getLogger().error("resultJson = {}", (Object)resultJson);
                    this.execute();
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 QR \u043a\u043e\u0434\u0430 [" + String.valueOf(result.optQuery("/description")) + "]");
                }
                formUrl = String.valueOf(object);
                this.setResultParam("formUrl", formUrl);
                this.setResultParam("qrImgData", BGSbpQrUtils.getSbpQR((String)formUrl));
                this.setResultParam("paymentId", result.optQuery("/payment_method/id"));
                String userAgent = this.context.getRequest().getHeader("User-Agent");
                this.setResultParam("android", BGSbpQrUtils.isAndroid((String)userAgent));
                this.setResultParam("apple", BGSbpQrUtils.isApple((String)userAgent));
                this.requestDispatcher("include", "payment_sbp");
                return;
            }
            formUrl = String.valueOf(result.optQuery("/confirmation/confirmation_url"));
            if (formUrl == null) {
                this.getLogger().error("resultJson = {}", (Object)resultJson);
                this.execute();
                throw new BGMessageException("Error: code=" + String.valueOf(result.optQuery("/code")) + "; description=" + String.valueOf(result.optQuery("/description")));
            }
        } else {
            String merchantReceipt = "";
            if (this.moduleSetup.getBoolean("yoomoney.fiscalization.enable", false)) {
                String customerContact = "";
                if (!Utils.isBlankString((String)this.customerAddress)) {
                    customerContact = this.customerAddress;
                }
                JSONObject priceJSON = new JSONObject().put("amount", (Object)this.sum);
                JSONObject itemJSON = new JSONObject().put("quantity", this.moduleSetup.getInt("yoomoney.fiscalization.receipt.qty", 1)).put("price", (Object)priceJSON).put("tax", this.moduleSetup.getInt("yoomoney.fiscalization.receipt.tax", 2)).put("text", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle)).put("paymentMethodType", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.payment.method.type", "full_prepayment")).put("paymentSubjectType", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.payment.subject.type", "service"));
                JSONArray itemsJSON = new JSONArray().put((Object)itemJSON);
                JSONObject merchantReceiptJSON = new JSONObject().put("customerContact", (Object)customerContact).put("taxSystem", this.moduleSetup.getInt("yoomoney.fiscalization.receipt.tax.system", 1)).put("items", (Object)itemsJSON);
                try {
                    merchantReceipt = "&ym_merchant_receipt=" + URLEncoder.encode(merchantReceiptJSON.toString(), "UTF-8");
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
            String paymentType = this.req.get("paymentType");
            formUrl = this.moduleSetup.get("yoomoney.url", "https://demomoney.yookassa.ru/eshop.xml") + "?mid=" + this.moduleId + "&shopId=" + this.moduleSetup.get("yoomoney.shopId", "") + "&scid=" + this.moduleSetup.get("yoomoney.scid", "") + "&CustomerNumber=" + contractTitle + "&paymentType=" + (paymentType != null ? paymentType : "") + "&Sum=" + this.sum.toPlainString() + "&shopSuccessURL=" + this.moduleSetup.get("yoomoney.shopSuccessURL", "") + "&shopFailURL=" + this.moduleSetup.get("yoomoney.shopFailURL", "") + merchantReceipt;
        }
        try {
            this.setResultParam("contentType", ActionResultContentType.binary);
            this.context.getResponse().sendRedirect(formUrl);
            return;
        }
        catch (IOException ex) {
            this.execute();
            throw new BGMessageException(ex.getMessage());
        }
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        super.autopayment();
        this.autopaymentImpl("yoomoney", new AutopaymentManager(this.con, this.moduleId), Constants.class);
    }

    protected void autopaymentRegisterOrder(BigDecimal sum, String customerAddress) throws Exception {
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        JSONObject data = transactionManager.getPaymentRequestJSON(sum, this.contractId, this.getContractTitle(), null, YoomoneyPaymentType.CARD_SAVE);
        String resultJson = transactionManager.doPaymentRequest(data.toString(), Setup.getSetup().get("billing.name", "") + System.currentTimeMillis());
        if (resultJson != null) {
            JSONObject result = new JSONObject(resultJson);
            String formUrl = String.valueOf(result.optQuery("/confirmation/confirmation_url"));
            if (formUrl == null) {
                this.getLogger().error("resultJson = {}", (Object)resultJson);
                throw new BGMessageException("formUrl = " + formUrl);
            }
            this.setResultParam("formUrl", formUrl);
        }
    }

    protected void autopaymentRedirect(boolean redirect) throws Exception {
        if (redirect) {
            try {
                this.setResultParam("contentType", ActionResultContentType.binary);
                this.context.getResponse().sendRedirect((String)this.getResultParam("formUrl"));
                return;
            }
            catch (IOException ex) {
                this.execute();
                throw new BGMessageException(ex.getMessage());
            }
        }
        this.execute();
    }
}

