/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server.servlet;

import bitel.billing.server.admin.bgsecure.bean.UserLoginModule;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.security.auth.Subject;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.security.server.FindAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantButton;
import ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.worker.ThreadContext;

@WebServlet(name="assistantExecutor", urlPatterns={"/assistant/*"})
public class AssistantExecutor
extends CommonExecutor {
    private static final String[] operations = new String[]{"assistantActionsForUser", "getAssistantActionByActionId", "doShow", "doButton"};
    private static String pluginId = "";

    public void init() throws ServletException {
        super.init();
        PermissionOfRoles.getInstance();
        Optional<BGInstalledModule> installedModule = ModuleCache.getInstance().getInstalledModulesList().stream().filter(m -> m.getTitle().equals("Assistant")).findFirst();
        installedModule.ifPresent(bgInstalledModule -> {
            pluginId = "p" + bgInstalledModule.getId();
        });
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("contextPath", (Object)this.setup.get("context.path", "/bgbilling"));
        HttpSession session = request.getSession(true);
        if (session.getAttribute("userId") == null) {
            this.getLoginAndPassword(request);
            String userName = (String)request.getAttribute("userName");
            String userPswd = (String)request.getAttribute("userPswd");
            if (userName != null && userPswd != null) {
                String userNameIp = String.format("%s [%s]", userName, ServletUtils.getIpFromHeader((HttpServletRequest)request, (Setup)this.setup));
                Object msg = null;
                try {
                    Subject subject = UserLoginModule.auth((String)"executer", (String)userName, (String)userPswd);
                    User user = UserLoginModule.getUser((Subject)subject);
                    if (!this.checkAccess(user)) {
                        msg = "\u041e\u0442\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0435" + userNameIp;
                    } else {
                        request.setAttribute("userId", (Object)user.getId());
                        session.setAttribute("userId", (Object)user.getId());
                    }
                }
                catch (FailedLoginException e) {
                    if (e.getCause() instanceof AuthenticationException) {
                        msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP. \u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c?";
                        this.getLogger().warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP. \u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c?", (Throwable)e);
                    } else if (e.getCause() instanceof CommunicationException) {
                        msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP.";
                        this.getLogger().warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP", (Throwable)e);
                    } else if ("Cannot find user's LDAP entry".equals(e.getMessage())) {
                        msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP.";
                        this.getLogger().warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP", (Throwable)e);
                    } else {
                        msg = e.getLocalizedMessage();
                        this.getLogger().warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438", (Throwable)e);
                    }
                }
                catch (LoginException e) {
                    msg = e.getLocalizedMessage();
                    this.getLogger().warn(userNameIp + " " + e.getMessage());
                }
                if (msg != null) {
                    request.setAttribute("errorMessage", msg);
                    request.getRequestDispatcher("/WEB-INF/jspf/assistant/login.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            }
        }
        if (session.getAttribute("userId") == null) {
            request.getRequestDispatcher("/WEB-INF/jspf/assistant/login.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String path = request.getPathInfo();
        if (path == null || path.isEmpty()) {
            this.requestDispatcher("body", request, response);
        } else if (path.startsWith("/exit")) {
            session.invalidate();
            response.sendRedirect("assistant/menu");
        } else if (path.startsWith("/action/")) {
            this.action(path.substring(8), request, response);
        } else if (path.startsWith("/doButton/")) {
            this.doButton(path.substring(10), request, response);
        } else if (path.startsWith("/contract/")) {
            this.getContracts(path.substring(10), request, response);
        } else if (path.startsWith("/menu")) {
            this.menu(request, response);
        } else if (path.startsWith("/search")) {
            this.search(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menu(HttpServletRequest request, HttpServletResponse response) {
        ServerContext serverContext = this.getServerContext(request);
        try {
            String contractId = request.getParameter("contractId");
            if (contractId != null) {
                this.openContract(contractId, request);
                request.setAttribute("contractId", (Object)contractId);
            }
            AssistantService assistantService = (AssistantService)serverContext.getService(AssistantService.class, -1);
            request.setAttribute("assistantActionItems", (Object)assistantService.assistantMastersForUser(Set.of("web"), -1));
            this.requestDispatcher("menu", request, response);
            serverContext.commit();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            serverContext.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(HttpServletRequest request, HttpServletResponse response) {
        ServerContext serverContext = this.getServerContext(request);
        try {
            String searchTxt = request.getParameter("txt");
            ContractService contractService = (ContractService)serverContext.getService(ContractService.class, 0);
            Contract contract = contractService.contractByTitle(searchTxt);
            request.setAttribute("searchTxt", (Object)searchTxt);
            if (contract != null) {
                request.setAttribute("contract", (Object)contract);
            } else {
                request.setAttribute("message", (Object)"\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            this.requestDispatcher("search", request, response);
            serverContext.commit();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            serverContext.destroy();
        }
    }

    private boolean checkAccess(User user) {
        try {
            int userId = user.getId();
            for (String operation : operations) {
                ModuleAction moduleAction = FindAction.find((String[])new String[]{pluginId}, (String)"AssistantService", (String)operation, new HashMap());
                PermissionOfRoles.getInstance().checkActionAllow(userId, pluginId, moduleAction, AssistantService.class.getSimpleName(), operation, -1, null);
            }
        }
        catch (BGIllegalAccessException ex) {
            this.getLogger().warn("\u041e\u0442\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e ID=" + user.getId() + " => " + ex.getMessage());
            return false;
        }
        catch (BGException ex) {
            this.logError((Exception)((Object)ex));
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void action(String masterActionId, HttpServletRequest request, HttpServletResponse response) {
        ServerContext serverContext = this.getServerContext(request);
        try {
            String data;
            JSONObject showJSON;
            JSONObject fieldValuesJSON;
            String[] actionData = masterActionId.split("/");
            int masterId = Utils.parseInt((String)actionData[0]);
            String actionId = actionData[1];
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("masterActionId={}; masterId={}; actionId={}", new Object[]{masterActionId, masterId, actionId});
            }
            AssistantService assistantService = (AssistantService)serverContext.getService(AssistantService.class, -1);
            AssistantAction assistantAction = assistantService.getAssistantActionByActionId(masterId, actionId);
            request.setAttribute("assistantAction", (Object)assistantAction);
            JSONObject configJsonObject = new JSONObject(assistantAction.getConfig());
            JSONObject options = configJsonObject.optJSONObject("options");
            if (options == null) {
                options = new JSONObject();
            }
            List<Map<String, Object>> fields = this.getFields(configJsonObject.optJSONArray("params"), options);
            JSONObject dataJson = new JSONObject();
            String dataParam = request.getParameter("data");
            JSONObject dataFieldsJSON = new JSONObject(dataParam == null ? "{}" : dataParam);
            dataJson.put("fields", (Object)dataFieldsJSON);
            List contractIds = null;
            Object object = request.getSession().getAttribute("contractIds");
            if (object instanceof List) {
                List list;
                contractIds = list = (List)object;
            }
            dataJson.put("contractId", contractIds != null && !contractIds.isEmpty() ? ((IdTitle)contractIds.get(0)).getId() : 0);
            String paramFields = request.getParameter("fields");
            if (paramFields != null) {
                JSONObject fieldsJSON = new JSONObject(paramFields);
                for (String key : fieldsJSON.keySet()) {
                    dataFieldsJSON.put(key, fieldsJSON.get(key));
                }
            }
            if ((fieldValuesJSON = (showJSON = new JSONObject(data = assistantService.doShow(masterId, actionId, dataJson.toString()))).optJSONObject("fieldValues")) != null) {
                for (Map<String, Object> map : fields) {
                    String key = (String)map.get("key");
                    Object value = fieldValuesJSON.opt(key);
                    if (value == null) continue;
                    String type = String.valueOf(map.get("type"));
                    if ("List".equals(type) || "Combox".equals(type)) {
                        if (!(value instanceof JSONArray)) continue;
                        String selectedKey = null;
                        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
                        JSONArray array = (JSONArray)value;
                        for (int index = 0; index < array.length(); ++index) {
                            JSONObject valuesItem = array.getJSONObject(index);
                            if (valuesItem.has("selected")) {
                                selectedKey = valuesItem.optString("key");
                            }
                            values.add(new KeyValue(valuesItem.optString("key"), valuesItem.optString("value")));
                        }
                        map.put("values", values);
                        if (selectedKey == null) continue;
                        map.put("selectedKey", selectedKey);
                        continue;
                    }
                    if ("Date".equals(type) || "Textarea".equals(type) || "String".equals(type) || "Hidden".equals(type)) {
                        map.put("value", value);
                        continue;
                    }
                    if ("Label".equals(type)) {
                        if (value instanceof JSONArray) {
                            JSONArray array = (JSONArray)value;
                            if (array == null || array.length() <= 0) continue;
                            map.put("value", array.getJSONObject(0).optString("value", ""));
                            continue;
                        }
                        map.put("value", value);
                        continue;
                    }
                    if (!"Period".equals(type) || !(value instanceof JSONObject)) continue;
                    JSONObject periodJSON = (JSONObject)value;
                    map.put("valueFrom", periodJSON.optString("dateFrom"));
                    map.put("valueTo", periodJSON.optString("dateTo"));
                }
            }
            request.setAttribute("message", (Object)configJsonObject.optString("comment", null));
            request.setAttribute("fields", fields);
            request.setAttribute("buttons", this.getButtons(options));
            request.setAttribute("masterId", (Object)masterId);
            serverContext.commit();
            this.requestDispatcher("action", request, response);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            serverContext.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doButton(String buttonInfo, HttpServletRequest request, HttpServletResponse response) {
        String[] data = buttonInfo.split("/");
        int masterId = Utils.parseInt((String)data[0]);
        String actionId = data[1];
        String buttonCode = data[2];
        int contractId = Utils.parseInt((String)request.getParameter("contractId"));
        JSONObject dataJson = new JSONObject();
        dataJson.put("fields", (Object)new JSONObject(request.getParameter("data")));
        dataJson.put("contractId", contractId);
        ServerContext serverContext = this.getServerContext(request);
        try {
            AssistantService assistantService = (AssistantService)serverContext.getService(AssistantService.class, -1);
            String resultOfPressButton = assistantService.doButton(masterId, actionId, dataJson.toString(), buttonCode);
            JSONObject resultJsonObject = new JSONObject(resultOfPressButton);
            JSONObject fieldsOfResponse = resultJsonObject.optJSONObject("fields");
            if (fieldsOfResponse != null) {
                this.openContract(fieldsOfResponse.optString("openContract"), request);
            }
            serverContext.commit();
            response.setContentType("text/json");
            response.getOutputStream().write(resultJsonObject.toString().getBytes("UTF-8"));
        }
        catch (Exception ex) {
            this.logError(ex);
            JSONObject result = new JSONObject();
            result.put("status", (Object)"error");
            result.put("error", (Object)ex.getCause().getMessage());
            response.setContentType("text/json");
            try {
                response.getOutputStream().write(result.toString().getBytes("UTF-8"));
            }
            catch (Exception ex1) {
                this.logError(ex1);
            }
        }
        finally {
            serverContext.destroy();
        }
    }

    private List<IdTitle> resortContractIds(String openContractId, List<IdTitle> contractIds) {
        int contractId = Utils.parseInt((String)openContractId);
        if (contractIds.stream().anyMatch(a -> a.getId() == contractId)) {
            ArrayList<IdTitle> newContractIds = new ArrayList<IdTitle>();
            newContractIds.add(contractIds.stream().filter(a -> a.getId() == contractId).findFirst().get());
            for (IdTitle contract : contractIds) {
                if (contract.getId() == contractId) continue;
                newContractIds.add(contract);
            }
            return newContractIds;
        }
        return contractIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getContracts(String contractId, HttpServletRequest request, HttpServletResponse response) {
        block31: {
            List<IdTitle> contracts = (ArrayList<IdTitle>)request.getSession().getAttribute("contractIds");
            if (contracts == null) {
                contracts = new ArrayList<IdTitle>();
            }
            contracts = this.resortContractIds(contractId, contracts);
            request.getSession().setAttribute("contractIds", contracts);
            if (!contracts.isEmpty()) {
                ServerContext serverContext = this.getServerContext(request);
                Connection con = serverContext.getConnection();
                try (BalanceUtils balanceUtils = new BalanceUtils(con);
                     TariffPlanDao tariffPlanDao = new TariffPlanDao(con);){
                    ContractTariffDao contractTariffDao = new ContractTariffDao(con);
                    Contract contract = ContractDao.getContract((Connection)con, (int)contracts.get(0).getId());
                    if (contract == null) break block31;
                    request.setAttribute("contract", (Object)contract);
                    request.setAttribute("contractStatus", (Object)StatusCache.getInstance().getStatusTitle((int)contract.getStatus()));
                    ArrayList contractTariffs = new ArrayList();
                    for (ContractTariff contractTariff : contractTariffDao.list(contract.getId(), LocalDate.now())) {
                        HashMap<String, Object> contractTariffMap = new HashMap<String, Object>();
                        contractTariffMap.put("period", contractTariff.getPeriod());
                        contractTariffMap.put("tariffPlan", tariffPlanDao.get(contractTariff.getTariffPlanId()));
                        contractTariffs.add(contractTariffMap);
                    }
                    request.setAttribute("contractTariffs", contractTariffs);
                    request.setAttribute("contractBalance", (Object)balanceUtils.getBalanceOut(new Date(), contract.getId()));
                    ArrayList<Integer> contractIds = new ArrayList<Integer>();
                    contractIds.add(contract.getId());
                    try (PaymentTypeDao paymentTypeDao = new PaymentTypeDao(con);){
                        SearchResult searchResult = new SearchResult();
                        new PaymentDao(con).searchLastPaymentList(searchResult, contractIds, 2);
                        List payments = searchResult.getList();
                        ArrayList<Integer> typeIds = new ArrayList<Integer>();
                        for (Payment payment : payments) {
                            int typeId = payment.getTypeId();
                            if (typeIds.contains(typeId)) continue;
                            typeIds.add(typeId);
                        }
                        request.setAttribute("contractPayments", (Object)payments);
                        request.setAttribute("contractPaymentTypes", (Object)paymentTypeDao.getTypeMapByIds(typeIds));
                    }
                    LocalDate now = LocalDate.now();
                    try (ChargeTypeDao chargeTypeDao = new ChargeTypeDao(con);){
                        ChargeDao chargeDao = new ChargeDao(con);
                        Period period = new Period(now.withDayOfMonth(1).minusMonths(1L), now);
                        SearchResult searchResult = new SearchResult(period, null, new String[]{"date:1"});
                        chargeDao.searchChargeList(searchResult, contractIds);
                        List charges = searchResult.getList();
                        if (charges.isEmpty()) {
                            chargeDao.searchLastChargeList(searchResult, contractIds, 2);
                        }
                        ArrayList<Integer> typeIds = new ArrayList<Integer>();
                        for (Charge charge : charges) {
                            int typeId = charge.getTypeId();
                            if (typeIds.contains(typeId)) continue;
                            typeIds.add(typeId);
                        }
                        request.setAttribute("contractCharges", (Object)charges);
                        request.setAttribute("contractChargeTypes", (Object)chargeTypeDao.getTypeMapByIds(typeIds));
                    }
                    ArrayList<Map<String, Object>> accounts = new ArrayList<Map<String, Object>>();
                    this.addAccountData(now, contractIds, accounts, con);
                    this.addAccountData(now.minusMonths(1L), contractIds, accounts, con);
                    request.setAttribute("contractAccounts", accounts);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
                finally {
                    serverContext.destroy();
                }
            }
        }
        this.requestDispatcher("contracts", request, response);
    }

    private List<Map<String, Object>> getButtons(JSONObject options) {
        ArrayList<Map<String, Object>> buttons = new ArrayList<Map<String, Object>>();
        for (String key : new String[]{"1", "2", "3", "4", "Cancel"}) {
            if (!options.optBoolean("windowShowButton" + key, false)) continue;
            AssistantButton assistantButton = AssistantButton.getAssistantButtonByCode((String)("Cancel".equals(key) ? "cancel" : "button" + key));
            HashMap<String, String> buttonMap = new HashMap<String, String>();
            buttonMap.put("code", assistantButton.getCode());
            buttonMap.put("title", options.optString("windowTextButton" + key, assistantButton.getTitle()));
            buttons.add(buttonMap);
        }
        return buttons;
    }

    private List<Map<String, Object>> getFields(JSONArray params, JSONObject options) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        if (params != null) {
            for (int index = 0; index < params.length(); ++index) {
                JSONObject paramObject = params.getJSONObject(index);
                Object type = paramObject.optString("type");
                type = ((String)type).substring(0, 1).toUpperCase() + ((String)type).substring(1);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("key", paramObject.optString("key"));
                paramMap.put("type", type);
                paramMap.put("title", paramObject.optString("title"));
                paramMap.put("value", paramObject.optString("value"));
                paramMap.put("comment", paramObject.optString("comment", null));
                fields.add(paramMap);
            }
        }
        return fields;
    }

    private ServerContext getServerContext(HttpServletRequest request) {
        Integer userId = (Integer)request.getSession().getAttribute("userId");
        if (userId == null) {
            userId = 0;
        }
        ServerContext serverContext = new ServerContext(Setup.getSetup(), -1, userId.intValue());
        ServerContext.set((ThreadContext)serverContext);
        return serverContext;
    }

    private void requestDispatcher(String jsp, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/html; charset=utf-8");
            request.getRequestDispatcher("/WEB-INF/jspf/assistant/" + jsp + ".jsp").include((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void addAccountData(LocalDate localDate, List<Integer> contractIds, List<Map<String, Object>> accounts, Connection con) {
        String query = "SELECT t2.title, t1.summa FROM contract_account AS t1 LEFT JOIN service AS t2 ON t1.sid=t2.id WHERE cid IN ( " + Utils.toString(contractIds) + " ) AND mm=? AND yy=?";
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, localDate.getMonthValue());
            ps.setInt(2, localDate.getYear());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String title = rs.getString(1);
                map.put("date", TimeUtils.convertLocalDateToDate((LocalDate)localDate));
                map.put("title", title == null ? "?" : title);
                map.put("sum", rs.getBigDecimal(2));
                accounts.add(map);
            }
            rs.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void openContract(String openContractId, HttpServletRequest request) {
        if (openContractId != null) {
            contractId = Utils.parseInt((String)openContractId);
            contractIds = (ArrayList<IdTitle>)request.getSession().getAttribute("contractIds");
            if (contractIds == null) {
                contractIds = new ArrayList<IdTitle>();
            }
            if (!contractIds.stream().anyMatch((Predicate<IdTitle>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$openContract$4(int ru.bitel.common.model.IdTitle ), (Lru/bitel/common/model/IdTitle;)Z)((int)contractId))) {
                serverContext = this.getServerContext(request);
                try {
                    contractService = (ContractService)serverContext.getService(ContractService.class, 0);
                    contract = contractService.contractGet(contractId);
                    if (contract == null) ** GOTO lbl21
                    contractIds.add(0, new IdTitle(contractId, contract.getTitle()));
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
                finally {
                    serverContext.destroy();
                }
            } else {
                contractIds = this.resortContractIds(openContractId, contractIds);
            }
lbl21:
            // 4 sources

            request.getSession().setAttribute("contractIds", contractIds);
        }
    }

    private static /* synthetic */ boolean lambda$openContract$4(int contractId, IdTitle a) {
        return a.getId() == contractId;
    }
}

