/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.CalendarPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.directory.address.AddressParamTableModel;
import ru.bitel.bgbilling.client.directory.address.AddressPodTableModel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityData;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityParam;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityType;
import ru.bitel.oss.kernel.directories.address.common.bean.HouseCoordinates;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class AddressHouseEditor
extends BGEditorDialog<AddressEntityData> {
    private AddressService addressService;
    private Street street;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGTextField parentTitle = new BGTextField(50);
    private BGUComboBox<IdTitle> area = new BGUComboBox();
    private BGUComboBox<IdTitle> quarter = new BGUComboBox();
    private BGIntTextField postIndex = new BGIntTextField(12);
    private BGIntTextField amount = new BGIntTextField(12);
    private BGIntTextField podCount = new BGIntTextField(12);
    private JTextField entityTitle = new JTextField(10);
    private BGTextArea comment = new BGTextArea(2, 70);
    private final CoordinatesPanel coordinatesPanel = new CoordinatesPanel();
    private AddressParamTableModel paramTableModel = new AddressParamTableModel();
    private AddressPodTableModel podTableModel = new AddressPodTableModel();
    private BGUTable paramTable = new BGUTable(this.paramTableModel);
    private BGUTable podTable = new BGUTable(this.podTableModel);
    private List<int[]> flats = new ArrayList<int[]>();

    public AddressHouseEditor(String title, AddressEntityData data, ClientContext clientContext) {
        super(title, data, clientContext);
    }

    private AddressService getAddressService() {
        if (this.addressService == null) {
            this.addressService = this.clientContext.getPort(AddressService.class, 0);
        }
        return this.addressService;
    }

    @Override
    public void doDialogPanel() {
        this.tabbedPane.add("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", this.getParamPanel());
        this.tabbedPane.add("\u041f\u043e\u0434\u044a\u0435\u0437\u0434\u044b", this.getPodPanel());
        this.panel.add((Component)this.getTitlePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getHouseDataPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        try {
            AddressService addressService = this.getAddressService();
            Async<List> areaItemsAsync = Async.of(() -> addressService.addressEntityItems(AddressEntityType.AREA, this.street.getCityId()));
            Async<List> quarterItemsAsync = Async.of(() -> addressService.addressEntityItems(AddressEntityType.QUARTER, this.street.getCityId()));
            this.data = addressService.addressEntityDataGet(((AddressEntityData)this.data).getAddressEntityType(), ((AddressEntityData)this.data).getRecordId());
            this.entityTitle.setText(((AddressEntityData)this.data).getTitle());
            this.postIndex.setText(((AddressEntityData)this.data).getEntityParameter("postIndex"));
            this.amount.setText(((AddressEntityData)this.data).getEntityParameter("amount"));
            this.podCount.setText(((AddressEntityData)this.data).getEntityParameter("podCount"));
            this.comment.setText(((AddressEntityData)this.data).getEntityParameter("comment"));
            this.coordinatesPanel.setCoordinates((AddressEntityData)this.data);
            int areaId = Utils.parseInt(((AddressEntityData)this.data).getEntityParameter("areaId"));
            List areaItems = areaItemsAsync.get();
            areaItems.add(0, IdTitle.NO_SELECT);
            this.area.setData(areaItems);
            this.area.setSelectedItem(areaItems.stream().filter(a -> a.getId() == areaId).findFirst().orElse((IdTitle)areaItems.get(0)));
            int quarterId = Utils.parseInt(((AddressEntityData)this.data).getEntityParameter("quarterId"));
            List quarterItems = quarterItemsAsync.get();
            quarterItems.add(0, IdTitle.NO_SELECT);
            this.quarter.setData(quarterItems);
            this.quarter.setSelectedItem(quarterItems.stream().filter(a -> a.getId() == quarterId).findFirst().orElse((IdTitle)quarterItems.get(0)));
            this.podCount.addActionListener(e -> this.setPodData());
            this.paramTableModel.setData(((AddressEntityData)this.data).getConfigParams());
            this.setPodData();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void setPodData() {
        ArrayList podDatas = new ArrayList();
        int pod = Utils.parseInt(this.podCount.getText());
        if (pod > 0) {
            this.flats.clear();
            IntStream.range(1, pod + 1).forEach(a -> {
                podDatas.add(new AddressPodTableModel.PodData().setPodNumber(a));
                this.flats.add(new int[1]);
            });
        }
        this.podTableModel.setData(podDatas);
        this.calc();
    }

    @Override
    public boolean doApply() throws Exception {
        if (this.entityTitle.getText().trim().length() == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
            return false;
        }
        try {
            ((AddressEntityData)this.data).getEntityParams().clear();
            ((AddressEntityData)this.data).setParentId(this.street.getId());
            ((AddressEntityData)this.data).setTitle(this.entityTitle.getText());
            ((AddressEntityData)this.data).addEntityParameter("postIndex", this.postIndex.getText());
            ((AddressEntityData)this.data).addEntityParameter("areaId", String.valueOf(((IdTitle)this.area.getSelectedItem()).getId()));
            ((AddressEntityData)this.data).addEntityParameter("quarterId", String.valueOf(((IdTitle)this.quarter.getSelectedItem()).getId()));
            ((AddressEntityData)this.data).addEntityParameter("amount", this.amount.getText());
            ((AddressEntityData)this.data).addEntityParameter("podCount", this.podCount.getText());
            ((AddressEntityData)this.data).addEntityParameter("comment", this.comment.getText());
            ((AddressEntityData)this.data).addEntityParameter("latitude", this.coordinatesPanel.getLatitude());
            ((AddressEntityData)this.data).addEntityParameter("longitude", this.coordinatesPanel.getLongitude());
            ((AddressEntityData)this.data).setConfigParams(this.paramTableModel.getRows());
            this.getAddressService().addressEntityDataUpdate((AddressEntityData)this.data);
            return true;
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
            return false;
        }
    }

    public void setTitleLabelText(String text) {
        this.parentTitle.setText(text);
    }

    public void setStreet(Street street) {
        this.street = street;
    }

    private JPanel getTitlePanel() {
        Color bgColor = this.parentTitle.getBackground();
        Font font = this.parentTitle.getFont();
        this.parentTitle.setEditable(false);
        this.parentTitle.setBackground(bgColor);
        this.parentTitle.setFont(font.deriveFont(font.getSize2D() * 1.3f).deriveFont(1));
        this.parentTitle.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.parentTitle, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getHouseDataPanel() {
        this.postIndex.setMaxValue(999999L);
        this.entityTitle.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getHousePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getAreaAndQuarterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)this.coordinatesPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getHousePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u043e\u043c/\u0434\u0440\u043e\u0431\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0418\u043d\u0434\u0435\u043a\u0441:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0438\u0440:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u043e\u0434\u044a\u0435\u0437\u0434\u043e\u0432:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.entityTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.postIndex, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.amount, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.podCount, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getAreaAndQuarterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0430\u0439\u043e\u043d:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0430\u043b:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add(this.area, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(this.quarter, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getParamPanel() {
        this.paramTable.setRowHeight(18);
        this.paramTable.setFont(new Font("Dialog", 0, 13));
        this.paramTable.setSelectionMode(0);
        BGSwingUtilites.handleMouseClicked(this.paramTable, e -> this.paramTableMouseClicked((MouseEvent)e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.paramTable, 800, 200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPodPanel() {
        BGSwingUtilites.handleRMouseClicked(this.podTable, e -> this.getPopupMenuPodTable().show(this.podTable, e.getX(), e.getY()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.podTable, 800, 200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPopupMenu getPopupMenuPodTable() {
        ActionListener floorActionListener = e -> {
            int floorCount = Utils.parseInt(((JMenuItem)e.getSource()).getText());
            this.podTableModel.getSelectedRows().forEach(a -> {
                a.setFloorCount(floorCount);
                this.flats.set(a.getPodNumber() - 1, new int[floorCount]);
            });
            this.calc();
        };
        ActionListener flatActionListener = e -> {};
        JMenu floorMenu = new JMenu("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u0442\u0430\u0436\u0435\u0439");
        for (int i = 1; i < 13; ++i) {
            floorMenu.add(String.valueOf(i)).addActionListener(floorActionListener);
        }
        floorMenu.add(new JSeparator());
        floorMenu.add("\u0434\u0440\u0443\u0433\u043e\u0435");
        JMenu flatOnFloorMenu = new JMenu("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u043d\u0430 \u044d\u0442\u0430\u0436\u0435");
        for (int i = 1; i < 11; ++i) {
            flatOnFloorMenu.add(String.valueOf(i)).addActionListener(flatActionListener);
        }
        flatOnFloorMenu.add(new JSeparator());
        flatOnFloorMenu.add("\u0434\u0440\u0443\u0433\u043e\u0435");
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> {
            List<AddressPodTableModel.PodData> datas = this.podTableModel.getSelectedRows();
            if (datas.isEmpty()) {
                ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0434\u044a\u0435\u0437\u0434(\u044b)");
            } else {
                new PodFlatEditor("\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u043f\u043e \u044d\u0442\u0430\u0436\u0430\u043c", datas).open();
                this.podTableModel.fireTableDataChanged();
            }
        });
        popupMenu.add(floorMenu);
        return popupMenu;
    }

    private void calc() {
        int flatCount = Utils.parseInt(this.amount.getText());
        int pod = Utils.parseInt(this.podCount.getText());
        if (flatCount > 0 && pod > 0) {
            int c = 0;
            int a = flatCount / pod;
            int b = flatCount % pod;
            for (AddressPodTableModel.PodData podData : this.podTableModel.getRows()) {
                podData.setFlatRangeFrom(c + 1);
                c = c + a + (b > 0 ? 1 : 0);
                podData.setFlatRangeTo(c);
                --b;
            }
        }
        this.podTableModel.fireTableDataChanged();
    }

    private void paramTableMouseClicked(MouseEvent event) {
        AddressEntityParam entityParam = (AddressEntityParam)this.paramTableModel.getSelectedRow();
        int col = this.paramTable.convertColumnIndexToModel(this.paramTable.columnAtPoint(event.getPoint()));
        if (entityParam != null && "date".equals(entityParam.getType()) && col == 3 && event.getClickCount() == 2) {
            JPopupMenu popupMenu = new JPopupMenu();
            CalendarPanel calendarPanel = new CalendarPanel();
            calendarPanel.setCalendar(TimeUtils.parseCalendar(entityParam.getValue(), "dd.MM.yyyy"));
            calendarPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            calendarPanel.addPropertyChangeListener(ce -> {
                if ("updateCalendar".equals(ce.getPropertyName())) {
                    entityParam.setValue(TimeUtils.format(calendarPanel.getCalendar(), "dd.MM.yyyy"));
                    popupMenu.setVisible(false);
                }
            });
            popupMenu.add(calendarPanel);
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        } else if (entityParam != null && "boolean".equals(entityParam.getType()) && col == 3 && event.getClickCount() == 2) {
            entityParam.setValue(String.valueOf(Boolean.valueOf(entityParam.getValue()) == false));
            this.paramTableModel.fireTableCellUpdated(this.paramTable.convertRowIndexToModel(this.paramTable.rowAtPoint(event.getPoint())), col);
        }
    }

    private final class CoordinatesPanel
    extends JPanel {
        private final JTextField latitude = new JTextField();
        private final JTextField longitude = new JTextField();

        private CoordinatesPanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.latitude, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)new JLabel("/"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)this.longitude, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            JButton searchCoordinates = new JButton("\u041d\u0430\u0439\u0442\u0438 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b");
            this.add((Component)searchCoordinates, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            BGSwingUtilites.wrapBorder(this, "\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b");
            try {
                searchCoordinates.setEnabled(AddressHouseEditor.this.getAddressService().checkGarPluginInstalled());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            searchCoordinates.addActionListener(e -> {
                try {
                    HouseCoordinates coordinates = AddressHouseEditor.this.getAddressService().searchCoordinatesByHouseId(((AddressEntityData)AddressHouseEditor.this.data).getRecordId());
                    if (coordinates != null) {
                        this.latitude.setText(String.valueOf(coordinates.getLatitude()));
                        this.longitude.setText(String.valueOf(coordinates.getLongitude()));
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            });
        }

        void setCoordinates(AddressEntityData addressEntityData) {
            this.latitude.setText(Utils.maskNull(addressEntityData.getEntityParameter("latitude")));
            this.longitude.setText(Utils.maskNull(addressEntityData.getEntityParameter("longitude")));
        }

        String getLatitude() {
            return Utils.maskNull(this.latitude.getText());
        }

        String getLongitude() {
            return Utils.maskNull(this.longitude.getText());
        }
    }

    class PodFlatEditor
    extends BGEditorDialog<List<AddressPodTableModel.PodData>> {
        private BGIntTextField podFlatFrom;
        private BGIntTextField podFlatTo;
        private BGIntTextField podCount;
        private BGIntTextField podFloorCount;
        private PodFloorTableModel floorTableModel;

        public PodFlatEditor(String title, List<AddressPodTableModel.PodData> data) {
            super(title, data);
            this.podFlatFrom = new BGIntTextField(13);
            this.podFlatTo = new BGIntTextField(13);
            this.podCount = new BGIntTextField(30);
            this.podFloorCount = new BGIntTextField(30);
            this.floorTableModel = new PodFloorTableModel();
        }

        @Override
        public void doDialogPanel() {
            if (((List)this.data).size() == 1) {
                this.addFieldV("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u0432 \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0435:", this.getFlatRangePanel());
                this.podFlatFrom.setText(String.valueOf(((AddressPodTableModel.PodData)((List)this.data).get(0)).getFlatRangeFrom()));
                this.podFlatTo.setText(String.valueOf(((AddressPodTableModel.PodData)((List)this.data).get(0)).getFlatRangeTo()));
                this.podFloorCount.setText(String.valueOf(((AddressPodTableModel.PodData)((List)this.data).get(0)).getFloorCount()));
            } else {
                this.addFieldV("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u0432 \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0435:", this.podCount);
                int count = ((AddressPodTableModel.PodData)((List)this.data).get(0)).getFlatRangeTo() - ((AddressPodTableModel.PodData)((List)this.data).get(0)).getFlatRangeFrom();
                boolean flag = ((List)this.data).stream().filter(a -> count != a.getFlatRangeTo() - a.getFlatRangeFrom()).findFirst().isEmpty();
                this.podCount.setText(flag ? String.valueOf(count + 1) : "");
            }
            this.addFieldV("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u0442\u0430\u0436\u0435\u0439 \u0432 \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0435:", this.podFloorCount);
            this.addFieldV("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0432\u0430\u0440\u0442\u0438\u0440 \u043d\u0430 \u044d\u0442\u0430\u0436\u0430\u0445:", this.getFloorsPanel());
            this.podCount.addActionListener(e -> this.setFloorData());
            this.podFloorCount.addActionListener(e -> this.setFloorData());
            this.setFloorData();
        }

        private void setFloorData() {
            ArrayList list = new ArrayList();
            int floorCount = Utils.parseInt(this.podFloorCount.getText());
            if (floorCount > 0) {
                int c = (((List)this.data).size() == 1 ? Utils.parseInt(this.podFlatTo.getText()) - Utils.parseInt(this.podFlatFrom.getText()) + 1 : Utils.parseInt(this.podCount.getText())) / floorCount;
                IntStream.range(1, Utils.parseInt(this.podFloorCount.getText(), 1) + 1).forEach(a -> list.add(new String[]{String.valueOf(a), String.valueOf(c)}));
            }
            this.floorTableModel.setData(list);
        }

        private JPanel getFlatRangePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0441"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.podFlatFrom, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.podFlatTo, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getFloorsPanel() {
            BGUTable table = new BGUTable(this.floorTableModel);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)BGSwingUtilites.wrapScrollPane(table, 300, 250), "Center");
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            int floorCount = Utils.parseInt(this.podFloorCount.getText());
            if (((List)this.data).size() == 1) {
                int from = Utils.parseInt(this.podFlatFrom.getText());
                if (from < 1) {
                    BGToolTip.showErrorMessage(this.podFlatFrom, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u044b");
                    return false;
                }
                int to = Utils.parseInt(this.podFlatTo.getText());
                if (to < 1) {
                    BGToolTip.showErrorMessage(this.podFlatTo, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u044b");
                    return false;
                }
                ((AddressPodTableModel.PodData)((List)this.data).get(0)).setFlatRangeFrom(from);
                ((AddressPodTableModel.PodData)((List)this.data).get(0)).setFlatRangeTo(to);
                ((AddressPodTableModel.PodData)((List)this.data).get(0)).setFloorCount(floorCount > 0 ? floorCount : 1);
            } else {
                ((List)this.data).forEach(a -> a.setFloorCount(floorCount > 0 ? floorCount : 1));
            }
            return super.doApply();
        }
    }

    class PodFloorTableModel
    extends BGTableModel<String[]> {
        public PodFloorTableModel() {
            super(PodFloorTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u042d\u0442\u0430\u0436", 100, 100, 100, "floor", false, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0432\u0430\u0440\u0442\u0438\u0440", 100, 100, -1, "count", false, DecimalTableCellRenderer.INTEGER());
        }

        @Override
        public Object getValue(String[] val, int columnIndex) throws Exception {
            String identifier = this.getIdentifier(columnIndex);
            if ("floor".equals(identifier)) {
                return Utils.parseInt(val[0]);
            }
            if ("count".equals(identifier)) {
                return Utils.parseInt(val[1]);
            }
            return super.getValue(val, columnIndex);
        }
    }
}

