/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Contractable;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.ScheduleTime;

public class Subscription
extends Id
implements Contractable {
    private int contractId;
    private String contractTitle;
    private String comment;
    private Dispatch dispatch;
    private List<Contact> contacts = new ArrayList<Contact>();
    private Preferences prefs;
    private ScheduleTime repeatTime;
    boolean active;
    private Period subscriptionPeriod;
    private boolean update = false;

    public void addContact(Contact contact) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<Contact>();
        }
        this.contacts.add(contact);
    }

    public String getComment() {
        return this.comment;
    }

    public String getContactHash(Contact contact) {
        return Utils.getDigest((String)(String.valueOf(this.getId()) + String.valueOf(contact.getId())), (String)"UTF-8");
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    @XmlAttribute
    public int getContractId() {
        return this.contractId;
    }

    @XmlAttribute
    public String getContractTitle() {
        return this.contractTitle;
    }

    public Dispatch getDispatch() {
        return this.dispatch;
    }

    public String getHumanReadableRepeatTime() {
        return ScheduleTime.toHumanReadable((ScheduleTime)this.repeatTime);
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public ScheduleTime getRepeatTime() {
        return this.repeatTime;
    }

    public String getRepeatTimeDaysOfWeek() {
        return Utils.unpackValues((long)this.repeatTime.getDayOfWeek(), (int)1);
    }

    public Period getSubscriptionPeriod() {
        return this.subscriptionPeriod;
    }

    public ScheduleTime getTotalRepeatTime() {
        ScheduleTime dispatchTime = this.dispatch.getRepeatTime();
        ScheduleTime totalTime = new ScheduleTime(this.repeatTime);
        totalTime.setHour(dispatchTime.getHour());
        totalTime.setMin(dispatchTime.getMin());
        return totalTime;
    }

    @XmlAttribute
    public boolean isActive() {
        return this.active;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public Subscription setActive(boolean active) {
        this.active = active;
        return this;
    }

    public Subscription setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Subscription setContacts(List<Contact> contacts) {
        this.contacts = contacts;
        return this;
    }

    public Subscription setContractId(int contractId) {
        this.contractId = contractId;
        return this;
    }

    public Subscription setContractTitle(String contractTitle) {
        this.contractTitle = contractTitle;
        return this;
    }

    public Subscription setDispatch(Dispatch dispatch) {
        this.dispatch = dispatch;
        return this;
    }

    public Subscription setPreferences(Preferences prefs) {
        this.prefs = prefs;
        return this;
    }

    public Subscription setRepeatTime(ScheduleTime recieveTime) {
        this.repeatTime = recieveTime;
        return this;
    }

    public Subscription setSubscriptionPeriod(Period subscriptionPeriod) {
        this.subscriptionPeriod = subscriptionPeriod;
        return this;
    }

    public Subscription setUpdate(boolean update) {
        this.update = update;
        return this;
    }
}

