/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.contract;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServRestriction;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServRestrictionTimeCondition;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class InetServRestrictionPanel
extends BGUPanel {
    private Integer inetServId;
    private InetServService servService;
    private InetServRestrictionTableModel model = new InetServRestrictionTableModel(InetServRestrictionTableModel.class.getName());
    boolean edited = false;
    private BGUTable table;

    public InetServRestrictionPanel(ClientContext context, Integer inetServId) {
        super(context);
        this.inetServId = inetServId;
        this.servService = (InetServService)context.getPort(InetServService.class);
    }

    public List<InetServRestriction> getInetServRestrictionList() {
        return this.model.getRows();
    }

    public void setInetServRestrictionList(List<InetServRestriction> data) {
        this.model.setData(data);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.inetServId != null) {
                this.model.setData(this.servService.inetServRestrictionList(((ClientContext)this.getContext()).getContractId(), this.inetServId.intValue()));
            } else {
                this.model.setData(new ArrayList());
            }
            this.edited = false;
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (!InetServRestrictionPanel.this.edited) {
                    return;
                }
                InetServRestrictionPanel.this.servService.inetServRestrictionListUpdate(((ClientContext)InetServRestrictionPanel.this.getContext()).getContractId(), InetServRestrictionPanel.this.inetServId.intValue(), InetServRestrictionPanel.this.getInetServRestrictionList());
            }
        };
    }

    protected void jbInit() {
        this.table = new BGUTable((TableModel)((Object)this.model));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        RestrictionForm restrictionForm = new RestrictionForm((ClientContext)this.getContext());
        BGEditor editor = new BGEditor();
        editor.addForm((JComponent)((Object)restrictionForm));
        editor.setVisible(false);
        BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)((Object)restrictionForm));
        toolBar.compact();
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)editor);
        this.setLayout(new GridBagLayout());
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setInetServId(Integer id) {
        this.inetServId = id;
    }

    class InetServRestrictionTableModel
    extends BGTableModel<InetServRestriction> {
        private static final String COLUMN_NAME = "period";
        private static final String COLUMN_RESTRICTION = "restriction";
        private static final String COLUMN_COMMENT = "comment";

        public InetServRestrictionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 140, 140, 180, COLUMN_NAME, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435", -1, 150, -1, COLUMN_RESTRICTION, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 150, -1, COLUMN_COMMENT, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(InetServRestriction inetServRestriction, int column) throws Exception {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "period": {
                    return new Period(inetServRestriction.getDateFrom(), inetServRestriction.getDateTo());
                }
                case "restriction": {
                    return inetServRestriction;
                }
            }
            return super.getValue((Object)inetServRestriction, column);
        }
    }

    class RestrictionForm
    extends BGUPanel {
        public RestrictionForm(ClientContext context) {
            super(context);
        }

        protected void jbInit() throws BGException {
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                InetServRestriction inetServRestriction = new InetServRestriction();
                inetServRestriction.setInetServId(InetServRestrictionPanel.this.inetServId != null ? InetServRestrictionPanel.this.inetServId : 0);
                RestrictionDialog dialog = new RestrictionDialog("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435", inetServRestriction);
                dialog.open();
                if (dialog.isOk()) {
                    InetServRestrictionPanel.this.model.addRow(inetServRestriction);
                    InetServRestrictionPanel.this.edited = true;
                }
            }).setIcon((Icon)ClientUtils.getIcon((String)"item_add"));
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                InetServRestriction inetServRestriction = (InetServRestriction)InetServRestrictionPanel.this.model.getSelectedRow();
                if (inetServRestriction != null) {
                    RestrictionDialog dialog = new RestrictionDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435", inetServRestriction);
                    dialog.open();
                    if (dialog.isOk()) {
                        InetServRestrictionPanel.this.model.setRow(InetServRestrictionPanel.this.table.getSelectedRow(), inetServRestriction);
                        InetServRestrictionPanel.this.edited = true;
                    }
                }
            }).setIcon((Icon)ClientUtils.getIcon((String)"item_edit"));
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                InetServRestriction inetServRestriction = (InetServRestriction)InetServRestrictionPanel.this.model.getSelectedRow();
                if (inetServRestriction != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    InetServRestrictionPanel.this.model.deleteRow(inetServRestriction);
                    InetServRestrictionPanel.this.edited = true;
                }
            }).setIcon((Icon)ClientUtils.getIcon((String)"item_delete"));
        }
    }

    class ScrollTimeField
    extends JTextField {
        private int hh;
        private int mm;

        public ScrollTimeField(int column) {
            super(column);
            this.hh = 0;
            this.mm = 0;
            this.setHorizontalAlignment(0);
            this.resetText();
            this.addMouseWheelListener(e -> {
                int step;
                int n = step = (e.getModifiersEx() & 0x80) == 128 ? 10 : 1;
                if (e.getX() > this.getWidth() / 2) {
                    this.mm += step * e.getWheelRotation();
                    if (this.mm < 0) {
                        this.mm = 0;
                    }
                    if (this.mm > 59) {
                        this.mm = 59;
                    }
                } else {
                    this.hh += step * e.getWheelRotation();
                    if (this.hh < 0) {
                        this.hh = 0;
                    }
                    if (this.hh > 23) {
                        this.hh = 23;
                    }
                }
                this.setText();
            });
        }

        public void setValue(String time) {
            String[] hhmm = time.split(":");
            if (hhmm.length > 0) {
                this.hh = Utils.parseInt((String)hhmm[0], (int)0);
            }
            if (hhmm.length > 1) {
                this.mm = Utils.parseInt((String)hhmm[1], (int)0);
            }
            this.setText();
        }

        public void setText() {
            this.setText(String.valueOf(this.hh > 9 ? Integer.valueOf(this.hh) : "0" + this.hh) + ":" + String.valueOf(this.mm > 9 ? Integer.valueOf(this.mm) : "0" + this.mm));
        }

        public void resetText() {
            this.setValue("00:00");
        }
    }

    class RestrictionDialog
    extends BGEditorDialog<InetServRestriction> {
        private boolean ok;
        private BGUComboBox<IdTitle> type;
        private BGControlPanelPeriodNoB period;
        private ScrollTimeField timeFrom;
        private ScrollTimeField timeTo;
        private List<JCheckBox> daysOfWeek;
        private BGTextField daysOfMonth;
        private BGTextField months;
        private BGUComboBox<IdTitle> mode;
        private JLabel amountTitle;
        private BGTextField amount;
        private BGUCheckList<Service> serviceList;
        private JTextArea comment;
        private JTabbedPane tabbedPane;

        public RestrictionDialog(String title, InetServRestriction data) {
            super(title, (Object)data);
            this.ok = false;
            this.type = new BGUComboBox();
            this.period = new BGControlPanelPeriodNoB(false);
            this.timeFrom = new ScrollTimeField(10);
            this.timeTo = new ScrollTimeField(10);
            this.daysOfWeek = new ArrayList<JCheckBox>();
            this.daysOfMonth = new BGTextField(21);
            this.months = new BGTextField(21);
            this.mode = new BGUComboBox();
            this.amountTitle = new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:");
            this.amount = new BGTextField(15);
            this.serviceList = new BGUCheckList();
            this.comment = new JTextArea(10, 50);
            this.tabbedPane = new JTabbedPane();
        }

        public void doDialogPanel() {
            this.tabbedPane.add((Component)this.getRestrictionPanel(), "\u0423\u0441\u043b\u043e\u0432\u0438\u044f");
            this.tabbedPane.add((Component)this.getCommentPanel(), "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
            int gridy = 0;
            this.panel.add((Component)this.getTopPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.type.setSelectedItem((Object)((InetServRestriction)this.data).getType());
            this.serviceList.setSelected(((InetServRestriction)this.data).getServiceIds() != null ? ((InetServRestriction)this.data).getServiceIds() : Collections.emptySet());
            this.period.setDateFrom(((InetServRestriction)this.data).getDateFrom());
            this.period.setDateTo(((InetServRestriction)this.data).getDateTo());
            this.comment.setText(((InetServRestriction)this.data).getComment());
            switch (((InetServRestriction)this.data).getType()) {
                case 11: 
                case 12: {
                    this.amount.setText(Utils.formatBigDecimal((BigDecimal)((InetServRestriction)this.data).getAmount(), (int)0));
                    break;
                }
                case 0: {
                    InetServRestrictionTimeCondition config = (InetServRestrictionTimeCondition)((InetServRestriction)this.data).getConfig();
                    if (config == null) break;
                    this.mode.setSelectedItem((Object)config.getMode());
                    this.timeFrom.setValue(config.getTimeFrom() != null ? config.getTimeFrom().toString() : "");
                    this.timeTo.setValue(config.getTimeTo() != null ? config.getTimeTo().toString() : "");
                    if (config.getDaysOfWeek() != null) {
                        for (int index = 0; index < 7; ++index) {
                            this.daysOfWeek.get(index).setSelected(config.getDaysOfWeek().contains(index + 1));
                        }
                    }
                    this.daysOfMonth.setText(config.getDaysOfMonth() == null ? "" : config.getDaysOfMonth().stream().sorted().map(String::valueOf).collect(Collectors.joining(",")));
                    this.months.setText(config.getMonths() == null ? "" : config.getMonths().stream().sorted().map(String::valueOf).collect(Collectors.joining(",")));
                    break;
                }
                default: {
                    this.amount.setText(Utils.formatCost((BigDecimal)((InetServRestriction)this.data).getAmount()));
                }
            }
        }

        public boolean doApply() throws Exception {
            ((InetServRestriction)this.data).setType(((IdTitle)this.type.getSelectedItem()).getId());
            ((InetServRestriction)this.data).setServiceIds(this.serviceList.getSelectedIds());
            ((InetServRestriction)this.data).setDateFrom(this.period.getDateFrom());
            ((InetServRestriction)this.data).setDateTo(this.period.getDateTo());
            ((InetServRestriction)this.data).setComment(this.comment.getText());
            switch (((InetServRestriction)this.data).getType()) {
                case 11: 
                case 12: {
                    ((InetServRestriction)this.data).setAmount(Utils.parseBigDecimal((String)this.amount.getText(), (BigDecimal)BigDecimal.ZERO).setScale(0, RoundingMode.DOWN));
                    break;
                }
                case 0: {
                    InetServRestrictionTimeCondition config = new InetServRestrictionTimeCondition();
                    config.setMode(((IdTitle)this.mode.getSelectedItem()).getId());
                    try {
                        config.setTimeFrom(LocalTime.parse(this.timeFrom.getText()));
                        config.setTimeTo(LocalTime.parse(this.timeTo.getText()));
                    }
                    catch (DateTimeParseException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                        throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432\u0440\u0435\u043c\u044f \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 -> HH:MM");
                    }
                    if (config.getTimeFrom().isAfter(config.getTimeTo())) {
                        throw new BGMessageException("\u041f\u0440\u0438 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043f\u0435\u0440\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0432\u0442\u043e\u0440\u043e\u0433\u043e.");
                    }
                    HashSet<Integer> days = new HashSet<Integer>();
                    for (int i = 0; i < this.daysOfWeek.size(); ++i) {
                        if (!this.daysOfWeek.get(i).isSelected()) continue;
                        days.add(i + 1);
                    }
                    config.setDaysOfWeek(days.size() > 0 ? days : null);
                    Set daysOfMonth = Utils.toIntegerSet((String)this.daysOfMonth.getText());
                    daysOfMonth.removeIf(d -> d <= 0 || d > 31);
                    config.setDaysOfMonth(daysOfMonth.size() > 0 ? daysOfMonth : null);
                    Set months = Utils.toIntegerSet((String)this.months.getText());
                    months.removeIf(d -> d <= 0 || d > 12);
                    config.setMonths(months.size() > 0 ? months : null);
                    ((InetServRestriction)this.data).setConfig((Object)config);
                    break;
                }
                default: {
                    ((InetServRestriction)this.data).setAmount(Utils.parseBigDecimal((String)this.amount.getText(), (BigDecimal)BigDecimal.ZERO));
                }
            }
            if (InetServRestrictionPanel.this.inetServId != null) {
                ((InetServRestriction)this.data).setInetServId(InetServRestrictionPanel.this.inetServId.intValue());
            }
            this.ok = true;
            return true;
        }

        private JPanel getTopPanel() {
            ArrayList<IdTitle> list = new ArrayList<IdTitle>();
            list.add(new IdTitle(0, "\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438"));
            list.add(new IdTitle(11, "\u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0437\u0430 \u043c\u0435\u0441\u044f\u0446 (\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e)"));
            list.add(new IdTitle(12, "\u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0437\u0430 \u0434\u0435\u043d\u044c (\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e)"));
            list.add(new IdTitle(21, "\u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0437\u0430 \u043c\u0435\u0441\u044f\u0446 (\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c)"));
            list.add(new IdTitle(22, "\u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0437\u0430 \u0434\u0435\u043d\u044c (\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c)"));
            this.type.setData(list);
            this.type.addActionListener(e -> {
                this.tabbedPane.setSelectedIndex(0);
                JPanel resPanel = (JPanel)this.tabbedPane.getComponentAt(0);
                ((CardLayout)resPanel.getLayout()).show(resPanel, ((IdTitle)this.type.getSelectedItem()).getId() == 0 ? "time" : "amount");
                this.amountTitle.setText(this.type.getSelectedIndex() < 3 ? "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:" : "\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:");
            });
            int gridx = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.type, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
            panel.add((Component)this.period, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getCommentPanel() {
            this.comment.setWrapStyleWord(true);
            this.comment.setLineWrap(true);
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getRestrictionPanel() {
            JPanel panel = new JPanel(new CardLayout());
            panel.add((Component)this.getTimePanel(), "time");
            panel.add((Component)this.getAmountPanel(), "amount");
            return panel;
        }

        private JPanel getAmountPanel() {
            this.amount.setHorizontalAlignment(0);
            try {
                this.serviceList.setData(((ModuleService)((ClientContext)InetServRestrictionPanel.this.getContext()).getWebService(ModuleService.class, 0)).serviceList(((ClientContext)InetServRestrictionPanel.this.getContext()).getModuleId()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0438:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.amountTitle, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.serviceList, new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 5, 0), 0, 0));
            panel.add((Component)this.amount, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 10, 0, 5), 0, 0));
            return panel;
        }

        private JPanel getTimePanel() {
            JPanel dayPanel = new JPanel(new GridLayout(1, 0));
            Stream.of("\u043f\u043d.", "\u0432\u0442.", "\u0441\u0440.", "\u0447\u0442.", "\u043f\u0442.", "\u0441\u0431.", "\u0432\u0441.").forEach(a -> {
                JCheckBox checkBox = new JCheckBox((String)a);
                dayPanel.add(checkBox);
                this.daysOfWeek.add(checkBox);
            });
            this.mode.addItem((Object)new IdTitle(0, "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e"));
            this.mode.addItem((Object)new IdTitle(1, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e"));
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0414\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 7, 3, 10), 0, 0));
            panel.add((Component)dayPanel, new GridBagConstraints(1, gridy++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 3), 0, 0));
            panel.add((Component)new JLabel("\u0414\u043d\u0438 \u043c\u0435\u0441\u044f\u0446\u0430:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 7, 3, 3), 0, 0));
            panel.add((Component)this.daysOfMonth, new GridBagConstraints(1, gridy++, 3, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            panel.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446\u044b:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 7, 3, 3), 0, 0));
            panel.add((Component)this.months, new GridBagConstraints(1, gridy++, 3, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            panel.add((Component)new JLabel("\u0412\u0440\u0435\u043c\u044f:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 7, 3, 3), 0, 0));
            panel.add((Component)this.timeFrom, new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            panel.add((Component)new JLabel("-"), new GridBagConstraints(2, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 0), 0, 0));
            panel.add((Component)this.timeTo, new GridBagConstraints(3, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 7, 3, 3), 0, 0));
            panel.add((Component)this.mode, new GridBagConstraints(1, gridy++, 3, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            return panel;
        }

        public boolean isOk() {
            return this.ok;
        }
    }
}

