/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractServiceDao;
import ru.bitel.bgbilling.kernel.event.events.ContractServicesChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ServiceUpdateEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;

public class ActionUpdateContractService
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", 0);
        int sid = this.getIntParameter("sid", -1);
        int cid = this.getIntParameter("cid", -1);
        Date dateFrom = this.getDateParameter("date1", null);
        Date dateTo = this.getDateParameter("date2", null);
        TimeUtils.checkPeriod((Date)dateFrom, (Date)dateTo);
        if (sid > 0 && cid > 0) {
            ContractServiceDao manager = new ContractServiceDao(this.con);
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionUpdateContractService", this.mid, this.userId);
            if (closedDate != null) {
                Date oldDate1 = null;
                Date oldDate2 = null;
                if (id > 0) {
                    ContractService old = manager.getContractServiceById(id);
                    oldDate1 = old.getDateFrom();
                    oldDate2 = old.getDateTo();
                }
                ClosedDateChecker.checkDatesForUpdate(closedDate, oldDate1, oldDate2, dateFrom, dateTo);
            }
            ContractService contractService = new ContractService().setId(id).setContractId(cid).setServiceId(sid).setDateFrom(dateFrom).setDateTo(dateTo).setComment(this.getParameter("comment", ""));
            manager.updateContractService(contractService);
            if (contractService != null) {
                this.context.publishAfterCommit(new ServiceUpdateEvent(this.userId, contractService));
                this.context.publishAfterCommit(new ContractServicesChangedEvent(cid));
            }
        }
    }
}

