/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.directory;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.EditorTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.smarthouse.client.common.EditorLabel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.EditorUtils;
import ru.bitel.bgbilling.modules.smarthouse.client.contract.AbstractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.directory.PackageOptionTableModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageOption;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.function.Async;

public class SmartHousePackageOptionPanel
extends AbstractBasePanel<SmartHousePackageOption, PackageOptionTableModel> {
    private PackageOptionTableModel tableModel = null;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)this.getTable()), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    protected PackageOptionTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new PackageOptionTableModel(PackageOptionTableModel.class.getName());
        }
        return this.tableModel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.getTableModel().setData(this.getSmartHousePackageService().packageOptionList())));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            SmartHousePackageOption packageOption = (SmartHousePackageOption)this.getTableModel().getSelectedRow();
            if (packageOption == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            } else {
                this.getPackageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u043f\u0446\u0438\u0438", packageOption).setVisible(true);
            }
        });
    }

    protected void getPopupMenuItems() {
        this.getPopupMenu().add(new JMenuItem(this.getActionMap().get("edit")));
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        return panel;
    }

    private BGUComboBox<KeyValue> getServiceComboBox() {
        BGUComboBox comboBox = new BGUComboBox();
        try {
            for (String service : this.getSmartHousePackageService().serviceList()) {
                JSONObject json = new JSONObject(service);
                comboBox.addItem((Object)new KeyValue(json.optString("key"), json.optString("value")));
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        return comboBox;
    }

    private JDialog getPackageDialog(String dialogTitle, SmartHousePackageOption packageOption) {
        EditorTextField title = new EditorTextField(40, "", this.focusListener);
        BGUComboBox<KeyValue> service = this.getServiceComboBox();
        Component[][] components = new Component[][]{{new EditorLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), title}, {new EditorLabel("\u0423\u0441\u043b\u0443\u0433\u0430"), service}};
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        ClientUtils.addComponentToPanel((JPanel)panel, (int)gridy, (Component[][])components, (boolean)true);
        title.setText(packageOption.getTitle());
        if (packageOption.getServiceId() > 0) {
            String key = String.valueOf(packageOption.getServiceId());
            for (int index = 0; index < service.getItemCount(); ++index) {
                if (!((KeyValue)service.getItemAt(index)).getKey().equals(key)) continue;
                service.setSelectedIndex(index);
                break;
            }
        }
        BGOptionPane optionPane = new BGOptionPane((Object)panel, dialogTitle);
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            Color color = Color.YELLOW;
            boolean error = EditorUtils.checkTextField(title, color, false);
            if (error) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439.");
                return;
            }
            packageOption.setTitle(title.getText());
            packageOption.setServiceId(Utils.parseInt((String)((KeyValue)service.getSelectedItem()).getKey()));
            try {
                this.getSmartHousePackageService().packageOptionUpdate(packageOption);
                this.performAction("refresh");
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        return dialog;
    }
}

