/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client.editors;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.BaseCerberEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardActionsService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.MapHolder;

public class SendMessageEditor
extends BaseCerberEditor {
    private final boolean contractPanel;
    private BGUTable newTable;
    private JTextField title;
    private JTextArea text;
    private String sendMode = "message";
    private String receiverMode = "selected";

    public SendMessageEditor(BGUTable table, boolean contractPanel) {
        super(new GridBagLayout());
        this.setName("card.sendMessage");
        this.contractPanel = contractPanel;
        this.newTable = table;
    }

    protected void jbInit() {
        this.title = new JTextField();
        this.text = new JTextArea(6, 0);
        JScrollPane pane = new JScrollPane(this.text);
        Dimension dim = this.text.getPreferredSize();
        dim.height += pane.getInsets().top + pane.getInsets().bottom;
        pane.setMinimumSize(dim);
        pane.setPreferredSize(dim);
        this.add(new JLabel("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add(new JLabel("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(pane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder(" \u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f "), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
    }

    protected void menuActionPerformed(Action action, ActionEvent e) {
        if (e.getActionCommand().startsWith("card.sendMessage")) {
            this.sendMode = "message";
        }
        if (e.getActionCommand().startsWith("card.sendMail")) {
            this.sendMode = "mail";
        }
        this.receiverMode = (String)action.getValue("receiverMode");
        this.title.setText("");
        this.text.setText("");
        this.performActionOpen();
    }

    protected void initActions() {
        new AbstractBGUPanel.MenuAction("card.sendMessage", "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SendMessageEditor.this.menuActionPerformed((Action)((Object)this), e);
            }
        }.putValue("receiverMode", (Object)"selected");
        if (!this.contractPanel) {
            new AbstractBGUPanel.MenuAction("card.sendMessage.filtered", "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u043c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    SendMessageEditor.this.menuActionPerformed((Action)((Object)this), e);
                }
            }.putValue("receiverMode", (Object)"filtered");
            new AbstractBGUPanel.MenuAction("card.sendMessage.all", "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0432\u0441\u0435\u043c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    SendMessageEditor.this.menuActionPerformed((Action)((Object)this), e);
                }
            }.putValue("receiverMode", (Object)"all");
        }
        new AbstractBGUPanel.MenuAction("card.sendMail", "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0438\u0441\u044c\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SendMessageEditor.this.menuActionPerformed((Action)((Object)this), e);
            }
        }.putValue("receiverMode", (Object)"selected");
        if (!this.contractPanel) {
            new AbstractBGUPanel.MenuAction("card.sendMail.filtered", "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0438\u0441\u044c\u043c\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u043c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    SendMessageEditor.this.menuActionPerformed((Action)((Object)this), e);
                }
            }.putValue("receiverMode", (Object)"filtered");
            new AbstractBGUPanel.MenuAction("card.sendMail.all", "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0438\u0441\u044c\u043c\u043e \u0432\u0441\u0435\u043c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    SendMessageEditor.this.menuActionPerformed((Action)((Object)this), e);
                }
            }.putValue("receiverMode", (Object)"all");
        }
        new AbstractBGUPanel.DefaultAction("ok", "\u041f\u043e\u0441\u043b\u0430\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                StringBuilder sb = new StringBuilder().append("\u041f\u043e\u0441\u043b\u0430\u0442\u044c ");
                if ("message".equals(SendMessageEditor.this.sendMode)) {
                    sb.append("\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
                } else {
                    sb.append("\u043f\u0438\u0441\u044c\u043c\u043e");
                }
                if ("filtered".equals(SendMessageEditor.this.receiverMode)) {
                    sb.append(" \u043d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u043c \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430\u043c?");
                } else if ("all".equals(SendMessageEditor.this.receiverMode)) {
                    sb.append(" \u0432\u0441\u0435\u043c \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430\u043c?");
                } else {
                    sb.append(" \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430\u043c?");
                }
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), sb.toString(), "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                    HashMap<String, String> req = new HashMap<String, String>();
                    if ("filtered".equals(SendMessageEditor.this.receiverMode)) {
                        if (!SendMessageEditor.this.filter(req)) {
                            return;
                        }
                    } else if ("selected".equals(SendMessageEditor.this.receiverMode)) {
                        String numbers = SendMessageEditor.this.getNumbers(SendMessageEditor.this.newTable, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f");
                        req.put("numbers", numbers);
                    }
                    try {
                        ((CardActionsService)((ClientContext)SendMessageEditor.this.getContext()).getPort(CardActionsService.class)).sendMessages(SendMessageEditor.this.sendMode, SendMessageEditor.this.title.getText(), SendMessageEditor.this.text.getText(), SendMessageEditor.this.receiverMode, new MapHolder(req));
                    }
                    catch (BGMessageException ex) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getMessage());
                    }
                    SendMessageEditor.this.performActionClose();
                }
            }
        };
    }

    protected boolean filter(Map<String, String> req) {
        return false;
    }
}

