/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.certificate.server.service;

import jakarta.jws.WebService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.util.encoders.Hex;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.certificate.common.bean.AliasEntry;
import ru.bitel.bgbilling.kernel.admin.certificate.common.bean.Ans1Block;
import ru.bitel.bgbilling.kernel.admin.certificate.common.bean.CertificateHolder;
import ru.bitel.bgbilling.kernel.admin.certificate.common.service.CertificateService;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.server.util.KeyStoreUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.certificate.common.service.CertificateService")
public class CertificateServiceImpl
extends AbstractService
implements CertificateService {
    @Override
    public List<AliasEntry> aliasEntryList() throws BGException {
        return this.tryReturn(() -> {
            File keyStoreFile = KeyStoreUtils.getKeyStoreFile();
            if (!keyStoreFile.exists()) {
                throw new BGMessageException("\u0424\u0430\u0439\u043b keystore \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d - \n" + keyStoreFile.getAbsolutePath());
            }
            ArrayList<AliasEntry> list = new ArrayList<AliasEntry>();
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(keyStoreFile), this.getSetup().get("keystore.password", "bgbilling").toCharArray());
            Enumeration<String> es = keyStore.aliases();
            while (es.hasMoreElements()) {
                String alias = es.nextElement();
                if (keyStore.isCertificateEntry(alias)) {
                    list.add(new AliasEntry(alias, AliasEntry.EntryType.CERTIFICATE, 0));
                }
                if (!keyStore.isKeyEntry(alias)) continue;
                list.add(new AliasEntry(alias, AliasEntry.EntryType.KEY, keyStore.getCertificateChain(alias).length));
            }
            return list;
        });
    }

    @Override
    public void aliasEntryDelete(String alias) throws BGException {
        this.tryCall(() -> {
            File keyStoreFile = KeyStoreUtils.getKeyStoreFile();
            if (!keyStoreFile.exists()) {
                throw new BGMessageException("\u0424\u0430\u0439\u043b keystore \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d - \n" + keyStoreFile.getAbsolutePath());
            }
            char[] pswd = this.getSetup().get("keystore.password", "bgbilling").toCharArray();
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(keyStoreFile), pswd);
            keyStore.deleteEntry(alias);
            keyStore.store(new FileOutputStream(keyStoreFile), pswd);
        });
    }

    @Override
    public CertificateHolder certificateGet(String alias, int chainIndex) throws BGException {
        return this.tryReturn(() -> {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(KeyStoreUtils.getKeyStoreFile()), this.getSetup().get("keystore.password", "bgbilling").toCharArray());
            if (keyStore.containsAlias(alias)) {
                if (keyStore.isKeyEntry(alias)) {
                    Certificate[] certificates = keyStore.getCertificateChain(alias);
                    if (chainIndex < certificates.length) {
                        Certificate certificate = certificates[chainIndex];
                        return new CertificateHolder(certificate.getType(), certificate.getEncoded());
                    }
                } else if (keyStore.isCertificateEntry(alias)) {
                    Certificate certificate = keyStore.getCertificate(alias);
                    return new CertificateHolder(certificate.getType(), certificate.getEncoded());
                }
            }
            return null;
        });
    }

    @Override
    public void certificateSet(String alias, String certificateType, String keyText, String cerText) throws BGException {
        this.tryCall(() -> {
            String keyTxt = keyText;
            String certTxt = cerText;
            File keyStoreFile = KeyStoreUtils.getKeyStoreFile();
            if (!keyStoreFile.exists()) {
                throw new BGMessageException("\u0424\u0430\u0439\u043b keystore \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d - \n" + keyStoreFile.getAbsolutePath());
            }
            byte[] cerBytes = null;
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(certificateType);
                StringBuffer buf = null;
                certTxt = certTxt.replace("\r", "");
                for (String line : cerText.split("\n")) {
                    if (line.startsWith("-----BEGIN CERTIFICATE-----")) {
                        buf = new StringBuffer();
                        continue;
                    }
                    if (line.startsWith("-----END CERTIFICATE-----")) {
                        cerBytes = Base64.getDecoder().decode(buf.toString());
                        certificates.add(certificateFactory.generateCertificate(new ByteArrayInputStream(cerBytes)));
                        buf = null;
                        continue;
                    }
                    if (buf == null) continue;
                    buf.append(line);
                }
            }
            catch (Exception certificateFactory) {
                // empty catch block
            }
            byte[] keyBytes = null;
            PrivateKey privateKey = null;
            if (keyText != null) {
                String algorithm = "RSA";
                try {
                    StringBuffer buf = null;
                    keyTxt = keyTxt.replace("\r", "");
                    for (String line : keyTxt.split("\n")) {
                        if (line.startsWith("-----BEGIN RSA PRIVATE KEY-----")) {
                            buf = new StringBuffer();
                            algorithm = "RSA";
                            continue;
                        }
                        if (line.startsWith("-----BEGIN DSA PRIVATE KEY-----")) {
                            buf = new StringBuffer();
                            algorithm = "DSA";
                            continue;
                        }
                        if (line.startsWith("-----BEGIN PRIVATE KEY-----")) {
                            buf = new StringBuffer();
                            algorithm = "PKCS8";
                            continue;
                        }
                        if (line.startsWith("-----END ")) {
                            keyBytes = Base64.getDecoder().decode(buf.toString());
                            buf = null;
                            break;
                        }
                        if (buf == null) continue;
                        buf.append(line);
                    }
                }
                catch (Exception buf) {
                    // empty catch block
                }
                if (keyBytes != null) {
                    EncodedKeySpec ks = null;
                    if ("PKCS8".equals(algorithm)) {
                        Ans1Block privateKeyInfo = new Ans1Block(ByteBuffer.wrap(keyBytes));
                        ByteBuffer byteBuffer = ByteBuffer.wrap(privateKeyInfo.getBlockBytes());
                        new Ans1Block(byteBuffer);
                        Ans1Block seqAns1Block = new Ans1Block(byteBuffer);
                        Ans1Block algorithmAns1Block = new Ans1Block(ByteBuffer.wrap(seqAns1Block.getBlockBytes()));
                        Ans1Block privateKeyAns1Block = new Ans1Block(byteBuffer);
                        algorithm = "rsaEncryption".equals(algorithmAns1Block.toString()) ? "RSA" : "DSA";
                        keyBytes = privateKeyAns1Block.getBlockBytes();
                        ks = new PKCS8EncodedKeySpec(keyBytes, algorithm);
                    } else {
                        ks = new X509EncodedKeySpec(keyBytes);
                    }
                    KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                    privateKey = keyFactory.generatePrivate(ks);
                }
            }
            char[] pswd = this.getSetup().get("keystore.password", "bgbilling").toCharArray();
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(keyStoreFile), pswd);
            if (privateKey == null) {
                int index = 0;
                for (Certificate certificate : certificates) {
                    keyStore.setCertificateEntry(alias + (String)(index == 0 ? "" : "_" + index++), certificate);
                }
            } else {
                keyStore.setKeyEntry(alias, privateKey, pswd, certificates.toArray(new Certificate[0]));
            }
            keyStore.store(new FileOutputStream(keyStoreFile), pswd);
        });
    }

    @Override
    public String keyGet(String alias) throws BGException {
        return this.tryReturn(() -> {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(KeyStoreUtils.getKeyStoreFile()), this.getSetup().get("keystore.password", "bgbilling").toCharArray());
            if (keyStore.containsAlias(alias) && keyStore.isKeyEntry(alias)) {
                Key key = keyStore.getKey(alias, this.getSetup().get("keystore.password", "bgbilling").toCharArray());
                return "Algorithm = " + key.getAlgorithm() + "\nFormat = " + key.getFormat() + "\nencoded = " + Hex.toHexString((byte[])key.getEncoded()) + "\nClass = " + String.valueOf(key.getClass()) + "\n\n" + key.toString();
            }
            return null;
        });
    }

    @Override
    public List<KeyValue> caCertList() throws BGException {
        return this.tryReturn(() -> {
            ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            List<TrustManager> trustManagers = Arrays.asList(trustManagerFactory.getTrustManagers());
            List certificates = trustManagers.stream().filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).map(trustManager -> Arrays.asList(trustManager.getAcceptedIssuers())).flatMap(Collection::stream).collect(Collectors.toList());
            for (X509Certificate x509Certificate : certificates) {
                keyValues.add(new KeyValue("", x509Certificate.getSubjectX500Principal().getName()));
            }
            return keyValues;
        });
    }

    @Override
    public void certificateSetP12(String encodeString, String inPswd) throws BGException {
        this.tryCall(() -> {
            File keyStoreFile = KeyStoreUtils.getKeyStoreFile();
            if (!keyStoreFile.exists()) {
                throw new BGMessageException("\u0424\u0430\u0439\u043b keystore \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d - \n" + keyStoreFile.getAbsolutePath());
            }
            char[] pswd = this.getSetup().get("keystore.password", "bgbilling").toCharArray();
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(keyStoreFile), pswd);
            KeyStore importKeyStore = KeyStore.getInstance("PKCS12");
            importKeyStore.load(new ByteArrayInputStream(Base64.getDecoder().decode(encodeString)), inPswd.toCharArray());
            Enumeration<String> aliases = importKeyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                PrivateKey privateKey = (PrivateKey)importKeyStore.getKey(alias, inPswd.toCharArray());
                Certificate[] certificates = importKeyStore.getCertificateChain(alias);
                keyStore.setKeyEntry(alias, privateKey, pswd, certificates);
            }
            keyStore.store(new FileOutputStream(keyStoreFile), pswd);
        });
    }

    @Override
    public boolean checkKeystore() throws BGException {
        return KeyStoreUtils.getKeyStoreFile().exists();
    }

    @Override
    public boolean createKeystore() throws BGException {
        return this.tryReturn(() -> {
            File keyStoreFile = KeyStoreUtils.getKeyStoreFile();
            if (!keyStoreFile.exists()) {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(null);
                char[] pswd = this.getSetup().get("keystore.password", "bgbilling").toCharArray();
                keyStore.store(new FileOutputStream(keyStoreFile), pswd);
                return true;
            }
            return false;
        });
    }
}

