/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean;

import bitel.billing.server.util.Config;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.BiSysTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.CPTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.CitiPayTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.ClickTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.ColomnaTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.ComepayTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.EPortTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.EasyPayTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.ElecsnetMskTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.ElecsnetSpbTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.EmpayTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.FreecashTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.GenericOSMPTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.KaspiTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MbankTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.OSMPTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.OptimaPlusTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.Payfon24TransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.PegasTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.QuickPayTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.RapidaOldTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.RapidaTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.SBTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.SberbankTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.SbrfTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.SfourAlternativeTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.UepcTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.UnikassaTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.VtbTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.XPlatTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.PaynetTransactionManager;
import ru.bitel.bgbilling.server.util.KeyStoreUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

public final class Conf
extends Config {
    public final Map<String, MPSSystem> mpsSystems;
    public final String mpsLoginFormat;
    public final Pattern mpsLoginPattern;
    public final String mpsLoginFormatErrorMessage;
    public final boolean mpsLoginContains;

    public Conf(int moduleId, ParameterMap setup, Setup serverSetup) {
        super(moduleId, setup, serverSetup);
        String mpsId;
        String protocol;
        this.getLogger().debug("Loading MPS config");
        HashMap<String, MPSSystem> systemMap = new HashMap<String, MPSSystem>();
        int defAccountServiceId = setup.getInt("mps.account.serviceId", -1);
        boolean mpsLoginSearchContains = false;
        List mpsKeys = Utils.toList((String)setup.get("mps.ids", "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20"));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("mpsKeys.size() = " + mpsKeys.size());
        }
        Iterator iterator = mpsKeys.iterator();
        while (iterator.hasNext() && (protocol = setup.get("mps." + (mpsId = (String)iterator.next()) + ".protocol", null)) != null) {
            MPSSystem system = null;
            if (setup.getInt("mps." + mpsId + ".mode", 0) > 0) {
                try {
                    ArrayList<SearchType> searchTypesList = new ArrayList<SearchType>();
                    ArrayList<Integer> searchTypeMidList = new ArrayList<Integer>();
                    ArrayList<Integer> searchTypePidList = new ArrayList<Integer>();
                    ArrayList<Pattern> searchTypePatternList = new ArrayList<Pattern>();
                    ArrayList<String> searchTypeReplaceList = new ArrayList<String>();
                    ArrayList<String> searchTypeCustomList = new ArrayList<String>();
                    ArrayList<Pattern> allowContractPatterns = new ArrayList<Pattern>();
                    ArrayList<Long> allowContractGroups = new ArrayList<Long>();
                    ArrayList<Boolean> allowClosedPayment = new ArrayList<Boolean>();
                    int stype = 0;
                    String mode = setup.get("mps." + mpsId + ".search.mode", null);
                    String prefix = "mps." + mpsId + ".search.";
                    while (mode != null || stype == 0) {
                        SearchType searchType;
                        Pattern p;
                        String pattern = setup.get(prefix + "pattern", null);
                        if (pattern == null) {
                            p = null;
                            pattern = null;
                        } else {
                            String[] temp = pattern.split(":::");
                            if (temp.length == 2) {
                                p = Pattern.compile(temp[0]);
                                pattern = temp[1];
                            } else {
                                p = null;
                            }
                        }
                        String pat = setup.get(prefix + "allow.contract.regexp", null);
                        Pattern allowContractPattern = Utils.notEmptyString((String)pat) && !pat.equals("*") ? Pattern.compile(pat) : null;
                        String groups = setup.get(prefix + "allow.contract.groups", null);
                        long groupMask = groups != null && groups.length() > 0 ? Utils.enumToMask((String)groups) : -1L;
                        SearchType searchType2 = searchType = mode != null ? SearchType.get(mode) : null;
                        if (searchType == SearchType.mps_login) {
                            mpsLoginSearchContains = true;
                        }
                        searchTypesList.add(searchType);
                        searchTypePatternList.add(p);
                        searchTypeReplaceList.add(pattern);
                        searchTypeCustomList.add(setup.get(prefix + "custom", ""));
                        searchTypeMidList.add(setup.getInt(prefix + "mid", 0));
                        searchTypePidList.add(setup.getInt(prefix + "pid", 0));
                        allowClosedPayment.add(setup.getBoolean(prefix + "allow.closed.payment", true));
                        allowContractPatterns.add(allowContractPattern);
                        allowContractGroups.add(groupMask);
                        prefix = "mps." + mpsId + ".search." + ++stype + ".";
                        mode = setup.get(prefix + "mode", null);
                    }
                    int cid = setup.getInt("mps." + mpsId + ".cid", -1);
                    int accountServiceId = setup.getInt("mps." + mpsId + ".account.serviceId", defAccountServiceId);
                    system = new MPSSystem(this, (SearchType[])Conf.toArray(searchTypesList, SearchType.class), Conf.intListToArray(searchTypeMidList), Conf.intListToArray(searchTypePidList), Conf.patternListToArray(searchTypePatternList), Conf.stringListToArray(searchTypeReplaceList), Conf.stringListToArray(searchTypeCustomList), true, mpsId, setup, protocol, Conf.patternListToArray(allowContractPatterns), Conf.longListToArray(allowContractGroups), cid, accountServiceId, Conf.booleanListToArray(allowClosedPayment));
                }
                catch (Exception e) {
                    system = new MPSSystem(this, setup, mpsId, Protocol.get(protocol));
                    e.printStackTrace();
                    this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 mps." + mpsId + ", mid=" + moduleId);
                }
            } else {
                system = new MPSSystem(this, setup, mpsId, Protocol.get(protocol));
            }
            systemMap.put(mpsId, system);
        }
        this.mpsSystems = systemMap;
        this.mpsLoginFormat = setup.get("mps.mps_login.format", null);
        String pat = setup.get("mps.mps_login.regexp", null);
        this.mpsLoginPattern = Utils.notEmptyString((String)pat) ? Pattern.compile(pat) : null;
        this.mpsLoginFormatErrorMessage = setup.get("mps.mps_login.regexp.error", "\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0446\u0435\u043b\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f \u0438 \u043c\u0435\u043d\u044c\u0448\u0435 2147483647");
        this.mpsLoginContains = mpsLoginSearchContains;
    }

    public String getMpsSystemRequestEncoding(String mpsId) {
        String requestEncoding = null;
        if (mpsId != null && this.mpsSystems.containsKey(mpsId)) {
            requestEncoding = this.mpsSystems.get((Object)mpsId).requestEncoding;
        }
        return requestEncoding;
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("\\A((?:\\d\\d\\d\\d\\d\\d)|(?:\\d\\d\\d\\d\\d\\d\\d))(\\d\\d)\\z");
        Matcher m = p.matcher("0000012");
        if (m.find()) {
            System.out.println(m.group(1));
            System.out.println(m.group(2));
        }
    }

    public static enum SearchType {
        none,
        mps_login,
        contract,
        login,
        voice,
        email,
        phone,
        parameter,
        inet_login,
        custom;


        public static SearchType get(String name) {
            return SearchType.valueOf(name);
        }
    }

    public class MPSSystem {
        public final boolean testMode;
        public final SearchType[] searchTypes;
        public final boolean multiSearch;
        public final int[] searchTypeMids;
        public final int[] searchTypePids;
        public final Pattern[] searchTypePattern;
        public final String[] searchTypeReplace;
        public final String[] searchTypeCustom;
        public final Pattern[] allowContractPattern;
        public final long[] allowContractGroups;
        public final boolean[] allowClosedPayment;
        public final boolean mode;
        public int paymentType;
        public final String login;
        public final String password;
        public final Protocol protocol;
        public final String requestEncoding;
        public final String responseEncoding;
        public final boolean certificateNeed;
        public final PublicKey publicKey;
        public final int payTime;
        public final int timeOffset;
        public final String title;
        public final String secret;
        public final String secretResponse;
        public final BigDecimal minSumm;
        public final BigDecimal maxSumm;
        public final boolean osmpPrefix;
        public final boolean extPayOnCheck;
        public final boolean extNoBaseAuth;
        public final boolean extAddBalanceInfo;
        public final boolean extOSMPSubBalance;
        public final String osmpContractPattern;
        public final boolean extOSMPFields;
        public final boolean extEportPayTime;
        public final boolean extDontCheckTransId;
        public final boolean extPaymentSystemTime;
        public final boolean extDontCheckSum;
        public final boolean extSfourComment;
        public final boolean extNeedClientInfo;
        public final Pattern registerPattern;
        public final Map<String, Integer> registerPatternOrder;
        public final String registerTimeFormat;
        public final boolean registerCheckAccount;
        public final Pattern numberPattern;
        public final int cid;
        public final int accountServiceId;
        public final ParameterMap responseAttributes;
        public final String comment;
        public final ParameterMap config;
        public final boolean storeOriginalSum;
        public final boolean extDenyForJur;
        public final String privateKeyAlias;
        private PrivateKey _privateKey = null;

        public MPSSystem(Conf this$0, ParameterMap setup, String mpsId, Protocol protocol) {
            this.mode = false;
            this.searchTypeMids = null;
            this.searchTypePids = null;
            this.searchTypePattern = null;
            this.searchTypeReplace = null;
            this.searchTypeCustom = null;
            this.searchTypes = null;
            this.multiSearch = false;
            this.publicKey = null;
            this.login = setup.get("mps." + mpsId + ".login", null);
            this.password = setup.get("mps." + mpsId + ".passw", null);
            this.certificateNeed = setup.getInt("mps." + mpsId + ".cert", 0) == 1;
            this.protocol = protocol;
            this.requestEncoding = setup.get("mps." + mpsId + ".request.encoding", null);
            this.responseEncoding = setup.get("mps." + mpsId + ".response.encoding", null);
            this.paymentType = setup.getInt("mps." + mpsId + ".pid", 0);
            this.payTime = setup.getInt("mps." + mpsId + ".paytime", 0);
            this.timeOffset = setup.getInt("mps." + mpsId + ".timeoffset", 0);
            this.title = setup.get("mps." + mpsId + ".title", "\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430");
            this.allowContractGroups = null;
            this.allowContractPattern = null;
            this.allowClosedPayment = null;
            this.secret = setup.get("mps." + mpsId + ".secret", "");
            this.secretResponse = setup.get("mps." + mpsId + ".secret.response", "");
            this.minSumm = setup.getBigDecimal("mps." + mpsId + ".min.summ", BigDecimal.ZERO);
            this.maxSumm = setup.getBigDecimal("mps." + mpsId + ".max.summ", new BigDecimal(1000000));
            this.osmpPrefix = false;
            this.extPayOnCheck = false;
            this.extNoBaseAuth = false;
            this.extAddBalanceInfo = false;
            this.extEportPayTime = false;
            this.extDontCheckTransId = false;
            this.extPaymentSystemTime = false;
            this.extDontCheckSum = false;
            this.extSfourComment = false;
            this.extNeedClientInfo = false;
            this.extOSMPSubBalance = false;
            this.osmpContractPattern = null;
            this.extOSMPFields = false;
            this.registerPattern = null;
            this.registerPatternOrder = null;
            this.registerTimeFormat = null;
            this.registerCheckAccount = false;
            this.testMode = false;
            this.numberPattern = null;
            this.cid = -1;
            this.accountServiceId = -1;
            this.responseAttributes = null;
            this.comment = "";
            this.storeOriginalSum = false;
            this.extDenyForJur = false;
            this.privateKeyAlias = setup.get("mps." + mpsId + ".privatekey.alias", null);
            this.config = setup.sub("mps." + mpsId + ".");
        }

        public MPSSystem(Conf this$0, SearchType[] searchTypes, int[] searchTypeMids, int[] searchTypePids, Pattern[] searchTypePattern, String[] searchTypeReplace, String[] searchTypeCustom, boolean mode, String mpsId, ParameterMap setup, String protocol, Pattern[] allowContractPattern, long[] allowContractGroups, int cid, int accountServiceId, boolean[] allowClosedPayment) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
            Pattern numberPattern;
            this.searchTypeMids = searchTypeMids;
            this.searchTypePids = searchTypePids;
            this.searchTypePattern = searchTypePattern;
            this.searchTypeReplace = searchTypeReplace;
            this.searchTypeCustom = searchTypeCustom;
            this.searchTypes = searchTypes;
            this.multiSearch = setup.getBoolean("mps." + mpsId + ".search.multi", false);
            this.storeOriginalSum = setup.getBoolean("mps." + mpsId + ".store.paynet.original.sum", setup.getBoolean("mps." + mpsId + ".store.original.sum", false));
            this.mode = mode;
            this.certificateNeed = setup.getInt("mps." + mpsId + ".cert", 0) == 1;
            this.login = setup.get("mps." + mpsId + ".login", null);
            this.password = setup.get("mps." + mpsId + ".passw", null);
            this.protocol = Protocol.get(protocol);
            this.payTime = setup.getInt("mps." + mpsId + ".paytime", 0);
            this.paymentType = setup.getInt("mps." + mpsId + ".pid", 0);
            this.timeOffset = setup.getInt("mps." + mpsId + ".timeoffset", 0);
            this.title = setup.get("mps." + mpsId + ".title", "\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430");
            this.requestEncoding = setup.get("mps." + mpsId + ".request.encoding", null);
            this.responseEncoding = setup.get("mps." + mpsId + ".response.encoding", null);
            this.comment = setup.get("mps." + mpsId + ".comment", setup.get("mps.comment", "$CONTRACT ($COMMENT)"));
            this.allowContractGroups = allowContractGroups;
            this.allowContractPattern = allowContractPattern;
            this.allowClosedPayment = allowClosedPayment;
            this.secret = setup.get("mps." + mpsId + ".secret", "");
            this.secretResponse = setup.get("mps." + mpsId + ".secret.response", "");
            this.minSumm = setup.getBigDecimal("mps." + mpsId + ".min.summ", BigDecimal.ZERO);
            this.maxSumm = setup.getBigDecimal("mps." + mpsId + ".max.summ", new BigDecimal(1000000));
            String ext = setup.get("mps." + mpsId + ".protocol.ext", "");
            this.osmpPrefix = ext.contains("1") || ext.contains("osmpPrefix");
            this.extPayOnCheck = ext.contains("payOnCheck");
            this.extNoBaseAuth = ext.contains("noBaseAuth");
            this.extAddBalanceInfo = ext.contains("addBalanceInfo");
            this.extEportPayTime = ext.contains("eportPayTime");
            this.extDontCheckTransId = ext.contains("dontCheckTransId");
            this.extPaymentSystemTime = ext.contains("paymentSystemTime");
            this.extDontCheckSum = ext.contains("dontCheckSum");
            this.extSfourComment = ext.contains("sfourComment");
            this.extNeedClientInfo = ext.contains("needClientInfo");
            this.extOSMPSubBalance = ext.contains("osmpSubBalance");
            this.extDenyForJur = ext.contains("denyForJur");
            this.extOSMPFields = ext.contains("osmpFields");
            this.osmpContractPattern = setup.get("mps." + mpsId + ".osmp.contract.pattern", null);
            String _registerPattern = setup.get("mps." + mpsId + ".register.pattern", null);
            if (Utils.notBlankString((String)_registerPattern)) {
                Pattern registerPattern;
                try {
                    registerPattern = _registerPattern != null ? Pattern.compile(_registerPattern, 8) : null;
                }
                catch (Exception e) {
                    this$0.getLogger().error("error param mps." + mpsId + ".register.pattern=" + _registerPattern, (Throwable)e);
                    registerPattern = null;
                }
                this.registerPattern = registerPattern;
                this.registerPatternOrder = new HashMap<String, Integer>();
                for (String param : Utils.toList((String)setup.get("mps." + mpsId + ".register.patternOrder", ""))) {
                    if (!Utils.notBlankString((String)param)) continue;
                    String[] _param = param.split("\\s*:\\s*", 2);
                    if (_param.length != 2) {
                        this$0.getLogger().error("Error in mps config: " + setup.get("mps." + mpsId + ".register.patternOrder", ""));
                    }
                    this.registerPatternOrder.put(_param[0], Utils.parseInt((String)_param[1]));
                }
            } else {
                this.registerPattern = null;
                this.registerPatternOrder = null;
            }
            this.registerTimeFormat = setup.get("mps." + mpsId + ".register.timeFormat", "dd.MM.yyyy HH:mm:ss");
            this.registerCheckAccount = setup.getInt("mps." + mpsId + ".register.checkAccount", 0) > 0;
            this.testMode = setup.getInt("mps." + mpsId + ".mode", 0) == 2;
            this.cid = cid;
            this.accountServiceId = accountServiceId;
            String _numberPattern = setup.get("mps." + mpsId + ".numberPattern", null);
            try {
                numberPattern = _numberPattern != null ? Pattern.compile(_numberPattern) : null;
            }
            catch (Exception e) {
                this$0.getLogger().error("error param mps." + mpsId + ".numberPattern=" + _numberPattern, (Throwable)e);
                numberPattern = null;
            }
            this.responseAttributes = setup.sub("mps." + mpsId + ".response.attribute.");
            this.numberPattern = numberPattern;
            PublicKey publicKey = null;
            try {
                String der;
                String encoded = setup.get("mps." + mpsId + ".cert.encoded", "");
                if (Utils.notBlankString((String)encoded)) {
                    publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(new BigInteger(encoded, 16).toByteArray()));
                }
                if (publicKey == null && Utils.notBlankString((String)(der = setup.get("mps." + mpsId + ".cert.pem", "")))) {
                    publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.decode((byte[])der.getBytes())));
                }
                if (publicKey == null) {
                    String smod = setup.get("mps." + mpsId + ".cert.mod", "");
                    String sexp = setup.get("mps." + mpsId + ".cert.exp", "");
                    if (Utils.notBlankString((String)smod) && Utils.notBlankString((String)sexp)) {
                        publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(new BigInteger(smod, 16), new BigInteger(sexp, 16)));
                    }
                }
            }
            catch (Exception ex) {
                this$0.logError(ex);
                throw ex;
            }
            this.publicKey = publicKey;
            this.privateKeyAlias = setup.get("mps." + mpsId + ".privatekey.alias", null);
            this.config = setup.sub("mps." + mpsId + ".");
        }

        public String toString() {
            return "[protocol=" + this.protocol.name() + "; protocol.isAuthBySign()=" + this.protocol.isAuthBySign() + "; extNoBaseAuth=" + this.extNoBaseAuth + "; login=" + this.login + "; password=" + this.password + "]";
        }

        public PrivateKey getPrivateKey() {
            if (this._privateKey == null) {
                this._privateKey = KeyStoreUtils.getPrivateKey((Setup)Setup.getSetup(), (String)this.privateKeyAlias);
            }
            return this._privateKey;
        }
    }

    public static enum Protocol {
        osmp(false, false, true, OSMPTransactionManager.class),
        cp(false, false, true, CPTransactionManager.class),
        xplat(true, true, false, XPlatTransactionManager.class),
        eport(true, false, true, EPortTransactionManager.class),
        rapida(RapidaTransactionManager.class),
        rapida_old(RapidaOldTransactionManager.class),
        empay(EmpayTransactionManager.class),
        pegas(PegasTransactionManager.class),
        comepay(ComepayTransactionManager.class),
        sfoura(true, true, true, SfourAlternativeTransactionManager.class),
        mgpe(false, false, true, GenericOSMPTransactionManager.MGPEPaymentManager.class),
        erc(false, false, true, GenericOSMPTransactionManager.ERCPaymentManager.class),
        colomna(false, false, true, ColomnaTransactionManager.class),
        sb(false, false, true, SBTransactionManager.class),
        optimaplus(true, false, false, OptimaPlusTransactionManager.class),
        elecsnet(true, false, false, ElecsnetMskTransactionManager.class),
        sberbank(SberbankTransactionManager.class),
        quickpay(false, false, true, QuickPayTransactionManager.class),
        unikassa(UnikassaTransactionManager.class),
        bisys(BiSysTransactionManager.class),
        citypay(CitiPayTransactionManager.class),
        sbrf(SbrfTransactionManager.class),
        paynet(PaynetTransactionManager.class),
        click(ClickTransactionManager.class),
        freecash(FreecashTransactionManager.class),
        elecsnetspb(ElecsnetSpbTransactionManager.class),
        uepc(UepcTransactionManager.class),
        mbank(MbankTransactionManager.class),
        kaspi(KaspiTransactionManager.class),
        payfon24(Payfon24TransactionManager.class),
        vtb(false, false, false, VtbTransactionManager.class),
        easypay(EasyPayTransactionManager.class);

        private final boolean authBySign;
        private final boolean needPrepare;
        private final boolean canBlockPayment;
        private final Class<?> transactionManagerClass;

        private Protocol(Class<?> transactionManagerClass) {
            this(false, false, false, transactionManagerClass);
        }

        private Protocol(boolean authBySign, boolean needPrepare, boolean canBlockPayment, Class<?> transactionManagerClass) {
            this.authBySign = authBySign;
            this.needPrepare = needPrepare;
            this.canBlockPayment = canBlockPayment;
            this.transactionManagerClass = transactionManagerClass;
        }

        public static Protocol get(String name) {
            if ("cyberplat".equals(name)) {
                name = "cp";
            }
            return Protocol.valueOf(name);
        }

        public final boolean isAuthBySign() {
            return this.authBySign;
        }

        public final boolean isNeedPrepare() {
            return this.needPrepare;
        }

        public final boolean isCanBlockPayment() {
            return this.canBlockPayment;
        }

        public final Class<?> getTransactionManagerClass() {
            return this.transactionManagerClass;
        }
    }
}

