/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;

public class TableTaskDao
extends AbstarctDaoConstant {
    public TableTaskDao(Connection con, int moduleId) {
        super(con, "dba_table_task", moduleId);
    }

    public List<String> getTables() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        String query = "SELECT * FROM " + this.tableName;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                tableNames.add(rs.getString(1));
            }
        }
        return tableNames;
    }

    public void deleteTask(String tableName) throws SQLException {
        String query = "DELETE FROM " + tableName + " WHERE table_name=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, tableName);
            ps.execute();
        }
    }

    public void tableInArchiveUpdate(List<String> tableNames, boolean value) throws SQLException {
        String queryInsert = "INSERT INTO " + this.tableName + " SET table_name=?";
        String queryDelete = "DELETE FROM " + this.tableName + " WHERE table_name=?";
        try (PreparedStatement psInsert = this.con.prepareStatement(queryInsert);
             PreparedStatement psDelete = this.con.prepareStatement(queryDelete);){
            for (String name : tableNames) {
                psDelete.setString(1, name);
                psDelete.execute();
                if (!value) continue;
                psInsert.setString(1, name);
                psInsert.execute();
            }
        }
    }
}

